% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spacyr-methods.R
\name{spacyr-methods}
\alias{spacyr-methods}
\title{Extensions for and from spacy_parse objects}
\arguments{
\item{x}{an object returned by \code{spacy_parse}, or (for
\code{spacy_parse}) a \link{corpus} object}

\item{...}{not used for these functions}
}
\description{
These functions provide \pkg{quanteda} methods for \pkg{spacyr} objects, and
also extend \link[spacyr:spacy_parse]{spacy_parse} and
\link[spacyr:spacy_tokenize]{spacy_tokenize} to work directly with \link{corpus}
objects.
}
\details{
\code{spacy_parse(x, ...)} and \code{spacy_tokenize(x, ...)} work directly on
\pkg{quanteda} \link{corpus} objects.

\code{docnames(x)} returns the document names

\code{ndoc(x)} returns the number of documents

\code{ntoken(x, ...)} returns the number of tokens by document

\code{ntype(x, ...)} returns the number of types (unique tokens) by document

\code{nsentence(x)} returns the number of sentences by document
}
\examples{
\dontrun{
library("spacyr")
spacy_initialize()

corp <- corpus(c(doc1 = "And now, now, now for something completely different.",
                 doc2 = "Jack and Jill are children."))
spacy_tokenize(corp)
(parsed <- spacy_parse(corp))

ntype(parsed)
ntoken(parsed)
ndoc(parsed)
docnames(parsed)
}
}
