% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textmodel_wordscores.R
\name{textmodel_wordscores}
\alias{textmodel_wordscores}
\title{Wordscores text model}
\usage{
textmodel_wordscores(x, y, scale = c("linear", "logit"), smooth = 0)
}
\arguments{
\item{x}{the \link{dfm} on which the model will be trained}

\item{y}{vector of training scores associated with each document 
in \code{x}}

\item{scale}{scale on which to score the words; \code{"linear"} for classic 
LBG linear posterior weighted word class differences, or \code{"logit"}
for log posterior differences}

\item{smooth}{a smoothing parameter for word counts; defaults to zero for the
to match the LBG (2003) method.}
}
\description{
\code{textmodel_wordscores} implements Laver, Benoit and Garry's (2003)
"Wordscores" method for scaling texts on a single dimension, given a set of
anchoring or \emph{reference} texts whose values are set through reference
scores. This scale can be fitted in the linear space (as per LBG 2003) or in
the logit space (as per Beauchamp 2012).  Estimates of \emph{virgin} or
unknown texts are obtained using the \code{predict()} method to score
documents from a fitted \code{textmodel_wordscores} object.
}
\details{
The \code{textmodel_wordscores()} function and the associated
  \code{\link[=predict.textmodel_wordscores]{predict()}} method are designed
  to function in the same manner as \code{\link[stats]{predict.lm}}.
  \code{coef()} can also be used to extract the word coefficients from the
  fitted \code{textmodel_wordscores} object, and \code{summary()} will print a
  nice summary of the fitted object.
}
\examples{
(ws <- textmodel_wordscores(data_dfm_lbgexample, c(seq(-1.5, 1.5, .75), NA)))
summary(ws)
coef(ws)
predict(ws)
predict(ws, rescaling = "lbg")
predict(ws, se.fit = TRUE, interval = "confidence", rescaling = "mv")
}
\references{
Laver, Michael, Kenneth R Benoit, and John Garry. 2003. 
  "\href{http://www.kenbenoit.net/pdfs/WORDSCORESAPSR.pdf}{Extracting Policy Positions From Political Texts Using Words as Data.}" 
  \emph{American Political Science Review} 97(02): 311-31
  
  Beauchamp, N. 2012. "Using Text to Scale Legislatures with Uninformative 
  Voting." New York University Mimeo.
  
  Martin, L W, and G Vanberg. 2007. "A Robust Transformation Procedure for 
  Interpreting Political Text." \emph{Political Analysis} 16(1): 93-100.
}
\seealso{
\code{\link{predict.textmodel_wordscores}} for methods of applying a
  fitted \link{textmodel_wordscores} model object to predict quantities from
  (other) documents.
}
\author{
Kenneth Benoit
}
