% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcm-methods.R
\name{fcm_sort}
\alias{fcm_sort}
\title{Sort an fcm in alphabetical order of the features}
\usage{
fcm_sort(x)
}
\arguments{
\item{x}{\link{fcm} object}
}
\value{
A \link{fcm} object whose features have been alphabetically sorted. 
  Differs from \code{\link{fcm_sort}} in that this function sorts the fcm by
  the feature labels, not the counts of the features.
}
\description{
Sorts an \link{fcm} in alphabetical order of the features.
}
\examples{
# with tri = FALSE
myfcm <- fcm(tokens(c("A X Y C B A", "X Y C A B B")), tri = FALSE)
rownames(myfcm)[3] <- colnames(myfcm)[3] <- "Z"
myfcm
fcm_sort(myfcm)

# with tri = TRUE
myfcm <- fcm(tokens(c("A X Y C B A", "X Y C A B B")), tri = TRUE)
rownames(myfcm)[3] <- colnames(myfcm)[3] <- "Z"
myfcm
fcm_sort(myfcm)
}
\author{
Ken Benoit
}
