% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/casechange-functions.R
\name{tokens_tolower}
\alias{tokens_tolower}
\alias{tokens_toupper}
\title{Convert the case of tokens}
\usage{
tokens_tolower(x, keep_acronyms = FALSE, ...)

tokens_toupper(x, ...)
}
\arguments{
\item{x}{the input object whose character/tokens/feature elements will be 
case-converted}

\item{keep_acronyms}{logical; if \code{TRUE}, do not lowercase any 
all-uppercase words (applies only to \code{*_tolower} functions)}

\item{...}{additional arguments passed to \pkg{stringi} functions, (e.g. 
\code{\link{stri_trans_tolower}}), such as \code{locale}}
}
\description{
\code{tokens_tolower} and \code{tokens_toupper} convert the features of a
\link{tokens} object and reindex the types.
}
\examples{
# for a document-feature matrix
toks <- tokens(c(txt1 = "b A A", txt2 = "C C a b B"))
tokens_tolower(toks) 
tokens_toupper(toks)
}
