% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textplot_keyness.R
\name{textplot_keyness}
\alias{textplot_keyness}
\title{plot word keyness}
\usage{
textplot_keyness(x, show_reference = TRUE, n = 20L, min_count = 2L)
}
\arguments{
\item{x}{a return object from \code{\link{textstat_keyness}}}

\item{show_reference}{logical; if \code{TRUE}, show key reference features in
addition to key target features}

\item{n}{integer; number of features to plot}

\item{min_count}{numeric; minimum total count of feature across the target 
and reference categories, for a feature to be included in the plot}
}
\value{
a \pkg{ggplot2} object
}
\description{
Plot the results of a "keyword" of features comparing their differential 
associations with a target and a reference group, after calculating keyness
using \code{\link{textstat_keyness}}.
}
\examples{
\dontrun{
# compare Trump v. Obama speeches
prescorpus <- corpus_subset(data_corpus_inaugural, 
                            President \%in\% c("Obama", "Trump"))
presdfm <- dfm(prescorpus, groups = "President", remove = stopwords("english"),
               remove_punct = TRUE)
result <- textstat_keyness(presdfm, target = "Trump")

# plot estimated word keyness
textplot_keyness(result) 
textplot_keyness(result, show_reference = FALSE)
}
}
\seealso{
\code{\link{textstat_keyness}}
}
\author{
Haiyan Wang
}
\keyword{textplot}
