% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_type_metrics.R
\name{calc_type_metrics}
\alias{calc_type_metrics}
\title{Calculate Frequency and Dispersion Metrics for Text Types}
\usage{
calc_type_metrics(data, type, document, frequency = NULL, dispersion = NULL)
}
\arguments{
\item{data}{Data frame. Contains the tokenized text data with document IDs
and types/terms.}

\item{type}{Symbol. Column in \code{data} containing the types to analyze
(e.g., terms, lemmas).}

\item{document}{Symbol. Column in \code{data} containing the document identifiers.}

\item{frequency}{Character vector. Frequency metrics to calculate:
- NULL (default): Returns only type counts
- 'all': All available metrics
- 'rf': Relative frequency
- 'orf': Observed relative frequency (per 100)}

\item{dispersion}{Character vector. Dispersion metrics to calculate:
- NULL (default): Returns only type counts
- 'all': All available metrics
- 'df': Document frequency
- 'idf': Inverse document frequency
- 'dp': Gries' deviation of proportions}
}
\value{
Data frame containing requested metrics:
\itemize{
\item type: Unique types from input data
\item n: Raw frequency count
\item rf: Relative frequency (if requested)
\item orf: Observed relative frequency per 100 (if requested)
\item df: Document frequency (if requested)
\item idf: Inverse document frequency (if requested)
\item dp: Deviation of proportions (if requested)
}
}
\description{
Calculates various frequency and dispersion metrics for types (terms/tokens)
in tokenized text data. Provides a comprehensive analysis of how types are
distributed across documents in a corpus.
}
\details{
The function creates a term-document matrix internally and calculates the
requested metrics. Frequency metrics show how often types occur, while
dispersion metrics show how evenly they are distributed across documents.

The 'dp' metric (Gries' Deviation of Proportions) ranges from 0 (perfectly
even distribution) to 1 (completely clumped distribution).
}
\examples{
data_path <- system.file("extdata", "types_data.rds", package = "qtkit")
df <- readRDS(data_path)
calc_type_metrics(
  data = df,
  type = letter,
  document = doc_id,
  frequency = c("rf", "orf"),
  dispersion = "dp"
)
}
\references{
Gries, Stefan Th. (2023). Statistical Methods in Corpus Linguistics.
In Readings in Corpus Linguistics: A Teaching and Research Guide
for Scholars in Nigeria and Beyond, pp. 78-114.
}
