#'PQ Q-set criteria scores and derived scales
#'
#'A data frame containing the Preschool Q-set (pq). 
#'In this dataset, column names ending in "_c" refer to criteria 
#'sorts' scores, while column names ending in "_s" refer to
#'scales' scores.
#'
#'@format PQ dataset with 72 rows (items) and 6 columns.
#'  \describe{
#'    \item{item}{Item number from 1 to 72.}
#'    \item{qset}{pq. Preschool
#'  Q-set (Baumrind, 1968 revised by Wanda Bronson).}
#'    \item{scomp_c}{Social competence criterion scores
#'    (retrieved from Waters et al., 1985).}
#'    \item{sest_c}{Self-esteem criterion scores
#'    (retrieved from Waters et al., 1985).}
#'    \item{sdes_c}{Social desirability criterion scores
#'    (retrieved from Waters et al., 1985).}
#'    \item{description}{Item description (retrieved from Waters et al., 1985).} }
#'    
#'@references Baumrind, D. (1968). Manual for the Preschool Behaviour Q-set.
#'  Parental Research Project. Berkeley, CA: Institute of Human Development,
#'  University of California.
#'  
#'  Waters, E., Noyes, D. M., Vaughn, B. E., & Ricks, M. (1985). Q-sort
#'  definitions of social competence and self-esteem: Discriminant validity of
#'  related constructs in theory and data. Developmental Psychology, 21,
#'  508-522.
#'
"qset_pq"