% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readQOI.R
\name{readQOI}
\alias{readQOI}
\title{Read an QOI image into a RGB(A) raster array}
\usage{
readQOI(qoi_image_path)
}
\arguments{
\item{qoi_image_path}{\link{character} (\strong{required}): Path to a stored qoi-image}
}
\value{
A matrix with integer (0-255) RGB(A) values with dimensions height x width x channels.
Until now 3 (RGB) and 4 (RGBA) channels are integrated in the specification.
If the decoding went wrong the returned value is NULL.
}
\description{
Read an QOI image into a RGB(A) raster array
}
\examples{
## (1) Read RGBA values from file
path <- system.file("extdata", "Rlogo.qoi", package="qoi")
rlogo_qoi <- readQOI(path)
dim(rlogo_qoi)

## (2) plot them
plot.new()
}
\author{
Johannes Friedrich
}
