% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.qlifetable}
\alias{plot.qlifetable}
\title{Graphical representation in a 4x4 raster of a qlifetable data frame.}
\usage{
\method{plot}{qlifetable}(
  x,
  ...,
  range.ages = NULL,
  key = "numbers",
  decimal.digits = 2,
  color.palette = "grey",
  alpha.max = 1,
  alpha.min = 0.4,
  color.values = "black",
  big.mark = NULL,
  size.values = 3,
  legend.name = NULL,
  name.labels.age = c("Q1", "Q2", "Q3", "Q4"),
  name.labels.season = c("Winter", "Spring", "Summer", "Autumn"),
  show.plot = TRUE
)
}
\arguments{
\item{x}{A data frame of quarterly summary statistics. Typically an output of the function \code{\link{count_events_quarter}} or whatever of the time_exposed_ functions (e.g., \code{\link{time_exposed_outs}}).}

\item{...}{Other arguments passed on to methods. Not currently used.}

\item{range.ages}{A vector of integers informing the aggregation of ages for which the graphical representation should be plotted. Default, NULL, the agggregation of all ages is shown.}

\item{key}{Type of statistic to be presented in the plot. Either 'numbers' or relative 'percentages'.}

\item{decimal.digits}{Integer indicating the number of decimal places to be shown. Default, 2.}

\item{color.palette}{Background base color for cells. Default, "grey".}

\item{alpha.max}{A number in the interval [0, 1]. Maximum level of transparency to be applied for the background to build the palette. Default, 1.}

\item{alpha.min}{A number in the interval [0, 1]. Minimum level of transparency to be applied for the background to build the palette. Default, 0.4.}

\item{color.values}{Base color for numbers printed in each cell. Default, "black".}

\item{big.mark}{A character string indicating the symbol to be used as thousand separator. Default, NULL.}

\item{size.values}{A number indicating the font size to be used for inner-cells values. Default, 3.}

\item{legend.name}{Name to be use as name in the legend. Default, NULL.}

\item{name.labels.age}{Names to be used for the (y) age axis. Default, c("Q1", "Q2", "Q3", "Q4").}

\item{name.labels.season}{Names to be used for the (x) season axis. Default, c("Winter", "Spring", "Summer", "Autumn").}

\item{show.plot}{A TRUE/FALSE indicating if the plot should be displayed as a side-effect. By default, TRUE.}
}
\value{
Invisibly returns the (ggplot) description of the plot, which is a list with components that contain the plot itself, the data, information about the scales, panels, etc.
}
\description{
Plot method for a data frame of events or time exposed occurring in each Lexis-diagram quarter for a set of ages.
This is a plot method for the objects typically obtained using the function \code{\link{count_events_quarter}} or whatever of the time_exposed_ functions (e.g., \code{\link{time_exposed_outs}}).
}
\note{
ggplot2 is needed to be installed for this function to work.
}
\examples{
dates.b <- c("1920-05-13", "1999-04-12", "2019-01-01")
dates.e <- c("2002-03-23", "2009-04-12", "2019-01-01")
x <- quarterly_variables(dates.b, dates.e)
out <- time_exposed_outs(x)
p <- plot(out, show.plot = FALSE)
}
\author{
Josep Lledo \email{josep.lledo@uv.es}

Jose M. Pavia, \email{pavia@uv.es}
}
