% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covariance.R
\name{reml}
\alias{reml}
\title{Restricted maximum likelihood (REML)}
\usage{
reml(models, pars, data, Xs, verbose = FALSE)
}
\arguments{
\item{models}{object of class \code{krige} (list of covariance models) or class
\code{covModel} (a single covariance model), see \code{\link{setCovModel}}}

\item{pars}{covariance parameter vector (including global scalar nugget value)}

\item{data}{data frame of simulated statistics, each column corresponds to a 
single covariance model in `\code{models}`}

\item{Xs}{matrix of sample points}

\item{verbose}{logical, if \code{TRUE}, print intermediate output}
}
\value{
List of REML function values.
}
\description{
Calculate the REML function value given a covariance model and (observed) data
}
\details{
Given a list of covariance models the function calculates the REML function values at
  the covariance parameter `\code{pars}`.
}
\examples{
	data(normal)

 # extract the sample points (the design)
 X <- as.matrix(qsd$qldata[1:2])

 # get the observed statistic
 T <- qsd$qldata[c("mean.T1")]
 reml(qsd$covT[1],pars=c(1e-4,1.5,0.1),T,X)

}
\author{
M. Baaske
}
