% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qsOpt.R
\name{qscoring}
\alias{qscoring}
\title{Quasi-scoring iteration}
\usage{
qscoring(qsd, x0, opts = list(), Sigma = NULL, ..., inverted = FALSE,
  check = TRUE, cvm = NULL, pl = 0L, verbose = FALSE)
}
\arguments{
\item{qsd}{object of class \code{\link{QLmodel}}}

\item{x0}{(named) numeric vector, the starting parameter}

\item{opts}{quasi-scoring options, see details}

\item{Sigma}{a pre-specified variance matrix estimate}

\item{...}{further arguments passed to function \code{\link{covarTx}}}

\item{inverted}{currently ignored}

\item{check}{logical, \code{TRUE} (default), whether to check input arguments}

\item{cvm}{list of covariance models for cross-validation (see \code{\link{prefitCV}})}

\item{pl}{numeric, print level, use \code{pl}>0 to give intermediate output}

\item{verbose}{\code{FALSE} (default), otherwise print intermediate output}
}
\value{
List of results of quasi-scoring iteration.
 \item{status}{ integer, why scoring iterations stopped}
 \item{message}{ string, corrsponding to `\code{status}`}
 \item{iter}{ number of iterations}
 \item{value}{ quasi-deviance value}
 \item{par}{ solution vector}
 \item{score}{ quasi-score vector}
 \item{I}{ quasi-information matrix}
 \item{start}{ starting point}
 \item{convergence}{ integer, for convergence=1 and local convergence=10, no convergence=-1}
 \item{method}{ simply: "\code{qscoring}"}
 \item{criterion}{ equal to "\code{qle}"}
}
\description{
The function solves the quasi-score equation by a root finding algorithm similar to Fisher's scoring iteration.
}
\details{
The function implements a step-length controlled quasi-scoring iteration with simple bound
 constraints (see, e.g. [1,3]) specifically tailored for quasi-likelihood parameter estimation. Due to the typical
 nonconvex nature of the (unknown and not further specified) quasi-likelihood function as an objective
 function one needs some kind of globalization strategy in order to stabilize the descent step and to avoid a premature
 termination. Therfore, we use the quasi-deviance function as a monitor function (see vignette) though it does not
 inherit all of the appreciable properties of a true objective function such as among others, for example,
 identifying appropriate descent directions. However, these are general numerical obsticles in case of pure root
 finding algorithms and need to be addressed elsewhere. 
 
 \subsection{Quasi-scoring under uncertainty}{ 
 The quasi-scoring iteration covers both kinds of prediction variances, kriging-based and those by a CV approach, which account for
 the uncertainty induced by the quasi-score approximation model. By default kriging variances
 are included in the computation during all iterations. If fitted covariance models `\code{cvm}` are supplied by the user
 in advance (see \code{\link{prefitCV}}), the variances of prediction errors of each statistic are separately evaluated by the proposed CV
 approach for each new point. For the price of relatively high computational costs those prediction variances
 are intended to increase the robustness against false roots due to simulation and approximation errors of the quasi-score function.

 Opposed to this, the user also has the option to carry out a "pure version" of quasi-scoring without accounting for
 these errors. This can be set earlier as an option in \code{\link{QLmodel}}. See also \code{\link{covarTx}} and
 \code{\link{mahalDist}} for details on how to choose the variance matrix approximation of the statistics.
 }

 The following algorithmic options, which can be set by `\code{opts}`, are available:
 \itemize{
  	\item{\code{ftol_stop}:}{ minimum value of the quasi-deviance for stopping the scoring iteration}
		\item{\code{ftol_abs}:}{ minimum value of the quasi-deviance which is used as a reference value for a local minimizer}
		\item{\code{xtol_rel}, \code{ftol_rel}:}{ see \code{\link{qle}} }
		\item{\code{grad_tol}:}{ upper bound on the quasi-score vector components,
				 testing for a local minimum of the quasi-deviance in case of a line search failure}
		\item{\code{score_tol}:}{ upper bound on the quasi-score vector components, testing for an approximate root}
	\item{\code{slope_tol}:}{ upper bound on the 2-norm of the quasi-score vector, testing for an approximate descent step}
     \item{\code{maxiter}:}{ maximum allowed number of iterations}
	    \item{\code{pl}:}{ print level (>=0), use \code{pl}=10 to print individual
							 iterates and further values}
 }
}
\examples{
data(normal)
QS <- qscoring(qsd,x0=c("mu"=3.5,"sigma"=0.5),
         opts=list("score_tol"=1e-4))

}
\seealso{
\code{\link{prefitCV}}
}
\author{
M. Baaske
}
