% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QCH_functions.R
\name{qch.fit}
\alias{qch.fit}
\title{Infer Hconfig posteriors}
\usage{
qch.fit(pValMat, Hconfig, plotting = FALSE)
}
\arguments{
\item{pValMat}{a matrix of p-values, each column corresponding to a p-value serie.}

\item{Hconfig}{an Hconfig list as generated by the \code{\link[=GetHinfo]{GetHinfo()}} function.}

\item{plotting}{a boolean. Should some diagnostic graphs be plotted ? Default is FALSE.}
}
\value{
A list of 2 objects 'prior' and 'posterior'.
Object 'prior' is a vector of estimated prior probabilities for each of the H-configurations.
Object 'posterior' is a matrix providing for each item (in row) its posterior probability to belong to each of the H-configurations (in columns).
}
\description{
Infer Hconfig posteriors
}
\examples{
data(PvalSets)
PvalMat <- as.matrix(PvalSets[,-3])
## Build the Hconfig objects
Q <- 2
AtLeast <- 2
Hconfig <- GetHinfo(Q,AtLeast)$Hconfig

## Run the function
res.fit <- qch.fit(PvalMat,Hconfig)

## Display the prior of each class of items
res.fit$prior

## Display the first posteriors
head(res.fit$posterior)
}
