% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmQueryTotalCount.R
\name{pmQueryTotalCount}
\alias{pmQueryTotalCount}
\title{Count the number of documents returned by a query}
\usage{
pmQueryTotalCount(query, api_key = NULL)
}
\arguments{
\item{query}{is a character. It contains a search query formulated using the Entrez query language.}

\item{api_key}{is a character. It contains a valid API keys for the NCBI E-utilities. Default is \code{api_key=NULL}
The use of NCBI PubMed APIs is entirely free, and doesn't necessary require an API key.}
}
\value{
a list. It contains three objects:
\tabular{lll}{
n \tab  \tab The total number of records returned by the query\cr
query_translation \tab       \tab The query transaltion by the NCBI Automatic Terms Translation system \cr
web_history \tab      \tab The web history object. The NCBI provides search history features, which isuseful for dealing with large lists of IDs or repeated searches.}

To obtain a free access to NCBI API, please visit: \href{https://www.ncbi.nlm.nih.gov/pmc/tools/developers/}{https://www.ncbi.nlm.nih.gov/pmc/tools/developers/}
}
\description{
It counts the number of documents that a query returns from the NCBI PubMed database.
}
\examples{

\donttest{
query <- "bibliometric*[Title/Abstract] AND english[LA]
           AND Journal Article[PT] AND 2000:2020[DP]"
D <- pmQueryTotalCount(query = query, api_key = NULL)
}

}
\seealso{
\code{\link{pmApiRequest}}

\code{\link{pmApi2df}}
}
