% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epi_functions.R
\name{expand_df}
\alias{expand_df}
\title{Expand a data frame.}
\usage{
expand_df(aggregate.data, index.var = "Freq", retain.freq = FALSE)
}
\arguments{
\item{aggregate.data}{A data frame.}

\item{index.var}{A numerical variable with the frequencies (counts).}

\item{retain.freq}{Logical expression indicating if frequencies should be kept.}
}
\value{
An expanded data frame with replicates given by the frequencies.
}
\description{
\code{expand_df} expands a data frame by a vector of frequencies.
}
\details{
This is a generic function that resembles weighted frequencies in other statistical packages
(for example, Stata). \code{expand.df} was adapted from a function developed by deprecated package
\code{epicalc} (now package \code{epiDisplay}).
}
\examples{
Freq <- c(5032, 5095, 41, 204)
Mortality <- gl(2, 2, labels=c("No", "Yes"))
Calcium <- gl(2, 1, 4, labels=c("No", "Yes"))
anyca <- data.frame(Freq, Mortality, Calcium)
anyca
anyca.exp <- expand_df(anyca)
with(anyca.exp, table(Calcium, Mortality))
}
