% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epi_functions.R
\name{prop_or}
\alias{prop_or}
\title{Proportion, p1 from proportion p2 and OR.}
\usage{
prop_or(p2, or)
}
\arguments{
\item{p2}{The value of a proportion in the unexposed group (p2).}

\item{or}{The odds ratio of p1/p2.}
}
\value{
\code{p1}, the proportion in the exposed group (p1).
}
\description{
\code{prop_or} is a simple function to calculate a proportion, from another proportion and the odds
ratio between them.
}
\examples{
flu <- matrix(c(20, 80, 220, 140), nrow = 2)
colnames(flu) <- c("Yes", "No")
rownames(flu) <- c("Vaccine", "Placebo")
flu

or <- (20 * 140) / (80 * 220)
p2 <- 80 / 220
prop_or(p2 = p2, or = or)
20 / 240
}
