% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranef.R
\name{ranef}
\alias{ranef}
\title{Compute random effects for Poisson-Tweedie and negative binomial mixed model}
\usage{
ranef(obj)
}
\arguments{
\item{obj}{an object of class \code{ptglmm} (obtained from 
\code{ptmixed} or \code{nbmixed} ).}
}
\value{
A vector with the EB estimates of the random effects
}
\description{
Compute the empirical Bayes estimates of the random effects  
for the Poisson-Tweedie and negative binomial generalized 
linear mixed models (fitted through \code{ptmixed} and 
\code{nbmixed} respectively)
}
\examples{
\donttest{
# generate data
set.seed(123)
n = 6; t = 3
id = rep(1:n, each = t)
rand.int = rep(rnorm(n, sd = 0.7), each = t)
group = rep(c(0,1), each = n*t/2)
time = rep(0:(t-1), n)
offset = rnorm(n*t, sd = 0.3)

beta = c(3, 0.3, 0.1)
X = model.matrix(~group + time)
mu = exp(X \%*\% beta + rand.int + offset)
y = rep(NA, n*t)
library(tweeDEseq)
for (i in 1:(n*t)) y[i] = rPT(1, mu = mu[i], D = 2, a = 0, max = 1000)

data.long = data.frame(y, group, time, id, offset)
rm(list = setdiff(ls(), 'data.long'))

# estimate the model
fit1 = nbmixed(fixef.formula = y ~ group + time, id = data.long$id,
              offset = data.long$offset, data = data.long, npoints = 5, 
              freq.updates = 200, hessian = FALSE, trace = TRUE)
              
# obtain random effect estimates
ranef(obj = fit1)
}
}
\seealso{
\code{\link{ptmixed}}, \code{\link{nbmixed}}
}
\author{
Mirko Signorelli
}
