% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeseries.R
\name{pspline.estimate.timeseries}
\alias{pspline.estimate.timeseries}
\title{Calculates confidence intervals for time series sampled from generalized additive (mixed) model of an outbreak}
\usage{
pspline.estimate.timeseries(
  model,
  predictors,
  outcome,
  samples = 1000,
  level = 0.95
)
}
\arguments{
\item{model}{model returned by \code{\link[mgcv]{gam}} or \code{\link[mgcv]{gamm}}, with a single parameter (time)}

\item{predictors}{data frame of predictor values at which the model will be evaluated}

\item{outcome}{function returning calculated outcome time series, as described above}

\item{samples}{number of simulations to run}

\item{level}{confidence level for returned estimates}
}
\value{
data frame of estimates, as described above
}
\description{
This function performs a series of Monte Carlo simulations of a GAM/GAMM outbreak model.
For each simulated outbreak, it calls \code{outcome} to calculate a time series for the
simulated outbreak (for example, the number of cumulative cases vs time).
It then calculates and returns the confidence interval of the simulated time series at
each time point across all simulations
}
\details{
The \code{outcome} function must accept (\code{model}, \code{params}, \code{time}) and return a vector
containing the outcome time series obtained by evaluating the model at the time points given in \code{time} and
using the model parameters given in \code{params}.

A typical implementation of the \code{outcome} function would call \code{predict} on
\code{model} and \code{time} to obtain the linear predictor matrix, and then post-multiply
that matrix by \code{params}. Having thus obtained model prediction at every time point,
it would calculate the desired time series outcome and return it in a vector.

For example, to calculate the time series of the first derivative of incidence,
you might use this function for \code{outcome}:

\code{
calc_deriv = function(model, params, time) {
  eps = 0.001
  predictors = predict(model, data.frame(time=time), type="lpmatrix")
  fit = model$family$linkinv(predictors %*% params)
  predictors_eps = predict(model, data.frame(time=time + eps), type="lpmatrix")
  fit_eps = model$family$linkinv(predictors_eps %*% params)
  (fit_eps - fit) / eps
}
}

The data frame returned by \code{pspline.estimate.timeseries} contains three columns and
one row for each time point in \code{time}. The columns are \code{lower}, \code{median}, and
\code{upper}, containing the median and the confidence interval for the computed
outcome time series at each time point.
}
