% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/protr-package.R
\docType{package}
\name{protr-package}
\alias{protr-package}
\alias{protr}
\title{Generating Various Numerical Representation Schemes for Protein Sequences}
\description{
The protr package is a comprehensive toolkit for generating various
numerical representation schemes of protein sequence.
The descriptors are extensively utilized in bioinformatics and
chemogenomics research. The commonly used descriptors include
amino acid composition, autocorrelation, CTD, conjoint traid,
quasi-sequence order, pseudo amino acid composition, and
profile-based descriptors derived by Position-Specific Scoring Matrix (PSSM).
The descriptors for proteochemometric (PCM) modeling include the scales-based
descriptors derived by principal components analysis, factor analysis,
multidimensional scaling, amino acid properties (AAindex), 20+ classes
of 2D and 3D molecular descriptors (Topological, WHIM, VHSE, etc.),
and BLOSUM/PAM matrix-derived descriptors. The protr package also
integrates the function of parallelized similarity computation derived
by pairwise protein sequence alignment and Gene Ontology (GO) semantic
similarity measures.
}
\note{
The package vignette can be opened with \code{vignette("protr")}.

The web server for this package, \code{ProtrWeb} can be accessed from:
\url{http://protr.org}.

Bug reports and feature requests should be sent to
\url{https://github.com/road2stat/protr/issues}.
}
\references{
Xiao, N., Cao, D.-S., Zhu, M.-F., and Xu, Q.-S. (2015).
protr/ProtrWeb: R package and web server for generating various
numerical representation schemes of protein sequences.
\emph{Bioinformatics} 31 (11), 1857--1859.
}
