% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/k_tuple.R
\name{k_tuple}
\alias{k_tuple}
\alias{sexy_prime_triplets}
\alias{twin_primes}
\alias{cousin_primes}
\alias{sexy_primes}
\alias{third_cousin_primes}
\title{Prime \emph{k}-tuples}
\usage{
k_tuple(min, max, tuple)

sexy_prime_triplets(min, max)

twin_primes(min, max)

cousin_primes(min, max)

sexy_primes(min, max)

third_cousin_primes(min, max)
}
\arguments{
\item{min}{the lower bound of the sequence.}

\item{max}{the upper bound of the sequence.}

\item{tuple}{an integer vector representing the target \emph{k}-tuple pattern.}
}
\value{
A list of vectors of prime numbers satisfying the condition of
\code{tuple}.
}
\description{
Use prime \emph{k}-tuples to create lists of twin primes, cousin primes,
prime triplets, and so forth.
}
\details{
You can construct your own tuples and generate series of primes using
\code{k_tuple}; however, there are functions that exist for some of the named
relationships. They are listed below.

\itemize{
\item \code{twin_primes}: represents \code{c(0,2)}.
\item \code{cousin_primes}: represents \code{c(0,4)}.
\item \code{third_cousin_primes}: represents \code{c(0,8)}.
\item \code{sexy_primes}: represents \code{c(0,6)}.
\item \code{sexy_prime_triplets}: represents \code{c(0,6,12)}. (This relationship is
unique in that \eqn{p + 18} is guaranteed to be composite.)
}

The term "third cousin primes" is of the author's coinage. There is no
canonical name for that relationship to the author's knowledge.
}
\examples{
# All twin primes up to 13
twin_primes(2, 13) # Identical to `k_tuple(2, 13, c(0,2))`
## [[1]]
## [1] 3 5
##
## [[2]]
## [1] 5 7
##
## [[3]]
## [1] 11 13

# Some prime triplets
k_tuple(2, 19, c(0,4,6))
## [[1]]
## [1]  7 11 13
##
## [[2]]
## [1] 13 17 19

}
\author{
Paul Egeler, MS
}
