% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_value.R
\name{validate_value}
\alias{validate_value}
\title{Validate a value}
\usage{
validate_value(
  VALUE,
  validations,
  replacementSources,
  errorMessages,
  convert_bipiped = TRUE
)
}
\arguments{
\item{VALUE}{The value to validate.}

\item{validations}{The validations, a vector or list that will be
consecutively searched for the first valid value (valid being defined as
a value that is not NULL or NA and has, after being trimmed of whitespace,
a nonzero length). That value has to be either as an R expression, or a
character value (i.e. a length 1 character vector) that is a valid R
expression, optionally after having performed the specified replacements.}

\item{replacementSources}{A list of named lists (or 1-row data frames) that
will be searched, consecutively, for values to replace the replacement
strings with.}

\item{errorMessages}{The errormessage to return if validation fails, of which
the first valid one will be returned (valid being defined as a value that is
not NULL or NA and has, after being trimmed of whitespace, a nonzero length).}

\item{convert_bipiped}{Whether to first run \code{\link[=bipiped_value_to_vector]{bipiped_value_to_vector()}} on
the replacment values.}
}
\value{
The message resulting from the validation (i.e. an error or "").
}
\description{
This function validates a value. Before validation, it checks
the validation expression and optionally performs replacements, where the
replacement strings (delimited by the validation replacement delimiters,
by default, \verb{\{\{} and \verb{\}\}}) are
replaced by the first valid corresponding value from the
\code{replacementSources} (working through those sources consecutively, i.e.
only looking in the second one of the first one doesn't contain a valid
value for the relevant replacement string, valid being defined as a value
that is not NULL or NA and has, after being trimmed of whitespace, a
nonzero length).
}
\details{
To change the validation replacement delimiters, use
\code{preregr::opts$set(validation_replacementDelimiters = c("{{", "}}"));}.
}
\examples{
### Set some validation variables
validationStatement <-
  paste(
    "is.na(VALUE) ||",
    "(VALUE \%in\% {{validValues}}) ||",
    "(VALUE \%in\% {{testField}})"
  );
replacementSources <-
  list(
    list(validValues = '"testValue" || "anotherValue"'),
    list(testField = "Yet another testvalue")
  );
errorMessages <-
  "No valid test value passed!";

### Run a passing validation
preregr::validate_value(
  "testValue",
  validations = validationStatement,
  replacementSources = replacementSources,
  errorMessages = errorMessages
);


### Run a failing validation
preregr::validate_value(
  "A testvalue that won't pass",
  validations = validationStatement,
  replacementSources = replacementSources,
  errorMessages = errorMessages
);
}
