% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/registry.R
\name{registry_move}
\alias{registry_move}
\alias{registry}
\alias{data_dir}
\title{Get registry and data directories.}
\usage{
registry_move(corpus, registry, registry_new, home_dir_new)

registry(pkg = NULL)

data_dir(pkg = NULL)
}
\arguments{
\item{corpus}{The ID of the corpus for which the registry file shall be moved.}

\item{registry}{The old registry directory.}

\item{registry_new}{The new registry directory.}

\item{home_dir_new}{The new home directory.}

\item{pkg}{A character string with the name of a single package; if \code{NULL} (default),
the temporary registry and data directory is returned.}
}
\value{
A path to a (registry or data) directory, or NULL, if package does not exist
or is not a package including a corpus.
}
\description{
The Corpus Workbench (CWB) uses a registry directory with plain text files
describing corpora in a standardized format. The binary files of a corpus are
stored in a data directory defined in the registry directory. The
\code{registry} and \code{data_dir} functions return the respective
direcories within a package, if the argument \code{pkg} is used, or the
temporary registry and data directory in the per-session temporary directory,
if \code{pkg} is \code{NULL} (default value).
}
\details{
The \code{registry_move} is an auxiliary function to create a copy
  of a registry file in the directory specified by the argument
  \code{registry_new}.

Upon loading the polmineR package, there is a check whether the
  environment variable \code{CORPUS_REGISTRY} is defined. In case it is, the
  registry files in the directory defined by the \code{CORPUS_REGISTRY}
  environment variable are copied to the temporary registry directory, which
  serves as the central place to store all registry files for all corpora, be
  it system corpora, corpora included in R packages, or temporary corpora.

The Corpus Workbench may have problems to cope with a registry path
  that includes registry non-ASCII characters. On Windows, a call to
  \code{utils::shortPathName} will generate the short MS-DOS path name that
  circumvents resulting problems.

Usage of the temporary registry directory can be suppress by setting
  the environment variable POLMINER_USE_TMP_REGISTRY as 'false'. In this
  case, the \code{registry} function will return the environment variable
  CORPUS_REGISTRY unchanged. The \code{data_dir} function will return the
  "indexed_corpus" directory that is assumed to live in the same parent
  directory as the registry directory.
}
\examples{
registry() # returns temporary registry directory
registry(pkg = "polmineR") # returns registry directory in polmineR-package

data_dir()
data_dir(pkg = "polmineR")
}
