% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pchisqC.r
\name{pchisqC}
\alias{pchisqC}
\title{Comparing Logistic Regression Models with Chi-Squared Test}
\usage{
pchisqC(reduced, full, digits = 3)
}
\arguments{
\item{reduced}{The reduced logisitic regression model as an object. This is model with fewer independent variables.}

\item{full}{The full logisitic regression model as an object. This is model with more independent variables.}

\item{digits}{The number of digits to display after decimal point, default is 3.}
}
\value{
The chi-squared statistic, df, and p-value as a vector of numbers to test null hypothesis that full model no better than reduced model.
}
\description{
Comparing Logistic Regression Models with Chi-Squared Test
}
\examples{
   library(poliscidata)
   
   obama_vote_model_reduced <- svyglm(obama_vote ~ ft_dem + white, design=nesD, 
                                      family="quasibinomial")
   obama_vote_model_full <- svyglm(obama_vote ~ ft_dem + white + (owngun_owngun=="1. Yes"), 
                                   design=nesD, family="quasibinomial")
   pchisqC(obama_vote_model_reduced, obama_vote_model_full)
}

