% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_objects.R
\name{custom_filter}
\alias{custom_filter}
\title{Custom Filter Object}
\usage{
custom_filter(
  omicsData,
  e_data_remove = NULL,
  f_data_remove = NULL,
  e_meta_remove = NULL,
  e_data_keep = NULL,
  f_data_keep = NULL,
  e_meta_keep = NULL
)
}
\arguments{
\item{omicsData}{an object of class 'pepData', 'proData', 'metabData',
'lipidData', 'nmrData', or 'seqData', created by \code{\link{as.pepData}},
\code{\link{as.proData}}, \code{\link{as.metabData}},
\code{\link{as.lipidData}}, \code{\link{as.nmrData}},
\code{\link{as.seqData}}, respectively.}

\item{e_data_remove}{character vector specifying the names of the e_data
identifiers to remove from the data. This argument can only be specified
with other 'remove' arguments.}

\item{f_data_remove}{character vector specifying the names of f_data
identifiers to remove from the data. This argument can only be specified
with other 'remove' arguments.}

\item{e_meta_remove}{character vector specifying the names of the e_meta
identifiers to remove from the data. This argument can only be specified
with other 'remove' arguments.}

\item{e_data_keep}{character vector specifying the names of the e_data
identifiers to keep from the data. This argument can only be specified with
other 'keep' arguments.}

\item{f_data_keep}{character vector specifying the names of f_data
identifiers to keep from the data. This argument can only be specified with
other 'keep' arguments.}

\item{e_meta_keep}{character vector specifying the names of the e_meta
identifiers to keep from the data. This argument can only be specified with
other 'keep' arguments.}
}
\value{
An S3 object of class 'customFilt', which is a list with 3 elements
  for e_data, f_data, and e_meta, specifying which entries should be either
  kept or removed
}
\description{
This function creates a customFilt S3 object based on user-specified items to
filter out of the dataset
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(pmartRdata)
to_filter <- custom_filter(omicsData = metab_object, 
                           e_data_remove = "fumaric acid",
                           f_data_remove = "Sample_1_Phenotype2_B")
summary(to_filter)

to_filter2 <- custom_filter(omicsData = metab_object, 
                            f_data_keep = metab_object$f_data$SampleID[1:10])
summary(to_filter2)
\dontshow{\}) # examplesIf}
}
\author{
Kelly Stratton
}
