% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edata_replace.R
\name{edata_replace}
\alias{edata_replace}
\title{Replace Values Equal to x with y}
\usage{
edata_replace(omicsData, x, y)
}
\arguments{
\item{omicsData}{an object of the class 'pepData', 'proData', 'metabData',
'lipidData', or 'nmrData' created by \code{\link{as.pepData}},
\code{\link{as.proData}}, \code{\link{as.metabData}},
\code{\link{as.lipidData}}, or \code{\link{as.nmrData}}, respectively.}

\item{x}{value to be replaced, usually numeric or NA}

\item{y}{replacement value, usually numeric or NA}
}
\value{
data object of the same class as omicsData
}
\description{
This function finds all values of x in the e_data element of omicsData and
replaces them with y
}
\details{
This function is often used to replace any 0 values in peptide,
  protein, metabolite, or lipid data with NA's. For omicsData on the
  abundance scale, when the omicsData object is created, any 0's in e_data
  are automatically converted to NA's. For omicsData on the count scale (e.g.
  seqData objects), when the omicsData object is created, any NA's in e_data
  are automatically converted to 0's.
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(pmartRdata)
mymetab <- edata_replace(omicsData = metab_object, x = 0, y = NA)
\dontshow{\}) # examplesIf}
}
\author{
Kelly Stratton
}
