% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_rocci.R
\docType{data}
\name{StatRocci}
\alias{StatRocci}
\alias{stat_rocci}
\title{Calculate confidence regions for the empirical ROC curve}
\format{
An object of class \code{StatRocci} (inherits from \code{Stat}, \code{ggproto}, \code{gg}) of length 5.
}
\usage{
StatRocci

stat_rocci(
  mapping = NULL,
  data = NULL,
  geom = "rocci",
  position = "identity",
  show.legend = NA,
  inherit.aes = TRUE,
  ci.at = NULL,
  sig.level = 0.05,
  na.rm = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{The geometric object to use display the data}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{ci.at}{Vector of cutoffs at which to display confidence regions. If
NULL, will automatically choose 3 evenly spaced points to display the regions}

\item{sig.level}{Significance level for the confidence regions}

\item{na.rm}{Remove missing observations}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\description{
Confidence intervals for TPF and FPF are calculated using the exact 
  method of Clopper and Pearson (1934) each at the level \code{1 - sqrt(1 - 
  alpha)}. Based on result 2.4 from Pepe (2003), the cross-product of these 
  intervals yields a 1 - alpha % confidence region for (FPF, TPF).
}
\section{Aesthetics}{
 
\code{stat_rocci} understands the following aesthetics (required aesthetics
are in bold):
\itemize{
  \item \strong{\code{m}} The continuous biomarker/predictor
  \item \strong{\code{d}} The binary outcome, if not coded as 0/1, the 
  smallest level in sort order is assumed to be 0, with a warning
  \item \code{alpha}
  \item \code{color}
  \item \code{fill}
  \item \code{linetype}
  \item \code{size}
}
}

\section{Computed variables}{

\describe{
  \item{FPF}{estimate of false positive fraction}
  \item{TPF}{estimate of true positive fraction}
  \item{cutoffs}{values of m at which estimates are calculated}
  \item{FPFL}{lower bound of confidence region for FPF}
  \item{FPFU}{upper bound of confidence region for FPF}
  \item{TPFL}{lower bound of confidence region for TPF}
  \item{TPFU}{upper bound of confidence region for TPF}
}
}

\examples{
D.ex <- rbinom(50, 1, .5)
rocdata <- data.frame(D = c(D.ex, D.ex), 
                   M = c(rnorm(50, mean = D.ex, sd = .4), rnorm(50, mean = D.ex, sd = 1)), 
                   Z = c(rep("A", 50), rep("B", 50)))

ggplot(rocdata, aes(m = M, d = D)) + geom_roc() + stat_rocci()
ggplot(rocdata, aes(m = M, d = D)) + geom_roc() + 
stat_rocci(ci.at = quantile(rocdata$M, c(.1, .3, .5, .7, .9)))

}
\references{
\itemize{
\item Clopper, C. J., and Egon S. Pearson. "The use of confidence or fiducial limits illustrated in the case of the binomial." Biometrika (1934): 404-413.
\item Pepe, M.S. "The Statistical Evaluation of Medical Tests for Classification and Prediction." Oxford (2003). 
}
}
\keyword{datasets}
