% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_landmarks.R
\name{landmarks_angle}
\alias{landmarks_angle}
\title{Angles between landmarks}
\usage{
landmarks_angle(x, unit = c("rad", "deg"))
}
\arguments{
\item{x}{An object computed with \code{\link[=landmarks]{landmarks()}}.}

\item{unit}{The unit of the angle. Defaults to radian (rad). Use \code{unit = "deg"} to return the angles in degrees.}
}
\value{
A matrix with the angles for each landmark combination.
}
\description{
Computes the angle from two interlandmark vectors using the difference of
their arguments using complex vectors (Claude, 2008).
}
\note{
Borrowed from Claude (2008), pp. 50
}
\examples{
if(isTRUE(interactive())){
library(pliman)
img <- image_pliman("potato_leaves.jpg")
x <- landmarks(img)
landmarks_angle(x)
}
}
\references{
Claude, J. (2008) \emph{Morphometrics with R}, Use R! series,
Springer 316 pp.
}
