% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.iterations.R
\name{iterationPlot}
\alias{iterationPlot}
\title{Plots estimated parameters by iteration for the gpcm and nominal models}
\usage{
iterationPlot(model.fit)
}
\arguments{
\item{model.fit}{Object from fitting nominal or gpcm model to data}
}
\value{
Plots of estimated parameters by iteration
}
\description{
This is a utility function that plots the estimated item parameters
by iterations.  The plots can be used to determine how many iterations
are required to get close to final values.  This functions can be used
uni- or multi-dimensional gpcm and models.  The number of pages equals
the number of items and each page has the plots of marginal effects
(left side) and category scale values or alph parameters (right).
}
\examples{

\donttest{
data(dass)
inData <- dass[1:250,c("d1", "d2", "d3", "a1","a2","a3","s1","s2","s3")]
#---   input for uni-dimensional
inTraitAdj  <- matrix(1, nrow=1, ncol=1)
inItemTraitAdj <- matrix(1, nrow=9, ncol=1)

#--- generalized partial credit model
g1 <- ple.lma(inData, model.type="gpcm", inItemTraitAdj, inTraitAdj)
iterationPlot(g1)

#--- nominal response model
n1 <- ple.lma(inData, model.type="nominal", inItemTraitAdj,inTraitAdj)
iterationPlot(n1)


#--- Multidimensional models
 inTraitAdj  <- matrix(1, nrow=3, ncol=3)

dpress <- matrix(c(1,0,0), nrow=3, ncol=3, byrow=TRUE)
anxiety <- matrix(c(0,1,0), nrow=3, ncol=3, byrow=TRUE)
stress <- matrix(c(0,0,1), nrow=3, ncol=3, byrow=TRUE)
das <- list(dpress, anxiety, stress)
inItemTraitAdj <- rbind(das[[1]], das[[2]], das[[3]])

g3 <- ple.lma(inData, model.type="gpcm", inItemTraitAdj, inTraitAdj)
iterationPlot(g3)

n3 <- ple.lma(inData, model.type="nominal", inItemTraitAdj, inTraitAdj)
iterationPlot(n3)
}

}
