% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.poset.R
\docType{methods}
\name{add.poset}
\alias{add.poset}
\alias{add.poset,pim.environment-method}
\title{Add a poset to a pim.environment object}
\usage{
add.poset(x, ...)

\S4method{add.poset}{pim.environment}(x, overwrite = FALSE, ...)
}
\arguments{
\item{x}{a pim.environment object}

\item{...}{further parameters passed to \code{\link{new.pim.poset}}.}

\item{overwrite}{a logical value indicating whether the poset
should be overwritten if it's already present. Defaults to 
\code{FALSE} to avoid problems.}
}
\value{
The object with a (new) poset attached.
}
\description{
This function adds a poset to a \code{\link{pim.environment}}
object.
}
\section{Warning}{
 Although it might be tempting to pass the argument
\code{nobs} to \code{\link{new.pim.poset}}, you shouldn't. 
The necessary information is taken from the respective slot 
in the \code{pim.environment} object.

If you provide a matrix or a list as value for the argument \code{compare},
note that you can easily create a poset that doesn't use all the 
observations. This might or might not be your intention. If the poset
you try to create contains indices that go beyond the number of
observations, you will get errors.
}

\examples{

data(DysData)
Dysenv <- new.pim.env(DysData)
Dysenv
DysenvAll <- add.poset(Dysenv, overwrite = TRUE, 
                       compare = 'all', nobs = nobs(DysData))
compare(Dysenv)
compare(DysenvAll)                       


}
\seealso{
\code{\link{new.pim.poset}} for the possible values of the
arguments \code{compare} and \code{nobs}.
}
