% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ornament.R
\name{new_ornament}
\alias{new_ornament}
\title{Helper to define the contents of a pillar}
\usage{
new_ornament(x, width = NULL, align = NULL)
}
\arguments{
\item{x}{A character vector with formatting,
can use ANYI styles e.g provided by the \pkg{cli} package.}

\item{width}{An optional width of the resulting pillar, computed from \code{x} if
missing}

\item{align}{Alignment, one of \code{"left"} or \code{"right"}}
}
\description{
This function is useful if your data renders differently depending on the
available width. In this case, implement the \code{\link[=pillar_shaft]{pillar_shaft()}} method for your
class to return a subclass of "pillar_shaft" and have the \code{\link[=format]{format()}} method
for this subclass call \code{new_ornament()}. See the implementation of
\code{pillar_shaft.numeric()} and \code{format.pillar_shaft_decimal()} for an example.
}
\examples{
new_ornament(c("abc", "de"), align = "right")
}
