% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefs.R
\name{coefs}
\alias{coefs}
\title{Extract path coefficients}
\usage{
coefs(modelList, standardize = "scale", standardize.type = "latent.linear",
  intercepts = FALSE)
}
\arguments{
\item{modelList}{A list of structural equations.}

\item{standardize}{The type of standardization: \code{none}, \code{scale}, \code{range}.
Default is \code{scale}.}

\item{standardize.type}{The type of standardized for non-Gaussian responses:
\code{latent.linear}, \code{Menard.OE}. Default is \code{latent.linear}.}

\item{intercepts}{Whether intercepts should be included in the coefficients
table. Default is FALSE.}
}
\value{
Returns a \code{data.frame} of coefficients, their standard errors,
degrees of freedom, and significance tests.
}
\description{
Extracts (standardized) path coefficients from a \code{psem} object.
}
\details{
P-values for models constructed using \code{lme4} are obtained
using the Kenward-Roger approximation of the denominator degrees of freedom
as implemented in the \code{pbkrtest} package.

Different forms of standardization can be implemented using the \code{standardize}
argument:\itemize{
\item{\code{none} No standardized coefficients are reported.}
\item{\code{scale} Raw coefficients are scaled by the ratio of the standard deviation
of x divided by the standard deviation of y. See below for cases pertaining to GLM. }
\item{\code{range} Raw coefficients are scaled by a pre-selected range of x
divided by a preselected range of y. The default argument is \code{range} which takes the
two extremes of the data, otherwise the user must supply must a named \code{list} where
the names are the variables to be standardized, and each entry contains a vector of length 2
to the ranges to be used in standardization.}
}

For binary response models (i.e., binomial responses), standardized coefficients
are obtained in one of two ways:\itemize{
\item{\code{latent.linear} Referred to in Grace et al. (in review) as the standard form of
the latent-theoretic (LT) approach. In this method, there is assumed to be a continuous
latent propensity, y*, that underlies the observed binary responses. The standard
deviation of y* is computed as the square-root of the variance of the predictions
(on the linear or 'link' scale) plus the distribution-specific assumed variance
(for logit links: pi^2/3, for probit links: 1).}
\item{\code{Menard.OE} Referred to in Grace et al. (in review) as the standard form of
the observed-empirical (OE) approach. In this method, error variance is based on the
differences between predicted scores and the observed binary data. The standard
deviation used for standardization is computed as the square-root of the variance of
the predictions (on the linear scale) plus the correlation between the observed and
predicted (on the original or 'response' scale) values of y.}
}
}
\references{
Grace, J.B., Johnson, D.A., Lefcheck, J.S., and Byrnes, J.E.
"Standardized Coefficients in Regression and Structural Models with Binary Outcomes." 
Ecosphere 9(6): e02283.
}
\seealso{
\code{\link{KRmodcomp}}
}
\author{
Jon Lefcheck <jlefcheck@bigelow.org>, Jim Grace
}
