% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index-class.R
\name{piar_index}
\alias{piar_index}
\alias{chainable_piar_index}
\alias{direct_piar_index}
\alias{aggregate_piar_index}
\title{Price index objects}
\description{
There are several classes to represent price indexes.
\itemize{
\item All indexes inherit from the \code{piar_index} virtual class.
\item Period-over-period indexes that can be chained over time inherit from
\code{chainable_piar_index}.
\item Fixed-base indexes inherit from \code{direct_piar_index}.
\item Aggregate price indexes that are the result of aggregating elemental
indexes with an aggregation structure further inherit from
\code{aggregate_piar_index}.
}
}
\details{
The \code{piar_index} object is a list-S3 class with the following
components:
\describe{
\item{index}{A list with an entry for each period in \code{time} that gives
a vector of index values for each level in \code{levels}.}
\item{contrib}{A list with an entry for each period in \code{time}, which
itself contains a list with an entry for each level in \code{levels} with
a named vector that gives the additive contribution for each price relative.}
\item{levels}{A character vector giving the levels of the index.}
\item{time}{A character vector giving the time periods for the index.}
}

The \code{chainable_piar_index} and \code{direct_piar_index} subclasses have
the same structure as the \code{piar_index} class, but differ in the methods
used to manipulate the indexes.

The \code{aggregate_piar_index} class further subclasses either
\code{chainable_piar_index} or \code{direct_piar_index}, and adds the
following components:
\describe{
\item{r}{The order of the generalized mean used to aggregated the
index (usually 1).}
\item{pias}{A list containing the \code{child}, \code{parent}, \code{eas}, and \code{height}
components of the aggregation structured used to aggregate the index.}
}
}
