% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrib.R
\name{contrib}
\alias{contrib}
\alias{contrib.piar_index}
\title{Extract percent-change contributions}
\usage{
contrib(x, ...)

\method{contrib}{piar_index}(x, level = levels(x), ...)
}
\arguments{
\item{x}{A price index, as made by, e.g., \code{\link[=elemental_index]{elemental_index()}}.}

\item{...}{Further arguments passed to or used by methods.}

\item{level}{The level of an index for which percent-change contributions
are desired, defaulting to the first level (usually the top-level for an
aggregate index).}
}
\value{
A matrix of percent-change contributions with a column for each
\code{period} and a row for each product (sorted) for which there are
contributions in \code{level}. Contributions are padded with 0 to fit into a
rectangular array when products differ over time.
}
\description{
Extract a matrix of percent-change contributions from a price index.
}
\examples{
prices <- data.frame(
  rel = 1:8,
  period = rep(1:2, each = 4),
  ea = rep(letters[1:2], 4)
)

epr <- with(
  prices,
  elemental_index(rel, period, ea, contrib = TRUE)
)

pias <- aggregation_structure(
  list(c("top", "top", "top"), c("a", "b", "c")), 1:3
)

index <- aggregate(epr, pias, na.rm = TRUE)

# Percent-change contributions for the top-level index

contrib(index)

# Calculate EA contributions for the chained index

library(gpindex)

arithmetic_contributions(
  as.matrix(chain(index))[c("a", "b", "c"), 2],
  weights(pias, ea_only = TRUE)
)

}
\seealso{
Other index methods: 
\code{\link{[.piar_index}()},
\code{\link{aggregate.piar_index}()},
\code{\link{as.data.frame.piar_index}()},
\code{\link{chain}()},
\code{\link{head.piar_index}()},
\code{\link{levels.piar_index}()},
\code{\link{mean.piar_index}()},
\code{\link{merge.piar_index}()},
\code{\link{stack.piar_index}()},
\code{\link{time.piar_index}()},
\code{\link{vcov.aggregate_piar_index}()}
}
\concept{index methods}
