#' Rhinogrades traits.
#'
#' A simulated dataset, as used by Gonzalez-Voyer and Von Hardenberg as an
#' example, containing variables on body mass (BM), litter size (LS), nose
#' length (NL), dispersal distance (DD) and range size (RS).
#'
#' @source Gonzalez-Voyer A & von Hardenberg A. 2014. An Introduction to
#'   Phylogenetic Path Analysis. Chapter 8. In: Garamszegi LZ (ed.), Modern
#'   Phylogenetic Comparative Methods and Their Application in Evolutionary
#'   Biology. pp. 201-229. Springer-Verlag Berlin Heidelberg.
#'   doi:10.1111/j.1558-5646.2012.01790.x
"rhino"

#' Rhinogrades phylogeny.
#'
#' A phylogenetic tree for the 100 species of the \code{rhino} dataset.
#'
#' @source Gonzalez-Voyer A & von Hardenberg A. 2014. An Introduction to
#'   Phylogenetic Path Analysis. Chapter 8. In: Garamszegi LZ (ed.), Modern
#'   Phylogenetic Comparative Methods and Their Application in Evolutionary
#'   Biology. pp. 201-229. Springer-Verlag Berlin Heidelberg.
#'   doi:10.1111/j.1558-5646.2012.01790.x
"rhino_tree"

#' Cichlid traits and the evolution of cooperative breeding.
#'
#' A data set with binary traits, used in an analysis on the evolution of
#' cooperative breeding by Dey et al 2017. Variable names are shortened for
#' easy of use and consist of cooperative breeding (C), mating system (M),
#' parental care (P), social grouping (G) and diet (D). All traits are coded as
#' two level factors.
#'
#' @source Dey, C.J., O'Connor, C.M., Wilkinson, H., Shultz, S., Balshine, S. &
#'   Fitzpatrick, J.L. 2017. Direct benefits and evolutionary transitions to
#'   complex societies. Nat Ecol Evol 1: 137.
"cichlids"

#' Cichlid phylogeny.
#'
#' The phylogenetic tree of cichlid species that accompanies the `cichlids`
#' dataset. The phylogeny is based on five nuclear genes and three
#' mitochondrial genes.
#'
#' @source Dey, C.J., O'Connor, C.M., Wilkinson, H., Shultz, S., Balshine, S. &
#'   Fitzpatrick, J.L. 2017. Direct benefits and evolutionary transitions to
#'   complex societies. Nat Ecol Evol 1: 137.
"cichlids_tree"