% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/phreeqc.R
\docType{data}
\name{ex11}
\alias{ex11}
\title{Example 11--Transport and Cation Exchange}
\source{
\url{http://wwwbrr.cr.usgs.gov/projects/GWC_coupled/phreeqc}
}
\description{
The following example simulates the chemical composition of the
effluent from a column containing a cation exchanger (Appelo and Postma,
2005). Initially, the column contains a sodium-potassium-nitrate solution
in equilibrium with the exchanger. The column is flushed with three pore
volumes of calcium chloride solution. Calcium, potassium, and sodium react
to equilibrium with the exchanger at all times. The problem is run two
ways--by using the ADVECTION data block, which models only advection, and by
using the TRANSPORT data block, which simulates advection and dispersive
mixing. The example can be run using the \code{\link{phrRunString}} routine.
}
\examples{
phrLoadDatabaseString(phreeqc.dat)
phrSetOutputStringsOn(TRUE)
phrRunString(ex11)
phrGetOutputStrings()
}
\references{
\url{http://pubs.usgs.gov/tm/06/a43/pdf/tm6-A43.pdf}
}
\seealso{
Other Examples: \code{\link{ex10}}; \code{\link{ex12}};
  \code{\link{ex13a}}, \code{\link{ex13b}},
  \code{\link{ex13c}}; \code{\link{ex14}};
  \code{\link{ex15}}; \code{\link{ex16}};
  \code{\link{ex17}}; \code{\link{ex18}};
  \code{\link{ex19}}; \code{\link{ex1}};
  \code{\link{ex20a}}, \code{\link{ex20b}};
  \code{\link{ex21}}; \code{\link{ex22}};
  \code{\link{ex2}}; \code{\link{ex3}}; \code{\link{ex4}};
  \code{\link{ex5}}; \code{\link{ex6}}; \code{\link{ex7}};
  \code{\link{ex8}}; \code{\link{ex9}}
}
\keyword{dataset}

