% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlap_coefficient.R
\name{overlap_coefficient}
\alias{overlap_coefficient}
\title{Calculate overlap coefficient between pathways}
\usage{
overlap_coefficient(pathwayA, pathwayB, pathways = NULL, organism = NULL)
}
\arguments{
\item{pathwayA}{a character string of pathway name or pathway code or a
character vector of metabolite names or metabolite codes}

\item{pathwayB}{a character string of pathway name or pathway code or a
character vector of metabolite names or metabolite codes}

\item{pathways}{data.frame or matrix with metabolites in rows and the
following information in columns: \itemize{
 \item \code{metabolite_code} metabolite code
 \item \code{metabolite_name} metabolite name
 \item \code{pathway_code} pathway code (identifier)
 \item \code{pathway_name} name of the pathway
}
Used if \code{pathwayA} and \code{pathwayB} are pathway names or pathway
codes.}

\item{organism}{organism code in KEGG database. Required if
\code{pathways = NULL} and \code{pathwayA} and \code{pathwayB} are pathway 
names and ignored otherwise.}
}
\value{
A value between 0 and 1 calculated with the formula:
\deqn{\text{OC}(A,B) = \frac{\vert A \cap B \vert}{\min(\vert A \vert,
\vert B \vert)}}
An overlap coefficient of 1 means that one pathway is included in the other.
An overlap coefficient of 0 means that there is no overlap between the
pathways.
}
\description{
Calculate overlap coefficient between pathways
}
\examples{
data("MTBLS422")
pathwayA <- "Galactose metabolism"
pathwayB <- "Vitamin digestion and absorption"
overlap_coefficient(pathwayA, pathwayB, pathways)

if (requireNamespace("KEGGREST", quietly = TRUE)) {
  pathwayA <- "Galactose metabolism"
  pathwayB <- "Vitamin digestion and absorption"
  \donttest{
  overlap_coefficient(pathwayA, pathwayB, organism = "mmu")
  }
}

pathwayA <- "mmu00052"
pathwayB <- "mmu00562"
overlap_coefficient(pathwayA, pathwayB, pathways)

pathwayA <- c("C00029", "C00116", "C00137", "C00794", "C00984", "C01697")
pathwayB <- c("C00191", "C00092", "C00137")
overlap_coefficient(pathwayA, pathwayB)

}
\references{
Wieder C., Lai R.P.J., Ebbels T.M.D. (2022). Single sample pathway analysis
in metabolomics: performance evaluation and application.
\emph{BMC Bioinformatics}, \strong{23}, 481.
\doi{10.1186/s12859-022-05005-1}
}
