% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pedigree.R
\name{editPed}
\alias{editPed}
\title{Edits a disordered or incomplete pedigree.}
\usage{
editPed(sire, dam, label, verbose = FALSE)
}
\arguments{
\item{sire}{integer vector or factor representation of the sires}

\item{dam}{integer vector or factor representation of the dams}

\item{label}{character vector of labels}

\item{verbose}{logical to print the row of the pedigree that the
function is ordering. Default is FALSE.}
}
\value{
a data frame with the pedigree ordered.
}
\description{
1_ add labels for the sires and dams not listed as labels before.
2_ order pedigree based on recursive calls to getGenAncestors.
}
\examples{
pede <- data.frame(sire=as.character(c(NA,NA,NA,NA,NA,1,3,5,6,4,8,1,10,8)),
                   dam=as.character(c(NA,NA,NA,NA,NA,2,2,NA,7,7,NA,9,9,13)),
                   label=as.character(1:14))
pede <- pede[sample(replace=FALSE, 1:14),]
pede <- editPed(sire=pede$sire, dam=pede$dam, label=pede$label)
ped <- with(pede, pedigree(label=label, sire=sire, dam=dam))
}

