# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Pediatric Blood Pressure
#'
#' @description Pediatric Blood Pressure quantile and probability
#' (distribution function) values
#'
#' @details
#'
#' \code{height} is used preferentially over \code{height_percentile} over
#' \code{default_height_percentile}.
#'
#' \code{source} can be one of \code{"gemelli1990"}, \code{"lo2013"},
#' \code{"nhlbi"}, \code{"flynn2017"}, or \code{"martin2022"}.
#'
#' @param qp_sbp the quantile(s) or probability(s) for systolic blood pressure
#' @param qp_dbp the quantile(s) or probability(s) for diastolic blood pressure
#' @param age numeric vector, in months
#' @param male integer vector; 0 = female, 1 = male
#' @param height numeric vector of stature
#' @param height_percentile numeric vector for height percentiles, expected
#'        values between 0 and 1.
#' @param default_height_percentile default height percentile to use if \code{height} is missing
#' @param source the method, or data set, to use as the reference.
#' @param type quantile or distribution to return
#'
#' @return
#' A list:
#'
#' [[1]] systolic blood pressure quantiles or probability (defined by the input value of \code{type}).
#' [[2]] diastolic blood pressure quantiles or probability (defined by the input value of \code{type}).
#'
#' \code{attr(, "bp_params")} is a \code{data.frame} with the values for the
#' look up table(s) needed to inform the sbp and dbp values.
cppBP <- function(qp_sbp, qp_dbp, age, male, height, height_percentile, default_height_percentile, source, type) {
    .Call('_pedbp_cppBP', PACKAGE = 'pedbp', qp_sbp, qp_dbp, age, male, height, height_percentile, default_height_percentile, source, type)
}

#' @title Pediatric Growth Standards
#'
#' @description Pediatric growth standard based on LMS data from the CDC and WHO.
#'
#' @details expect to call this from R after checking some functional
#' arguments within R.
#'
#' @param metric string, for example bmi_for_age
#' @param source string, CDC or WHO
#' @param male  integer, 0 = female; 1 = male
#' @param x is the age (in months), length (cm) or height (cm) as needed for
#' the metric.
#' @param qp the quantile or percentile, whichever is relevant for the type
#' @param type quantile, distribution, or zscore
#'
cppPGSF <- function(metric, source, male, x, qp, type) {
    .Call('_pedbp_cppPGSF', PACKAGE = 'pedbp', metric, source, male, x, qp, type)
}

