% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{macie}
\alias{macie}
\title{Amazon Macie}
\usage{
macie(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\description{
Amazon Macie is a security service that uses machine learning to
automatically discover, classify, and protect sensitive data in AWS.
Macie recognizes sensitive data such as personally identifiable
information (PII) or intellectual property, and provides you with
dashboards and alerts that give visibility into how this data is being
accessed or moved. For more information, see the \href{https://docs.aws.amazon.com/macie/latest/userguide/what-is-macie.html}{Macie User Guide}.
}
\section{Service syntax}{
\preformatted{svc <- macie(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=macie_associate_member_account]{associate_member_account} \tab Associates a specified AWS account with Amazon Macie as a member account \cr
\link[=macie_associate_s3_resources]{associate_s3_resources} \tab Associates specified S3 resources with Amazon Macie for monitoring and data classification\cr
\link[=macie_disassociate_member_account]{disassociate_member_account} \tab Removes the specified member account from Amazon Macie \cr
\link[=macie_disassociate_s3_resources]{disassociate_s3_resources} \tab Removes specified S3 resources from being monitored by Amazon Macie \cr
\link[=macie_list_member_accounts]{list_member_accounts} \tab Lists all Amazon Macie member accounts for the current Amazon Macie master account \cr
\link[=macie_list_s3_resources]{list_s3_resources} \tab Lists all the S3 resources associated with Amazon Macie \cr
\link[=macie_update_s3_resources]{update_s3_resources} \tab Updates the classification types for the specified S3 resources
}
}

\examples{
\donttest{svc <- macie()
svc$associate_member_account(
  Foo = 123
)}

}
