% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_update_bandwidth_rate_limit}
\alias{storagegateway_update_bandwidth_rate_limit}
\title{Updates the bandwidth rate limits of a gateway}
\usage{
storagegateway_update_bandwidth_rate_limit(
  GatewayARN,
  AverageUploadRateLimitInBitsPerSec = NULL,
  AverageDownloadRateLimitInBitsPerSec = NULL
)
}
\arguments{
\item{GatewayARN}{[required]}

\item{AverageUploadRateLimitInBitsPerSec}{The average upload bandwidth rate limit in bits per second.}

\item{AverageDownloadRateLimitInBitsPerSec}{The average download bandwidth rate limit in bits per second.}
}
\description{
Updates the bandwidth rate limits of a gateway. You can update both the upload and download bandwidth rate limit or specify only one of the two. If you don't set a bandwidth rate limit, the existing rate limit remains. This operation is supported only for the stored volume, cached volume, and tape gateway types. To update bandwidth rate limits for S3 file gateways, use \code{\link[=storagegateway_update_bandwidth_rate_limit_schedule]{update_bandwidth_rate_limit_schedule}}.

See \url{https://www.paws-r-sdk.com/docs/storagegateway_update_bandwidth_rate_limit/} for full documentation.
}
\keyword{internal}
