% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_get_object_retention}
\alias{s3_get_object_retention}
\title{Retrieves an object's retention settings}
\usage{
s3_get_object_retention(
  Bucket,
  Key,
  VersionId = NULL,
  RequestPayer = NULL,
  ExpectedBucketOwner = NULL
)
}
\arguments{
\item{Bucket}{[required] The bucket name containing the object whose retention settings you want
to retrieve.

When using this action with an access point, you must direct requests to
the access point hostname. The access point hostname takes the form
\emph{AccessPointName}-\emph{AccountId}.s3-accesspoint.\emph{Region}.amazonaws.com.
When using this action with an access point through the Amazon Web
Services SDKs, you provide the access point ARN in place of the bucket
name. For more information about access point ARNs, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html}{Using access points}
in the \emph{Amazon S3 User Guide}.}

\item{Key}{[required] The key name for the object whose retention settings you want to
retrieve.}

\item{VersionId}{The version ID for the object whose retention settings you want to
retrieve.}

\item{RequestPayer}{}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the bucket is owned by a
different account, the request fails with the HTTP status code
\verb{403 Forbidden} (access denied).}
}
\description{
Retrieves an object's retention settings. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock.html}{Locking Objects}.

See \url{https://paws-r.github.io/docs/s3/get_object_retention.html} for full documentation.
}
\keyword{internal}
