% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efs_operations.R
\name{efs_create_mount_target}
\alias{efs_create_mount_target}
\title{Creates a mount target for a file system}
\usage{
efs_create_mount_target(
  FileSystemId,
  SubnetId,
  IpAddress = NULL,
  SecurityGroups = NULL
)
}
\arguments{
\item{FileSystemId}{[required] The ID of the file system for which to create the mount target.}

\item{SubnetId}{[required] The ID of the subnet to add the mount target in. For file systems that
use One Zone storage classes, use the subnet that is associated with the
file system's Availability Zone.}

\item{IpAddress}{Valid IPv4 address within the address range of the specified subnet.}

\item{SecurityGroups}{Up to five VPC security group IDs, of the form \code{sg-xxxxxxxx}. These must
be for the same VPC as subnet specified.}
}
\description{
Creates a mount target for a file system. You can then mount the file system on EC2 instances by using the mount target.

See \url{https://paws-r.github.io/docs/efs/create_mount_target.html} for full documentation.
}
\keyword{internal}
