% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_admin_update_auth_event_feedback}
\alias{cognitoidentityprovider_admin_update_auth_event_feedback}
\title{Provides feedback for an authentication event indicating if it was from
a valid user}
\usage{
cognitoidentityprovider_admin_update_auth_event_feedback(
  UserPoolId,
  Username,
  EventId,
  FeedbackValue
)
}
\arguments{
\item{UserPoolId}{[required] The user pool ID.}

\item{Username}{[required] The username of the user that you want to query or modify. The value of
this parameter is typically your user's username, but it can be any of
their alias attributes. If \code{username} isn't an alias attribute in your
user pool, this value must be the \code{sub} of a local user or the username
of a user from a third-party IdP.}

\item{EventId}{[required] The authentication event ID.}

\item{FeedbackValue}{[required] The authentication event feedback value. When you provide a
\code{FeedbackValue} value of \code{valid}, you tell Amazon Cognito that you trust
a user session where Amazon Cognito has evaluated some level of risk.
When you provide a \code{FeedbackValue} value of \code{invalid}, you tell Amazon
Cognito that you don't trust a user session, or you don't believe that
Amazon Cognito evaluated a high-enough risk level.}
}
\description{
Provides feedback for an authentication event indicating if it was from a valid user. This feedback is used for improving the risk evaluation decision for the user pool as part of Amazon Cognito advanced security.

See \url{https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_update_auth_event_feedback/} for full documentation.
}
\keyword{internal}
