# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' Inspector2
#'
#' @description
#' Amazon Inspector is a vulnerability discovery service that automates
#' continuous scanning for security vulnerabilities within your Amazon EC2
#' and Amazon ECR environments.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' \item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
#' \item{\strong{region}:} {The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}:} {Immediately close all HTTP connections.}
#' \item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}:} {Set this to `true` to force the request to use path-style addressing, i.e., `http://s3.amazonaws.com/BUCKET/KEY`.}
#' }
#'
#' @section Service syntax:
#' ```
#' svc <- inspector2(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- inspector2()
#' svc$associate_member(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=inspector2_associate_member]{associate_member} \tab Associates an Amazon Web Services account with an Amazon Inspector delegated administrator\cr
#'  \link[=inspector2_batch_get_account_status]{batch_get_account_status} \tab Retrieves the Amazon Inspector status of multiple Amazon Web Services accounts within your environment\cr
#'  \link[=inspector2_batch_get_free_trial_info]{batch_get_free_trial_info} \tab Gets free trial status for multiple Amazon Web Services accounts\cr
#'  \link[=inspector2_batch_get_member_ec_2_deep_inspection_status]{batch_get_member_ec_2_deep_inspection_status} \tab Retrieves Amazon Inspector deep inspection activation status of multiple member accounts within your organization\cr
#'  \link[=inspector2_batch_update_member_ec_2_deep_inspection_status]{batch_update_member_ec_2_deep_inspection_status} \tab Activates or deactivates Amazon Inspector deep inspection for the provided member accounts in your organization\cr
#'  \link[=inspector2_cancel_findings_report]{cancel_findings_report} \tab Cancels the given findings report\cr
#'  \link[=inspector2_create_filter]{create_filter} \tab Creates a filter resource using specified filter criteria\cr
#'  \link[=inspector2_create_findings_report]{create_findings_report} \tab Creates a finding report\cr
#'  \link[=inspector2_delete_filter]{delete_filter} \tab Deletes a filter resource\cr
#'  \link[=inspector2_describe_organization_configuration]{describe_organization_configuration} \tab Describe Amazon Inspector configuration settings for an Amazon Web Services organization\cr
#'  \link[=inspector2_disable]{disable} \tab Disables Amazon Inspector scans for one or more Amazon Web Services accounts\cr
#'  \link[=inspector2_disable_delegated_admin_account]{disable_delegated_admin_account} \tab Disables the Amazon Inspector delegated administrator for your organization\cr
#'  \link[=inspector2_disassociate_member]{disassociate_member} \tab Disassociates a member account from an Amazon Inspector delegated administrator\cr
#'  \link[=inspector2_enable]{enable} \tab Enables Amazon Inspector scans for one or more Amazon Web Services accounts\cr
#'  \link[=inspector2_enable_delegated_admin_account]{enable_delegated_admin_account} \tab Enables the Amazon Inspector delegated administrator for your Organizations organization\cr
#'  \link[=inspector2_get_configuration]{get_configuration} \tab Retrieves setting configurations for Inspector scans\cr
#'  \link[=inspector2_get_delegated_admin_account]{get_delegated_admin_account} \tab Retrieves information about the Amazon Inspector delegated administrator for your organization\cr
#'  \link[=inspector2_get_ec_2_deep_inspection_configuration]{get_ec_2_deep_inspection_configuration} \tab Retrieves the activation status of Amazon Inspector deep inspection and custom paths associated with your account\cr
#'  \link[=inspector2_get_findings_report_status]{get_findings_report_status} \tab Gets the status of a findings report\cr
#'  \link[=inspector2_get_member]{get_member} \tab Gets member information for your organization\cr
#'  \link[=inspector2_list_account_permissions]{list_account_permissions} \tab Lists the permissions an account has to configure Amazon Inspector\cr
#'  \link[=inspector2_list_coverage]{list_coverage} \tab Lists coverage details for you environment\cr
#'  \link[=inspector2_list_coverage_statistics]{list_coverage_statistics} \tab Lists Amazon Inspector coverage statistics for your environment\cr
#'  \link[=inspector2_list_delegated_admin_accounts]{list_delegated_admin_accounts} \tab Lists information about the Amazon Inspector delegated administrator of your organization\cr
#'  \link[=inspector2_list_filters]{list_filters} \tab Lists the filters associated with your account\cr
#'  \link[=inspector2_list_finding_aggregations]{list_finding_aggregations} \tab Lists aggregated finding data for your environment based on specific criteria\cr
#'  \link[=inspector2_list_findings]{list_findings} \tab Lists findings for your environment\cr
#'  \link[=inspector2_list_members]{list_members} \tab List members associated with the Amazon Inspector delegated administrator for your organization\cr
#'  \link[=inspector2_list_tags_for_resource]{list_tags_for_resource} \tab Lists all tags attached to a given resource\cr
#'  \link[=inspector2_list_usage_totals]{list_usage_totals} \tab Lists the Amazon Inspector usage totals over the last 30 days\cr
#'  \link[=inspector2_search_vulnerabilities]{search_vulnerabilities} \tab Lists Amazon Inspector coverage details for a specific vulnerability\cr
#'  \link[=inspector2_tag_resource]{tag_resource} \tab Adds tags to a resource\cr
#'  \link[=inspector2_untag_resource]{untag_resource} \tab Removes tags from a resource\cr
#'  \link[=inspector2_update_configuration]{update_configuration} \tab Updates setting configurations for your Amazon Inspector account\cr
#'  \link[=inspector2_update_ec_2_deep_inspection_configuration]{update_ec_2_deep_inspection_configuration} \tab Activates, deactivates Amazon Inspector deep inspection, or updates custom paths for your account\cr
#'  \link[=inspector2_update_filter]{update_filter} \tab Specifies the action that is to be applied to the findings that match the filter\cr
#'  \link[=inspector2_update_organization_configuration]{update_organization_configuration} \tab Updates the configurations for your Amazon Inspector organization\cr
#'  \link[=inspector2_update_org_ec_2_deep_inspection_configuration]{update_org_ec_2_deep_inspection_configuration} \tab Updates the Amazon Inspector deep inspection custom paths for your organization
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname inspector2
#' @export
inspector2 <- function(config = list()) {
  svc <- .inspector2$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.inspector2 <- list()

.inspector2$operations <- list()

.inspector2$metadata <- list(
  service_name = "inspector2",
  endpoints = list("*" = list(endpoint = "inspector2.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "inspector2.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "inspector2.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "inspector2.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "Inspector2",
  api_version = "2020-06-08",
  signing_name = "inspector2",
  json_version = "1.1",
  target_prefix = ""
)

.inspector2$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.inspector2$metadata, handlers, config)
}
