# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include secretsmanager_service.R
NULL

#' Disables automatic scheduled rotation and cancels the rotation of a
#' secret if one is currently in progress
#'
#' Disables automatic scheduled rotation and cancels the rotation of a
#' secret if one is currently in progress.
#' 
#' To re-enable scheduled rotation, call RotateSecret with
#' `AutomaticallyRotateAfterDays` set to a value greater than 0. This will
#' immediately rotate your secret and then enable the automatic schedule.
#' 
#' If you cancel a rotation that is in progress, it can leave the
#' `VersionStage` labels in an unexpected state. Depending on what step of
#' the rotation was in progress, you might need to remove the staging label
#' `AWSPENDING` from the partially created version, specified by the
#' `VersionId` response value. You should also evaluate the partially
#' rotated new version to see if it should be deleted, which you can do by
#' removing all staging labels from the new version\'s `VersionStage`
#' field.
#' 
#' To successfully start a rotation, the staging label `AWSPENDING` must be
#' in one of the following states:
#' 
#' -   Not be attached to any version at all
#' 
#' -   Attached to the same version as the staging label `AWSCURRENT`
#' 
#' If the staging label `AWSPENDING` is attached to a different version
#' than the version with `AWSCURRENT` then the attempt to rotate fails.
#' 
#' **Minimum permissions**
#' 
#' To run this command, you must have the following permissions:
#' 
#' -   secretsmanager:CancelRotateSecret
#' 
#' **Related operations**
#' 
#' -   To configure rotation for a secret or to manually trigger a
#'     rotation, use RotateSecret.
#' 
#' -   To get the rotation configuration details for a secret, use
#'     DescribeSecret.
#' 
#' -   To list all of the currently available secrets, use ListSecrets.
#' 
#' -   To list all of the versions currently associated with a secret, use
#'     ListSecretVersionIds.
#'
#' @usage
#' secretsmanager_cancel_rotate_secret(SecretId)
#'
#' @param SecretId &#91;required&#93; Specifies the secret for which you want to cancel a rotation request.
#' You can specify either the Amazon Resource Name (ARN) or the friendly
#' name of the secret.
#' 
#' If you specify an ARN, we generally recommend that you specify a
#' complete ARN. You can specify a partial ARN too---for example, if you
#' don't include the final hyphen and six random characters that Secrets
#' Manager adds at the end of the ARN when you created the secret. A
#' partial ARN match can work as long as it uniquely matches only one
#' secret. However, if your secret has a name that ends in a hyphen
#' followed by six characters (before Secrets Manager adds the hyphen and
#' six characters to the ARN) and you try to use that as a partial ARN,
#' then those characters cause Secrets Manager to assume that you're
#' specifying a complete ARN. This confusion can cause unexpected results.
#' To avoid this situation, we recommend that you don't create secret names
#' that end with a hyphen followed by six characters.
#'
#' @section Request syntax:
#' ```
#' svc$cancel_rotate_secret(
#'   SecretId = "string"
#' )
#' ```
#'
#' @examples
#' # The following example shows how to cancel rotation for a secret. The
#' # operation sets the RotationEnabled field to false and cancels all
#' # scheduled rotations. To resume scheduled rotations, you must re-enable
#' # rotation by calling the rotate-secret operation.
#' \donttest{svc$cancel_rotate_secret(
#'   SecretId = "MyTestDatabaseSecret"
#' )}
#'
#' @keywords internal
#'
#' @rdname secretsmanager_cancel_rotate_secret
secretsmanager_cancel_rotate_secret <- function(SecretId) {
  op <- new_operation(
    name = "CancelRotateSecret",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .secretsmanager$cancel_rotate_secret_input(SecretId = SecretId)
  output <- .secretsmanager$cancel_rotate_secret_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$cancel_rotate_secret <- secretsmanager_cancel_rotate_secret

#' Creates a new secret
#'
#' Creates a new secret. A secret in Secrets Manager consists of both the
#' protected secret data and the important information needed to manage the
#' secret.
#' 
#' Secrets Manager stores the encrypted secret data in one of a collection
#' of \"versions\" associated with the secret. Each version contains a copy
#' of the encrypted secret data. Each version is associated with one or
#' more \"staging labels\" that identify where the version is in the
#' rotation cycle. The `SecretVersionsToStages` field of the secret
#' contains the mapping of staging labels to the active versions of the
#' secret. Versions without a staging label are considered deprecated and
#' are not included in the list.
#' 
#' You provide the secret data to be encrypted by putting text in either
#' the `SecretString` parameter or binary data in the `SecretBinary`
#' parameter, but not both. If you include `SecretString` or `SecretBinary`
#' then Secrets Manager also creates an initial secret version and
#' automatically attaches the staging label `AWSCURRENT` to the new
#' version.
#' 
#' -   If you call an operation that needs to encrypt or decrypt the
#'     `SecretString` or `SecretBinary` for a secret in the same account as
#'     the calling user and that secret doesn\'t specify a AWS KMS
#'     encryption key, Secrets Manager uses the account\'s default AWS
#'     managed customer master key (CMK) with the alias
#'     `aws/secretsmanager`. If this key doesn\'t already exist in your
#'     account then Secrets Manager creates it for you automatically. All
#'     users and roles in the same AWS account automatically have access to
#'     use the default CMK. Note that if an Secrets Manager API call
#'     results in AWS having to create the account\'s AWS-managed CMK, it
#'     can result in a one-time significant delay in returning the result.
#' 
#' -   If the secret is in a different AWS account from the credentials
#'     calling an API that requires encryption or decryption of the secret
#'     value then you must create and use a custom AWS KMS CMK because you
#'     can\'t access the default CMK for the account using credentials from
#'     a different AWS account. Store the ARN of the CMK in the secret when
#'     you create the secret or when you update it by including it in the
#'     `KMSKeyId`. If you call an API that must encrypt or decrypt
#'     `SecretString` or `SecretBinary` using credentials from a different
#'     account then the AWS KMS key policy must grant cross-account access
#'     to that other account\'s user or role for both the
#'     kms:GenerateDataKey and kms:Decrypt operations.
#' 
#' **Minimum permissions**
#' 
#' To run this command, you must have the following permissions:
#' 
#' -   secretsmanager:CreateSecret
#' 
#' -   kms:GenerateDataKey - needed only if you use a customer-managed AWS
#'     KMS key to encrypt the secret. You do not need this permission to
#'     use the account\'s default AWS managed CMK for Secrets Manager.
#' 
#' -   kms:Decrypt - needed only if you use a customer-managed AWS KMS key
#'     to encrypt the secret. You do not need this permission to use the
#'     account\'s default AWS managed CMK for Secrets Manager.
#' 
#' -   secretsmanager:TagResource - needed only if you include the `Tags`
#'     parameter.
#' 
#' **Related operations**
#' 
#' -   To delete a secret, use DeleteSecret.
#' 
#' -   To modify an existing secret, use UpdateSecret.
#' 
#' -   To create a new version of a secret, use PutSecretValue.
#' 
#' -   To retrieve the encrypted secure string and secure binary values,
#'     use GetSecretValue.
#' 
#' -   To retrieve all other details for a secret, use DescribeSecret. This
#'     does not include the encrypted secure string and secure binary
#'     values.
#' 
#' -   To retrieve the list of secret versions associated with the current
#'     secret, use DescribeSecret and examine the `SecretVersionsToStages`
#'     response value.
#'
#' @usage
#' secretsmanager_create_secret(Name, ClientRequestToken, Description,
#'   KmsKeyId, SecretBinary, SecretString, Tags)
#'
#' @param Name &#91;required&#93; Specifies the friendly name of the new secret.
#' 
#' The secret name must be ASCII letters, digits, or the following
#' characters : /\\_+=.@-
#' 
#' Don\'t end your secret name with a hyphen followed by six characters. If
#' you do so, you risk confusion and unexpected results when searching for
#' a secret by partial ARN. This is because Secrets Manager automatically
#' adds a hyphen and six random characters at the end of the ARN.
#' @param ClientRequestToken (Optional) If you include `SecretString` or `SecretBinary`, then an
#' initial version is created as part of the secret, and this parameter
#' specifies a unique identifier for the new version.
#' 
#' If you use the AWS CLI or one of the AWS SDK to call this operation,
#' then you can leave this parameter empty. The CLI or SDK generates a
#' random UUID for you and includes it as the value for this parameter in
#' the request. If you don\'t use the SDK and instead generate a raw HTTP
#' request to the Secrets Manager service endpoint, then you must generate
#' a `ClientRequestToken` yourself for the new version and include that
#' value in the request.
#' 
#' This value helps ensure idempotency. Secrets Manager uses this value to
#' prevent the accidental creation of duplicate versions if there are
#' failures and retries during a rotation. We recommend that you generate a
#' [UUID-type](https://wikipedia.org/wiki/Universally_unique_identifier)
#' value to ensure uniqueness of your versions within the specified secret.
#' 
#' -   If the `ClientRequestToken` value isn\'t already associated with a
#'     version of the secret then a new version of the secret is created.
#' 
#' -   If a version with this value already exists and that version\'s
#'     `SecretString` and `SecretBinary` values are the same as those in
#'     the request, then the request is ignored (the operation is
#'     idempotent).
#' 
#' -   If a version with this value already exists and that version\'s
#'     `SecretString` and `SecretBinary` values are different from those in
#'     the request then the request fails because you cannot modify an
#'     existing version. Instead, use PutSecretValue to create a new
#'     version.
#' 
#' This value becomes the `VersionId` of the new version.
#' @param Description (Optional) Specifies a user-provided description of the secret.
#' @param KmsKeyId (Optional) Specifies the ARN, Key ID, or alias of the AWS KMS customer
#' master key (CMK) to be used to encrypt the `SecretString` or
#' `SecretBinary` values in the versions stored in this secret.
#' 
#' You can specify any of the supported ways to identify a AWS KMS key ID.
#' If you need to reference a CMK in a different account, you can use only
#' the key ARN or the alias ARN.
#' 
#' If you don\'t specify this value, then Secrets Manager defaults to using
#' the AWS account\'s default CMK (the one named `aws/secretsmanager`). If
#' a AWS KMS CMK with that name doesn\'t yet exist, then Secrets Manager
#' creates it for you automatically the first time it needs to encrypt a
#' version\'s `SecretString` or `SecretBinary` fields.
#' 
#' You can use the account\'s default CMK to encrypt and decrypt only if
#' you call this operation using credentials from the same account that
#' owns the secret. If the secret is in a different account, then you must
#' create a custom CMK and specify the ARN in this field.
#' @param SecretBinary (Optional) Specifies binary data that you want to encrypt and store in
#' the new version of the secret. To use this parameter in the command-line
#' tools, we recommend that you store your binary data in a file and then
#' use the appropriate technique for your tool to pass the contents of the
#' file as a parameter.
#' 
#' Either `SecretString` or `SecretBinary` must have a value, but not both.
#' They cannot both be empty.
#' 
#' This parameter is not available using the Secrets Manager console. It
#' can be accessed only by using the AWS CLI or one of the AWS SDKs.
#' @param SecretString (Optional) Specifies text data that you want to encrypt and store in
#' this new version of the secret.
#' 
#' Either `SecretString` or `SecretBinary` must have a value, but not both.
#' They cannot both be empty.
#' 
#' If you create a secret by using the Secrets Manager console then Secrets
#' Manager puts the protected secret text in only the `SecretString`
#' parameter. The Secrets Manager console stores the information as a JSON
#' structure of key/value pairs that the Lambda rotation function knows how
#' to parse.
#' 
#' For storing multiple values, we recommend that you use a JSON text
#' string argument and specify key/value pairs. For information on how to
#' format a JSON parameter for the various command line tool environments,
#' see [Using JSON for
#' Parameters](https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json)
#' in the *AWS CLI User Guide*. For example:
#' 
#' `\\[\{"username":"bob"\},\{"password":"abc123xyz456"\}\\]`
#' 
#' If your command-line tool or SDK requires quotation marks around the
#' parameter, you should use single quotes to avoid confusion with the
#' double quotes required in the JSON text.
#' @param Tags (Optional) Specifies a list of user-defined tags that are attached to
#' the secret. Each tag is a \"Key\" and \"Value\" pair of strings. This
#' operation only appends tags to the existing list of tags. To remove
#' tags, you must use UntagResource.
#' 
#' -   Secrets Manager tag key names are case sensitive. A tag with the key
#'     \"ABC\" is a different tag from one with key \"abc\".
#' 
#' -   If you check tags in IAM policy `Condition` elements as part of your
#'     security strategy, then adding or removing a tag can change
#'     permissions. If the successful completion of this operation would
#'     result in you losing your permissions for this secret, then this
#'     operation is blocked and returns an `Access Denied` error.
#' 
#' This parameter requires a JSON text string argument. For information on
#' how to format a JSON parameter for the various command line tool
#' environments, see [Using JSON for
#' Parameters](https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json)
#' in the *AWS CLI User Guide*. For example:
#' 
#' `\\[\{"Key":"CostCenter","Value":"12345"\},\{"Key":"environment","Value":"production"\}\\]`
#' 
#' If your command-line tool or SDK requires quotation marks around the
#' parameter, you should use single quotes to avoid confusion with the
#' double quotes required in the JSON text.
#' 
#' The following basic restrictions apply to tags:
#' 
#' -   Maximum number of tags per secret---50
#' 
#' -   Maximum key length---127 Unicode characters in UTF-8
#' 
#' -   Maximum value length---255 Unicode characters in UTF-8
#' 
#' -   Tag keys and values are case sensitive.
#' 
#' -   Do not use the `aws:` prefix in your tag names or values because it
#'     is reserved for AWS use. You can\'t edit or delete tag names or
#'     values with this prefix. Tags with this prefix do not count against
#'     your tags per secret limit.
#' 
#' -   If your tagging schema will be used across multiple services and
#'     resources, remember that other services might have restrictions on
#'     allowed characters. Generally allowed characters are: letters,
#'     spaces, and numbers representable in UTF-8, plus the following
#'     special characters: + - = . \\_ : / @.
#'
#' @section Request syntax:
#' ```
#' svc$create_secret(
#'   Name = "string",
#'   ClientRequestToken = "string",
#'   Description = "string",
#'   KmsKeyId = "string",
#'   SecretBinary = raw,
#'   SecretString = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # The following example shows how to create a secret. The credentials
#' # stored in the encrypted secret value are retrieved from a file on disk
#' # named mycreds.json.
#' \donttest{svc$create_secret(
#'   ClientRequestToken = "EXAMPLE1-90ab-cdef-fedc-ba987SECRET1",
#'   Description = "My test database secret created with the CLI",
#'   Name = "MyTestDatabaseSecret",
#'   SecretString = "{\"username\":\"david\",\"password\":\"BnQw!XDWgaEeT9XGTT29\"}"
#' )}
#'
#' @keywords internal
#'
#' @rdname secretsmanager_create_secret
secretsmanager_create_secret <- function(Name, ClientRequestToken = NULL, Description = NULL, KmsKeyId = NULL, SecretBinary = NULL, SecretString = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateSecret",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .secretsmanager$create_secret_input(Name = Name, ClientRequestToken = ClientRequestToken, Description = Description, KmsKeyId = KmsKeyId, SecretBinary = SecretBinary, SecretString = SecretString, Tags = Tags)
  output <- .secretsmanager$create_secret_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$create_secret <- secretsmanager_create_secret

#' Deletes the resource-based permission policy that's attached to the
#' secret
#'
#' Deletes the resource-based permission policy that\'s attached to the
#' secret.
#' 
#' **Minimum permissions**
#' 
#' To run this command, you must have the following permissions:
#' 
#' -   secretsmanager:DeleteResourcePolicy
#' 
#' **Related operations**
#' 
#' -   To attach a resource policy to a secret, use PutResourcePolicy.
#' 
#' -   To retrieve the current resource-based policy that\'s attached to a
#'     secret, use GetResourcePolicy.
#' 
#' -   To list all of the currently available secrets, use ListSecrets.
#'
#' @usage
#' secretsmanager_delete_resource_policy(SecretId)
#'
#' @param SecretId &#91;required&#93; Specifies the secret that you want to delete the attached resource-based
#' policy for. You can specify either the Amazon Resource Name (ARN) or the
#' friendly name of the secret.
#' 
#' If you specify an ARN, we generally recommend that you specify a
#' complete ARN. You can specify a partial ARN too---for example, if you
#' don't include the final hyphen and six random characters that Secrets
#' Manager adds at the end of the ARN when you created the secret. A
#' partial ARN match can work as long as it uniquely matches only one
#' secret. However, if your secret has a name that ends in a hyphen
#' followed by six characters (before Secrets Manager adds the hyphen and
#' six characters to the ARN) and you try to use that as a partial ARN,
#' then those characters cause Secrets Manager to assume that you're
#' specifying a complete ARN. This confusion can cause unexpected results.
#' To avoid this situation, we recommend that you don't create secret names
#' that end with a hyphen followed by six characters.
#'
#' @section Request syntax:
#' ```
#' svc$delete_resource_policy(
#'   SecretId = "string"
#' )
#' ```
#'
#' @examples
#' # The following example shows how to delete the resource-based policy that
#' # is attached to a secret.
#' \donttest{svc$delete_resource_policy(
#'   SecretId = "MyTestDatabaseSecret"
#' )}
#'
#' @keywords internal
#'
#' @rdname secretsmanager_delete_resource_policy
secretsmanager_delete_resource_policy <- function(SecretId) {
  op <- new_operation(
    name = "DeleteResourcePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .secretsmanager$delete_resource_policy_input(SecretId = SecretId)
  output <- .secretsmanager$delete_resource_policy_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$delete_resource_policy <- secretsmanager_delete_resource_policy

#' Deletes an entire secret and all of its versions
#'
#' Deletes an entire secret and all of its versions. You can optionally
#' include a recovery window during which you can restore the secret. If
#' you don\'t specify a recovery window value, the operation defaults to 30
#' days. Secrets Manager attaches a `DeletionDate` stamp to the secret that
#' specifies the end of the recovery window. At the end of the recovery
#' window, Secrets Manager deletes the secret permanently.
#' 
#' At any time before recovery window ends, you can use RestoreSecret to
#' remove the `DeletionDate` and cancel the deletion of the secret.
#' 
#' You cannot access the encrypted secret information in any secret that is
#' scheduled for deletion. If you need to access that information, you must
#' cancel the deletion with RestoreSecret and then retrieve the
#' information.
#' 
#' -   There is no explicit operation to delete a version of a secret.
#'     Instead, remove all staging labels from the `VersionStage` field of
#'     a version. That marks the version as deprecated and allows Secrets
#'     Manager to delete it as needed. Versions that do not have any
#'     staging labels do not show up in ListSecretVersionIds unless you
#'     specify `IncludeDeprecated`.
#' 
#' -   The permanent secret deletion at the end of the waiting period is
#'     performed as a background task with low priority. There is no
#'     guarantee of a specific time after the recovery window for the
#'     actual delete operation to occur.
#' 
#' **Minimum permissions**
#' 
#' To run this command, you must have the following permissions:
#' 
#' -   secretsmanager:DeleteSecret
#' 
#' **Related operations**
#' 
#' -   To create a secret, use CreateSecret.
#' 
#' -   To cancel deletion of a version of a secret before the recovery
#'     window has expired, use RestoreSecret.
#'
#' @usage
#' secretsmanager_delete_secret(SecretId, RecoveryWindowInDays,
#'   ForceDeleteWithoutRecovery)
#'
#' @param SecretId &#91;required&#93; Specifies the secret that you want to delete. You can specify either the
#' Amazon Resource Name (ARN) or the friendly name of the secret.
#' 
#' If you specify an ARN, we generally recommend that you specify a
#' complete ARN. You can specify a partial ARN too---for example, if you
#' don't include the final hyphen and six random characters that Secrets
#' Manager adds at the end of the ARN when you created the secret. A
#' partial ARN match can work as long as it uniquely matches only one
#' secret. However, if your secret has a name that ends in a hyphen
#' followed by six characters (before Secrets Manager adds the hyphen and
#' six characters to the ARN) and you try to use that as a partial ARN,
#' then those characters cause Secrets Manager to assume that you're
#' specifying a complete ARN. This confusion can cause unexpected results.
#' To avoid this situation, we recommend that you don't create secret names
#' that end with a hyphen followed by six characters.
#' @param RecoveryWindowInDays (Optional) Specifies the number of days that Secrets Manager waits
#' before it can delete the secret. You can\'t use both this parameter and
#' the `ForceDeleteWithoutRecovery` parameter in the same API call.
#' 
#' This value can range from 7 to 30 days. The default value is 30.
#' @param ForceDeleteWithoutRecovery (Optional) Specifies that the secret is to be deleted without any
#' recovery window. You can\'t use both this parameter and the
#' `RecoveryWindowInDays` parameter in the same API call.
#' 
#' An asynchronous background process performs the actual deletion, so
#' there can be a short delay before the operation completes. If you write
#' code to delete and then immediately recreate a secret with the same
#' name, ensure that your code includes appropriate back off and retry
#' logic.
#' 
#' Use this parameter with caution. This parameter causes the operation to
#' skip the normal waiting period before the permanent deletion that AWS
#' would normally impose with the `RecoveryWindowInDays` parameter. If you
#' delete a secret with the `ForceDeleteWithouRecovery` parameter, then you
#' have no opportunity to recover the secret. It is permanently lost.
#'
#' @section Request syntax:
#' ```
#' svc$delete_secret(
#'   SecretId = "string",
#'   RecoveryWindowInDays = 123,
#'   ForceDeleteWithoutRecovery = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # The following example shows how to delete a secret. The secret stays in
#' # your account in a deprecated and inaccessible state until the recovery
#' # window ends. After the date and time in the DeletionDate response field
#' # has passed, you can no longer recover this secret with restore-secret.
#' \donttest{svc$delete_secret(
#'   RecoveryWindowInDays = 7L,
#'   SecretId = "MyTestDatabaseSecret1"
#' )}
#'
#' @keywords internal
#'
#' @rdname secretsmanager_delete_secret
secretsmanager_delete_secret <- function(SecretId, RecoveryWindowInDays = NULL, ForceDeleteWithoutRecovery = NULL) {
  op <- new_operation(
    name = "DeleteSecret",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .secretsmanager$delete_secret_input(SecretId = SecretId, RecoveryWindowInDays = RecoveryWindowInDays, ForceDeleteWithoutRecovery = ForceDeleteWithoutRecovery)
  output <- .secretsmanager$delete_secret_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$delete_secret <- secretsmanager_delete_secret

#' Retrieves the details of a secret
#'
#' Retrieves the details of a secret. It does not include the encrypted
#' fields. Only those fields that are populated with a value are returned
#' in the response.
#' 
#' **Minimum permissions**
#' 
#' To run this command, you must have the following permissions:
#' 
#' -   secretsmanager:DescribeSecret
#' 
#' **Related operations**
#' 
#' -   To create a secret, use CreateSecret.
#' 
#' -   To modify a secret, use UpdateSecret.
#' 
#' -   To retrieve the encrypted secret information in a version of the
#'     secret, use GetSecretValue.
#' 
#' -   To list all of the secrets in the AWS account, use ListSecrets.
#'
#' @usage
#' secretsmanager_describe_secret(SecretId)
#'
#' @param SecretId &#91;required&#93; The identifier of the secret whose details you want to retrieve. You can
#' specify either the Amazon Resource Name (ARN) or the friendly name of
#' the secret.
#' 
#' If you specify an ARN, we generally recommend that you specify a
#' complete ARN. You can specify a partial ARN too---for example, if you
#' don't include the final hyphen and six random characters that Secrets
#' Manager adds at the end of the ARN when you created the secret. A
#' partial ARN match can work as long as it uniquely matches only one
#' secret. However, if your secret has a name that ends in a hyphen
#' followed by six characters (before Secrets Manager adds the hyphen and
#' six characters to the ARN) and you try to use that as a partial ARN,
#' then those characters cause Secrets Manager to assume that you're
#' specifying a complete ARN. This confusion can cause unexpected results.
#' To avoid this situation, we recommend that you don't create secret names
#' that end with a hyphen followed by six characters.
#'
#' @section Request syntax:
#' ```
#' svc$describe_secret(
#'   SecretId = "string"
#' )
#' ```
#'
#' @examples
#' # The following example shows how to get the details about a secret.
#' \donttest{svc$describe_secret(
#'   SecretId = "MyTestDatabaseSecret"
#' )}
#'
#' @keywords internal
#'
#' @rdname secretsmanager_describe_secret
secretsmanager_describe_secret <- function(SecretId) {
  op <- new_operation(
    name = "DescribeSecret",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .secretsmanager$describe_secret_input(SecretId = SecretId)
  output <- .secretsmanager$describe_secret_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$describe_secret <- secretsmanager_describe_secret

#' Generates a random password of the specified complexity
#'
#' Generates a random password of the specified complexity. This operation
#' is intended for use in the Lambda rotation function. Per best practice,
#' we recommend that you specify the maximum length and include every
#' character type that the system you are generating a password for can
#' support.
#' 
#' **Minimum permissions**
#' 
#' To run this command, you must have the following permissions:
#' 
#' -   secretsmanager:GetRandomPassword
#'
#' @usage
#' secretsmanager_get_random_password(PasswordLength, ExcludeCharacters,
#'   ExcludeNumbers, ExcludePunctuation, ExcludeUppercase, ExcludeLowercase,
#'   IncludeSpace, RequireEachIncludedType)
#'
#' @param PasswordLength The desired length of the generated password. The default value if you
#' do not include this parameter is 32 characters.
#' @param ExcludeCharacters A string that includes characters that should not be included in the
#' generated password. The default is that all characters from the included
#' sets can be used.
#' @param ExcludeNumbers Specifies that the generated password should not include digits. The
#' default if you do not include this switch parameter is that digits can
#' be included.
#' @param ExcludePunctuation Specifies that the generated password should not include punctuation
#' characters. The default if you do not include this switch parameter is
#' that punctuation characters can be included.
#' 
#' The following are the punctuation characters that *can* be included in
#' the generated password if you don\'t explicitly exclude them with
#' `ExcludeCharacters` or `ExcludePunctuation`:
#' 
#' `` ! \" # $ \% &amp; \' ( ) * + , - . / : ; &lt; = &gt; ? @ \\[ \\ \\] ^ _ \` \{ | \} ~ ``
#' @param ExcludeUppercase Specifies that the generated password should not include uppercase
#' letters. The default if you do not include this switch parameter is that
#' uppercase letters can be included.
#' @param ExcludeLowercase Specifies that the generated password should not include lowercase
#' letters. The default if you do not include this switch parameter is that
#' lowercase letters can be included.
#' @param IncludeSpace Specifies that the generated password can include the space character.
#' The default if you do not include this switch parameter is that the
#' space character is not included.
#' @param RequireEachIncludedType A boolean value that specifies whether the generated password must
#' include at least one of every allowed character type. The default value
#' is `True` and the operation requires at least one of every character
#' type.
#'
#' @section Request syntax:
#' ```
#' svc$get_random_password(
#'   PasswordLength = 123,
#'   ExcludeCharacters = "string",
#'   ExcludeNumbers = TRUE|FALSE,
#'   ExcludePunctuation = TRUE|FALSE,
#'   ExcludeUppercase = TRUE|FALSE,
#'   ExcludeLowercase = TRUE|FALSE,
#'   IncludeSpace = TRUE|FALSE,
#'   RequireEachIncludedType = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # The following example shows how to request a randomly generated
#' # password. This example includes the optional flags to require spaces and
#' # at least one character of each included type. It specifies a length of
#' # 20 characters.
#' \donttest{svc$get_random_password(
#'   IncludeSpace = TRUE,
#'   PasswordLength = 20L,
#'   RequireEachIncludedType = TRUE
#' )}
#'
#' @keywords internal
#'
#' @rdname secretsmanager_get_random_password
secretsmanager_get_random_password <- function(PasswordLength = NULL, ExcludeCharacters = NULL, ExcludeNumbers = NULL, ExcludePunctuation = NULL, ExcludeUppercase = NULL, ExcludeLowercase = NULL, IncludeSpace = NULL, RequireEachIncludedType = NULL) {
  op <- new_operation(
    name = "GetRandomPassword",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .secretsmanager$get_random_password_input(PasswordLength = PasswordLength, ExcludeCharacters = ExcludeCharacters, ExcludeNumbers = ExcludeNumbers, ExcludePunctuation = ExcludePunctuation, ExcludeUppercase = ExcludeUppercase, ExcludeLowercase = ExcludeLowercase, IncludeSpace = IncludeSpace, RequireEachIncludedType = RequireEachIncludedType)
  output <- .secretsmanager$get_random_password_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$get_random_password <- secretsmanager_get_random_password

#' Retrieves the JSON text of the resource-based policy document that's
#' attached to the specified secret
#'
#' Retrieves the JSON text of the resource-based policy document that\'s
#' attached to the specified secret. The JSON request string input and
#' response output are shown formatted with white space and line breaks for
#' better readability. Submit your input as a single line JSON string.
#' 
#' **Minimum permissions**
#' 
#' To run this command, you must have the following permissions:
#' 
#' -   secretsmanager:GetResourcePolicy
#' 
#' **Related operations**
#' 
#' -   To attach a resource policy to a secret, use PutResourcePolicy.
#' 
#' -   To delete the resource-based policy that\'s attached to a secret,
#'     use DeleteResourcePolicy.
#' 
#' -   To list all of the currently available secrets, use ListSecrets.
#'
#' @usage
#' secretsmanager_get_resource_policy(SecretId)
#'
#' @param SecretId &#91;required&#93; Specifies the secret that you want to retrieve the attached
#' resource-based policy for. You can specify either the Amazon Resource
#' Name (ARN) or the friendly name of the secret.
#' 
#' If you specify an ARN, we generally recommend that you specify a
#' complete ARN. You can specify a partial ARN too---for example, if you
#' don't include the final hyphen and six random characters that Secrets
#' Manager adds at the end of the ARN when you created the secret. A
#' partial ARN match can work as long as it uniquely matches only one
#' secret. However, if your secret has a name that ends in a hyphen
#' followed by six characters (before Secrets Manager adds the hyphen and
#' six characters to the ARN) and you try to use that as a partial ARN,
#' then those characters cause Secrets Manager to assume that you're
#' specifying a complete ARN. This confusion can cause unexpected results.
#' To avoid this situation, we recommend that you don't create secret names
#' that end with a hyphen followed by six characters.
#'
#' @section Request syntax:
#' ```
#' svc$get_resource_policy(
#'   SecretId = "string"
#' )
#' ```
#'
#' @examples
#' # The following example shows how to retrieve the resource-based policy
#' # that is attached to a secret.
#' \donttest{svc$get_resource_policy(
#'   SecretId = "MyTestDatabaseSecret"
#' )}
#'
#' @keywords internal
#'
#' @rdname secretsmanager_get_resource_policy
secretsmanager_get_resource_policy <- function(SecretId) {
  op <- new_operation(
    name = "GetResourcePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .secretsmanager$get_resource_policy_input(SecretId = SecretId)
  output <- .secretsmanager$get_resource_policy_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$get_resource_policy <- secretsmanager_get_resource_policy

#' Retrieves the contents of the encrypted fields SecretString or
#' SecretBinary from the specified version of a secret, whichever contains
#' content
#'
#' Retrieves the contents of the encrypted fields `SecretString` or
#' `SecretBinary` from the specified version of a secret, whichever
#' contains content.
#' 
#' **Minimum permissions**
#' 
#' To run this command, you must have the following permissions:
#' 
#' -   secretsmanager:GetSecretValue
#' 
#' -   kms:Decrypt - required only if you use a customer-managed AWS KMS
#'     key to encrypt the secret. You do not need this permission to use
#'     the account\'s default AWS managed CMK for Secrets Manager.
#' 
#' **Related operations**
#' 
#' -   To create a new version of the secret with different encrypted
#'     information, use PutSecretValue.
#' 
#' -   To retrieve the non-encrypted details for the secret, use
#'     DescribeSecret.
#'
#' @usage
#' secretsmanager_get_secret_value(SecretId, VersionId, VersionStage)
#'
#' @param SecretId &#91;required&#93; Specifies the secret containing the version that you want to retrieve.
#' You can specify either the Amazon Resource Name (ARN) or the friendly
#' name of the secret.
#' 
#' If you specify an ARN, we generally recommend that you specify a
#' complete ARN. You can specify a partial ARN too---for example, if you
#' don't include the final hyphen and six random characters that Secrets
#' Manager adds at the end of the ARN when you created the secret. A
#' partial ARN match can work as long as it uniquely matches only one
#' secret. However, if your secret has a name that ends in a hyphen
#' followed by six characters (before Secrets Manager adds the hyphen and
#' six characters to the ARN) and you try to use that as a partial ARN,
#' then those characters cause Secrets Manager to assume that you're
#' specifying a complete ARN. This confusion can cause unexpected results.
#' To avoid this situation, we recommend that you don't create secret names
#' that end with a hyphen followed by six characters.
#' @param VersionId Specifies the unique identifier of the version of the secret that you
#' want to retrieve. If you specify this parameter then don\'t specify
#' `VersionStage`. If you don\'t specify either a `VersionStage` or
#' `VersionId` then the default is to perform the operation on the version
#' with the `VersionStage` value of `AWSCURRENT`.
#' 
#' This value is typically a
#' [UUID-type](https://wikipedia.org/wiki/Universally_unique_identifier)
#' value with 32 hexadecimal digits.
#' @param VersionStage Specifies the secret version that you want to retrieve by the staging
#' label attached to the version.
#' 
#' Staging labels are used to keep track of different versions during the
#' rotation process. If you use this parameter then don\'t specify
#' `VersionId`. If you don\'t specify either a `VersionStage` or
#' `VersionId`, then the default is to perform the operation on the version
#' with the `VersionStage` value of `AWSCURRENT`.
#'
#' @section Request syntax:
#' ```
#' svc$get_secret_value(
#'   SecretId = "string",
#'   VersionId = "string",
#'   VersionStage = "string"
#' )
#' ```
#'
#' @examples
#' # The following example shows how to retrieve the secret string value from
#' # the version of the secret that has the AWSPREVIOUS staging label
#' # attached. If you want to retrieve the AWSCURRENT version of the secret,
#' # then you can omit the VersionStage parameter because it defaults to
#' # AWSCURRENT.
#' \donttest{svc$get_secret_value(
#'   SecretId = "MyTestDatabaseSecret",
#'   VersionStage = "AWSPREVIOUS"
#' )}
#'
#' @keywords internal
#'
#' @rdname secretsmanager_get_secret_value
secretsmanager_get_secret_value <- function(SecretId, VersionId = NULL, VersionStage = NULL) {
  op <- new_operation(
    name = "GetSecretValue",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .secretsmanager$get_secret_value_input(SecretId = SecretId, VersionId = VersionId, VersionStage = VersionStage)
  output <- .secretsmanager$get_secret_value_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$get_secret_value <- secretsmanager_get_secret_value

#' Lists all of the versions attached to the specified secret
#'
#' Lists all of the versions attached to the specified secret. The output
#' does not include the `SecretString` or `SecretBinary` fields. By
#' default, the list includes only versions that have at least one staging
#' label in `VersionStage` attached.
#' 
#' Always check the `NextToken` response parameter when calling any of the
#' `List*` operations. These operations can occasionally return an empty or
#' shorter than expected list of results even when there are more results
#' available. When this happens, the `NextToken` response parameter
#' contains a value to pass to the next call to the same API to request the
#' next part of the list.
#' 
#' **Minimum permissions**
#' 
#' To run this command, you must have the following permissions:
#' 
#' -   secretsmanager:ListSecretVersionIds
#' 
#' **Related operations**
#' 
#' -   To list the secrets in an account, use ListSecrets.
#'
#' @usage
#' secretsmanager_list_secret_version_ids(SecretId, MaxResults, NextToken,
#'   IncludeDeprecated)
#'
#' @param SecretId &#91;required&#93; The identifier for the secret containing the versions you want to list.
#' You can specify either the Amazon Resource Name (ARN) or the friendly
#' name of the secret.
#' 
#' If you specify an ARN, we generally recommend that you specify a
#' complete ARN. You can specify a partial ARN too---for example, if you
#' don't include the final hyphen and six random characters that Secrets
#' Manager adds at the end of the ARN when you created the secret. A
#' partial ARN match can work as long as it uniquely matches only one
#' secret. However, if your secret has a name that ends in a hyphen
#' followed by six characters (before Secrets Manager adds the hyphen and
#' six characters to the ARN) and you try to use that as a partial ARN,
#' then those characters cause Secrets Manager to assume that you're
#' specifying a complete ARN. This confusion can cause unexpected results.
#' To avoid this situation, we recommend that you don't create secret names
#' that end with a hyphen followed by six characters.
#' @param MaxResults (Optional) Limits the number of results that you want to include in the
#' response. If you don\'t include this parameter, it defaults to a value
#' that\'s specific to the operation. If additional items exist beyond the
#' maximum you specify, the `NextToken` response element is present and has
#' a value (isn\'t null). Include that value as the `NextToken` request
#' parameter in the next call to the operation to get the next part of the
#' results. Note that Secrets Manager might return fewer results than the
#' maximum even when there are more results available. You should check
#' `NextToken` after every operation to ensure that you receive all of the
#' results.
#' @param NextToken (Optional) Use this parameter in a request if you receive a `NextToken`
#' response in a previous request that indicates that there\'s more output
#' available. In a subsequent call, set it to the value of the previous
#' call\'s `NextToken` response to indicate where the output should
#' continue from.
#' @param IncludeDeprecated (Optional) Specifies that you want the results to include versions that
#' do not have any staging labels attached to them. Such versions are
#' considered deprecated and are subject to deletion by Secrets Manager as
#' needed.
#'
#' @section Request syntax:
#' ```
#' svc$list_secret_version_ids(
#'   SecretId = "string",
#'   MaxResults = 123,
#'   NextToken = "string",
#'   IncludeDeprecated = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # The following example shows how to retrieve a list of all of the
#' # versions of a secret, including those without any staging labels.
#' \donttest{svc$list_secret_version_ids(
#'   IncludeDeprecated = TRUE,
#'   SecretId = "MyTestDatabaseSecret"
#' )}
#'
#' @keywords internal
#'
#' @rdname secretsmanager_list_secret_version_ids
secretsmanager_list_secret_version_ids <- function(SecretId, MaxResults = NULL, NextToken = NULL, IncludeDeprecated = NULL) {
  op <- new_operation(
    name = "ListSecretVersionIds",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .secretsmanager$list_secret_version_ids_input(SecretId = SecretId, MaxResults = MaxResults, NextToken = NextToken, IncludeDeprecated = IncludeDeprecated)
  output <- .secretsmanager$list_secret_version_ids_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$list_secret_version_ids <- secretsmanager_list_secret_version_ids

#' Lists all of the secrets that are stored by Secrets Manager in the AWS
#' account
#'
#' Lists all of the secrets that are stored by Secrets Manager in the AWS
#' account. To list the versions currently stored for a specific secret,
#' use ListSecretVersionIds. The encrypted fields `SecretString` and
#' `SecretBinary` are not included in the output. To get that information,
#' call the GetSecretValue operation.
#' 
#' Always check the `NextToken` response parameter when calling any of the
#' `List*` operations. These operations can occasionally return an empty or
#' shorter than expected list of results even when there are more results
#' available. When this happens, the `NextToken` response parameter
#' contains a value to pass to the next call to the same API to request the
#' next part of the list.
#' 
#' **Minimum permissions**
#' 
#' To run this command, you must have the following permissions:
#' 
#' -   secretsmanager:ListSecrets
#' 
#' **Related operations**
#' 
#' -   To list the versions attached to a secret, use ListSecretVersionIds.
#'
#' @usage
#' secretsmanager_list_secrets(MaxResults, NextToken)
#'
#' @param MaxResults (Optional) Limits the number of results that you want to include in the
#' response. If you don\'t include this parameter, it defaults to a value
#' that\'s specific to the operation. If additional items exist beyond the
#' maximum you specify, the `NextToken` response element is present and has
#' a value (isn\'t null). Include that value as the `NextToken` request
#' parameter in the next call to the operation to get the next part of the
#' results. Note that Secrets Manager might return fewer results than the
#' maximum even when there are more results available. You should check
#' `NextToken` after every operation to ensure that you receive all of the
#' results.
#' @param NextToken (Optional) Use this parameter in a request if you receive a `NextToken`
#' response in a previous request that indicates that there\'s more output
#' available. In a subsequent call, set it to the value of the previous
#' call\'s `NextToken` response to indicate where the output should
#' continue from.
#'
#' @section Request syntax:
#' ```
#' svc$list_secrets(
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @examples
#' # The following example shows how to list all of the secrets in your
#' # account.
#' \donttest{svc$list_secrets()}
#'
#' @keywords internal
#'
#' @rdname secretsmanager_list_secrets
secretsmanager_list_secrets <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListSecrets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .secretsmanager$list_secrets_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .secretsmanager$list_secrets_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$list_secrets <- secretsmanager_list_secrets

#' Attaches the contents of the specified resource-based permission policy
#' to a secret
#'
#' Attaches the contents of the specified resource-based permission policy
#' to a secret. A resource-based policy is optional. Alternatively, you can
#' use IAM identity-based policies that specify the secret\'s Amazon
#' Resource Name (ARN) in the policy statement\'s `Resources` element. You
#' can also use a combination of both identity-based and resource-based
#' policies. The affected users and roles receive the permissions that are
#' permitted by all of the relevant policies. For more information, see
#' [Using Resource-Based Policies for AWS Secrets
#' Manager](http://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_resource-based-policies.html).
#' For the complete description of the AWS policy syntax and grammar, see
#' [IAM JSON Policy
#' Reference](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html)
#' in the *IAM User Guide*.
#' 
#' **Minimum permissions**
#' 
#' To run this command, you must have the following permissions:
#' 
#' -   secretsmanager:PutResourcePolicy
#' 
#' **Related operations**
#' 
#' -   To retrieve the resource policy that\'s attached to a secret, use
#'     GetResourcePolicy.
#' 
#' -   To delete the resource-based policy that\'s attached to a secret,
#'     use DeleteResourcePolicy.
#' 
#' -   To list all of the currently available secrets, use ListSecrets.
#'
#' @usage
#' secretsmanager_put_resource_policy(SecretId, ResourcePolicy)
#'
#' @param SecretId &#91;required&#93; Specifies the secret that you want to attach the resource-based policy
#' to. You can specify either the ARN or the friendly name of the secret.
#' 
#' If you specify an ARN, we generally recommend that you specify a
#' complete ARN. You can specify a partial ARN too---for example, if you
#' don't include the final hyphen and six random characters that Secrets
#' Manager adds at the end of the ARN when you created the secret. A
#' partial ARN match can work as long as it uniquely matches only one
#' secret. However, if your secret has a name that ends in a hyphen
#' followed by six characters (before Secrets Manager adds the hyphen and
#' six characters to the ARN) and you try to use that as a partial ARN,
#' then those characters cause Secrets Manager to assume that you're
#' specifying a complete ARN. This confusion can cause unexpected results.
#' To avoid this situation, we recommend that you don't create secret names
#' that end with a hyphen followed by six characters.
#' @param ResourcePolicy &#91;required&#93; A JSON-formatted string that\'s constructed according to the grammar and
#' syntax for an AWS resource-based policy. The policy in the string
#' identifies who can access or manage this secret and its versions. For
#' information on how to format a JSON parameter for the various command
#' line tool environments, see [Using JSON for
#' Parameters](http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json)
#' in the *AWS CLI User Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$put_resource_policy(
#'   SecretId = "string",
#'   ResourcePolicy = "string"
#' )
#' ```
#'
#' @examples
#' # The following example shows how to add a resource-based policy to a
#' # secret.
#' \donttest{svc$put_resource_policy(
#'   ResourcePolicy = "{\n\"Version\":\"2012-10-17\",\n\"Statement\":[{\n\"Effect\":\"Allow\",...",
#'   SecretId = "MyTestDatabaseSecret"
#' )}
#'
#' @keywords internal
#'
#' @rdname secretsmanager_put_resource_policy
secretsmanager_put_resource_policy <- function(SecretId, ResourcePolicy) {
  op <- new_operation(
    name = "PutResourcePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .secretsmanager$put_resource_policy_input(SecretId = SecretId, ResourcePolicy = ResourcePolicy)
  output <- .secretsmanager$put_resource_policy_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$put_resource_policy <- secretsmanager_put_resource_policy

#' Stores a new encrypted secret value in the specified secret
#'
#' Stores a new encrypted secret value in the specified secret. To do this,
#' the operation creates a new version and attaches it to the secret. The
#' version can contain a new `SecretString` value or a new `SecretBinary`
#' value. You can also specify the staging labels that are initially
#' attached to the new version.
#' 
#' The Secrets Manager console uses only the `SecretString` field. To add
#' binary data to a secret with the `SecretBinary` field you must use the
#' AWS CLI or one of the AWS SDKs.
#' 
#' -   If this operation creates the first version for the secret then
#'     Secrets Manager automatically attaches the staging label
#'     `AWSCURRENT` to the new version.
#' 
#' -   If another version of this secret already exists, then this
#'     operation does not automatically move any staging labels other than
#'     those that you explicitly specify in the `VersionStages` parameter.
#' 
#' -   If this operation moves the staging label `AWSCURRENT` from another
#'     version to this version (because you included it in the
#'     `StagingLabels` parameter) then Secrets Manager also automatically
#'     moves the staging label `AWSPREVIOUS` to the version that
#'     `AWSCURRENT` was removed from.
#' 
#' -   This operation is idempotent. If a version with a `VersionId` with
#'     the same value as the `ClientRequestToken` parameter already exists
#'     and you specify the same secret data, the operation succeeds but
#'     does nothing. However, if the secret data is different, then the
#'     operation fails because you cannot modify an existing version; you
#'     can only create new ones.
#' 
#' <!-- -->
#' 
#' -   If you call an operation that needs to encrypt or decrypt the
#'     `SecretString` or `SecretBinary` for a secret in the same account as
#'     the calling user and that secret doesn\'t specify a AWS KMS
#'     encryption key, Secrets Manager uses the account\'s default AWS
#'     managed customer master key (CMK) with the alias
#'     `aws/secretsmanager`. If this key doesn\'t already exist in your
#'     account then Secrets Manager creates it for you automatically. All
#'     users and roles in the same AWS account automatically have access to
#'     use the default CMK. Note that if an Secrets Manager API call
#'     results in AWS having to create the account\'s AWS-managed CMK, it
#'     can result in a one-time significant delay in returning the result.
#' 
#' -   If the secret is in a different AWS account from the credentials
#'     calling an API that requires encryption or decryption of the secret
#'     value then you must create and use a custom AWS KMS CMK because you
#'     can\'t access the default CMK for the account using credentials from
#'     a different AWS account. Store the ARN of the CMK in the secret when
#'     you create the secret or when you update it by including it in the
#'     `KMSKeyId`. If you call an API that must encrypt or decrypt
#'     `SecretString` or `SecretBinary` using credentials from a different
#'     account then the AWS KMS key policy must grant cross-account access
#'     to that other account\'s user or role for both the
#'     kms:GenerateDataKey and kms:Decrypt operations.
#' 
#' **Minimum permissions**
#' 
#' To run this command, you must have the following permissions:
#' 
#' -   secretsmanager:PutSecretValue
#' 
#' -   kms:GenerateDataKey - needed only if you use a customer-managed AWS
#'     KMS key to encrypt the secret. You do not need this permission to
#'     use the account\'s default AWS managed CMK for Secrets Manager.
#' 
#' **Related operations**
#' 
#' -   To retrieve the encrypted value you store in the version of a
#'     secret, use GetSecretValue.
#' 
#' -   To create a secret, use CreateSecret.
#' 
#' -   To get the details for a secret, use DescribeSecret.
#' 
#' -   To list the versions attached to a secret, use ListSecretVersionIds.
#'
#' @usage
#' secretsmanager_put_secret_value(SecretId, ClientRequestToken,
#'   SecretBinary, SecretString, VersionStages)
#'
#' @param SecretId &#91;required&#93; Specifies the secret to which you want to add a new version. You can
#' specify either the Amazon Resource Name (ARN) or the friendly name of
#' the secret. The secret must already exist.
#' 
#' If you specify an ARN, we generally recommend that you specify a
#' complete ARN. You can specify a partial ARN too---for example, if you
#' don't include the final hyphen and six random characters that Secrets
#' Manager adds at the end of the ARN when you created the secret. A
#' partial ARN match can work as long as it uniquely matches only one
#' secret. However, if your secret has a name that ends in a hyphen
#' followed by six characters (before Secrets Manager adds the hyphen and
#' six characters to the ARN) and you try to use that as a partial ARN,
#' then those characters cause Secrets Manager to assume that you're
#' specifying a complete ARN. This confusion can cause unexpected results.
#' To avoid this situation, we recommend that you don't create secret names
#' that end with a hyphen followed by six characters.
#' @param ClientRequestToken (Optional) Specifies a unique identifier for the new version of the
#' secret.
#' 
#' If you use the AWS CLI or one of the AWS SDK to call this operation,
#' then you can leave this parameter empty. The CLI or SDK generates a
#' random UUID for you and includes that in the request. If you don\'t use
#' the SDK and instead generate a raw HTTP request to the Secrets Manager
#' service endpoint, then you must generate a `ClientRequestToken` yourself
#' for new versions and include that value in the request.
#' 
#' This value helps ensure idempotency. Secrets Manager uses this value to
#' prevent the accidental creation of duplicate versions if there are
#' failures and retries during the Lambda rotation function\'s processing.
#' We recommend that you generate a
#' [UUID-type](https://wikipedia.org/wiki/Universally_unique_identifier)
#' value to ensure uniqueness within the specified secret.
#' 
#' -   If the `ClientRequestToken` value isn\'t already associated with a
#'     version of the secret then a new version of the secret is created.
#' 
#' -   If a version with this value already exists and that version\'s
#'     `SecretString` or `SecretBinary` values are the same as those in the
#'     request then the request is ignored (the operation is idempotent).
#' 
#' -   If a version with this value already exists and that version\'s
#'     `SecretString` and `SecretBinary` values are different from those in
#'     the request then the request fails because you cannot modify an
#'     existing secret version. You can only create new versions to store
#'     new secret values.
#' 
#' This value becomes the `VersionId` of the new version.
#' @param SecretBinary (Optional) Specifies binary data that you want to encrypt and store in
#' the new version of the secret. To use this parameter in the command-line
#' tools, we recommend that you store your binary data in a file and then
#' use the appropriate technique for your tool to pass the contents of the
#' file as a parameter. Either `SecretBinary` or `SecretString` must have a
#' value, but not both. They cannot both be empty.
#' 
#' This parameter is not accessible if the secret using the Secrets Manager
#' console.
#' @param SecretString (Optional) Specifies text data that you want to encrypt and store in
#' this new version of the secret. Either `SecretString` or `SecretBinary`
#' must have a value, but not both. They cannot both be empty.
#' 
#' If you create this secret by using the Secrets Manager console then
#' Secrets Manager puts the protected secret text in only the
#' `SecretString` parameter. The Secrets Manager console stores the
#' information as a JSON structure of key/value pairs that the default
#' Lambda rotation function knows how to parse.
#' 
#' For storing multiple values, we recommend that you use a JSON text
#' string argument and specify key/value pairs. For information on how to
#' format a JSON parameter for the various command line tool environments,
#' see [Using JSON for
#' Parameters](https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json)
#' in the *AWS CLI User Guide*.
#' 
#' For example:
#' 
#' `\\[\{"username":"bob"\},\{"password":"abc123xyz456"\}\\]`
#' 
#' If your command-line tool or SDK requires quotation marks around the
#' parameter, you should use single quotes to avoid confusion with the
#' double quotes required in the JSON text.
#' @param VersionStages (Optional) Specifies a list of staging labels that are attached to this
#' version of the secret. These staging labels are used to track the
#' versions through the rotation process by the Lambda rotation function.
#' 
#' A staging label must be unique to a single version of the secret. If you
#' specify a staging label that\'s already associated with a different
#' version of the same secret then that staging label is automatically
#' removed from the other version and attached to this version.
#' 
#' If you do not specify a value for `VersionStages` then Secrets Manager
#' automatically moves the staging label `AWSCURRENT` to this new version.
#'
#' @section Request syntax:
#' ```
#' svc$put_secret_value(
#'   SecretId = "string",
#'   ClientRequestToken = "string",
#'   SecretBinary = raw,
#'   SecretString = "string",
#'   VersionStages = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # The following example shows how to create a new version of the secret.
#' # Alternatively, you can use the update-secret command.
#' \donttest{svc$put_secret_value(
#'   ClientRequestToken = "EXAMPLE2-90ab-cdef-fedc-ba987EXAMPLE",
#'   SecretId = "MyTestDatabaseSecret",
#'   SecretString = "{\"username\":\"david\",\"password\":\"BnQw!XDWgaEeT9XGTT29\"}"
#' )}
#'
#' @keywords internal
#'
#' @rdname secretsmanager_put_secret_value
secretsmanager_put_secret_value <- function(SecretId, ClientRequestToken = NULL, SecretBinary = NULL, SecretString = NULL, VersionStages = NULL) {
  op <- new_operation(
    name = "PutSecretValue",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .secretsmanager$put_secret_value_input(SecretId = SecretId, ClientRequestToken = ClientRequestToken, SecretBinary = SecretBinary, SecretString = SecretString, VersionStages = VersionStages)
  output <- .secretsmanager$put_secret_value_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$put_secret_value <- secretsmanager_put_secret_value

#' Cancels the scheduled deletion of a secret by removing the DeletedDate
#' time stamp
#'
#' Cancels the scheduled deletion of a secret by removing the `DeletedDate`
#' time stamp. This makes the secret accessible to query once again.
#' 
#' **Minimum permissions**
#' 
#' To run this command, you must have the following permissions:
#' 
#' -   secretsmanager:RestoreSecret
#' 
#' **Related operations**
#' 
#' -   To delete a secret, use DeleteSecret.
#'
#' @usage
#' secretsmanager_restore_secret(SecretId)
#'
#' @param SecretId &#91;required&#93; Specifies the secret that you want to restore from a previously
#' scheduled deletion. You can specify either the Amazon Resource Name
#' (ARN) or the friendly name of the secret.
#' 
#' If you specify an ARN, we generally recommend that you specify a
#' complete ARN. You can specify a partial ARN too---for example, if you
#' don't include the final hyphen and six random characters that Secrets
#' Manager adds at the end of the ARN when you created the secret. A
#' partial ARN match can work as long as it uniquely matches only one
#' secret. However, if your secret has a name that ends in a hyphen
#' followed by six characters (before Secrets Manager adds the hyphen and
#' six characters to the ARN) and you try to use that as a partial ARN,
#' then those characters cause Secrets Manager to assume that you're
#' specifying a complete ARN. This confusion can cause unexpected results.
#' To avoid this situation, we recommend that you don't create secret names
#' that end with a hyphen followed by six characters.
#'
#' @section Request syntax:
#' ```
#' svc$restore_secret(
#'   SecretId = "string"
#' )
#' ```
#'
#' @examples
#' # The following example shows how to restore a secret that you previously
#' # scheduled for deletion.
#' \donttest{svc$restore_secret(
#'   SecretId = "MyTestDatabaseSecret"
#' )}
#'
#' @keywords internal
#'
#' @rdname secretsmanager_restore_secret
secretsmanager_restore_secret <- function(SecretId) {
  op <- new_operation(
    name = "RestoreSecret",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .secretsmanager$restore_secret_input(SecretId = SecretId)
  output <- .secretsmanager$restore_secret_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$restore_secret <- secretsmanager_restore_secret

#' Configures and starts the asynchronous process of rotating this secret
#'
#' Configures and starts the asynchronous process of rotating this secret.
#' If you include the configuration parameters, the operation sets those
#' values for the secret and then immediately starts a rotation. If you do
#' not include the configuration parameters, the operation starts a
#' rotation with the values already stored in the secret. After the
#' rotation completes, the protected service and its clients all use the
#' new version of the secret.
#' 
#' This required configuration information includes the ARN of an AWS
#' Lambda function and the time between scheduled rotations. The Lambda
#' rotation function creates a new version of the secret and creates or
#' updates the credentials on the protected service to match. After testing
#' the new credentials, the function marks the new secret with the staging
#' label `AWSCURRENT` so that your clients all immediately begin to use the
#' new version. For more information about rotating secrets and how to
#' configure a Lambda function to rotate the secrets for your protected
#' service, see [Rotating Secrets in AWS Secrets
#' Manager](https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets.html)
#' in the *AWS Secrets Manager User Guide*.
#' 
#' Secrets Manager schedules the next rotation when the previous one is
#' complete. Secrets Manager schedules the date by adding the rotation
#' interval (number of days) to the actual date of the last rotation. The
#' service chooses the hour within that 24-hour date window randomly. The
#' minute is also chosen somewhat randomly, but weighted towards the top of
#' the hour and influenced by a variety of factors that help distribute
#' load.
#' 
#' The rotation function must end with the versions of the secret in one of
#' two states:
#' 
#' -   The `AWSPENDING` and `AWSCURRENT` staging labels are attached to the
#'     same version of the secret, or
#' 
#' -   The `AWSPENDING` staging label is not attached to any version of the
#'     secret.
#' 
#' If instead the `AWSPENDING` staging label is present but is not attached
#' to the same version as `AWSCURRENT` then any later invocation of
#' `RotateSecret` assumes that a previous rotation request is still in
#' progress and returns an error.
#' 
#' **Minimum permissions**
#' 
#' To run this command, you must have the following permissions:
#' 
#' -   secretsmanager:RotateSecret
#' 
#' -   lambda:InvokeFunction (on the function specified in the secret\'s
#'     metadata)
#' 
#' **Related operations**
#' 
#' -   To list the secrets in your account, use ListSecrets.
#' 
#' -   To get the details for a version of a secret, use DescribeSecret.
#' 
#' -   To create a new version of a secret, use CreateSecret.
#' 
#' -   To attach staging labels to or remove staging labels from a version
#'     of a secret, use UpdateSecretVersionStage.
#'
#' @usage
#' secretsmanager_rotate_secret(SecretId, ClientRequestToken,
#'   RotationLambdaARN, RotationRules)
#'
#' @param SecretId &#91;required&#93; Specifies the secret that you want to rotate. You can specify either the
#' Amazon Resource Name (ARN) or the friendly name of the secret.
#' 
#' If you specify an ARN, we generally recommend that you specify a
#' complete ARN. You can specify a partial ARN too---for example, if you
#' don't include the final hyphen and six random characters that Secrets
#' Manager adds at the end of the ARN when you created the secret. A
#' partial ARN match can work as long as it uniquely matches only one
#' secret. However, if your secret has a name that ends in a hyphen
#' followed by six characters (before Secrets Manager adds the hyphen and
#' six characters to the ARN) and you try to use that as a partial ARN,
#' then those characters cause Secrets Manager to assume that you're
#' specifying a complete ARN. This confusion can cause unexpected results.
#' To avoid this situation, we recommend that you don't create secret names
#' that end with a hyphen followed by six characters.
#' @param ClientRequestToken (Optional) Specifies a unique identifier for the new version of the
#' secret that helps ensure idempotency.
#' 
#' If you use the AWS CLI or one of the AWS SDK to call this operation,
#' then you can leave this parameter empty. The CLI or SDK generates a
#' random UUID for you and includes that in the request for this parameter.
#' If you don\'t use the SDK and instead generate a raw HTTP request to the
#' Secrets Manager service endpoint, then you must generate a
#' `ClientRequestToken` yourself for new versions and include that value in
#' the request.
#' 
#' You only need to specify your own value if you are implementing your own
#' retry logic and want to ensure that a given secret is not created twice.
#' We recommend that you generate a
#' [UUID-type](https://wikipedia.org/wiki/Universally_unique_identifier)
#' value to ensure uniqueness within the specified secret.
#' 
#' Secrets Manager uses this value to prevent the accidental creation of
#' duplicate versions if there are failures and retries during the
#' function\'s processing. This value becomes the `VersionId` of the new
#' version.
#' @param RotationLambdaARN (Optional) Specifies the ARN of the Lambda function that can rotate the
#' secret.
#' @param RotationRules A structure that defines the rotation configuration for this secret.
#'
#' @section Request syntax:
#' ```
#' svc$rotate_secret(
#'   SecretId = "string",
#'   ClientRequestToken = "string",
#'   RotationLambdaARN = "string",
#'   RotationRules = list(
#'     AutomaticallyAfterDays = 123
#'   )
#' )
#' ```
#'
#' @examples
#' # The following example configures rotation for a secret by providing the
#' # ARN of a Lambda rotation function (which must already exist) and the
#' # number of days between rotation. The first rotation happens immediately
#' # upon completion of this command. The rotation function runs
#' # asynchronously in the background.
#' \donttest{svc$rotate_secret(
#'   RotationLambdaARN = "arn:aws:lambda:us-west-2:123456789012:function:MyTestDatabaseRotation...",
#'   RotationRules = list(
#'     AutomaticallyAfterDays = 30L
#'   ),
#'   SecretId = "MyTestDatabaseSecret"
#' )}
#' 
#' # The following example requests an immediate invocation of the secret's
#' # Lambda rotation function. It assumes that the specified secret already
#' # has rotation configured. The rotation function runs asynchronously in
#' # the background.
#' \donttest{svc$rotate_secret(
#'   SecretId = "MyTestDatabaseSecret"
#' )}
#'
#' @keywords internal
#'
#' @rdname secretsmanager_rotate_secret
secretsmanager_rotate_secret <- function(SecretId, ClientRequestToken = NULL, RotationLambdaARN = NULL, RotationRules = NULL) {
  op <- new_operation(
    name = "RotateSecret",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .secretsmanager$rotate_secret_input(SecretId = SecretId, ClientRequestToken = ClientRequestToken, RotationLambdaARN = RotationLambdaARN, RotationRules = RotationRules)
  output <- .secretsmanager$rotate_secret_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$rotate_secret <- secretsmanager_rotate_secret

#' Attaches one or more tags, each consisting of a key name and a value, to
#' the specified secret
#'
#' Attaches one or more tags, each consisting of a key name and a value, to
#' the specified secret. Tags are part of the secret\'s overall metadata,
#' and are not associated with any specific version of the secret. This
#' operation only appends tags to the existing list of tags. To remove
#' tags, you must use UntagResource.
#' 
#' The following basic restrictions apply to tags:
#' 
#' -   Maximum number of tags per secret---50
#' 
#' -   Maximum key length---127 Unicode characters in UTF-8
#' 
#' -   Maximum value length---255 Unicode characters in UTF-8
#' 
#' -   Tag keys and values are case sensitive.
#' 
#' -   Do not use the `aws:` prefix in your tag names or values because it
#'     is reserved for AWS use. You can\'t edit or delete tag names or
#'     values with this prefix. Tags with this prefix do not count against
#'     your tags per secret limit.
#' 
#' -   If your tagging schema will be used across multiple services and
#'     resources, remember that other services might have restrictions on
#'     allowed characters. Generally allowed characters are: letters,
#'     spaces, and numbers representable in UTF-8, plus the following
#'     special characters: + - = . \\_ : / @.
#' 
#' If you use tags as part of your security strategy, then adding or
#' removing a tag can change permissions. If successfully completing this
#' operation would result in you losing your permissions for this secret,
#' then the operation is blocked and returns an Access Denied error.
#' 
#' **Minimum permissions**
#' 
#' To run this command, you must have the following permissions:
#' 
#' -   secretsmanager:TagResource
#' 
#' **Related operations**
#' 
#' -   To remove one or more tags from the collection attached to a secret,
#'     use UntagResource.
#' 
#' -   To view the list of tags attached to a secret, use DescribeSecret.
#'
#' @usage
#' secretsmanager_tag_resource(SecretId, Tags)
#'
#' @param SecretId &#91;required&#93; The identifier for the secret that you want to attach tags to. You can
#' specify either the Amazon Resource Name (ARN) or the friendly name of
#' the secret.
#' 
#' If you specify an ARN, we generally recommend that you specify a
#' complete ARN. You can specify a partial ARN too---for example, if you
#' don't include the final hyphen and six random characters that Secrets
#' Manager adds at the end of the ARN when you created the secret. A
#' partial ARN match can work as long as it uniquely matches only one
#' secret. However, if your secret has a name that ends in a hyphen
#' followed by six characters (before Secrets Manager adds the hyphen and
#' six characters to the ARN) and you try to use that as a partial ARN,
#' then those characters cause Secrets Manager to assume that you're
#' specifying a complete ARN. This confusion can cause unexpected results.
#' To avoid this situation, we recommend that you don't create secret names
#' that end with a hyphen followed by six characters.
#' @param Tags &#91;required&#93; The tags to attach to the secret. Each element in the list consists of a
#' `Key` and a `Value`.
#' 
#' This parameter to the API requires a JSON text string argument. For
#' information on how to format a JSON parameter for the various command
#' line tool environments, see [Using JSON for
#' Parameters](https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json)
#' in the *AWS CLI User Guide*. For the AWS CLI, you can also use the
#' syntax:
#' `--Tags Key="Key1",Value="Value1",Key="Key2",Value="Value2"\\[,â€¦\\]`
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   SecretId = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # The following example shows how to attach two tags each with a Key and
#' # Value to a secret. There is no output from this API. To see the result,
#' # use the DescribeSecret operation.
#' \donttest{svc$tag_resource(
#'   SecretId = "MyExampleSecret",
#'   Tags = list(
#'     list(
#'       Key = "FirstTag",
#'       Value = "SomeValue"
#'     ),
#'     list(
#'       Key = "SecondTag",
#'       Value = "AnotherValue"
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname secretsmanager_tag_resource
secretsmanager_tag_resource <- function(SecretId, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .secretsmanager$tag_resource_input(SecretId = SecretId, Tags = Tags)
  output <- .secretsmanager$tag_resource_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$tag_resource <- secretsmanager_tag_resource

#' Removes one or more tags from the specified secret
#'
#' Removes one or more tags from the specified secret.
#' 
#' This operation is idempotent. If a requested tag is not attached to the
#' secret, no error is returned and the secret metadata is unchanged.
#' 
#' If you use tags as part of your security strategy, then removing a tag
#' can change permissions. If successfully completing this operation would
#' result in you losing your permissions for this secret, then the
#' operation is blocked and returns an Access Denied error.
#' 
#' **Minimum permissions**
#' 
#' To run this command, you must have the following permissions:
#' 
#' -   secretsmanager:UntagResource
#' 
#' **Related operations**
#' 
#' -   To add one or more tags to the collection attached to a secret, use
#'     TagResource.
#' 
#' -   To view the list of tags attached to a secret, use DescribeSecret.
#'
#' @usage
#' secretsmanager_untag_resource(SecretId, TagKeys)
#'
#' @param SecretId &#91;required&#93; The identifier for the secret that you want to remove tags from. You can
#' specify either the Amazon Resource Name (ARN) or the friendly name of
#' the secret.
#' 
#' If you specify an ARN, we generally recommend that you specify a
#' complete ARN. You can specify a partial ARN too---for example, if you
#' don't include the final hyphen and six random characters that Secrets
#' Manager adds at the end of the ARN when you created the secret. A
#' partial ARN match can work as long as it uniquely matches only one
#' secret. However, if your secret has a name that ends in a hyphen
#' followed by six characters (before Secrets Manager adds the hyphen and
#' six characters to the ARN) and you try to use that as a partial ARN,
#' then those characters cause Secrets Manager to assume that you're
#' specifying a complete ARN. This confusion can cause unexpected results.
#' To avoid this situation, we recommend that you don't create secret names
#' that end with a hyphen followed by six characters.
#' @param TagKeys &#91;required&#93; A list of tag key names to remove from the secret. You don\'t specify
#' the value. Both the key and its associated value are removed.
#' 
#' This parameter to the API requires a JSON text string argument. For
#' information on how to format a JSON parameter for the various command
#' line tool environments, see [Using JSON for
#' Parameters](https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json)
#' in the *AWS CLI User Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   SecretId = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # The following example shows how to remove two tags from a secret's
#' # metadata. For each, both the tag and the associated value are removed.
#' # There is no output from this API. To see the result, use the
#' # DescribeSecret operation.
#' \donttest{svc$untag_resource(
#'   SecretId = "MyTestDatabaseSecret",
#'   TagKeys = list(
#'     "FirstTag",
#'     "SecondTag"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname secretsmanager_untag_resource
secretsmanager_untag_resource <- function(SecretId, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .secretsmanager$untag_resource_input(SecretId = SecretId, TagKeys = TagKeys)
  output <- .secretsmanager$untag_resource_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$untag_resource <- secretsmanager_untag_resource

#' Modifies many of the details of the specified secret
#'
#' Modifies many of the details of the specified secret. If you include a
#' `ClientRequestToken` and *either* `SecretString` or `SecretBinary` then
#' it also creates a new version attached to the secret.
#' 
#' To modify the rotation configuration of a secret, use RotateSecret
#' instead.
#' 
#' The Secrets Manager console uses only the `SecretString` parameter and
#' therefore limits you to encrypting and storing only a text string. To
#' encrypt and store binary data as part of the version of a secret, you
#' must use either the AWS CLI or one of the AWS SDKs.
#' 
#' -   If a version with a `VersionId` with the same value as the
#'     `ClientRequestToken` parameter already exists, the operation results
#'     in an error. You cannot modify an existing version, you can only
#'     create a new version.
#' 
#' -   If you include `SecretString` or `SecretBinary` to create a new
#'     secret version, Secrets Manager automatically attaches the staging
#'     label `AWSCURRENT` to the new version.
#' 
#' <!-- -->
#' 
#' -   If you call an operation that needs to encrypt or decrypt the
#'     `SecretString` or `SecretBinary` for a secret in the same account as
#'     the calling user and that secret doesn\'t specify a AWS KMS
#'     encryption key, Secrets Manager uses the account\'s default AWS
#'     managed customer master key (CMK) with the alias
#'     `aws/secretsmanager`. If this key doesn\'t already exist in your
#'     account then Secrets Manager creates it for you automatically. All
#'     users and roles in the same AWS account automatically have access to
#'     use the default CMK. Note that if an Secrets Manager API call
#'     results in AWS having to create the account\'s AWS-managed CMK, it
#'     can result in a one-time significant delay in returning the result.
#' 
#' -   If the secret is in a different AWS account from the credentials
#'     calling an API that requires encryption or decryption of the secret
#'     value then you must create and use a custom AWS KMS CMK because you
#'     can\'t access the default CMK for the account using credentials from
#'     a different AWS account. Store the ARN of the CMK in the secret when
#'     you create the secret or when you update it by including it in the
#'     `KMSKeyId`. If you call an API that must encrypt or decrypt
#'     `SecretString` or `SecretBinary` using credentials from a different
#'     account then the AWS KMS key policy must grant cross-account access
#'     to that other account\'s user or role for both the
#'     kms:GenerateDataKey and kms:Decrypt operations.
#' 
#' **Minimum permissions**
#' 
#' To run this command, you must have the following permissions:
#' 
#' -   secretsmanager:UpdateSecret
#' 
#' -   kms:GenerateDataKey - needed only if you use a custom AWS KMS key to
#'     encrypt the secret. You do not need this permission to use the
#'     account\'s AWS managed CMK for Secrets Manager.
#' 
#' -   kms:Decrypt - needed only if you use a custom AWS KMS key to encrypt
#'     the secret. You do not need this permission to use the account\'s
#'     AWS managed CMK for Secrets Manager.
#' 
#' **Related operations**
#' 
#' -   To create a new secret, use CreateSecret.
#' 
#' -   To add only a new version to an existing secret, use PutSecretValue.
#' 
#' -   To get the details for a secret, use DescribeSecret.
#' 
#' -   To list the versions contained in a secret, use
#'     ListSecretVersionIds.
#'
#' @usage
#' secretsmanager_update_secret(SecretId, ClientRequestToken, Description,
#'   KmsKeyId, SecretBinary, SecretString)
#'
#' @param SecretId &#91;required&#93; Specifies the secret that you want to modify or to which you want to add
#' a new version. You can specify either the Amazon Resource Name (ARN) or
#' the friendly name of the secret.
#' 
#' If you specify an ARN, we generally recommend that you specify a
#' complete ARN. You can specify a partial ARN too---for example, if you
#' don't include the final hyphen and six random characters that Secrets
#' Manager adds at the end of the ARN when you created the secret. A
#' partial ARN match can work as long as it uniquely matches only one
#' secret. However, if your secret has a name that ends in a hyphen
#' followed by six characters (before Secrets Manager adds the hyphen and
#' six characters to the ARN) and you try to use that as a partial ARN,
#' then those characters cause Secrets Manager to assume that you're
#' specifying a complete ARN. This confusion can cause unexpected results.
#' To avoid this situation, we recommend that you don't create secret names
#' that end with a hyphen followed by six characters.
#' @param ClientRequestToken (Optional) If you want to add a new version to the secret, this
#' parameter specifies a unique identifier for the new version that helps
#' ensure idempotency.
#' 
#' If you use the AWS CLI or one of the AWS SDK to call this operation,
#' then you can leave this parameter empty. The CLI or SDK generates a
#' random UUID for you and includes that in the request. If you don\'t use
#' the SDK and instead generate a raw HTTP request to the Secrets Manager
#' service endpoint, then you must generate a `ClientRequestToken` yourself
#' for new versions and include that value in the request.
#' 
#' You typically only need to interact with this value if you implement
#' your own retry logic and want to ensure that a given secret is not
#' created twice. We recommend that you generate a
#' [UUID-type](https://wikipedia.org/wiki/Universally_unique_identifier)
#' value to ensure uniqueness within the specified secret.
#' 
#' Secrets Manager uses this value to prevent the accidental creation of
#' duplicate versions if there are failures and retries during the Lambda
#' rotation function\'s processing.
#' 
#' -   If the `ClientRequestToken` value isn\'t already associated with a
#'     version of the secret then a new version of the secret is created.
#' 
#' -   If a version with this value already exists and that version\'s
#'     `SecretString` and `SecretBinary` values are the same as those in
#'     the request then the request is ignored (the operation is
#'     idempotent).
#' 
#' -   If a version with this value already exists and that version\'s
#'     `SecretString` and `SecretBinary` values are different from the
#'     request then an error occurs because you cannot modify an existing
#'     secret value.
#' 
#' This value becomes the `VersionId` of the new version.
#' @param Description (Optional) Specifies an updated user-provided description of the secret.
#' @param KmsKeyId (Optional) Specifies an updated ARN or alias of the AWS KMS customer
#' master key (CMK) to be used to encrypt the protected text in new
#' versions of this secret.
#' 
#' You can only use the account\'s default CMK to encrypt and decrypt if
#' you call this operation using credentials from the same account that
#' owns the secret. If the secret is in a different account, then you must
#' create a custom CMK and provide the ARN of that CMK in this field. The
#' user making the call must have permissions to both the secret and the
#' CMK in their respective accounts.
#' @param SecretBinary (Optional) Specifies updated binary data that you want to encrypt and
#' store in the new version of the secret. To use this parameter in the
#' command-line tools, we recommend that you store your binary data in a
#' file and then use the appropriate technique for your tool to pass the
#' contents of the file as a parameter. Either `SecretBinary` or
#' `SecretString` must have a value, but not both. They cannot both be
#' empty.
#' 
#' This parameter is not accessible using the Secrets Manager console.
#' @param SecretString (Optional) Specifies updated text data that you want to encrypt and
#' store in this new version of the secret. Either `SecretBinary` or
#' `SecretString` must have a value, but not both. They cannot both be
#' empty.
#' 
#' If you create this secret by using the Secrets Manager console then
#' Secrets Manager puts the protected secret text in only the
#' `SecretString` parameter. The Secrets Manager console stores the
#' information as a JSON structure of key/value pairs that the default
#' Lambda rotation function knows how to parse.
#' 
#' For storing multiple values, we recommend that you use a JSON text
#' string argument and specify key/value pairs. For information on how to
#' format a JSON parameter for the various command line tool environments,
#' see [Using JSON for
#' Parameters](https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json)
#' in the *AWS CLI User Guide*. For example:
#' 
#' `\\[\{"username":"bob"\},\{"password":"abc123xyz456"\}\\]`
#' 
#' If your command-line tool or SDK requires quotation marks around the
#' parameter, you should use single quotes to avoid confusion with the
#' double quotes required in the JSON text. You can also \'escape\' the
#' double quote character in the embedded JSON text by prefacing each with
#' a backslash. For example, the following string is surrounded by
#' double-quotes. All of the embedded double quotes are escaped:
#' 
#' `"\\[\{\"username\":\"bob\"\},\{\"password\":\"abc123xyz456\"\}\\]"`
#'
#' @section Request syntax:
#' ```
#' svc$update_secret(
#'   SecretId = "string",
#'   ClientRequestToken = "string",
#'   Description = "string",
#'   KmsKeyId = "string",
#'   SecretBinary = raw,
#'   SecretString = "string"
#' )
#' ```
#'
#' @examples
#' # The following example shows how to modify the description of a secret.
#' \donttest{svc$update_secret(
#'   ClientRequestToken = "EXAMPLE1-90ab-cdef-fedc-ba987EXAMPLE",
#'   Description = "This is a new description for the secret.",
#'   SecretId = "MyTestDatabaseSecret"
#' )}
#' 
#' # This example shows how to update the KMS customer managed key (CMK) used
#' # to encrypt the secret value. The KMS CMK must be in the same region as
#' # the secret.
#' \donttest{svc$update_secret(
#'   KmsKeyId = "arn:aws:kms:us-west-2:123456789012:key/EXAMPLE2-90ab-cdef-fedc-ba987EXAMPLE",
#'   SecretId = "MyTestDatabaseSecret"
#' )}
#' 
#' # The following example shows how to create a new version of the secret by
#' # updating the SecretString field. Alternatively, you can use the
#' # put-secret-value operation.
#' \donttest{svc$update_secret(
#'   SecretId = "MyTestDatabaseSecret",
#'   SecretString = "{JSON STRING WITH CREDENTIALS}"
#' )}
#'
#' @keywords internal
#'
#' @rdname secretsmanager_update_secret
secretsmanager_update_secret <- function(SecretId, ClientRequestToken = NULL, Description = NULL, KmsKeyId = NULL, SecretBinary = NULL, SecretString = NULL) {
  op <- new_operation(
    name = "UpdateSecret",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .secretsmanager$update_secret_input(SecretId = SecretId, ClientRequestToken = ClientRequestToken, Description = Description, KmsKeyId = KmsKeyId, SecretBinary = SecretBinary, SecretString = SecretString)
  output <- .secretsmanager$update_secret_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$update_secret <- secretsmanager_update_secret

#' Modifies the staging labels attached to a version of a secret
#'
#' Modifies the staging labels attached to a version of a secret. Staging
#' labels are used to track a version as it progresses through the secret
#' rotation process. You can attach a staging label to only one version of
#' a secret at a time. If a staging label to be added is already attached
#' to another version, then it is moved\\--removed from the other version
#' first and then attached to this one. For more information about staging
#' labels, see [Staging
#' Labels](https://docs.aws.amazon.com/secretsmanager/latest/userguide/terms-concepts.html#term_staging-label)
#' in the *AWS Secrets Manager User Guide*.
#' 
#' The staging labels that you specify in the `VersionStage` parameter are
#' added to the existing list of staging labels\\--they don\'t replace it.
#' 
#' You can move the `AWSCURRENT` staging label to this version by including
#' it in this call.
#' 
#' Whenever you move `AWSCURRENT`, Secrets Manager automatically moves the
#' label `AWSPREVIOUS` to the version that `AWSCURRENT` was removed from.
#' 
#' If this action results in the last label being removed from a version,
#' then the version is considered to be \'deprecated\' and can be deleted
#' by Secrets Manager.
#' 
#' **Minimum permissions**
#' 
#' To run this command, you must have the following permissions:
#' 
#' -   secretsmanager:UpdateSecretVersionStage
#' 
#' **Related operations**
#' 
#' -   To get the list of staging labels that are currently associated with
#'     a version of a secret, use ` <a>DescribeSecret</a> ` and examine the
#'     `SecretVersionsToStages` response value.
#'
#' @usage
#' secretsmanager_update_secret_version_stage(SecretId, VersionStage,
#'   RemoveFromVersionId, MoveToVersionId)
#'
#' @param SecretId &#91;required&#93; Specifies the secret with the version whose list of staging labels you
#' want to modify. You can specify either the Amazon Resource Name (ARN) or
#' the friendly name of the secret.
#' 
#' If you specify an ARN, we generally recommend that you specify a
#' complete ARN. You can specify a partial ARN too---for example, if you
#' don't include the final hyphen and six random characters that Secrets
#' Manager adds at the end of the ARN when you created the secret. A
#' partial ARN match can work as long as it uniquely matches only one
#' secret. However, if your secret has a name that ends in a hyphen
#' followed by six characters (before Secrets Manager adds the hyphen and
#' six characters to the ARN) and you try to use that as a partial ARN,
#' then those characters cause Secrets Manager to assume that you're
#' specifying a complete ARN. This confusion can cause unexpected results.
#' To avoid this situation, we recommend that you don't create secret names
#' that end with a hyphen followed by six characters.
#' @param VersionStage &#91;required&#93; The staging label to add to this version.
#' @param RemoveFromVersionId Specifies the secret version ID of the version that the staging label is
#' to be removed from. If the staging label you are trying to attach to one
#' version is already attached to a different version, then you must
#' include this parameter and specify the version that the label is to be
#' removed from. If the label is attached and you either do not specify
#' this parameter, or the version ID does not match, then the operation
#' fails.
#' @param MoveToVersionId (Optional) The secret version ID that you want to add the staging label
#' to. If you want to remove a label from a version, then do not specify
#' this parameter.
#' 
#' If the staging label is already attached to a different version of the
#' secret, then you must also specify the `RemoveFromVersionId` parameter.
#'
#' @section Request syntax:
#' ```
#' svc$update_secret_version_stage(
#'   SecretId = "string",
#'   VersionStage = "string",
#'   RemoveFromVersionId = "string",
#'   MoveToVersionId = "string"
#' )
#' ```
#'
#' @examples
#' # The following example shows you how to add a staging label to a version
#' # of a secret. You can review the results by running the operation
#' # ListSecretVersionIds and viewing the VersionStages response field for
#' # the affected version.
#' \donttest{svc$update_secret_version_stage(
#'   MoveToVersionId = "EXAMPLE1-90ab-cdef-fedc-ba987SECRET1",
#'   SecretId = "MyTestDatabaseSecret",
#'   VersionStage = "STAGINGLABEL1"
#' )}
#' 
#' # The following example shows you how to delete a staging label that is
#' # attached to a version of a secret. You can review the results by running
#' # the operation ListSecretVersionIds and viewing the VersionStages
#' # response field for the affected version.
#' \donttest{svc$update_secret_version_stage(
#'   RemoveFromVersionId = "EXAMPLE1-90ab-cdef-fedc-ba987SECRET1",
#'   SecretId = "MyTestDatabaseSecret",
#'   VersionStage = "STAGINGLABEL1"
#' )}
#' 
#' # The following example shows you how to move a staging label that is
#' # attached to one version of a secret to a different version. You can
#' # review the results by running the operation ListSecretVersionIds and
#' # viewing the VersionStages response field for the affected version.
#' \donttest{svc$update_secret_version_stage(
#'   MoveToVersionId = "EXAMPLE2-90ab-cdef-fedc-ba987SECRET2",
#'   RemoveFromVersionId = "EXAMPLE1-90ab-cdef-fedc-ba987SECRET1",
#'   SecretId = "MyTestDatabaseSecret",
#'   VersionStage = "AWSCURRENT"
#' )}
#'
#' @keywords internal
#'
#' @rdname secretsmanager_update_secret_version_stage
secretsmanager_update_secret_version_stage <- function(SecretId, VersionStage, RemoveFromVersionId = NULL, MoveToVersionId = NULL) {
  op <- new_operation(
    name = "UpdateSecretVersionStage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .secretsmanager$update_secret_version_stage_input(SecretId = SecretId, VersionStage = VersionStage, RemoveFromVersionId = RemoveFromVersionId, MoveToVersionId = MoveToVersionId)
  output <- .secretsmanager$update_secret_version_stage_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$update_secret_version_stage <- secretsmanager_update_secret_version_stage
