# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include iam_service.R
NULL

#' Adds a new client ID (also known as audience) to the list of client IDs
#' already registered for the specified IAM OpenID Connect (OIDC) provider
#' resource
#'
#' Adds a new client ID (also known as audience) to the list of client IDs
#' already registered for the specified IAM OpenID Connect (OIDC) provider
#' resource.
#' 
#' This operation is idempotent; it does not fail or return an error if you
#' add an existing client ID to the provider.
#'
#' @usage
#' iam_add_client_id_to_open_id_connect_provider(OpenIDConnectProviderArn,
#'   ClientID)
#'
#' @param OpenIDConnectProviderArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM OpenID Connect (OIDC) provider
#' resource to add the client ID to. You can get a list of OIDC provider
#' ARNs by using the ListOpenIDConnectProviders operation.
#' @param ClientID &#91;required&#93; The client ID (also known as audience) to add to the IAM OpenID Connect
#' provider resource.
#'
#' @section Request syntax:
#' ```
#' svc$add_client_id_to_open_id_connect_provider(
#'   OpenIDConnectProviderArn = "string",
#'   ClientID = "string"
#' )
#' ```
#'
#' @examples
#' # The following add-client-id-to-open-id-connect-provider command adds the
#' # client ID my-application-ID to the OIDC provider named
#' # server.example.com:
#' \donttest{svc$add_client_id_to_open_id_connect_provider(
#'   ClientID = "my-application-ID",
#'   OpenIDConnectProviderArn = "arn:aws:iam::123456789012:oidc-provider/server.example.com"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_add_client_id_to_open_id_connect_provider
iam_add_client_id_to_open_id_connect_provider <- function(OpenIDConnectProviderArn, ClientID) {
  op <- new_operation(
    name = "AddClientIDToOpenIDConnectProvider",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$add_client_id_to_open_id_connect_provider_input(OpenIDConnectProviderArn = OpenIDConnectProviderArn, ClientID = ClientID)
  output <- .iam$add_client_id_to_open_id_connect_provider_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$add_client_id_to_open_id_connect_provider <- iam_add_client_id_to_open_id_connect_provider

#' Adds the specified IAM role to the specified instance profile
#'
#' Adds the specified IAM role to the specified instance profile. An
#' instance profile can contain only one role, and this limit cannot be
#' increased. You can remove the existing role and then add a different
#' role to an instance profile. You must then wait for the change to appear
#' across all of AWS because of [eventual
#' consistency](https://en.wikipedia.org/wiki/Eventual_consistency). To
#' force the change, you must [disassociate the instance
#' profile](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateIamInstanceProfile.html)
#' and then [associate the instance
#' profile](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateIamInstanceProfile.html),
#' or you can stop your instance and then restart it.
#' 
#' The caller of this API must be granted the `PassRole` permission on the
#' IAM role by a permissions policy.
#' 
#' For more information about roles, go to [Working with
#' Roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html).
#' For more information about instance profiles, go to [About Instance
#' Profiles](https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html).
#'
#' @usage
#' iam_add_role_to_instance_profile(InstanceProfileName, RoleName)
#'
#' @param InstanceProfileName &#91;required&#93; The name of the instance profile to update.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param RoleName &#91;required&#93; The name of the role to add.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#'
#' @section Request syntax:
#' ```
#' svc$add_role_to_instance_profile(
#'   InstanceProfileName = "string",
#'   RoleName = "string"
#' )
#' ```
#'
#' @examples
#' # The following command adds the role named S3Access to the instance
#' # profile named Webserver:
#' \donttest{svc$add_role_to_instance_profile(
#'   InstanceProfileName = "Webserver",
#'   RoleName = "S3Access"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_add_role_to_instance_profile
iam_add_role_to_instance_profile <- function(InstanceProfileName, RoleName) {
  op <- new_operation(
    name = "AddRoleToInstanceProfile",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$add_role_to_instance_profile_input(InstanceProfileName = InstanceProfileName, RoleName = RoleName)
  output <- .iam$add_role_to_instance_profile_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$add_role_to_instance_profile <- iam_add_role_to_instance_profile

#' Adds the specified user to the specified group
#'
#' Adds the specified user to the specified group.
#'
#' @usage
#' iam_add_user_to_group(GroupName, UserName)
#'
#' @param GroupName &#91;required&#93; The name of the group to update.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param UserName &#91;required&#93; The name of the user to add.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#'
#' @section Request syntax:
#' ```
#' svc$add_user_to_group(
#'   GroupName = "string",
#'   UserName = "string"
#' )
#' ```
#'
#' @examples
#' # The following command adds an IAM user named Bob to the IAM group named
#' # Admins:
#' \donttest{svc$add_user_to_group(
#'   GroupName = "Admins",
#'   UserName = "Bob"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_add_user_to_group
iam_add_user_to_group <- function(GroupName, UserName) {
  op <- new_operation(
    name = "AddUserToGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$add_user_to_group_input(GroupName = GroupName, UserName = UserName)
  output <- .iam$add_user_to_group_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$add_user_to_group <- iam_add_user_to_group

#' Attaches the specified managed policy to the specified IAM group
#'
#' Attaches the specified managed policy to the specified IAM group.
#' 
#' You use this API to attach a managed policy to a group. To embed an
#' inline policy in a group, use PutGroupPolicy.
#' 
#' For more information about policies, see [Managed Policies and Inline
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_attach_group_policy(GroupName, PolicyArn)
#'
#' @param GroupName &#91;required&#93; The name (friendly name, not ARN) of the group to attach the policy to.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param PolicyArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM policy you want to attach.
#' 
#' For more information about ARNs, see [Amazon Resource Names (ARNs) and
#' AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#'
#' @section Request syntax:
#' ```
#' svc$attach_group_policy(
#'   GroupName = "string",
#'   PolicyArn = "string"
#' )
#' ```
#'
#' @examples
#' # The following command attaches the AWS managed policy named
#' # ReadOnlyAccess to the IAM group named Finance.
#' \donttest{svc$attach_group_policy(
#'   GroupName = "Finance",
#'   PolicyArn = "arn:aws:iam::aws:policy/ReadOnlyAccess"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_attach_group_policy
iam_attach_group_policy <- function(GroupName, PolicyArn) {
  op <- new_operation(
    name = "AttachGroupPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$attach_group_policy_input(GroupName = GroupName, PolicyArn = PolicyArn)
  output <- .iam$attach_group_policy_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$attach_group_policy <- iam_attach_group_policy

#' Attaches the specified managed policy to the specified IAM role
#'
#' Attaches the specified managed policy to the specified IAM role. When
#' you attach a managed policy to a role, the managed policy becomes part
#' of the role\'s permission (access) policy.
#' 
#' You cannot use a managed policy as the role\'s trust policy. The role\'s
#' trust policy is created at the same time as the role, using CreateRole.
#' You can update a role\'s trust policy using UpdateAssumeRolePolicy.
#' 
#' Use this API to attach a *managed* policy to a role. To embed an inline
#' policy in a role, use PutRolePolicy. For more information about
#' policies, see [Managed Policies and Inline
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_attach_role_policy(RoleName, PolicyArn)
#'
#' @param RoleName &#91;required&#93; The name (friendly name, not ARN) of the role to attach the policy to.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param PolicyArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM policy you want to attach.
#' 
#' For more information about ARNs, see [Amazon Resource Names (ARNs) and
#' AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#'
#' @section Request syntax:
#' ```
#' svc$attach_role_policy(
#'   RoleName = "string",
#'   PolicyArn = "string"
#' )
#' ```
#'
#' @examples
#' # The following command attaches the AWS managed policy named
#' # ReadOnlyAccess to the IAM role named ReadOnlyRole.
#' \donttest{svc$attach_role_policy(
#'   PolicyArn = "arn:aws:iam::aws:policy/ReadOnlyAccess",
#'   RoleName = "ReadOnlyRole"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_attach_role_policy
iam_attach_role_policy <- function(RoleName, PolicyArn) {
  op <- new_operation(
    name = "AttachRolePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$attach_role_policy_input(RoleName = RoleName, PolicyArn = PolicyArn)
  output <- .iam$attach_role_policy_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$attach_role_policy <- iam_attach_role_policy

#' Attaches the specified managed policy to the specified user
#'
#' Attaches the specified managed policy to the specified user.
#' 
#' You use this API to attach a *managed* policy to a user. To embed an
#' inline policy in a user, use PutUserPolicy.
#' 
#' For more information about policies, see [Managed Policies and Inline
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_attach_user_policy(UserName, PolicyArn)
#'
#' @param UserName &#91;required&#93; The name (friendly name, not ARN) of the IAM user to attach the policy
#' to.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param PolicyArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM policy you want to attach.
#' 
#' For more information about ARNs, see [Amazon Resource Names (ARNs) and
#' AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#'
#' @section Request syntax:
#' ```
#' svc$attach_user_policy(
#'   UserName = "string",
#'   PolicyArn = "string"
#' )
#' ```
#'
#' @examples
#' # The following command attaches the AWS managed policy named
#' # AdministratorAccess to the IAM user named Alice.
#' \donttest{svc$attach_user_policy(
#'   PolicyArn = "arn:aws:iam::aws:policy/AdministratorAccess",
#'   UserName = "Alice"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_attach_user_policy
iam_attach_user_policy <- function(UserName, PolicyArn) {
  op <- new_operation(
    name = "AttachUserPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$attach_user_policy_input(UserName = UserName, PolicyArn = PolicyArn)
  output <- .iam$attach_user_policy_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$attach_user_policy <- iam_attach_user_policy

#' Changes the password of the IAM user who is calling this operation
#'
#' Changes the password of the IAM user who is calling this operation. The
#' AWS account root user password is not affected by this operation.
#' 
#' To change the password for a different user, see UpdateLoginProfile. For
#' more information about modifying passwords, see [Managing
#' Passwords](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_change_password(OldPassword, NewPassword)
#'
#' @param OldPassword &#91;required&#93; The IAM user\'s current password.
#' @param NewPassword &#91;required&#93; The new password. The new password must conform to the AWS account\'s
#' password policy, if one exists.
#' 
#' The [regex pattern](http://wikipedia.org/wiki/regex) that is used to
#' validate this parameter is a string of characters. That string can
#' include almost any printable ASCII character from the space (`U+0020`)
#' through the end of the ASCII character range (`U+00FF`). You can also
#' include the tab (`U+0009`), line feed (`U+000A`), and carriage return
#' (`U+000D`) characters. Any of these characters are valid in a password.
#' However, many tools, such as the AWS Management Console, might restrict
#' the ability to type certain characters because they have special meaning
#' within that tool.
#'
#' @section Request syntax:
#' ```
#' svc$change_password(
#'   OldPassword = "string",
#'   NewPassword = "string"
#' )
#' ```
#'
#' @examples
#' # The following command changes the password for the current IAM user.
#' \donttest{svc$change_password(
#'   NewPassword = "]35d/{pB9Fo9wJ",
#'   OldPassword = "3s0K_;xh4~8XXI"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_change_password
iam_change_password <- function(OldPassword, NewPassword) {
  op <- new_operation(
    name = "ChangePassword",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$change_password_input(OldPassword = OldPassword, NewPassword = NewPassword)
  output <- .iam$change_password_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$change_password <- iam_change_password

#' Creates a new AWS secret access key and corresponding AWS access key ID
#' for the specified user
#'
#' Creates a new AWS secret access key and corresponding AWS access key ID
#' for the specified user. The default status for new keys is `Active`.
#' 
#' If you do not specify a user name, IAM determines the user name
#' implicitly based on the AWS access key ID signing the request. This
#' operation works for access keys under the AWS account. Consequently, you
#' can use this operation to manage AWS account root user credentials. This
#' is true even if the AWS account has no associated users.
#' 
#' For information about limits on the number of keys you can create, see
#' [Limitations on IAM
#' Entities](https://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html)
#' in the *IAM User Guide*.
#' 
#' To ensure the security of your AWS account, the secret access key is
#' accessible only during key and user creation. You must save the key (for
#' example, in a text file) if you want to be able to access it again. If a
#' secret key is lost, you can delete the access keys for the associated
#' user and then create new keys.
#'
#' @usage
#' iam_create_access_key(UserName)
#'
#' @param UserName The name of the IAM user that the new key will belong to.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#'
#' @section Request syntax:
#' ```
#' svc$create_access_key(
#'   UserName = "string"
#' )
#' ```
#'
#' @examples
#' # The following command creates an access key (access key ID and secret
#' # access key) for the IAM user named Bob.
#' \donttest{svc$create_access_key(
#'   UserName = "Bob"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_create_access_key
iam_create_access_key <- function(UserName = NULL) {
  op <- new_operation(
    name = "CreateAccessKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$create_access_key_input(UserName = UserName)
  output <- .iam$create_access_key_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$create_access_key <- iam_create_access_key

#' Creates an alias for your AWS account
#'
#' Creates an alias for your AWS account. For information about using an
#' AWS account alias, see [Using an Alias for Your AWS Account
#' ID](https://docs.aws.amazon.com/IAM/latest/UserGuide/AccountAlias.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_create_account_alias(AccountAlias)
#'
#' @param AccountAlias &#91;required&#93; The account alias to create.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of lowercase letters, digits, and dashes. You cannot start or
#' finish with a dash, nor can you have two dashes in a row.
#'
#' @section Request syntax:
#' ```
#' svc$create_account_alias(
#'   AccountAlias = "string"
#' )
#' ```
#'
#' @examples
#' # The following command associates the alias examplecorp to your AWS
#' # account.
#' \donttest{svc$create_account_alias(
#'   AccountAlias = "examplecorp"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_create_account_alias
iam_create_account_alias <- function(AccountAlias) {
  op <- new_operation(
    name = "CreateAccountAlias",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$create_account_alias_input(AccountAlias = AccountAlias)
  output <- .iam$create_account_alias_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$create_account_alias <- iam_create_account_alias

#' Creates a new group
#'
#' Creates a new group.
#' 
#' For information about the number of groups you can create, see
#' [Limitations on IAM
#' Entities](https://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_create_group(Path, GroupName)
#'
#' @param Path The path to the group. For more information about paths, see [IAM
#' Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
#' in the *IAM User Guide*.
#' 
#' This parameter is optional. If it is not included, it defaults to a
#' slash (/).
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of either a forward slash (/) by itself or a string that must
#' begin and end with forward slashes. In addition, it can contain any
#' ASCII character from the ! (`U+0021`) through the DEL character
#' (`U+007F`), including most punctuation characters, digits, and upper and
#' lowercased letters.
#' @param GroupName &#91;required&#93; The name of the group to create. Do not include the path in this value.
#' 
#' IAM user, group, role, and policy names must be unique within the
#' account. Names are not distinguished by case. For example, you cannot
#' create resources named both \"MyResource\" and \"myresource\".
#'
#' @section Request syntax:
#' ```
#' svc$create_group(
#'   Path = "string",
#'   GroupName = "string"
#' )
#' ```
#'
#' @examples
#' # The following command creates an IAM group named Admins.
#' \donttest{svc$create_group(
#'   GroupName = "Admins"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_create_group
iam_create_group <- function(Path = NULL, GroupName) {
  op <- new_operation(
    name = "CreateGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$create_group_input(Path = Path, GroupName = GroupName)
  output <- .iam$create_group_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$create_group <- iam_create_group

#' Creates a new instance profile
#'
#' Creates a new instance profile. For information about instance profiles,
#' go to [About Instance
#' Profiles](https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html).
#' 
#' For information about the number of instance profiles you can create,
#' see [Limitations on IAM
#' Entities](https://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_create_instance_profile(InstanceProfileName, Path)
#'
#' @param InstanceProfileName &#91;required&#93; The name of the instance profile to create.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param Path The path to the instance profile. For more information about paths, see
#' [IAM
#' Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
#' in the *IAM User Guide*.
#' 
#' This parameter is optional. If it is not included, it defaults to a
#' slash (/).
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of either a forward slash (/) by itself or a string that must
#' begin and end with forward slashes. In addition, it can contain any
#' ASCII character from the ! (`U+0021`) through the DEL character
#' (`U+007F`), including most punctuation characters, digits, and upper and
#' lowercased letters.
#'
#' @section Request syntax:
#' ```
#' svc$create_instance_profile(
#'   InstanceProfileName = "string",
#'   Path = "string"
#' )
#' ```
#'
#' @examples
#' # The following command creates an instance profile named Webserver that
#' # is ready to have a role attached and then be associated with an EC2
#' # instance.
#' \donttest{svc$create_instance_profile(
#'   InstanceProfileName = "Webserver"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_create_instance_profile
iam_create_instance_profile <- function(InstanceProfileName, Path = NULL) {
  op <- new_operation(
    name = "CreateInstanceProfile",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$create_instance_profile_input(InstanceProfileName = InstanceProfileName, Path = Path)
  output <- .iam$create_instance_profile_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$create_instance_profile <- iam_create_instance_profile

#' Creates a password for the specified user, giving the user the ability
#' to access AWS services through the AWS Management Console
#'
#' Creates a password for the specified user, giving the user the ability
#' to access AWS services through the AWS Management Console. For more
#' information about managing passwords, see [Managing
#' Passwords](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_create_login_profile(UserName, Password, PasswordResetRequired)
#'
#' @param UserName &#91;required&#93; The name of the IAM user to create a password for. The user must already
#' exist.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param Password &#91;required&#93; The new password for the user.
#' 
#' The [regex pattern](http://wikipedia.org/wiki/regex) that is used to
#' validate this parameter is a string of characters. That string can
#' include almost any printable ASCII character from the space (`U+0020`)
#' through the end of the ASCII character range (`U+00FF`). You can also
#' include the tab (`U+0009`), line feed (`U+000A`), and carriage return
#' (`U+000D`) characters. Any of these characters are valid in a password.
#' However, many tools, such as the AWS Management Console, might restrict
#' the ability to type certain characters because they have special meaning
#' within that tool.
#' @param PasswordResetRequired Specifies whether the user is required to set a new password on next
#' sign-in.
#'
#' @section Request syntax:
#' ```
#' svc$create_login_profile(
#'   UserName = "string",
#'   Password = "string",
#'   PasswordResetRequired = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # The following command changes IAM user Bob's password and sets the flag
#' # that required Bob to change the password the next time he signs in.
#' \donttest{svc$create_login_profile(
#'   Password = "h]6EszR}vJ*m",
#'   PasswordResetRequired = TRUE,
#'   UserName = "Bob"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_create_login_profile
iam_create_login_profile <- function(UserName, Password, PasswordResetRequired = NULL) {
  op <- new_operation(
    name = "CreateLoginProfile",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$create_login_profile_input(UserName = UserName, Password = Password, PasswordResetRequired = PasswordResetRequired)
  output <- .iam$create_login_profile_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$create_login_profile <- iam_create_login_profile

#' Creates an IAM entity to describe an identity provider (IdP) that
#' supports OpenID Connect (OIDC)
#'
#' Creates an IAM entity to describe an identity provider (IdP) that
#' supports [OpenID Connect (OIDC)](http://openid.net/connect/).
#' 
#' The OIDC provider that you create with this operation can be used as a
#' principal in a role\'s trust policy. Such a policy establishes a trust
#' relationship between AWS and the OIDC provider.
#' 
#' When you create the IAM OIDC provider, you specify the following:
#' 
#' -   The URL of the OIDC identity provider (IdP) to trust
#' 
#' -   A list of client IDs (also known as audiences) that identify the
#'     application or applications that are allowed to authenticate using
#'     the OIDC provider
#' 
#' -   A list of thumbprints of the server certificate(s) that the IdP uses
#' 
#' You get all of this information from the OIDC IdP that you want to use
#' to access AWS.
#' 
#' The trust for the OIDC provider is derived from the IAM provider that
#' this operation creates. Therefore, it is best to limit access to the
#' CreateOpenIDConnectProvider operation to highly privileged users.
#'
#' @usage
#' iam_create_open_id_connect_provider(Url, ClientIDList, ThumbprintList)
#'
#' @param Url &#91;required&#93; The URL of the identity provider. The URL must begin with `https://` and
#' should correspond to the `iss` claim in the provider\'s OpenID Connect
#' ID tokens. Per the OIDC standard, path components are allowed but query
#' parameters are not. Typically the URL consists of only a hostname, like
#' `https://server.example.org` or `https://example.com`.
#' 
#' You cannot register the same provider multiple times in a single AWS
#' account. If you try to submit a URL that has already been used for an
#' OpenID Connect provider in the AWS account, you will get an error.
#' @param ClientIDList A list of client IDs (also known as audiences). When a mobile or web app
#' registers with an OpenID Connect provider, they establish a value that
#' identifies the application. (This is the value that\'s sent as the
#' `client_id` parameter on OAuth requests.)
#' 
#' You can register multiple client IDs with the same provider. For
#' example, you might have multiple applications that use the same OIDC
#' provider. You cannot register more than 100 client IDs with a single IAM
#' OIDC provider.
#' 
#' There is no defined format for a client ID. The
#' `CreateOpenIDConnectProviderRequest` operation accepts client IDs up to
#' 255 characters long.
#' @param ThumbprintList &#91;required&#93; A list of server certificate thumbprints for the OpenID Connect (OIDC)
#' identity provider\'s server certificates. Typically this list includes
#' only one entry. However, IAM lets you have up to five thumbprints for an
#' OIDC provider. This lets you maintain multiple thumbprints if the
#' identity provider is rotating certificates.
#' 
#' The server certificate thumbprint is the hex-encoded SHA-1 hash value of
#' the X.509 certificate used by the domain where the OpenID Connect
#' provider makes its keys available. It is always a 40-character string.
#' 
#' You must provide at least one thumbprint when creating an IAM OIDC
#' provider. For example, assume that the OIDC provider is
#' `server.example.com` and the provider stores its keys at
#' https://keys.server.example.com/openid-connect. In that case, the
#' thumbprint string would be the hex-encoded SHA-1 hash value of the
#' certificate used by https://keys.server.example.com.
#' 
#' For more information about obtaining the OIDC provider\'s thumbprint,
#' see [Obtaining the Thumbprint for an OpenID Connect
#' Provider](https://docs.aws.amazon.com/IAM/latest/UserGuide/identity-providers-oidc-obtain-thumbprint.html)
#' in the *IAM User Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$create_open_id_connect_provider(
#'   Url = "string",
#'   ClientIDList = list(
#'     "string"
#'   ),
#'   ThumbprintList = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # The following example defines a new OIDC provider in IAM with a client
#' # ID of my-application-id and pointing at the server with a URL of
#' # https://server.example.com.
#' \donttest{svc$create_open_id_connect_provider(
#'   ClientIDList = list(
#'     "my-application-id"
#'   ),
#'   ThumbprintList = list(
#'     "3768084dfb3d2b68b7897bf5f565da8efEXAMPLE"
#'   ),
#'   Url = "https://server.example.com"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_create_open_id_connect_provider
iam_create_open_id_connect_provider <- function(Url, ClientIDList = NULL, ThumbprintList) {
  op <- new_operation(
    name = "CreateOpenIDConnectProvider",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$create_open_id_connect_provider_input(Url = Url, ClientIDList = ClientIDList, ThumbprintList = ThumbprintList)
  output <- .iam$create_open_id_connect_provider_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$create_open_id_connect_provider <- iam_create_open_id_connect_provider

#' Creates a new managed policy for your AWS account
#'
#' Creates a new managed policy for your AWS account.
#' 
#' This operation creates a policy version with a version identifier of
#' `v1` and sets v1 as the policy\'s default version. For more information
#' about policy versions, see [Versioning for Managed
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html)
#' in the *IAM User Guide*.
#' 
#' For more information about managed policies in general, see [Managed
#' Policies and Inline
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_create_policy(PolicyName, Path, PolicyDocument, Description)
#'
#' @param PolicyName &#91;required&#93; The friendly name of the policy.
#' 
#' IAM user, group, role, and policy names must be unique within the
#' account. Names are not distinguished by case. For example, you cannot
#' create resources named both \"MyResource\" and \"myresource\".
#' @param Path The path for the policy.
#' 
#' For more information about paths, see [IAM
#' Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
#' in the *IAM User Guide*.
#' 
#' This parameter is optional. If it is not included, it defaults to a
#' slash (/).
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of either a forward slash (/) by itself or a string that must
#' begin and end with forward slashes. In addition, it can contain any
#' ASCII character from the ! (`U+0021`) through the DEL character
#' (`U+007F`), including most punctuation characters, digits, and upper and
#' lowercased letters.
#' @param PolicyDocument &#91;required&#93; The JSON policy document that you want to use as the content for the new
#' policy.
#' 
#' You must provide policies in JSON format in IAM. However, for AWS
#' CloudFormation templates formatted in YAML, you can provide the policy
#' in JSON or YAML format. AWS CloudFormation always converts a YAML policy
#' to JSON format before submitting it to IAM.
#' 
#' The [regex pattern](http://wikipedia.org/wiki/regex) used to validate
#' this parameter is a string of characters consisting of the following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (`U+0020`) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through `U+00FF`)
#' 
#' -   The special characters tab (`U+0009`), line feed (`U+000A`), and
#'     carriage return (`U+000D`)
#' @param Description A friendly description of the policy.
#' 
#' Typically used to store information about the permissions defined in the
#' policy. For example, \"Grants access to production DynamoDB tables.\"
#' 
#' The policy description is immutable. After a value is assigned, it
#' cannot be changed.
#'
#' @section Request syntax:
#' ```
#' svc$create_policy(
#'   PolicyName = "string",
#'   Path = "string",
#'   PolicyDocument = "string",
#'   Description = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_create_policy
iam_create_policy <- function(PolicyName, Path = NULL, PolicyDocument, Description = NULL) {
  op <- new_operation(
    name = "CreatePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$create_policy_input(PolicyName = PolicyName, Path = Path, PolicyDocument = PolicyDocument, Description = Description)
  output <- .iam$create_policy_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$create_policy <- iam_create_policy

#' Creates a new version of the specified managed policy
#'
#' Creates a new version of the specified managed policy. To update a
#' managed policy, you create a new policy version. A managed policy can
#' have up to five versions. If the policy has five versions, you must
#' delete an existing version using DeletePolicyVersion before you create a
#' new version.
#' 
#' Optionally, you can set the new version as the policy\'s default
#' version. The default version is the version that is in effect for the
#' IAM users, groups, and roles to which the policy is attached.
#' 
#' For more information about managed policy versions, see [Versioning for
#' Managed
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_create_policy_version(PolicyArn, PolicyDocument, SetAsDefault)
#'
#' @param PolicyArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM policy to which you want to
#' add a new version.
#' 
#' For more information about ARNs, see [Amazon Resource Names (ARNs) and
#' AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param PolicyDocument &#91;required&#93; The JSON policy document that you want to use as the content for this
#' new version of the policy.
#' 
#' You must provide policies in JSON format in IAM. However, for AWS
#' CloudFormation templates formatted in YAML, you can provide the policy
#' in JSON or YAML format. AWS CloudFormation always converts a YAML policy
#' to JSON format before submitting it to IAM.
#' 
#' The [regex pattern](http://wikipedia.org/wiki/regex) used to validate
#' this parameter is a string of characters consisting of the following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (`U+0020`) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through `U+00FF`)
#' 
#' -   The special characters tab (`U+0009`), line feed (`U+000A`), and
#'     carriage return (`U+000D`)
#' @param SetAsDefault Specifies whether to set this version as the policy\'s default version.
#' 
#' When this parameter is `true`, the new policy version becomes the
#' operative version. That is, it becomes the version that is in effect for
#' the IAM users, groups, and roles that the policy is attached to.
#' 
#' For more information about managed policy versions, see [Versioning for
#' Managed
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html)
#' in the *IAM User Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$create_policy_version(
#'   PolicyArn = "string",
#'   PolicyDocument = "string",
#'   SetAsDefault = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_create_policy_version
iam_create_policy_version <- function(PolicyArn, PolicyDocument, SetAsDefault = NULL) {
  op <- new_operation(
    name = "CreatePolicyVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$create_policy_version_input(PolicyArn = PolicyArn, PolicyDocument = PolicyDocument, SetAsDefault = SetAsDefault)
  output <- .iam$create_policy_version_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$create_policy_version <- iam_create_policy_version

#' Creates a new role for your AWS account
#'
#' Creates a new role for your AWS account. For more information about
#' roles, go to [IAM
#' Roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html).
#' For information about limitations on role names and the number of roles
#' you can create, go to [Limitations on IAM
#' Entities](https://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_create_role(Path, RoleName, AssumeRolePolicyDocument, Description,
#'   MaxSessionDuration, PermissionsBoundary, Tags)
#'
#' @param Path The path to the role. For more information about paths, see [IAM
#' Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
#' in the *IAM User Guide*.
#' 
#' This parameter is optional. If it is not included, it defaults to a
#' slash (/).
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of either a forward slash (/) by itself or a string that must
#' begin and end with forward slashes. In addition, it can contain any
#' ASCII character from the ! (`U+0021`) through the DEL character
#' (`U+007F`), including most punctuation characters, digits, and upper and
#' lowercased letters.
#' @param RoleName &#91;required&#93; The name of the role to create.
#' 
#' IAM user, group, role, and policy names must be unique within the
#' account. Names are not distinguished by case. For example, you cannot
#' create resources named both \"MyResource\" and \"myresource\".
#' @param AssumeRolePolicyDocument &#91;required&#93; The trust relationship policy document that grants an entity permission
#' to assume the role.
#' 
#' In IAM, you must provide a JSON policy that has been converted to a
#' string. However, for AWS CloudFormation templates formatted in YAML, you
#' can provide the policy in JSON or YAML format. AWS CloudFormation always
#' converts a YAML policy to JSON format before submitting it to IAM.
#' 
#' The [regex pattern](http://wikipedia.org/wiki/regex) used to validate
#' this parameter is a string of characters consisting of the following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (`U+0020`) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through `U+00FF`)
#' 
#' -   The special characters tab (`U+0009`), line feed (`U+000A`), and
#'     carriage return (`U+000D`)
#' 
#' Upon success, the response includes the same trust policy as a
#' URL-encoded JSON string.
#' @param Description A description of the role.
#' @param MaxSessionDuration The maximum session duration (in seconds) that you want to set for the
#' specified role. If you do not specify a value for this setting, the
#' default maximum of one hour is applied. This setting can have a value
#' from 1 hour to 12 hours.
#' 
#' Anyone who assumes the role from the AWS CLI or API can use the
#' `DurationSeconds` API parameter or the `duration-seconds` CLI parameter
#' to request a longer session. The `MaxSessionDuration` setting determines
#' the maximum duration that can be requested using the `DurationSeconds`
#' parameter. If users don\'t specify a value for the `DurationSeconds`
#' parameter, their security credentials are valid for one hour by default.
#' This applies when you use the `AssumeRole*` API operations or the
#' `assume-role*` CLI operations but does not apply when you use those
#' operations to create a console URL. For more information, see [Using IAM
#' Roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html)
#' in the *IAM User Guide*.
#' @param PermissionsBoundary The ARN of the policy that is used to set the permissions boundary for
#' the role.
#' @param Tags A list of tags that you want to attach to the newly created role. Each
#' tag consists of a key name and an associated value. For more information
#' about tagging, see [Tagging IAM
#' Identities](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html)
#' in the *IAM User Guide*.
#' 
#' If any one of the tags is invalid or if you exceed the allowed number of
#' tags per role, then the entire request fails and the role is not
#' created.
#'
#' @section Request syntax:
#' ```
#' svc$create_role(
#'   Path = "string",
#'   RoleName = "string",
#'   AssumeRolePolicyDocument = "string",
#'   Description = "string",
#'   MaxSessionDuration = 123,
#'   PermissionsBoundary = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # The following command creates a role named Test-Role and attaches a
#' # trust policy that you must convert from JSON to a string. Upon success,
#' # the response includes the same policy as a URL-encoded JSON string.
#' \donttest{svc$create_role(
#'   AssumeRolePolicyDocument = "<Stringified-JSON>",
#'   Path = "/",
#'   RoleName = "Test-Role"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_create_role
iam_create_role <- function(Path = NULL, RoleName, AssumeRolePolicyDocument, Description = NULL, MaxSessionDuration = NULL, PermissionsBoundary = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateRole",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$create_role_input(Path = Path, RoleName = RoleName, AssumeRolePolicyDocument = AssumeRolePolicyDocument, Description = Description, MaxSessionDuration = MaxSessionDuration, PermissionsBoundary = PermissionsBoundary, Tags = Tags)
  output <- .iam$create_role_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$create_role <- iam_create_role

#' Creates an IAM resource that describes an identity provider (IdP) that
#' supports SAML 2
#'
#' Creates an IAM resource that describes an identity provider (IdP) that
#' supports SAML 2.0.
#' 
#' The SAML provider resource that you create with this operation can be
#' used as a principal in an IAM role\'s trust policy. Such a policy can
#' enable federated users who sign in using the SAML IdP to assume the
#' role. You can create an IAM role that supports Web-based single sign-on
#' (SSO) to the AWS Management Console or one that supports API access to
#' AWS.
#' 
#' When you create the SAML provider resource, you upload a SAML metadata
#' document that you get from your IdP. That document includes the
#' issuer\'s name, expiration information, and keys that can be used to
#' validate the SAML authentication response (assertions) that the IdP
#' sends. You must generate the metadata document using the identity
#' management software that is used as your organization\'s IdP.
#' 
#' This operation requires [Signature Version
#' 4](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
#' 
#' For more information, see [Enabling SAML 2.0 Federated Users to Access
#' the AWS Management
#' Console](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-saml.html)
#' and [About SAML 2.0-based
#' Federation](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_create_saml_provider(SAMLMetadataDocument, Name)
#'
#' @param SAMLMetadataDocument &#91;required&#93; An XML document generated by an identity provider (IdP) that supports
#' SAML 2.0. The document includes the issuer\'s name, expiration
#' information, and keys that can be used to validate the SAML
#' authentication response (assertions) that are received from the IdP. You
#' must generate the metadata document using the identity management
#' software that is used as your organization\'s IdP.
#' 
#' For more information, see [About SAML 2.0-based
#' Federation](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html)
#' in the *IAM User Guide*
#' @param Name &#91;required&#93; The name of the provider to create.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#'
#' @section Request syntax:
#' ```
#' svc$create_saml_provider(
#'   SAMLMetadataDocument = "string",
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_create_saml_provider
iam_create_saml_provider <- function(SAMLMetadataDocument, Name) {
  op <- new_operation(
    name = "CreateSAMLProvider",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$create_saml_provider_input(SAMLMetadataDocument = SAMLMetadataDocument, Name = Name)
  output <- .iam$create_saml_provider_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$create_saml_provider <- iam_create_saml_provider

#' Creates an IAM role that is linked to a specific AWS service
#'
#' Creates an IAM role that is linked to a specific AWS service. The
#' service controls the attached policies and when the role can be deleted.
#' This helps ensure that the service is not broken by an unexpectedly
#' changed or deleted role, which could put your AWS resources into an
#' unknown state. Allowing the service to control the role helps improve
#' service stability and proper cleanup when a service and its role are no
#' longer needed. For more information, see [Using Service-Linked
#' Roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/using-service-linked-roles.html)
#' in the *IAM User Guide*.
#' 
#' To attach a policy to this service-linked role, you must make the
#' request using the AWS service that depends on this role.
#'
#' @usage
#' iam_create_service_linked_role(AWSServiceName, Description,
#'   CustomSuffix)
#'
#' @param AWSServiceName &#91;required&#93; The service principal for the AWS service to which this role is
#' attached. You use a string similar to a URL but without the http:// in
#' front. For example: `elasticbeanstalk.amazonaws.com`.
#' 
#' Service principals are unique and case-sensitive. To find the exact
#' service principal for your service-linked role, see [AWS Services That
#' Work with
#' IAM](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-services-that-work-with-iam.html)
#' in the *IAM User Guide*. Look for the services that have **Yes** in the
#' **Service-Linked Role** column. Choose the **Yes** link to view the
#' service-linked role documentation for that service.
#' @param Description The description of the role.
#' @param CustomSuffix A string that you provide, which is combined with the service-provided
#' prefix to form the complete role name. If you make multiple requests for
#' the same service, then you must supply a different `CustomSuffix` for
#' each request. Otherwise the request fails with a duplicate role name
#' error. For example, you could add `-1` or `-debug` to the suffix.
#' 
#' Some services do not support the `CustomSuffix` parameter. If you
#' provide an optional suffix and the operation fails, try the operation
#' again without the suffix.
#'
#' @section Request syntax:
#' ```
#' svc$create_service_linked_role(
#'   AWSServiceName = "string",
#'   Description = "string",
#'   CustomSuffix = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_create_service_linked_role
iam_create_service_linked_role <- function(AWSServiceName, Description = NULL, CustomSuffix = NULL) {
  op <- new_operation(
    name = "CreateServiceLinkedRole",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$create_service_linked_role_input(AWSServiceName = AWSServiceName, Description = Description, CustomSuffix = CustomSuffix)
  output <- .iam$create_service_linked_role_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$create_service_linked_role <- iam_create_service_linked_role

#' Generates a set of credentials consisting of a user name and password
#' that can be used to access the service specified in the request
#'
#' Generates a set of credentials consisting of a user name and password
#' that can be used to access the service specified in the request. These
#' credentials are generated by IAM, and can be used only for the specified
#' service.
#' 
#' You can have a maximum of two sets of service-specific credentials for
#' each supported service per user.
#' 
#' The only supported service at this time is AWS CodeCommit.
#' 
#' You can reset the password to a new service-generated value by calling
#' ResetServiceSpecificCredential.
#' 
#' For more information about service-specific credentials, see [Using IAM
#' with AWS CodeCommit: Git Credentials, SSH Keys, and AWS Access
#' Keys](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_ssh-keys.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_create_service_specific_credential(UserName, ServiceName)
#'
#' @param UserName &#91;required&#93; The name of the IAM user that is to be associated with the credentials.
#' The new service-specific credentials have the same permissions as the
#' associated user except that they can be used only to access the
#' specified service.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param ServiceName &#91;required&#93; The name of the AWS service that is to be associated with the
#' credentials. The service you specify here is the only service that can
#' be accessed using these credentials.
#'
#' @section Request syntax:
#' ```
#' svc$create_service_specific_credential(
#'   UserName = "string",
#'   ServiceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_create_service_specific_credential
iam_create_service_specific_credential <- function(UserName, ServiceName) {
  op <- new_operation(
    name = "CreateServiceSpecificCredential",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$create_service_specific_credential_input(UserName = UserName, ServiceName = ServiceName)
  output <- .iam$create_service_specific_credential_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$create_service_specific_credential <- iam_create_service_specific_credential

#' Creates a new IAM user for your AWS account
#'
#' Creates a new IAM user for your AWS account.
#' 
#' For information about limitations on the number of IAM users you can
#' create, see [Limitations on IAM
#' Entities](https://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_create_user(Path, UserName, PermissionsBoundary, Tags)
#'
#' @param Path The path for the user name. For more information about paths, see [IAM
#' Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
#' in the *IAM User Guide*.
#' 
#' This parameter is optional. If it is not included, it defaults to a
#' slash (/).
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of either a forward slash (/) by itself or a string that must
#' begin and end with forward slashes. In addition, it can contain any
#' ASCII character from the ! (`U+0021`) through the DEL character
#' (`U+007F`), including most punctuation characters, digits, and upper and
#' lowercased letters.
#' @param UserName &#91;required&#93; The name of the user to create.
#' 
#' IAM user, group, role, and policy names must be unique within the
#' account. Names are not distinguished by case. For example, you cannot
#' create resources named both \"MyResource\" and \"myresource\".
#' @param PermissionsBoundary The ARN of the policy that is used to set the permissions boundary for
#' the user.
#' @param Tags A list of tags that you want to attach to the newly created user. Each
#' tag consists of a key name and an associated value. For more information
#' about tagging, see [Tagging IAM
#' Identities](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html)
#' in the *IAM User Guide*.
#' 
#' If any one of the tags is invalid or if you exceed the allowed number of
#' tags per user, then the entire request fails and the user is not
#' created.
#'
#' @section Request syntax:
#' ```
#' svc$create_user(
#'   Path = "string",
#'   UserName = "string",
#'   PermissionsBoundary = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # The following create-user command creates an IAM user named Bob in the
#' # current account.
#' \donttest{svc$create_user(
#'   UserName = "Bob"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_create_user
iam_create_user <- function(Path = NULL, UserName, PermissionsBoundary = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$create_user_input(Path = Path, UserName = UserName, PermissionsBoundary = PermissionsBoundary, Tags = Tags)
  output <- .iam$create_user_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$create_user <- iam_create_user

#' Creates a new virtual MFA device for the AWS account
#'
#' Creates a new virtual MFA device for the AWS account. After creating the
#' virtual MFA, use EnableMFADevice to attach the MFA device to an IAM
#' user. For more information about creating and working with virtual MFA
#' devices, go to [Using a Virtual MFA
#' Device](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html)
#' in the *IAM User Guide*.
#' 
#' For information about limits on the number of MFA devices you can
#' create, see [Limitations on
#' Entities](https://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html)
#' in the *IAM User Guide*.
#' 
#' The seed information contained in the QR code and the Base32 string
#' should be treated like any other secret access information. In other
#' words, protect the seed information as you would your AWS access keys or
#' your passwords. After you provision your virtual device, you should
#' ensure that the information is destroyed following secure procedures.
#'
#' @usage
#' iam_create_virtual_mfa_device(Path, VirtualMFADeviceName)
#'
#' @param Path The path for the virtual MFA device. For more information about paths,
#' see [IAM
#' Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
#' in the *IAM User Guide*.
#' 
#' This parameter is optional. If it is not included, it defaults to a
#' slash (/).
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of either a forward slash (/) by itself or a string that must
#' begin and end with forward slashes. In addition, it can contain any
#' ASCII character from the ! (`U+0021`) through the DEL character
#' (`U+007F`), including most punctuation characters, digits, and upper and
#' lowercased letters.
#' @param VirtualMFADeviceName &#91;required&#93; The name of the virtual MFA device. Use with path to uniquely identify a
#' virtual MFA device.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#'
#' @section Request syntax:
#' ```
#' svc$create_virtual_mfa_device(
#'   Path = "string",
#'   VirtualMFADeviceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_create_virtual_mfa_device
iam_create_virtual_mfa_device <- function(Path = NULL, VirtualMFADeviceName) {
  op <- new_operation(
    name = "CreateVirtualMFADevice",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$create_virtual_mfa_device_input(Path = Path, VirtualMFADeviceName = VirtualMFADeviceName)
  output <- .iam$create_virtual_mfa_device_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$create_virtual_mfa_device <- iam_create_virtual_mfa_device

#' Deactivates the specified MFA device and removes it from association
#' with the user name for which it was originally enabled
#'
#' Deactivates the specified MFA device and removes it from association
#' with the user name for which it was originally enabled.
#' 
#' For more information about creating and working with virtual MFA
#' devices, go to [Enabling a Virtual Multi-factor Authentication (MFA)
#' Device](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_deactivate_mfa_device(UserName, SerialNumber)
#'
#' @param UserName &#91;required&#93; The name of the user whose MFA device you want to deactivate.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param SerialNumber &#91;required&#93; The serial number that uniquely identifies the MFA device. For virtual
#' MFA devices, the serial number is the device ARN.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: =,.@:/-
#'
#' @section Request syntax:
#' ```
#' svc$deactivate_mfa_device(
#'   UserName = "string",
#'   SerialNumber = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_deactivate_mfa_device
iam_deactivate_mfa_device <- function(UserName, SerialNumber) {
  op <- new_operation(
    name = "DeactivateMFADevice",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$deactivate_mfa_device_input(UserName = UserName, SerialNumber = SerialNumber)
  output <- .iam$deactivate_mfa_device_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$deactivate_mfa_device <- iam_deactivate_mfa_device

#' Deletes the access key pair associated with the specified IAM user
#'
#' Deletes the access key pair associated with the specified IAM user.
#' 
#' If you do not specify a user name, IAM determines the user name
#' implicitly based on the AWS access key ID signing the request. This
#' operation works for access keys under the AWS account. Consequently, you
#' can use this operation to manage AWS account root user credentials even
#' if the AWS account has no associated users.
#'
#' @usage
#' iam_delete_access_key(UserName, AccessKeyId)
#'
#' @param UserName The name of the user whose access key pair you want to delete.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param AccessKeyId &#91;required&#93; The access key ID for the access key ID and secret access key you want
#' to delete.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters that
#' can consist of any upper or lowercased letter or digit.
#'
#' @section Request syntax:
#' ```
#' svc$delete_access_key(
#'   UserName = "string",
#'   AccessKeyId = "string"
#' )
#' ```
#'
#' @examples
#' # The following command deletes one access key (access key ID and secret
#' # access key) assigned to the IAM user named Bob.
#' \donttest{svc$delete_access_key(
#'   AccessKeyId = "AKIDPMS9RO4H3FEXAMPLE",
#'   UserName = "Bob"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_delete_access_key
iam_delete_access_key <- function(UserName = NULL, AccessKeyId) {
  op <- new_operation(
    name = "DeleteAccessKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$delete_access_key_input(UserName = UserName, AccessKeyId = AccessKeyId)
  output <- .iam$delete_access_key_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_access_key <- iam_delete_access_key

#' Deletes the specified AWS account alias
#'
#' Deletes the specified AWS account alias. For information about using an
#' AWS account alias, see [Using an Alias for Your AWS Account
#' ID](https://docs.aws.amazon.com/IAM/latest/UserGuide/AccountAlias.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_delete_account_alias(AccountAlias)
#'
#' @param AccountAlias &#91;required&#93; The name of the account alias to delete.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of lowercase letters, digits, and dashes. You cannot start or
#' finish with a dash, nor can you have two dashes in a row.
#'
#' @section Request syntax:
#' ```
#' svc$delete_account_alias(
#'   AccountAlias = "string"
#' )
#' ```
#'
#' @examples
#' # The following command removes the alias mycompany from the current AWS
#' # account:
#' \donttest{svc$delete_account_alias(
#'   AccountAlias = "mycompany"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_delete_account_alias
iam_delete_account_alias <- function(AccountAlias) {
  op <- new_operation(
    name = "DeleteAccountAlias",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$delete_account_alias_input(AccountAlias = AccountAlias)
  output <- .iam$delete_account_alias_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_account_alias <- iam_delete_account_alias

#' Deletes the password policy for the AWS account
#'
#' Deletes the password policy for the AWS account. There are no
#' parameters.
#'
#' @usage
#' iam_delete_account_password_policy()
#'

#'

#'
#' @examples
#' # The following command removes the password policy from the current AWS
#' # account:
#' \donttest{svc$delete_account_password_policy()}
#'
#' @keywords internal
#'
#' @rdname iam_delete_account_password_policy
iam_delete_account_password_policy <- function() {
  op <- new_operation(
    name = "DeleteAccountPasswordPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$delete_account_password_policy_input()
  output <- .iam$delete_account_password_policy_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_account_password_policy <- iam_delete_account_password_policy

#' Deletes the specified IAM group
#'
#' Deletes the specified IAM group. The group must not contain any users or
#' have any attached policies.
#'
#' @usage
#' iam_delete_group(GroupName)
#'
#' @param GroupName &#91;required&#93; The name of the IAM group to delete.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#'
#' @section Request syntax:
#' ```
#' svc$delete_group(
#'   GroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_delete_group
iam_delete_group <- function(GroupName) {
  op <- new_operation(
    name = "DeleteGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$delete_group_input(GroupName = GroupName)
  output <- .iam$delete_group_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_group <- iam_delete_group

#' Deletes the specified inline policy that is embedded in the specified
#' IAM group
#'
#' Deletes the specified inline policy that is embedded in the specified
#' IAM group.
#' 
#' A group can also have managed policies attached to it. To detach a
#' managed policy from a group, use DetachGroupPolicy. For more information
#' about policies, refer to [Managed Policies and Inline
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_delete_group_policy(GroupName, PolicyName)
#'
#' @param GroupName &#91;required&#93; The name (friendly name, not ARN) identifying the group that the policy
#' is embedded in.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param PolicyName &#91;required&#93; The name identifying the policy document to delete.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#'
#' @section Request syntax:
#' ```
#' svc$delete_group_policy(
#'   GroupName = "string",
#'   PolicyName = "string"
#' )
#' ```
#'
#' @examples
#' # The following command deletes the policy named ExamplePolicy from the
#' # group named Admins:
#' \donttest{svc$delete_group_policy(
#'   GroupName = "Admins",
#'   PolicyName = "ExamplePolicy"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_delete_group_policy
iam_delete_group_policy <- function(GroupName, PolicyName) {
  op <- new_operation(
    name = "DeleteGroupPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$delete_group_policy_input(GroupName = GroupName, PolicyName = PolicyName)
  output <- .iam$delete_group_policy_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_group_policy <- iam_delete_group_policy

#' Deletes the specified instance profile
#'
#' Deletes the specified instance profile. The instance profile must not
#' have an associated role.
#' 
#' Make sure that you do not have any Amazon EC2 instances running with the
#' instance profile you are about to delete. Deleting a role or instance
#' profile that is associated with a running instance will break any
#' applications running on the instance.
#' 
#' For more information about instance profiles, go to [About Instance
#' Profiles](https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html).
#'
#' @usage
#' iam_delete_instance_profile(InstanceProfileName)
#'
#' @param InstanceProfileName &#91;required&#93; The name of the instance profile to delete.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#'
#' @section Request syntax:
#' ```
#' svc$delete_instance_profile(
#'   InstanceProfileName = "string"
#' )
#' ```
#'
#' @examples
#' # The following command deletes the instance profile named
#' # ExampleInstanceProfile
#' \donttest{svc$delete_instance_profile(
#'   InstanceProfileName = "ExampleInstanceProfile"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_delete_instance_profile
iam_delete_instance_profile <- function(InstanceProfileName) {
  op <- new_operation(
    name = "DeleteInstanceProfile",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$delete_instance_profile_input(InstanceProfileName = InstanceProfileName)
  output <- .iam$delete_instance_profile_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_instance_profile <- iam_delete_instance_profile

#' Deletes the password for the specified IAM user, which terminates the
#' user's ability to access AWS services through the AWS Management Console
#'
#' Deletes the password for the specified IAM user, which terminates the
#' user\'s ability to access AWS services through the AWS Management
#' Console.
#' 
#' Deleting a user\'s password does not prevent a user from accessing AWS
#' through the command line interface or the API. To prevent all user
#' access, you must also either make any access keys inactive or delete
#' them. For more information about making keys inactive or deleting them,
#' see UpdateAccessKey and DeleteAccessKey.
#'
#' @usage
#' iam_delete_login_profile(UserName)
#'
#' @param UserName &#91;required&#93; The name of the user whose password you want to delete.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#'
#' @section Request syntax:
#' ```
#' svc$delete_login_profile(
#'   UserName = "string"
#' )
#' ```
#'
#' @examples
#' # The following command deletes the password for the IAM user named Bob.
#' \donttest{svc$delete_login_profile(
#'   UserName = "Bob"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_delete_login_profile
iam_delete_login_profile <- function(UserName) {
  op <- new_operation(
    name = "DeleteLoginProfile",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$delete_login_profile_input(UserName = UserName)
  output <- .iam$delete_login_profile_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_login_profile <- iam_delete_login_profile

#' Deletes an OpenID Connect identity provider (IdP) resource object in IAM
#'
#' Deletes an OpenID Connect identity provider (IdP) resource object in
#' IAM.
#' 
#' Deleting an IAM OIDC provider resource does not update any roles that
#' reference the provider as a principal in their trust policies. Any
#' attempt to assume a role that references a deleted provider fails.
#' 
#' This operation is idempotent; it does not fail or return an error if you
#' call the operation for a provider that does not exist.
#'
#' @usage
#' iam_delete_open_id_connect_provider(OpenIDConnectProviderArn)
#'
#' @param OpenIDConnectProviderArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM OpenID Connect provider
#' resource object to delete. You can get a list of OpenID Connect provider
#' resource ARNs by using the ListOpenIDConnectProviders operation.
#'
#' @section Request syntax:
#' ```
#' svc$delete_open_id_connect_provider(
#'   OpenIDConnectProviderArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_delete_open_id_connect_provider
iam_delete_open_id_connect_provider <- function(OpenIDConnectProviderArn) {
  op <- new_operation(
    name = "DeleteOpenIDConnectProvider",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$delete_open_id_connect_provider_input(OpenIDConnectProviderArn = OpenIDConnectProviderArn)
  output <- .iam$delete_open_id_connect_provider_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_open_id_connect_provider <- iam_delete_open_id_connect_provider

#' Deletes the specified managed policy
#'
#' Deletes the specified managed policy.
#' 
#' Before you can delete a managed policy, you must first detach the policy
#' from all users, groups, and roles that it is attached to. In addition,
#' you must delete all the policy\'s versions. The following steps describe
#' the process for deleting a managed policy:
#' 
#' -   Detach the policy from all users, groups, and roles that the policy
#'     is attached to, using the DetachUserPolicy, DetachGroupPolicy, or
#'     DetachRolePolicy API operations. To list all the users, groups, and
#'     roles that a policy is attached to, use ListEntitiesForPolicy.
#' 
#' -   Delete all versions of the policy using DeletePolicyVersion. To list
#'     the policy\'s versions, use ListPolicyVersions. You cannot use
#'     DeletePolicyVersion to delete the version that is marked as the
#'     default version. You delete the policy\'s default version in the
#'     next step of the process.
#' 
#' -   Delete the policy (this automatically deletes the policy\'s default
#'     version) using this API.
#' 
#' For information about managed policies, see [Managed Policies and Inline
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_delete_policy(PolicyArn)
#'
#' @param PolicyArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM policy you want to delete.
#' 
#' For more information about ARNs, see [Amazon Resource Names (ARNs) and
#' AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#'
#' @section Request syntax:
#' ```
#' svc$delete_policy(
#'   PolicyArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_delete_policy
iam_delete_policy <- function(PolicyArn) {
  op <- new_operation(
    name = "DeletePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$delete_policy_input(PolicyArn = PolicyArn)
  output <- .iam$delete_policy_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_policy <- iam_delete_policy

#' Deletes the specified version from the specified managed policy
#'
#' Deletes the specified version from the specified managed policy.
#' 
#' You cannot delete the default version from a policy using this API. To
#' delete the default version from a policy, use DeletePolicy. To find out
#' which version of a policy is marked as the default version, use
#' ListPolicyVersions.
#' 
#' For information about versions for managed policies, see [Versioning for
#' Managed
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_delete_policy_version(PolicyArn, VersionId)
#'
#' @param PolicyArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM policy from which you want to
#' delete a version.
#' 
#' For more information about ARNs, see [Amazon Resource Names (ARNs) and
#' AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param VersionId &#91;required&#93; The policy version to delete.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters that
#' consists of the lowercase letter \'v\' followed by one or two digits,
#' and optionally followed by a period \'.\' and a string of letters and
#' digits.
#' 
#' For more information about managed policy versions, see [Versioning for
#' Managed
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html)
#' in the *IAM User Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$delete_policy_version(
#'   PolicyArn = "string",
#'   VersionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_delete_policy_version
iam_delete_policy_version <- function(PolicyArn, VersionId) {
  op <- new_operation(
    name = "DeletePolicyVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$delete_policy_version_input(PolicyArn = PolicyArn, VersionId = VersionId)
  output <- .iam$delete_policy_version_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_policy_version <- iam_delete_policy_version

#' Deletes the specified role
#'
#' Deletes the specified role. The role must not have any policies
#' attached. For more information about roles, go to [Working with
#' Roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html).
#' 
#' Make sure that you do not have any Amazon EC2 instances running with the
#' role you are about to delete. Deleting a role or instance profile that
#' is associated with a running instance will break any applications
#' running on the instance.
#'
#' @usage
#' iam_delete_role(RoleName)
#'
#' @param RoleName &#91;required&#93; The name of the role to delete.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#'
#' @section Request syntax:
#' ```
#' svc$delete_role(
#'   RoleName = "string"
#' )
#' ```
#'
#' @examples
#' # The following command removes the role named Test-Role.
#' \donttest{svc$delete_role(
#'   RoleName = "Test-Role"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_delete_role
iam_delete_role <- function(RoleName) {
  op <- new_operation(
    name = "DeleteRole",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$delete_role_input(RoleName = RoleName)
  output <- .iam$delete_role_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_role <- iam_delete_role

#' Deletes the permissions boundary for the specified IAM role
#'
#' Deletes the permissions boundary for the specified IAM role.
#' 
#' Deleting the permissions boundary for a role might increase its
#' permissions. For example, it might allow anyone who assumes the role to
#' perform all the actions granted in its permissions policies.
#'
#' @usage
#' iam_delete_role_permissions_boundary(RoleName)
#'
#' @param RoleName &#91;required&#93; The name (friendly name, not ARN) of the IAM role from which you want to
#' remove the permissions boundary.
#'
#' @section Request syntax:
#' ```
#' svc$delete_role_permissions_boundary(
#'   RoleName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_delete_role_permissions_boundary
iam_delete_role_permissions_boundary <- function(RoleName) {
  op <- new_operation(
    name = "DeleteRolePermissionsBoundary",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$delete_role_permissions_boundary_input(RoleName = RoleName)
  output <- .iam$delete_role_permissions_boundary_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_role_permissions_boundary <- iam_delete_role_permissions_boundary

#' Deletes the specified inline policy that is embedded in the specified
#' IAM role
#'
#' Deletes the specified inline policy that is embedded in the specified
#' IAM role.
#' 
#' A role can also have managed policies attached to it. To detach a
#' managed policy from a role, use DetachRolePolicy. For more information
#' about policies, refer to [Managed Policies and Inline
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_delete_role_policy(RoleName, PolicyName)
#'
#' @param RoleName &#91;required&#93; The name (friendly name, not ARN) identifying the role that the policy
#' is embedded in.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param PolicyName &#91;required&#93; The name of the inline policy to delete from the specified IAM role.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#'
#' @section Request syntax:
#' ```
#' svc$delete_role_policy(
#'   RoleName = "string",
#'   PolicyName = "string"
#' )
#' ```
#'
#' @examples
#' # The following command removes the policy named ExamplePolicy from the
#' # role named Test-Role.
#' \donttest{svc$delete_role_policy(
#'   PolicyName = "ExamplePolicy",
#'   RoleName = "Test-Role"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_delete_role_policy
iam_delete_role_policy <- function(RoleName, PolicyName) {
  op <- new_operation(
    name = "DeleteRolePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$delete_role_policy_input(RoleName = RoleName, PolicyName = PolicyName)
  output <- .iam$delete_role_policy_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_role_policy <- iam_delete_role_policy

#' Deletes a SAML provider resource in IAM
#'
#' Deletes a SAML provider resource in IAM.
#' 
#' Deleting the provider resource from IAM does not update any roles that
#' reference the SAML provider resource\'s ARN as a principal in their
#' trust policies. Any attempt to assume a role that references a
#' non-existent provider resource ARN fails.
#' 
#' This operation requires [Signature Version
#' 4](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
#'
#' @usage
#' iam_delete_saml_provider(SAMLProviderArn)
#'
#' @param SAMLProviderArn &#91;required&#93; The Amazon Resource Name (ARN) of the SAML provider to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_saml_provider(
#'   SAMLProviderArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_delete_saml_provider
iam_delete_saml_provider <- function(SAMLProviderArn) {
  op <- new_operation(
    name = "DeleteSAMLProvider",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$delete_saml_provider_input(SAMLProviderArn = SAMLProviderArn)
  output <- .iam$delete_saml_provider_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_saml_provider <- iam_delete_saml_provider

#' Deletes the specified SSH public key
#'
#' Deletes the specified SSH public key.
#' 
#' The SSH public key deleted by this operation is used only for
#' authenticating the associated IAM user to an AWS CodeCommit repository.
#' For more information about using SSH keys to authenticate to an AWS
#' CodeCommit repository, see [Set up AWS CodeCommit for SSH
#' Connections](https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html)
#' in the *AWS CodeCommit User Guide*.
#'
#' @usage
#' iam_delete_ssh_public_key(UserName, SSHPublicKeyId)
#'
#' @param UserName &#91;required&#93; The name of the IAM user associated with the SSH public key.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param SSHPublicKeyId &#91;required&#93; The unique identifier for the SSH public key.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters that
#' can consist of any upper or lowercased letter or digit.
#'
#' @section Request syntax:
#' ```
#' svc$delete_ssh_public_key(
#'   UserName = "string",
#'   SSHPublicKeyId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_delete_ssh_public_key
iam_delete_ssh_public_key <- function(UserName, SSHPublicKeyId) {
  op <- new_operation(
    name = "DeleteSSHPublicKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$delete_ssh_public_key_input(UserName = UserName, SSHPublicKeyId = SSHPublicKeyId)
  output <- .iam$delete_ssh_public_key_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_ssh_public_key <- iam_delete_ssh_public_key

#' Deletes the specified server certificate
#'
#' Deletes the specified server certificate.
#' 
#' For more information about working with server certificates, see
#' [Working with Server
#' Certificates](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html)
#' in the *IAM User Guide*. This topic also includes a list of AWS services
#' that can use the server certificates that you manage with IAM.
#' 
#' If you are using a server certificate with Elastic Load Balancing,
#' deleting the certificate could have implications for your application.
#' If Elastic Load Balancing doesn\'t detect the deletion of bound
#' certificates, it may continue to use the certificates. This could cause
#' Elastic Load Balancing to stop accepting traffic. We recommend that you
#' remove the reference to the certificate from Elastic Load Balancing
#' before using this command to delete the certificate. For more
#' information, go to
#' [DeleteLoadBalancerListeners](https://docs.aws.amazon.com/ElasticLoadBalancing/latest/APIReference/API_DeleteLoadBalancerListeners.html)
#' in the *Elastic Load Balancing API Reference*.
#'
#' @usage
#' iam_delete_server_certificate(ServerCertificateName)
#'
#' @param ServerCertificateName &#91;required&#93; The name of the server certificate you want to delete.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#'
#' @section Request syntax:
#' ```
#' svc$delete_server_certificate(
#'   ServerCertificateName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_delete_server_certificate
iam_delete_server_certificate <- function(ServerCertificateName) {
  op <- new_operation(
    name = "DeleteServerCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$delete_server_certificate_input(ServerCertificateName = ServerCertificateName)
  output <- .iam$delete_server_certificate_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_server_certificate <- iam_delete_server_certificate

#' Submits a service-linked role deletion request and returns a
#' DeletionTaskId, which you can use to check the status of the deletion
#'
#' Submits a service-linked role deletion request and returns a
#' `DeletionTaskId`, which you can use to check the status of the deletion.
#' Before you call this operation, confirm that the role has no active
#' sessions and that any resources used by the role in the linked service
#' are deleted. If you call this operation more than once for the same
#' service-linked role and an earlier deletion task is not complete, then
#' the `DeletionTaskId` of the earlier request is returned.
#' 
#' If you submit a deletion request for a service-linked role whose linked
#' service is still accessing a resource, then the deletion task fails. If
#' it fails, the GetServiceLinkedRoleDeletionStatus API operation returns
#' the reason for the failure, usually including the resources that must be
#' deleted. To delete the service-linked role, you must first remove those
#' resources from the linked service and then submit the deletion request
#' again. Resources are specific to the service that is linked to the role.
#' For more information about removing resources from a service, see the
#' [AWS documentation](http://docs.aws.amazon.com/) for your service.
#' 
#' For more information about service-linked roles, see [Roles Terms and
#' Concepts: AWS Service-Linked
#' Role](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-linked-role)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_delete_service_linked_role(RoleName)
#'
#' @param RoleName &#91;required&#93; The name of the service-linked role to be deleted.
#'
#' @section Request syntax:
#' ```
#' svc$delete_service_linked_role(
#'   RoleName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_delete_service_linked_role
iam_delete_service_linked_role <- function(RoleName) {
  op <- new_operation(
    name = "DeleteServiceLinkedRole",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$delete_service_linked_role_input(RoleName = RoleName)
  output <- .iam$delete_service_linked_role_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_service_linked_role <- iam_delete_service_linked_role

#' Deletes the specified service-specific credential
#'
#' Deletes the specified service-specific credential.
#'
#' @usage
#' iam_delete_service_specific_credential(UserName,
#'   ServiceSpecificCredentialId)
#'
#' @param UserName The name of the IAM user associated with the service-specific
#' credential. If this value is not specified, then the operation assumes
#' the user whose credentials are used to call the operation.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param ServiceSpecificCredentialId &#91;required&#93; The unique identifier of the service-specific credential. You can get
#' this value by calling ListServiceSpecificCredentials.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters that
#' can consist of any upper or lowercased letter or digit.
#'
#' @section Request syntax:
#' ```
#' svc$delete_service_specific_credential(
#'   UserName = "string",
#'   ServiceSpecificCredentialId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_delete_service_specific_credential
iam_delete_service_specific_credential <- function(UserName = NULL, ServiceSpecificCredentialId) {
  op <- new_operation(
    name = "DeleteServiceSpecificCredential",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$delete_service_specific_credential_input(UserName = UserName, ServiceSpecificCredentialId = ServiceSpecificCredentialId)
  output <- .iam$delete_service_specific_credential_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_service_specific_credential <- iam_delete_service_specific_credential

#' Deletes a signing certificate associated with the specified IAM user
#'
#' Deletes a signing certificate associated with the specified IAM user.
#' 
#' If you do not specify a user name, IAM determines the user name
#' implicitly based on the AWS access key ID signing the request. This
#' operation works for access keys under the AWS account. Consequently, you
#' can use this operation to manage AWS account root user credentials even
#' if the AWS account has no associated IAM users.
#'
#' @usage
#' iam_delete_signing_certificate(UserName, CertificateId)
#'
#' @param UserName The name of the user the signing certificate belongs to.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param CertificateId &#91;required&#93; The ID of the signing certificate to delete.
#' 
#' The format of this parameter, as described by its
#' [regex](http://wikipedia.org/wiki/regex) pattern, is a string of
#' characters that can be upper- or lower-cased letters or digits.
#'
#' @section Request syntax:
#' ```
#' svc$delete_signing_certificate(
#'   UserName = "string",
#'   CertificateId = "string"
#' )
#' ```
#'
#' @examples
#' # The following command deletes the specified signing certificate for the
#' # IAM user named Anika.
#' \donttest{svc$delete_signing_certificate(
#'   CertificateId = "TA7SMP42TDN5Z26OBPJE7EXAMPLE",
#'   UserName = "Anika"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_delete_signing_certificate
iam_delete_signing_certificate <- function(UserName = NULL, CertificateId) {
  op <- new_operation(
    name = "DeleteSigningCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$delete_signing_certificate_input(UserName = UserName, CertificateId = CertificateId)
  output <- .iam$delete_signing_certificate_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_signing_certificate <- iam_delete_signing_certificate

#' Deletes the specified IAM user
#'
#' Deletes the specified IAM user. Unlike the AWS Management Console, when
#' you delete a user programmatically, you must delete the items attached
#' to the user manually, or the deletion fails. For more information, see
#' [Deleting an IAM
#' User](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users_manage.html#id_users_deleting_cli).
#' Before attempting to delete a user, remove the following items:
#' 
#' -   Password (DeleteLoginProfile)
#' 
#' -   Access keys (DeleteAccessKey)
#' 
#' -   Signing certificate (DeleteSigningCertificate)
#' 
#' -   SSH public key (DeleteSSHPublicKey)
#' 
#' -   Git credentials (DeleteServiceSpecificCredential)
#' 
#' -   Multi-factor authentication (MFA) device (DeactivateMFADevice,
#'     DeleteVirtualMFADevice)
#' 
#' -   Inline policies (DeleteUserPolicy)
#' 
#' -   Attached managed policies (DetachUserPolicy)
#' 
#' -   Group memberships (RemoveUserFromGroup)
#'
#' @usage
#' iam_delete_user(UserName)
#'
#' @param UserName &#91;required&#93; The name of the user to delete.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#'
#' @section Request syntax:
#' ```
#' svc$delete_user(
#'   UserName = "string"
#' )
#' ```
#'
#' @examples
#' # The following command removes the IAM user named Bob from the current
#' # account.
#' \donttest{svc$delete_user(
#'   UserName = "Bob"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_delete_user
iam_delete_user <- function(UserName) {
  op <- new_operation(
    name = "DeleteUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$delete_user_input(UserName = UserName)
  output <- .iam$delete_user_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_user <- iam_delete_user

#' Deletes the permissions boundary for the specified IAM user
#'
#' Deletes the permissions boundary for the specified IAM user.
#' 
#' Deleting the permissions boundary for a user might increase its
#' permissions by allowing the user to perform all the actions granted in
#' its permissions policies.
#'
#' @usage
#' iam_delete_user_permissions_boundary(UserName)
#'
#' @param UserName &#91;required&#93; The name (friendly name, not ARN) of the IAM user from which you want to
#' remove the permissions boundary.
#'
#' @section Request syntax:
#' ```
#' svc$delete_user_permissions_boundary(
#'   UserName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_delete_user_permissions_boundary
iam_delete_user_permissions_boundary <- function(UserName) {
  op <- new_operation(
    name = "DeleteUserPermissionsBoundary",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$delete_user_permissions_boundary_input(UserName = UserName)
  output <- .iam$delete_user_permissions_boundary_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_user_permissions_boundary <- iam_delete_user_permissions_boundary

#' Deletes the specified inline policy that is embedded in the specified
#' IAM user
#'
#' Deletes the specified inline policy that is embedded in the specified
#' IAM user.
#' 
#' A user can also have managed policies attached to it. To detach a
#' managed policy from a user, use DetachUserPolicy. For more information
#' about policies, refer to [Managed Policies and Inline
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_delete_user_policy(UserName, PolicyName)
#'
#' @param UserName &#91;required&#93; The name (friendly name, not ARN) identifying the user that the policy
#' is embedded in.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param PolicyName &#91;required&#93; The name identifying the policy document to delete.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#'
#' @section Request syntax:
#' ```
#' svc$delete_user_policy(
#'   UserName = "string",
#'   PolicyName = "string"
#' )
#' ```
#'
#' @examples
#' # The following delete-user-policy command removes the specified policy
#' # from the IAM user named Juan:
#' \donttest{svc$delete_user_policy(
#'   PolicyName = "ExamplePolicy",
#'   UserName = "Juan"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_delete_user_policy
iam_delete_user_policy <- function(UserName, PolicyName) {
  op <- new_operation(
    name = "DeleteUserPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$delete_user_policy_input(UserName = UserName, PolicyName = PolicyName)
  output <- .iam$delete_user_policy_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_user_policy <- iam_delete_user_policy

#' Deletes a virtual MFA device
#'
#' Deletes a virtual MFA device.
#' 
#' You must deactivate a user\'s virtual MFA device before you can delete
#' it. For information about deactivating MFA devices, see
#' DeactivateMFADevice.
#'
#' @usage
#' iam_delete_virtual_mfa_device(SerialNumber)
#'
#' @param SerialNumber &#91;required&#93; The serial number that uniquely identifies the MFA device. For virtual
#' MFA devices, the serial number is the same as the ARN.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: =,.@:/-
#'
#' @section Request syntax:
#' ```
#' svc$delete_virtual_mfa_device(
#'   SerialNumber = "string"
#' )
#' ```
#'
#' @examples
#' # The following delete-virtual-mfa-device command removes the specified
#' # MFA device from the current AWS account.
#' \donttest{svc$delete_virtual_mfa_device(
#'   SerialNumber = "arn:aws:iam::123456789012:mfa/ExampleName"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_delete_virtual_mfa_device
iam_delete_virtual_mfa_device <- function(SerialNumber) {
  op <- new_operation(
    name = "DeleteVirtualMFADevice",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$delete_virtual_mfa_device_input(SerialNumber = SerialNumber)
  output <- .iam$delete_virtual_mfa_device_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_virtual_mfa_device <- iam_delete_virtual_mfa_device

#' Removes the specified managed policy from the specified IAM group
#'
#' Removes the specified managed policy from the specified IAM group.
#' 
#' A group can also have inline policies embedded with it. To delete an
#' inline policy, use the DeleteGroupPolicy API. For information about
#' policies, see [Managed Policies and Inline
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_detach_group_policy(GroupName, PolicyArn)
#'
#' @param GroupName &#91;required&#93; The name (friendly name, not ARN) of the IAM group to detach the policy
#' from.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param PolicyArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM policy you want to detach.
#' 
#' For more information about ARNs, see [Amazon Resource Names (ARNs) and
#' AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#'
#' @section Request syntax:
#' ```
#' svc$detach_group_policy(
#'   GroupName = "string",
#'   PolicyArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_detach_group_policy
iam_detach_group_policy <- function(GroupName, PolicyArn) {
  op <- new_operation(
    name = "DetachGroupPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$detach_group_policy_input(GroupName = GroupName, PolicyArn = PolicyArn)
  output <- .iam$detach_group_policy_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$detach_group_policy <- iam_detach_group_policy

#' Removes the specified managed policy from the specified role
#'
#' Removes the specified managed policy from the specified role.
#' 
#' A role can also have inline policies embedded with it. To delete an
#' inline policy, use the DeleteRolePolicy API. For information about
#' policies, see [Managed Policies and Inline
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_detach_role_policy(RoleName, PolicyArn)
#'
#' @param RoleName &#91;required&#93; The name (friendly name, not ARN) of the IAM role to detach the policy
#' from.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param PolicyArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM policy you want to detach.
#' 
#' For more information about ARNs, see [Amazon Resource Names (ARNs) and
#' AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#'
#' @section Request syntax:
#' ```
#' svc$detach_role_policy(
#'   RoleName = "string",
#'   PolicyArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_detach_role_policy
iam_detach_role_policy <- function(RoleName, PolicyArn) {
  op <- new_operation(
    name = "DetachRolePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$detach_role_policy_input(RoleName = RoleName, PolicyArn = PolicyArn)
  output <- .iam$detach_role_policy_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$detach_role_policy <- iam_detach_role_policy

#' Removes the specified managed policy from the specified user
#'
#' Removes the specified managed policy from the specified user.
#' 
#' A user can also have inline policies embedded with it. To delete an
#' inline policy, use the DeleteUserPolicy API. For information about
#' policies, see [Managed Policies and Inline
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_detach_user_policy(UserName, PolicyArn)
#'
#' @param UserName &#91;required&#93; The name (friendly name, not ARN) of the IAM user to detach the policy
#' from.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param PolicyArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM policy you want to detach.
#' 
#' For more information about ARNs, see [Amazon Resource Names (ARNs) and
#' AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#'
#' @section Request syntax:
#' ```
#' svc$detach_user_policy(
#'   UserName = "string",
#'   PolicyArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_detach_user_policy
iam_detach_user_policy <- function(UserName, PolicyArn) {
  op <- new_operation(
    name = "DetachUserPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$detach_user_policy_input(UserName = UserName, PolicyArn = PolicyArn)
  output <- .iam$detach_user_policy_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$detach_user_policy <- iam_detach_user_policy

#' Enables the specified MFA device and associates it with the specified
#' IAM user
#'
#' Enables the specified MFA device and associates it with the specified
#' IAM user. When enabled, the MFA device is required for every subsequent
#' login by the IAM user associated with the device.
#'
#' @usage
#' iam_enable_mfa_device(UserName, SerialNumber, AuthenticationCode1,
#'   AuthenticationCode2)
#'
#' @param UserName &#91;required&#93; The name of the IAM user for whom you want to enable the MFA device.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param SerialNumber &#91;required&#93; The serial number that uniquely identifies the MFA device. For virtual
#' MFA devices, the serial number is the device ARN.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: =,.@:/-
#' @param AuthenticationCode1 &#91;required&#93; An authentication code emitted by the device.
#' 
#' The format for this parameter is a string of six digits.
#' 
#' Submit your request immediately after generating the authentication
#' codes. If you generate the codes and then wait too long to submit the
#' request, the MFA device successfully associates with the user but the
#' MFA device becomes out of sync. This happens because time-based one-time
#' passwords (TOTP) expire after a short period of time. If this happens,
#' you can [resync the
#' device](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_mfa_sync.html).
#' @param AuthenticationCode2 &#91;required&#93; A subsequent authentication code emitted by the device.
#' 
#' The format for this parameter is a string of six digits.
#' 
#' Submit your request immediately after generating the authentication
#' codes. If you generate the codes and then wait too long to submit the
#' request, the MFA device successfully associates with the user but the
#' MFA device becomes out of sync. This happens because time-based one-time
#' passwords (TOTP) expire after a short period of time. If this happens,
#' you can [resync the
#' device](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_mfa_sync.html).
#'
#' @section Request syntax:
#' ```
#' svc$enable_mfa_device(
#'   UserName = "string",
#'   SerialNumber = "string",
#'   AuthenticationCode1 = "string",
#'   AuthenticationCode2 = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_enable_mfa_device
iam_enable_mfa_device <- function(UserName, SerialNumber, AuthenticationCode1, AuthenticationCode2) {
  op <- new_operation(
    name = "EnableMFADevice",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$enable_mfa_device_input(UserName = UserName, SerialNumber = SerialNumber, AuthenticationCode1 = AuthenticationCode1, AuthenticationCode2 = AuthenticationCode2)
  output <- .iam$enable_mfa_device_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$enable_mfa_device <- iam_enable_mfa_device

#' Generates a credential report for the AWS account
#'
#' Generates a credential report for the AWS account. For more information
#' about the credential report, see [Getting Credential
#' Reports](https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_generate_credential_report()
#'

#'

#'
#' @keywords internal
#'
#' @rdname iam_generate_credential_report
iam_generate_credential_report <- function() {
  op <- new_operation(
    name = "GenerateCredentialReport",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$generate_credential_report_input()
  output <- .iam$generate_credential_report_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$generate_credential_report <- iam_generate_credential_report

#' Generates a report for service last accessed data for AWS Organizations
#'
#' Generates a report for service last accessed data for AWS Organizations.
#' You can generate a report for any entities (organization root,
#' organizational unit, or account) or policies in your organization.
#' 
#' To call this operation, you must be signed in using your AWS
#' Organizations master account credentials. You can use your long-term IAM
#' user or root user credentials, or temporary credentials from assuming an
#' IAM role. SCPs must be enabled for your organization root. You must have
#' the required IAM and AWS Organizations permissions. For more
#' information, see [Refining Permissions Using Service Last Accessed
#' Data](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html)
#' in the *IAM User Guide*.
#' 
#' You can generate a service last accessed data report for entities by
#' specifying only the entity\'s path. This data includes a list of
#' services that are allowed by any service control policies (SCPs) that
#' apply to the entity.
#' 
#' You can generate a service last accessed data report for a policy by
#' specifying an entity\'s path and an optional AWS Organizations policy
#' ID. This data includes a list of services that are allowed by the
#' specified SCP.
#' 
#' For each service in both report types, the data includes the most recent
#' account activity that the policy allows to account principals in the
#' entity or the entity\'s children. For important information about the
#' data, reporting period, permissions required, troubleshooting, and
#' supported Regions see [Reducing Permissions Using Service Last Accessed
#' Data](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html)
#' in the *IAM User Guide*.
#' 
#' The data includesÂ allÂ attempts to access AWS, not just the successful
#' ones. This includes all attempts that were made using the AWS Management
#' Console, the AWS API through any of the SDKs, or any of the command line
#' tools. An unexpected entry in the service last accessed data does not
#' mean that an account has been compromised, because the request might
#' have been denied. Refer to your CloudTrail logs as the authoritative
#' source for information about all API calls and whether they were
#' successful or denied access. For more information, seeÂ [Logging IAM
#' Events with
#' CloudTrail](https://docs.aws.amazon.com/IAM/latest/UserGuide/cloudtrail-integration.html)
#' in the *IAM User Guide*.
#' 
#' This operation returns a `JobId`. Use this parameter in the
#' ` <a>GetOrganizationsAccessReport</a> ` operation to check the status of
#' the report generation. To check the status of this request, use the
#' `JobId` parameter in the ` <a>GetOrganizationsAccessReport</a> `
#' operation and test the `JobStatus` response parameter. When the job is
#' complete, you can retrieve the report.
#' 
#' To generate a service last accessed data report for entities, specify an
#' entity path without specifying the optional AWS Organizations policy ID.
#' The type of entity that you specify determines the data returned in the
#' report.
#' 
#' -   **Root** -- When you specify the organizations root as the entity,
#'     the resulting report lists all of the services allowed by SCPs that
#'     are attached to your root. For each service, the report includes
#'     data for all accounts in your organization except the master
#'     account, because the master account is not limited by SCPs.
#' 
#' -   **OU** -- When you specify an organizational unit (OU) as the
#'     entity, the resulting report lists all of the services allowed by
#'     SCPs that are attached to the OU and its parents. For each service,
#'     the report includes data for all accounts in the OU or its children.
#'     This data excludes the master account, because the master account is
#'     not limited by SCPs.
#' 
#' -   **Master account** -- When you specify the master account, the
#'     resulting report lists all AWS services, because the master account
#'     is not limited by SCPs. For each service, the report includes data
#'     for only the master account.
#' 
#' -   **Account** -- When you specify another account as the entity, the
#'     resulting report lists all of the services allowed by SCPs that are
#'     attached to the account and its parents. For each service, the
#'     report includes data for only the specified account.
#' 
#' To generate a service last accessed data report for policies, specify an
#' entity path and the optional AWS Organizations policy ID. The type of
#' entity that you specify determines the data returned for each service.
#' 
#' -   **Root** -- When you specify the root entity and a policy ID, the
#'     resulting report lists all of the services that are allowed by the
#'     specified SCP. For each service, the report includes data for all
#'     accounts in your organization to which the SCP applies. This data
#'     excludes the master account, because the master account is not
#'     limited by SCPs. If the SCP is not attached to any entities in the
#'     organization, then the report will return a list of services with no
#'     data.
#' 
#' -   **OU** -- When you specify an OU entity and a policy ID, the
#'     resulting report lists all of the services that are allowed by the
#'     specified SCP. For each service, the report includes data for all
#'     accounts in the OU or its children to which the SCP applies. This
#'     means that other accounts outside the OU that are affected by the
#'     SCP might not be included in the data. This data excludes the master
#'     account, because the master account is not limited by SCPs. If the
#'     SCP is not attached to the OU or one of its children, the report
#'     will return a list of services with no data.
#' 
#' -   **Master account** -- When you specify the master account, the
#'     resulting report lists all AWS services, because the master account
#'     is not limited by SCPs. If you specify a policy ID in the CLI or
#'     API, the policy is ignored. For each service, the report includes
#'     data for only the master account.
#' 
#' -   **Account** -- When you specify another account entity and a policy
#'     ID, the resulting report lists all of the services that are allowed
#'     by the specified SCP. For each service, the report includes data for
#'     only the specified account. This means that other accounts in the
#'     organization that are affected by the SCP might not be included in
#'     the data. If the SCP is not attached to the account, the report will
#'     return a list of services with no data.
#' 
#' Service last accessed data does not use other policy types when
#' determining whether a principal could access a service. These other
#' policy types include identity-based policies, resource-based policies,
#' access control lists, IAM permissions boundaries, and STS assume role
#' policies. It only applies SCP logic. For more about the evaluation of
#' policy types, see [Evaluating
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics)
#' in the *IAM User Guide*.
#' 
#' For more information about service last accessed data, see [Reducing
#' Policy Scope by Viewing User
#' Activity](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_generate_organizations_access_report(EntityPath,
#'   OrganizationsPolicyId)
#'
#' @param EntityPath &#91;required&#93; The path of the AWS Organizations entity (root, OU, or account). You can
#' build an entity path using the known structure of your organization. For
#' example, assume that your account ID is `123456789012` and its parent OU
#' ID is `ou-rge0-awsabcde`. The organization root ID is
#' `r-f6g7h8i9j0example` and your organization ID is `o-a1b2c3d4e5`. Your
#' entity path is
#' `o-a1b2c3d4e5/r-f6g7h8i9j0example/ou-rge0-awsabcde/123456789012`.
#' @param OrganizationsPolicyId The identifier of the AWS Organizations service control policy (SCP).
#' This parameter is optional.
#' 
#' This ID is used to generate information about when an account principal
#' that is limited by the SCP attempted to access an AWS service.
#'
#' @section Request syntax:
#' ```
#' svc$generate_organizations_access_report(
#'   EntityPath = "string",
#'   OrganizationsPolicyId = "string"
#' )
#' ```
#'
#' @examples
#' # The following operation generates a report for the organizational unit
#' # ou-rge0-awexample
#' \donttest{svc$generate_organizations_access_report(
#'   EntityPath = "o-a1b2c3d4e5/r-f6g7h8i9j0example/ou-1a2b3c-k9l8m7n6o5example"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_generate_organizations_access_report
iam_generate_organizations_access_report <- function(EntityPath, OrganizationsPolicyId = NULL) {
  op <- new_operation(
    name = "GenerateOrganizationsAccessReport",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$generate_organizations_access_report_input(EntityPath = EntityPath, OrganizationsPolicyId = OrganizationsPolicyId)
  output <- .iam$generate_organizations_access_report_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$generate_organizations_access_report <- iam_generate_organizations_access_report

#' Generates a report that includes details about when an IAM resource
#' (user, group, role, or policy) was last used in an attempt to access AWS
#' services
#'
#' Generates a report that includes details about when an IAM resource
#' (user, group, role, or policy) was last used in an attempt to access AWS
#' services. Recent activity usually appears within four hours. IAM reports
#' activity for the last 365 days, or less if your Region began supporting
#' this feature within the last year. For more information, see [Regions
#' Where Data Is
#' Tracked](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period).
#' 
#' The service last accessed data includesÂ allÂ attempts to access an AWS
#' API, not just the successful ones. This includes all attempts that were
#' made using the AWS Management Console, the AWS API through any of the
#' SDKs, or any of the command line tools. An unexpected entry in the
#' service last accessed data does not mean that your account has been
#' compromised, because the request might have been denied. Refer to your
#' CloudTrail logs as the authoritative source for information about all
#' API calls and whether they were successful or denied access. For more
#' information, seeÂ [Logging IAM Events with
#' CloudTrail](https://docs.aws.amazon.com/IAM/latest/UserGuide/cloudtrail-integration.html)
#' in the *IAM User Guide*.
#' 
#' The `GenerateServiceLastAccessedDetails` operation returns a `JobId`.
#' Use this parameter in the following operations to retrieve the following
#' details from your report:
#' 
#' -   GetServiceLastAccessedDetails -- Use this operation for users,
#'     groups, roles, or policies to list every AWS service that the
#'     resource could access using permissions policies. For each service,
#'     the response includes information about the most recent access
#'     attempt.
#' 
#' -   GetServiceLastAccessedDetailsWithEntities -- Use this operation for
#'     groups and policies to list information about the associated
#'     entities (users or roles) that attempted to access a specific AWS
#'     service.
#' 
#' To check the status of the `GenerateServiceLastAccessedDetails` request,
#' use the `JobId` parameter in the same operations and test the
#' `JobStatus` response parameter.
#' 
#' For additional information about the permissions policies that allow an
#' identity (user, group, or role) to access specific services, use the
#' ListPoliciesGrantingServiceAccess operation.
#' 
#' Service last accessed data does not use other policy types when
#' determining whether a resource could access a service. These other
#' policy types include resource-based policies, access control lists, AWS
#' Organizations policies, IAM permissions boundaries, and AWS STS assume
#' role policies. It only applies permissions policy logic. For more about
#' the evaluation of policy types, see [Evaluating
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics)
#' in the *IAM User Guide*.
#' 
#' For more information about service last accessed data, see [Reducing
#' Policy Scope by Viewing User
#' Activity](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_generate_service_last_accessed_details(Arn)
#'
#' @param Arn &#91;required&#93; The ARN of the IAM resource (user, group, role, or managed policy) used
#' to generate information about when the resource was last used in an
#' attempt to access an AWS service.
#'
#' @section Request syntax:
#' ```
#' svc$generate_service_last_accessed_details(
#'   Arn = "string"
#' )
#' ```
#'
#' @examples
#' # The following operation generates a report for the policy:
#' # ExamplePolicy1
#' \donttest{svc$generate_service_last_accessed_details(
#'   Arn = "arn:aws:iam::123456789012:policy/ExamplePolicy1"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_generate_service_last_accessed_details
iam_generate_service_last_accessed_details <- function(Arn) {
  op <- new_operation(
    name = "GenerateServiceLastAccessedDetails",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$generate_service_last_accessed_details_input(Arn = Arn)
  output <- .iam$generate_service_last_accessed_details_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$generate_service_last_accessed_details <- iam_generate_service_last_accessed_details

#' Retrieves information about when the specified access key was last used
#'
#' Retrieves information about when the specified access key was last used.
#' The information includes the date and time of last use, along with the
#' AWS service and Region that were specified in the last request made with
#' that key.
#'
#' @usage
#' iam_get_access_key_last_used(AccessKeyId)
#'
#' @param AccessKeyId &#91;required&#93; The identifier of an access key.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters that
#' can consist of any upper or lowercased letter or digit.
#'
#' @section Request syntax:
#' ```
#' svc$get_access_key_last_used(
#'   AccessKeyId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_get_access_key_last_used
iam_get_access_key_last_used <- function(AccessKeyId) {
  op <- new_operation(
    name = "GetAccessKeyLastUsed",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$get_access_key_last_used_input(AccessKeyId = AccessKeyId)
  output <- .iam$get_access_key_last_used_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_access_key_last_used <- iam_get_access_key_last_used

#' Retrieves information about all IAM users, groups, roles, and policies
#' in your AWS account, including their relationships to one another
#'
#' Retrieves information about all IAM users, groups, roles, and policies
#' in your AWS account, including their relationships to one another. Use
#' this API to obtain a snapshot of the configuration of IAM permissions
#' (users, groups, roles, and policies) in your account.
#' 
#' Policies returned by this API are URL-encoded compliant with [RFC
#' 3986](https://tools.ietf.org/html/rfc3986). You can use a URL decoding
#' method to convert the policy back to plain JSON text. For example, if
#' you use Java, you can use the `decode` method of the
#' `java.net.URLDecoder` utility class in the Java SDK. Other languages and
#' SDKs provide similar functionality.
#' 
#' You can optionally filter the results using the `Filter` parameter. You
#' can paginate the results using the `MaxItems` and `Marker` parameters.
#'
#' @usage
#' iam_get_account_authorization_details(Filter, MaxItems, Marker)
#'
#' @param Filter A list of entity types used to filter the results. Only the entities
#' that match the types you specify are included in the output. Use the
#' value `LocalManagedPolicy` to include customer managed policies.
#' 
#' The format for this parameter is a comma-separated (if more than one)
#' list of strings. Each string value in the list must be one of the valid
#' values listed below.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#'
#' @section Request syntax:
#' ```
#' svc$get_account_authorization_details(
#'   Filter = list(
#'     "User"|"Role"|"Group"|"LocalManagedPolicy"|"AWSManagedPolicy"
#'   ),
#'   MaxItems = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_get_account_authorization_details
iam_get_account_authorization_details <- function(Filter = NULL, MaxItems = NULL, Marker = NULL) {
  op <- new_operation(
    name = "GetAccountAuthorizationDetails",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$get_account_authorization_details_input(Filter = Filter, MaxItems = MaxItems, Marker = Marker)
  output <- .iam$get_account_authorization_details_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_account_authorization_details <- iam_get_account_authorization_details

#' Retrieves the password policy for the AWS account
#'
#' Retrieves the password policy for the AWS account. For more information
#' about using a password policy, go to [Managing an IAM Password
#' Policy](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingPasswordPolicies.html).
#'
#' @usage
#' iam_get_account_password_policy()
#'

#'

#'
#' @examples
#' # The following command displays details about the password policy for the
#' # current AWS account.
#' \donttest{svc$get_account_password_policy()}
#'
#' @keywords internal
#'
#' @rdname iam_get_account_password_policy
iam_get_account_password_policy <- function() {
  op <- new_operation(
    name = "GetAccountPasswordPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$get_account_password_policy_input()
  output <- .iam$get_account_password_policy_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_account_password_policy <- iam_get_account_password_policy

#' Retrieves information about IAM entity usage and IAM quotas in the AWS
#' account
#'
#' Retrieves information about IAM entity usage and IAM quotas in the AWS
#' account.
#' 
#' For information about limitations on IAM entities, see [Limitations on
#' IAM
#' Entities](https://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_get_account_summary()
#'

#'

#'
#' @examples
#' # The following command returns information about the IAM entity quotas
#' # and usage in the current AWS account.
#' \donttest{svc$get_account_summary()}
#'
#' @keywords internal
#'
#' @rdname iam_get_account_summary
iam_get_account_summary <- function() {
  op <- new_operation(
    name = "GetAccountSummary",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$get_account_summary_input()
  output <- .iam$get_account_summary_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_account_summary <- iam_get_account_summary

#' Gets a list of all of the context keys referenced in the input policies
#'
#' Gets a list of all of the context keys referenced in the input policies.
#' The policies are supplied as a list of one or more strings. To get the
#' context keys from policies associated with an IAM user, group, or role,
#' use GetContextKeysForPrincipalPolicy.
#' 
#' Context keys are variables maintained by AWS and its services that
#' provide details about the context of an API query request. Context keys
#' can be evaluated by testing against a value specified in an IAM policy.
#' Use `GetContextKeysForCustomPolicy` to understand what key names and
#' values you must supply when you call SimulateCustomPolicy. Note that all
#' parameters are shown in unencoded form here for clarity but must be URL
#' encoded to be included as a part of a real HTML request.
#'
#' @usage
#' iam_get_context_keys_for_custom_policy(PolicyInputList)
#'
#' @param PolicyInputList &#91;required&#93; A list of policies for which you want the list of context keys
#' referenced in those policies. Each document is specified as a string
#' containing the complete, valid JSON text of an IAM policy.
#' 
#' The [regex pattern](http://wikipedia.org/wiki/regex) used to validate
#' this parameter is a string of characters consisting of the following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (`U+0020`) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through `U+00FF`)
#' 
#' -   The special characters tab (`U+0009`), line feed (`U+000A`), and
#'     carriage return (`U+000D`)
#'
#' @section Request syntax:
#' ```
#' svc$get_context_keys_for_custom_policy(
#'   PolicyInputList = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_get_context_keys_for_custom_policy
iam_get_context_keys_for_custom_policy <- function(PolicyInputList) {
  op <- new_operation(
    name = "GetContextKeysForCustomPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$get_context_keys_for_custom_policy_input(PolicyInputList = PolicyInputList)
  output <- .iam$get_context_keys_for_custom_policy_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_context_keys_for_custom_policy <- iam_get_context_keys_for_custom_policy

#' Gets a list of all of the context keys referenced in all the IAM
#' policies that are attached to the specified IAM entity
#'
#' Gets a list of all of the context keys referenced in all the IAM
#' policies that are attached to the specified IAM entity. The entity can
#' be an IAM user, group, or role. If you specify a user, then the request
#' also includes all of the policies attached to groups that the user is a
#' member of.
#' 
#' You can optionally include a list of one or more additional policies,
#' specified as strings. If you want to include *only* a list of policies
#' by string, use GetContextKeysForCustomPolicy instead.
#' 
#' **Note:** This API discloses information about the permissions granted
#' to other users. If you do not want users to see other user\'s
#' permissions, then consider allowing them to use
#' GetContextKeysForCustomPolicy instead.
#' 
#' Context keys are variables maintained by AWS and its services that
#' provide details about the context of an API query request. Context keys
#' can be evaluated by testing against a value in an IAM policy. Use
#' GetContextKeysForPrincipalPolicy to understand what key names and values
#' you must supply when you call SimulatePrincipalPolicy.
#'
#' @usage
#' iam_get_context_keys_for_principal_policy(PolicySourceArn,
#'   PolicyInputList)
#'
#' @param PolicySourceArn &#91;required&#93; The ARN of a user, group, or role whose policies contain the context
#' keys that you want listed. If you specify a user, the list includes
#' context keys that are found in all policies that are attached to the
#' user. The list also includes all groups that the user is a member of. If
#' you pick a group or a role, then it includes only those context keys
#' that are found in policies attached to that entity. Note that all
#' parameters are shown in unencoded form here for clarity, but must be URL
#' encoded to be included as a part of a real HTML request.
#' 
#' For more information about ARNs, see [Amazon Resource Names (ARNs) and
#' AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param PolicyInputList An optional list of additional policies for which you want the list of
#' context keys that are referenced.
#' 
#' The [regex pattern](http://wikipedia.org/wiki/regex) used to validate
#' this parameter is a string of characters consisting of the following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (`U+0020`) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through `U+00FF`)
#' 
#' -   The special characters tab (`U+0009`), line feed (`U+000A`), and
#'     carriage return (`U+000D`)
#'
#' @section Request syntax:
#' ```
#' svc$get_context_keys_for_principal_policy(
#'   PolicySourceArn = "string",
#'   PolicyInputList = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_get_context_keys_for_principal_policy
iam_get_context_keys_for_principal_policy <- function(PolicySourceArn, PolicyInputList = NULL) {
  op <- new_operation(
    name = "GetContextKeysForPrincipalPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$get_context_keys_for_principal_policy_input(PolicySourceArn = PolicySourceArn, PolicyInputList = PolicyInputList)
  output <- .iam$get_context_keys_for_principal_policy_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_context_keys_for_principal_policy <- iam_get_context_keys_for_principal_policy

#' Retrieves a credential report for the AWS account
#'
#' Retrieves a credential report for the AWS account. For more information
#' about the credential report, see [Getting Credential
#' Reports](https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_get_credential_report()
#'

#'

#'
#' @keywords internal
#'
#' @rdname iam_get_credential_report
iam_get_credential_report <- function() {
  op <- new_operation(
    name = "GetCredentialReport",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$get_credential_report_input()
  output <- .iam$get_credential_report_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_credential_report <- iam_get_credential_report

#' Returns a list of IAM users that are in the specified IAM group
#'
#' Returns a list of IAM users that are in the specified IAM group. You can
#' paginate the results using the `MaxItems` and `Marker` parameters.
#'
#' @usage
#' iam_get_group(GroupName, Marker, MaxItems)
#'
#' @param GroupName &#91;required&#93; The name of the group.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @section Request syntax:
#' ```
#' svc$get_group(
#'   GroupName = "string",
#'   Marker = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_get_group
iam_get_group <- function(GroupName, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "GetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$get_group_input(GroupName = GroupName, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$get_group_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_group <- iam_get_group

#' Retrieves the specified inline policy document that is embedded in the
#' specified IAM group
#'
#' Retrieves the specified inline policy document that is embedded in the
#' specified IAM group.
#' 
#' Policies returned by this API are URL-encoded compliant with [RFC
#' 3986](https://tools.ietf.org/html/rfc3986). You can use a URL decoding
#' method to convert the policy back to plain JSON text. For example, if
#' you use Java, you can use the `decode` method of the
#' `java.net.URLDecoder` utility class in the Java SDK. Other languages and
#' SDKs provide similar functionality.
#' 
#' An IAM group can also have managed policies attached to it. To retrieve
#' a managed policy document that is attached to a group, use GetPolicy to
#' determine the policy\'s default version, then use GetPolicyVersion to
#' retrieve the policy document.
#' 
#' For more information about policies, see [Managed Policies and Inline
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_get_group_policy(GroupName, PolicyName)
#'
#' @param GroupName &#91;required&#93; The name of the group the policy is associated with.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param PolicyName &#91;required&#93; The name of the policy document to get.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#'
#' @section Request syntax:
#' ```
#' svc$get_group_policy(
#'   GroupName = "string",
#'   PolicyName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_get_group_policy
iam_get_group_policy <- function(GroupName, PolicyName) {
  op <- new_operation(
    name = "GetGroupPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$get_group_policy_input(GroupName = GroupName, PolicyName = PolicyName)
  output <- .iam$get_group_policy_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_group_policy <- iam_get_group_policy

#' Retrieves information about the specified instance profile, including
#' the instance profile's path, GUID, ARN, and role
#'
#' Retrieves information about the specified instance profile, including
#' the instance profile\'s path, GUID, ARN, and role. For more information
#' about instance profiles, see [About Instance
#' Profiles](https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_get_instance_profile(InstanceProfileName)
#'
#' @param InstanceProfileName &#91;required&#93; The name of the instance profile to get information about.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#'
#' @section Request syntax:
#' ```
#' svc$get_instance_profile(
#'   InstanceProfileName = "string"
#' )
#' ```
#'
#' @examples
#' # The following command gets information about the instance profile named
#' # ExampleInstanceProfile.
#' \donttest{svc$get_instance_profile(
#'   InstanceProfileName = "ExampleInstanceProfile"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_get_instance_profile
iam_get_instance_profile <- function(InstanceProfileName) {
  op <- new_operation(
    name = "GetInstanceProfile",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$get_instance_profile_input(InstanceProfileName = InstanceProfileName)
  output <- .iam$get_instance_profile_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_instance_profile <- iam_get_instance_profile

#' Retrieves the user name and password-creation date for the specified IAM
#' user
#'
#' Retrieves the user name and password-creation date for the specified IAM
#' user. If the user has not been assigned a password, the operation
#' returns a 404 (`NoSuchEntity`) error.
#'
#' @usage
#' iam_get_login_profile(UserName)
#'
#' @param UserName &#91;required&#93; The name of the user whose login profile you want to retrieve.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#'
#' @section Request syntax:
#' ```
#' svc$get_login_profile(
#'   UserName = "string"
#' )
#' ```
#'
#' @examples
#' # The following command gets information about the password for the IAM
#' # user named Anika.
#' \donttest{svc$get_login_profile(
#'   UserName = "Anika"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_get_login_profile
iam_get_login_profile <- function(UserName) {
  op <- new_operation(
    name = "GetLoginProfile",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$get_login_profile_input(UserName = UserName)
  output <- .iam$get_login_profile_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_login_profile <- iam_get_login_profile

#' Returns information about the specified OpenID Connect (OIDC) provider
#' resource object in IAM
#'
#' Returns information about the specified OpenID Connect (OIDC) provider
#' resource object in IAM.
#'
#' @usage
#' iam_get_open_id_connect_provider(OpenIDConnectProviderArn)
#'
#' @param OpenIDConnectProviderArn &#91;required&#93; The Amazon Resource Name (ARN) of the OIDC provider resource object in
#' IAM to get information for. You can get a list of OIDC provider resource
#' ARNs by using the ListOpenIDConnectProviders operation.
#' 
#' For more information about ARNs, see [Amazon Resource Names (ARNs) and
#' AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#'
#' @section Request syntax:
#' ```
#' svc$get_open_id_connect_provider(
#'   OpenIDConnectProviderArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_get_open_id_connect_provider
iam_get_open_id_connect_provider <- function(OpenIDConnectProviderArn) {
  op <- new_operation(
    name = "GetOpenIDConnectProvider",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$get_open_id_connect_provider_input(OpenIDConnectProviderArn = OpenIDConnectProviderArn)
  output <- .iam$get_open_id_connect_provider_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_open_id_connect_provider <- iam_get_open_id_connect_provider

#' Retrieves the service last accessed data report for AWS Organizations
#' that was previously generated using the
#' GenerateOrganizationsAccessReport operation
#'
#' Retrieves the service last accessed data report for AWS Organizations
#' that was previously generated using the
#' ` <a>GenerateOrganizationsAccessReport</a> ` operation. This operation
#' retrieves the status of your report job and the report contents.
#' 
#' Depending on the parameters that you passed when you generated the
#' report, the data returned could include different information. For
#' details, see GenerateOrganizationsAccessReport.
#' 
#' To call this operation, you must be signed in to the master account in
#' your organization. SCPs must be enabled for your organization root. You
#' must have permissions to perform this operation. For more information,
#' see [Refining Permissions Using Service Last Accessed
#' Data](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html)
#' in the *IAM User Guide*.
#' 
#' For each service that principals in an account (root users, IAM users,
#' or IAM roles) could access using SCPs, the operation returns details
#' about the most recent access attempt. If there was no attempt, the
#' service is listed without details about the most recent attempt to
#' access the service. If the operation fails, it returns the reason that
#' it failed.
#' 
#' By default, the list is sorted by service namespace.
#'
#' @usage
#' iam_get_organizations_access_report(JobId, MaxItems, Marker, SortKey)
#'
#' @param JobId &#91;required&#93; The identifier of the request generated by the
#' GenerateOrganizationsAccessReport operation.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param SortKey The key that is used to sort the results. If you choose the namespace
#' key, the results are returned in alphabetical order. If you choose the
#' time key, the results are sorted numerically by the date and time.
#'
#' @section Request syntax:
#' ```
#' svc$get_organizations_access_report(
#'   JobId = "string",
#'   MaxItems = 123,
#'   Marker = "string",
#'   SortKey = "SERVICE_NAMESPACE_ASCENDING"|"SERVICE_NAMESPACE_DESCENDING"|"LAST_AUTHENTICATED_TIME_ASCENDING"|"LAST_AUTHENTICATED_TIME_DESCENDING"
#' )
#' ```
#'
#' @examples
#' # The following operation gets details about the report with the job ID:
#' # examplea-1234-b567-cde8-90fg123abcd4
#' \donttest{svc$get_organizations_access_report(
#'   JobId = "examplea-1234-b567-cde8-90fg123abcd4"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_get_organizations_access_report
iam_get_organizations_access_report <- function(JobId, MaxItems = NULL, Marker = NULL, SortKey = NULL) {
  op <- new_operation(
    name = "GetOrganizationsAccessReport",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$get_organizations_access_report_input(JobId = JobId, MaxItems = MaxItems, Marker = Marker, SortKey = SortKey)
  output <- .iam$get_organizations_access_report_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_organizations_access_report <- iam_get_organizations_access_report

#' Retrieves information about the specified managed policy, including the
#' policy's default version and the total number of IAM users, groups, and
#' roles to which the policy is attached
#'
#' Retrieves information about the specified managed policy, including the
#' policy\'s default version and the total number of IAM users, groups, and
#' roles to which the policy is attached. To retrieve the list of the
#' specific users, groups, and roles that the policy is attached to, use
#' the ListEntitiesForPolicy API. This API returns metadata about the
#' policy. To retrieve the actual policy document for a specific version of
#' the policy, use GetPolicyVersion.
#' 
#' This API retrieves information about managed policies. To retrieve
#' information about an inline policy that is embedded with an IAM user,
#' group, or role, use the GetUserPolicy, GetGroupPolicy, or GetRolePolicy
#' API.
#' 
#' For more information about policies, see [Managed Policies and Inline
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_get_policy(PolicyArn)
#'
#' @param PolicyArn &#91;required&#93; The Amazon Resource Name (ARN) of the managed policy that you want
#' information about.
#' 
#' For more information about ARNs, see [Amazon Resource Names (ARNs) and
#' AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#'
#' @section Request syntax:
#' ```
#' svc$get_policy(
#'   PolicyArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_get_policy
iam_get_policy <- function(PolicyArn) {
  op <- new_operation(
    name = "GetPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$get_policy_input(PolicyArn = PolicyArn)
  output <- .iam$get_policy_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_policy <- iam_get_policy

#' Retrieves information about the specified version of the specified
#' managed policy, including the policy document
#'
#' Retrieves information about the specified version of the specified
#' managed policy, including the policy document.
#' 
#' Policies returned by this API are URL-encoded compliant with [RFC
#' 3986](https://tools.ietf.org/html/rfc3986). You can use a URL decoding
#' method to convert the policy back to plain JSON text. For example, if
#' you use Java, you can use the `decode` method of the
#' `java.net.URLDecoder` utility class in the Java SDK. Other languages and
#' SDKs provide similar functionality.
#' 
#' To list the available versions for a policy, use ListPolicyVersions.
#' 
#' This API retrieves information about managed policies. To retrieve
#' information about an inline policy that is embedded in a user, group, or
#' role, use the GetUserPolicy, GetGroupPolicy, or GetRolePolicy API.
#' 
#' For more information about the types of policies, see [Managed Policies
#' and Inline
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
#' in the *IAM User Guide*.
#' 
#' For more information about managed policy versions, see [Versioning for
#' Managed
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_get_policy_version(PolicyArn, VersionId)
#'
#' @param PolicyArn &#91;required&#93; The Amazon Resource Name (ARN) of the managed policy that you want
#' information about.
#' 
#' For more information about ARNs, see [Amazon Resource Names (ARNs) and
#' AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param VersionId &#91;required&#93; Identifies the policy version to retrieve.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters that
#' consists of the lowercase letter \'v\' followed by one or two digits,
#' and optionally followed by a period \'.\' and a string of letters and
#' digits.
#'
#' @section Request syntax:
#' ```
#' svc$get_policy_version(
#'   PolicyArn = "string",
#'   VersionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_get_policy_version
iam_get_policy_version <- function(PolicyArn, VersionId) {
  op <- new_operation(
    name = "GetPolicyVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$get_policy_version_input(PolicyArn = PolicyArn, VersionId = VersionId)
  output <- .iam$get_policy_version_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_policy_version <- iam_get_policy_version

#' Retrieves information about the specified role, including the role's
#' path, GUID, ARN, and the role's trust policy that grants permission to
#' assume the role
#'
#' Retrieves information about the specified role, including the role\'s
#' path, GUID, ARN, and the role\'s trust policy that grants permission to
#' assume the role. For more information about roles, see [Working with
#' Roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html).
#' 
#' Policies returned by this API are URL-encoded compliant with [RFC
#' 3986](https://tools.ietf.org/html/rfc3986). You can use a URL decoding
#' method to convert the policy back to plain JSON text. For example, if
#' you use Java, you can use the `decode` method of the
#' `java.net.URLDecoder` utility class in the Java SDK. Other languages and
#' SDKs provide similar functionality.
#'
#' @usage
#' iam_get_role(RoleName)
#'
#' @param RoleName &#91;required&#93; The name of the IAM role to get information about.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#'
#' @section Request syntax:
#' ```
#' svc$get_role(
#'   RoleName = "string"
#' )
#' ```
#'
#' @examples
#' # The following command gets information about the role named Test-Role.
#' \donttest{svc$get_role(
#'   RoleName = "Test-Role"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_get_role
iam_get_role <- function(RoleName) {
  op <- new_operation(
    name = "GetRole",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$get_role_input(RoleName = RoleName)
  output <- .iam$get_role_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_role <- iam_get_role

#' Retrieves the specified inline policy document that is embedded with the
#' specified IAM role
#'
#' Retrieves the specified inline policy document that is embedded with the
#' specified IAM role.
#' 
#' Policies returned by this API are URL-encoded compliant with [RFC
#' 3986](https://tools.ietf.org/html/rfc3986). You can use a URL decoding
#' method to convert the policy back to plain JSON text. For example, if
#' you use Java, you can use the `decode` method of the
#' `java.net.URLDecoder` utility class in the Java SDK. Other languages and
#' SDKs provide similar functionality.
#' 
#' An IAM role can also have managed policies attached to it. To retrieve a
#' managed policy document that is attached to a role, use GetPolicy to
#' determine the policy\'s default version, then use GetPolicyVersion to
#' retrieve the policy document.
#' 
#' For more information about policies, see [Managed Policies and Inline
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
#' in the *IAM User Guide*.
#' 
#' For more information about roles, see [Using Roles to Delegate
#' Permissions and Federate
#' Identities](https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html).
#'
#' @usage
#' iam_get_role_policy(RoleName, PolicyName)
#'
#' @param RoleName &#91;required&#93; The name of the role associated with the policy.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param PolicyName &#91;required&#93; The name of the policy document to get.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#'
#' @section Request syntax:
#' ```
#' svc$get_role_policy(
#'   RoleName = "string",
#'   PolicyName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_get_role_policy
iam_get_role_policy <- function(RoleName, PolicyName) {
  op <- new_operation(
    name = "GetRolePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$get_role_policy_input(RoleName = RoleName, PolicyName = PolicyName)
  output <- .iam$get_role_policy_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_role_policy <- iam_get_role_policy

#' Returns the SAML provider metadocument that was uploaded when the IAM
#' SAML provider resource object was created or updated
#'
#' Returns the SAML provider metadocument that was uploaded when the IAM
#' SAML provider resource object was created or updated.
#' 
#' This operation requires [Signature Version
#' 4](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
#'
#' @usage
#' iam_get_saml_provider(SAMLProviderArn)
#'
#' @param SAMLProviderArn &#91;required&#93; The Amazon Resource Name (ARN) of the SAML provider resource object in
#' IAM to get information about.
#' 
#' For more information about ARNs, see [Amazon Resource Names (ARNs) and
#' AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#'
#' @section Request syntax:
#' ```
#' svc$get_saml_provider(
#'   SAMLProviderArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_get_saml_provider
iam_get_saml_provider <- function(SAMLProviderArn) {
  op <- new_operation(
    name = "GetSAMLProvider",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$get_saml_provider_input(SAMLProviderArn = SAMLProviderArn)
  output <- .iam$get_saml_provider_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_saml_provider <- iam_get_saml_provider

#' Retrieves the specified SSH public key, including metadata about the key
#'
#' Retrieves the specified SSH public key, including metadata about the
#' key.
#' 
#' The SSH public key retrieved by this operation is used only for
#' authenticating the associated IAM user to an AWS CodeCommit repository.
#' For more information about using SSH keys to authenticate to an AWS
#' CodeCommit repository, see [Set up AWS CodeCommit for SSH
#' Connections](https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html)
#' in the *AWS CodeCommit User Guide*.
#'
#' @usage
#' iam_get_ssh_public_key(UserName, SSHPublicKeyId, Encoding)
#'
#' @param UserName &#91;required&#93; The name of the IAM user associated with the SSH public key.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param SSHPublicKeyId &#91;required&#93; The unique identifier for the SSH public key.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters that
#' can consist of any upper or lowercased letter or digit.
#' @param Encoding &#91;required&#93; Specifies the public key encoding format to use in the response. To
#' retrieve the public key in ssh-rsa format, use `SSH`. To retrieve the
#' public key in PEM format, use `PEM`.
#'
#' @section Request syntax:
#' ```
#' svc$get_ssh_public_key(
#'   UserName = "string",
#'   SSHPublicKeyId = "string",
#'   Encoding = "SSH"|"PEM"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_get_ssh_public_key
iam_get_ssh_public_key <- function(UserName, SSHPublicKeyId, Encoding) {
  op <- new_operation(
    name = "GetSSHPublicKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$get_ssh_public_key_input(UserName = UserName, SSHPublicKeyId = SSHPublicKeyId, Encoding = Encoding)
  output <- .iam$get_ssh_public_key_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_ssh_public_key <- iam_get_ssh_public_key

#' Retrieves information about the specified server certificate stored in
#' IAM
#'
#' Retrieves information about the specified server certificate stored in
#' IAM.
#' 
#' For more information about working with server certificates, see
#' [Working with Server
#' Certificates](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html)
#' in the *IAM User Guide*. This topic includes a list of AWS services that
#' can use the server certificates that you manage with IAM.
#'
#' @usage
#' iam_get_server_certificate(ServerCertificateName)
#'
#' @param ServerCertificateName &#91;required&#93; The name of the server certificate you want to retrieve information
#' about.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#'
#' @section Request syntax:
#' ```
#' svc$get_server_certificate(
#'   ServerCertificateName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_get_server_certificate
iam_get_server_certificate <- function(ServerCertificateName) {
  op <- new_operation(
    name = "GetServerCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$get_server_certificate_input(ServerCertificateName = ServerCertificateName)
  output <- .iam$get_server_certificate_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_server_certificate <- iam_get_server_certificate

#' Retrieves a service last accessed report that was created using the
#' GenerateServiceLastAccessedDetails operation
#'
#' Retrieves a service last accessed report that was created using the
#' `GenerateServiceLastAccessedDetails` operation. You can use the `JobId`
#' parameter in `GetServiceLastAccessedDetails` to retrieve the status of
#' your report job. When the report is complete, you can retrieve the
#' generated report. The report includes a list of AWS services that the
#' resource (user, group, role, or managed policy) can access.
#' 
#' Service last accessed data does not use other policy types when
#' determining whether a resource could access a service. These other
#' policy types include resource-based policies, access control lists, AWS
#' Organizations policies, IAM permissions boundaries, and AWS STS assume
#' role policies. It only applies permissions policy logic. For more about
#' the evaluation of policy types, see [Evaluating
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics)
#' in the *IAM User Guide*.
#' 
#' For each service that the resource could access using permissions
#' policies, the operation returns details about the most recent access
#' attempt. If there was no attempt, the service is listed without details
#' about the most recent attempt to access the service. If the operation
#' fails, the `GetServiceLastAccessedDetails` operation returns the reason
#' that it failed.
#' 
#' The `GetServiceLastAccessedDetails` operation returns a list of
#' services. This list includes the number of entities that have attempted
#' to access the service and the date and time of the last attempt. It also
#' returns the ARN of the following entity, depending on the resource ARN
#' that you used to generate the report:
#' 
#' -   **User** -- Returns the user ARN that you used to generate the
#'     report
#' 
#' -   **Group** -- Returns the ARN of the group member (user) that last
#'     attempted to access the service
#' 
#' -   **Role** -- Returns the role ARN that you used to generate the
#'     report
#' 
#' -   **Policy** -- Returns the ARN of the user or role that last used the
#'     policy to attempt to access the service
#' 
#' By default, the list is sorted by service namespace.
#'
#' @usage
#' iam_get_service_last_accessed_details(JobId, MaxItems, Marker)
#'
#' @param JobId &#91;required&#93; The ID of the request generated by the
#' GenerateServiceLastAccessedDetails operation.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#'
#' @section Request syntax:
#' ```
#' svc$get_service_last_accessed_details(
#'   JobId = "string",
#'   MaxItems = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @examples
#' # The following operation gets details about the report with the job ID:
#' # examplef-1305-c245-eba4-71fe298bcda7
#' \donttest{svc$get_service_last_accessed_details(
#'   JobId = "examplef-1305-c245-eba4-71fe298bcda7"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_get_service_last_accessed_details
iam_get_service_last_accessed_details <- function(JobId, MaxItems = NULL, Marker = NULL) {
  op <- new_operation(
    name = "GetServiceLastAccessedDetails",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$get_service_last_accessed_details_input(JobId = JobId, MaxItems = MaxItems, Marker = Marker)
  output <- .iam$get_service_last_accessed_details_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_service_last_accessed_details <- iam_get_service_last_accessed_details

#' After you generate a group or policy report using the
#' GenerateServiceLastAccessedDetails operation, you can use the JobId
#' parameter in GetServiceLastAccessedDetailsWithEntities
#'
#' After you generate a group or policy report using the
#' `GenerateServiceLastAccessedDetails` operation, you can use the `JobId`
#' parameter in `GetServiceLastAccessedDetailsWithEntities`. This operation
#' retrieves the status of your report job and a list of entities that
#' could have used group or policy permissions to access the specified
#' service.
#' 
#' -   **Group** -- For a group report, this operation returns a list of
#'     users in the group that could have used the group's policies in an
#'     attempt to access the service.
#' 
#' -   **Policy** -- For a policy report, this operation returns a list of
#'     entities (users or roles) that could have used the policy in an
#'     attempt to access the service.
#' 
#' You can also use this operation for user or role reports to retrieve
#' details about those entities.
#' 
#' If the operation fails, the `GetServiceLastAccessedDetailsWithEntities`
#' operation returns the reason that it failed.
#' 
#' By default, the list of associated entities is sorted by date, with the
#' most recent access listed first.
#'
#' @usage
#' iam_get_service_last_accessed_details_with_entities(JobId,
#'   ServiceNamespace, MaxItems, Marker)
#'
#' @param JobId &#91;required&#93; The ID of the request generated by the
#' `GenerateServiceLastAccessedDetails` operation.
#' @param ServiceNamespace &#91;required&#93; The service namespace for an AWS service. Provide the service namespace
#' to learn when the IAM entity last attempted to access the specified
#' service.
#' 
#' To learn the service namespace for a service, go to [Actions, Resources,
#' and Condition Keys for AWS
#' Services](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_actions-resources-contextkeys.html)
#' in the *IAM User Guide*. Choose the name of the service to view details
#' for that service. In the first paragraph, find the service prefix. For
#' example, `(service prefix: a4b)`. For more information about service
#' namespaces, see [AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
#' in theÂ *AWS General Reference*.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#'
#' @section Request syntax:
#' ```
#' svc$get_service_last_accessed_details_with_entities(
#'   JobId = "string",
#'   ServiceNamespace = "string",
#'   MaxItems = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @examples
#' # The following operation returns details about the entities that
#' # attempted to access the IAM service.
#' \donttest{svc$get_service_last_accessed_details_with_entities(
#'   JobId = "examplef-1305-c245-eba4-71fe298bcda7",
#'   ServiceNamespace = "iam"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_get_service_last_accessed_details_with_entities
iam_get_service_last_accessed_details_with_entities <- function(JobId, ServiceNamespace, MaxItems = NULL, Marker = NULL) {
  op <- new_operation(
    name = "GetServiceLastAccessedDetailsWithEntities",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$get_service_last_accessed_details_with_entities_input(JobId = JobId, ServiceNamespace = ServiceNamespace, MaxItems = MaxItems, Marker = Marker)
  output <- .iam$get_service_last_accessed_details_with_entities_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_service_last_accessed_details_with_entities <- iam_get_service_last_accessed_details_with_entities

#' Retrieves the status of your service-linked role deletion
#'
#' Retrieves the status of your service-linked role deletion. After you use
#' the DeleteServiceLinkedRole API operation to submit a service-linked
#' role for deletion, you can use the `DeletionTaskId` parameter in
#' `GetServiceLinkedRoleDeletionStatus` to check the status of the
#' deletion. If the deletion fails, this operation returns the reason that
#' it failed, if that information is returned by the service.
#'
#' @usage
#' iam_get_service_linked_role_deletion_status(DeletionTaskId)
#'
#' @param DeletionTaskId &#91;required&#93; The deletion task identifier. This identifier is returned by the
#' DeleteServiceLinkedRole operation in the format
#' `task/aws-service-role/&lt;service-principal-name&gt;/&lt;role-name&gt;/&lt;task-uuid&gt;`.
#'
#' @section Request syntax:
#' ```
#' svc$get_service_linked_role_deletion_status(
#'   DeletionTaskId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_get_service_linked_role_deletion_status
iam_get_service_linked_role_deletion_status <- function(DeletionTaskId) {
  op <- new_operation(
    name = "GetServiceLinkedRoleDeletionStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$get_service_linked_role_deletion_status_input(DeletionTaskId = DeletionTaskId)
  output <- .iam$get_service_linked_role_deletion_status_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_service_linked_role_deletion_status <- iam_get_service_linked_role_deletion_status

#' Retrieves information about the specified IAM user, including the user's
#' creation date, path, unique ID, and ARN
#'
#' Retrieves information about the specified IAM user, including the
#' user\'s creation date, path, unique ID, and ARN.
#' 
#' If you do not specify a user name, IAM determines the user name
#' implicitly based on the AWS access key ID used to sign the request to
#' this API.
#'
#' @usage
#' iam_get_user(UserName)
#'
#' @param UserName The name of the user to get information about.
#' 
#' This parameter is optional. If it is not included, it defaults to the
#' user making the request. This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#'
#' @section Request syntax:
#' ```
#' svc$get_user(
#'   UserName = "string"
#' )
#' ```
#'
#' @examples
#' # The following command gets information about the IAM user named Bob.
#' \donttest{svc$get_user(
#'   UserName = "Bob"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_get_user
iam_get_user <- function(UserName = NULL) {
  op <- new_operation(
    name = "GetUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$get_user_input(UserName = UserName)
  output <- .iam$get_user_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_user <- iam_get_user

#' Retrieves the specified inline policy document that is embedded in the
#' specified IAM user
#'
#' Retrieves the specified inline policy document that is embedded in the
#' specified IAM user.
#' 
#' Policies returned by this API are URL-encoded compliant with [RFC
#' 3986](https://tools.ietf.org/html/rfc3986). You can use a URL decoding
#' method to convert the policy back to plain JSON text. For example, if
#' you use Java, you can use the `decode` method of the
#' `java.net.URLDecoder` utility class in the Java SDK. Other languages and
#' SDKs provide similar functionality.
#' 
#' An IAM user can also have managed policies attached to it. To retrieve a
#' managed policy document that is attached to a user, use GetPolicy to
#' determine the policy\'s default version. Then use GetPolicyVersion to
#' retrieve the policy document.
#' 
#' For more information about policies, see [Managed Policies and Inline
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_get_user_policy(UserName, PolicyName)
#'
#' @param UserName &#91;required&#93; The name of the user who the policy is associated with.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param PolicyName &#91;required&#93; The name of the policy document to get.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#'
#' @section Request syntax:
#' ```
#' svc$get_user_policy(
#'   UserName = "string",
#'   PolicyName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_get_user_policy
iam_get_user_policy <- function(UserName, PolicyName) {
  op <- new_operation(
    name = "GetUserPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$get_user_policy_input(UserName = UserName, PolicyName = PolicyName)
  output <- .iam$get_user_policy_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_user_policy <- iam_get_user_policy

#' Returns information about the access key IDs associated with the
#' specified IAM user
#'
#' Returns information about the access key IDs associated with the
#' specified IAM user. If there is none, the operation returns an empty
#' list.
#' 
#' Although each user is limited to a small number of keys, you can still
#' paginate the results using the `MaxItems` and `Marker` parameters.
#' 
#' If the `UserName` field is not specified, the user name is determined
#' implicitly based on the AWS access key ID used to sign the request. This
#' operation works for access keys under the AWS account. Consequently, you
#' can use this operation to manage AWS account root user credentials even
#' if the AWS account has no associated users.
#' 
#' To ensure the security of your AWS account, the secret access key is
#' accessible only during key and user creation.
#'
#' @usage
#' iam_list_access_keys(UserName, Marker, MaxItems)
#'
#' @param UserName The name of the user.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @section Request syntax:
#' ```
#' svc$list_access_keys(
#'   UserName = "string",
#'   Marker = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @examples
#' # The following command lists the access keys IDs for the IAM user named
#' # Alice.
#' \donttest{svc$list_access_keys(
#'   UserName = "Alice"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_list_access_keys
iam_list_access_keys <- function(UserName = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListAccessKeys",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$list_access_keys_input(UserName = UserName, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_access_keys_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_access_keys <- iam_list_access_keys

#' Lists the account alias associated with the AWS account (Note: you can
#' have only one)
#'
#' Lists the account alias associated with the AWS account (Note: you can
#' have only one). For information about using an AWS account alias, see
#' [Using an Alias for Your AWS Account
#' ID](https://docs.aws.amazon.com/IAM/latest/UserGuide/AccountAlias.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_list_account_aliases(Marker, MaxItems)
#'
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @section Request syntax:
#' ```
#' svc$list_account_aliases(
#'   Marker = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @examples
#' # The following command lists the aliases for the current account.
#' \donttest{svc$list_account_aliases()}
#'
#' @keywords internal
#'
#' @rdname iam_list_account_aliases
iam_list_account_aliases <- function(Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListAccountAliases",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$list_account_aliases_input(Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_account_aliases_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_account_aliases <- iam_list_account_aliases

#' Lists all managed policies that are attached to the specified IAM group
#'
#' Lists all managed policies that are attached to the specified IAM group.
#' 
#' An IAM group can also have inline policies embedded with it. To list the
#' inline policies for a group, use the ListGroupPolicies API. For
#' information about policies, see [Managed Policies and Inline
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
#' in the *IAM User Guide*.
#' 
#' You can paginate the results using the `MaxItems` and `Marker`
#' parameters. You can use the `PathPrefix` parameter to limit the list of
#' policies to only those matching the specified path prefix. If there are
#' no policies attached to the specified group (or none that match the
#' specified path prefix), the operation returns an empty list.
#'
#' @usage
#' iam_list_attached_group_policies(GroupName, PathPrefix, Marker,
#'   MaxItems)
#'
#' @param GroupName &#91;required&#93; The name (friendly name, not ARN) of the group to list attached policies
#' for.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param PathPrefix The path prefix for filtering the results. This parameter is optional.
#' If it is not included, it defaults to a slash (/), listing all policies.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of either a forward slash (/) by itself or a string that must
#' begin and end with forward slashes. In addition, it can contain any
#' ASCII character from the ! (`U+0021`) through the DEL character
#' (`U+007F`), including most punctuation characters, digits, and upper and
#' lowercased letters.
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @section Request syntax:
#' ```
#' svc$list_attached_group_policies(
#'   GroupName = "string",
#'   PathPrefix = "string",
#'   Marker = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_list_attached_group_policies
iam_list_attached_group_policies <- function(GroupName, PathPrefix = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListAttachedGroupPolicies",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$list_attached_group_policies_input(GroupName = GroupName, PathPrefix = PathPrefix, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_attached_group_policies_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_attached_group_policies <- iam_list_attached_group_policies

#' Lists all managed policies that are attached to the specified IAM role
#'
#' Lists all managed policies that are attached to the specified IAM role.
#' 
#' An IAM role can also have inline policies embedded with it. To list the
#' inline policies for a role, use the ListRolePolicies API. For
#' information about policies, see [Managed Policies and Inline
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
#' in the *IAM User Guide*.
#' 
#' You can paginate the results using the `MaxItems` and `Marker`
#' parameters. You can use the `PathPrefix` parameter to limit the list of
#' policies to only those matching the specified path prefix. If there are
#' no policies attached to the specified role (or none that match the
#' specified path prefix), the operation returns an empty list.
#'
#' @usage
#' iam_list_attached_role_policies(RoleName, PathPrefix, Marker, MaxItems)
#'
#' @param RoleName &#91;required&#93; The name (friendly name, not ARN) of the role to list attached policies
#' for.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param PathPrefix The path prefix for filtering the results. This parameter is optional.
#' If it is not included, it defaults to a slash (/), listing all policies.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of either a forward slash (/) by itself or a string that must
#' begin and end with forward slashes. In addition, it can contain any
#' ASCII character from the ! (`U+0021`) through the DEL character
#' (`U+007F`), including most punctuation characters, digits, and upper and
#' lowercased letters.
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @section Request syntax:
#' ```
#' svc$list_attached_role_policies(
#'   RoleName = "string",
#'   PathPrefix = "string",
#'   Marker = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_list_attached_role_policies
iam_list_attached_role_policies <- function(RoleName, PathPrefix = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListAttachedRolePolicies",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$list_attached_role_policies_input(RoleName = RoleName, PathPrefix = PathPrefix, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_attached_role_policies_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_attached_role_policies <- iam_list_attached_role_policies

#' Lists all managed policies that are attached to the specified IAM user
#'
#' Lists all managed policies that are attached to the specified IAM user.
#' 
#' An IAM user can also have inline policies embedded with it. To list the
#' inline policies for a user, use the ListUserPolicies API. For
#' information about policies, see [Managed Policies and Inline
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
#' in the *IAM User Guide*.
#' 
#' You can paginate the results using the `MaxItems` and `Marker`
#' parameters. You can use the `PathPrefix` parameter to limit the list of
#' policies to only those matching the specified path prefix. If there are
#' no policies attached to the specified group (or none that match the
#' specified path prefix), the operation returns an empty list.
#'
#' @usage
#' iam_list_attached_user_policies(UserName, PathPrefix, Marker, MaxItems)
#'
#' @param UserName &#91;required&#93; The name (friendly name, not ARN) of the user to list attached policies
#' for.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param PathPrefix The path prefix for filtering the results. This parameter is optional.
#' If it is not included, it defaults to a slash (/), listing all policies.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of either a forward slash (/) by itself or a string that must
#' begin and end with forward slashes. In addition, it can contain any
#' ASCII character from the ! (`U+0021`) through the DEL character
#' (`U+007F`), including most punctuation characters, digits, and upper and
#' lowercased letters.
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @section Request syntax:
#' ```
#' svc$list_attached_user_policies(
#'   UserName = "string",
#'   PathPrefix = "string",
#'   Marker = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_list_attached_user_policies
iam_list_attached_user_policies <- function(UserName, PathPrefix = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListAttachedUserPolicies",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$list_attached_user_policies_input(UserName = UserName, PathPrefix = PathPrefix, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_attached_user_policies_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_attached_user_policies <- iam_list_attached_user_policies

#' Lists all IAM users, groups, and roles that the specified managed policy
#' is attached to
#'
#' Lists all IAM users, groups, and roles that the specified managed policy
#' is attached to.
#' 
#' You can use the optional `EntityFilter` parameter to limit the results
#' to a particular type of entity (users, groups, or roles). For example,
#' to list only the roles that are attached to the specified policy, set
#' `EntityFilter` to `Role`.
#' 
#' You can paginate the results using the `MaxItems` and `Marker`
#' parameters.
#'
#' @usage
#' iam_list_entities_for_policy(PolicyArn, EntityFilter, PathPrefix,
#'   PolicyUsageFilter, Marker, MaxItems)
#'
#' @param PolicyArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM policy for which you want the
#' versions.
#' 
#' For more information about ARNs, see [Amazon Resource Names (ARNs) and
#' AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param EntityFilter The entity type to use for filtering the results.
#' 
#' For example, when `EntityFilter` is `Role`, only the roles that are
#' attached to the specified policy are returned. This parameter is
#' optional. If it is not included, all attached entities (users, groups,
#' and roles) are returned. The argument for this parameter must be one of
#' the valid values listed below.
#' @param PathPrefix The path prefix for filtering the results. This parameter is optional.
#' If it is not included, it defaults to a slash (/), listing all entities.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of either a forward slash (/) by itself or a string that must
#' begin and end with forward slashes. In addition, it can contain any
#' ASCII character from the ! (`U+0021`) through the DEL character
#' (`U+007F`), including most punctuation characters, digits, and upper and
#' lowercased letters.
#' @param PolicyUsageFilter The policy usage method to use for filtering the results.
#' 
#' To list only permissions policies,
#' setÂ `PolicyUsageFilter`Â toÂ `PermissionsPolicy`. To list only the
#' policies used to set permissions boundaries, setÂ the value
#' toÂ `PermissionsBoundary`.
#' 
#' This parameter is optional. If it is not included, all policies are
#' returned.
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @section Request syntax:
#' ```
#' svc$list_entities_for_policy(
#'   PolicyArn = "string",
#'   EntityFilter = "User"|"Role"|"Group"|"LocalManagedPolicy"|"AWSManagedPolicy",
#'   PathPrefix = "string",
#'   PolicyUsageFilter = "PermissionsPolicy"|"PermissionsBoundary",
#'   Marker = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_list_entities_for_policy
iam_list_entities_for_policy <- function(PolicyArn, EntityFilter = NULL, PathPrefix = NULL, PolicyUsageFilter = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListEntitiesForPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$list_entities_for_policy_input(PolicyArn = PolicyArn, EntityFilter = EntityFilter, PathPrefix = PathPrefix, PolicyUsageFilter = PolicyUsageFilter, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_entities_for_policy_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_entities_for_policy <- iam_list_entities_for_policy

#' Lists the names of the inline policies that are embedded in the
#' specified IAM group
#'
#' Lists the names of the inline policies that are embedded in the
#' specified IAM group.
#' 
#' An IAM group can also have managed policies attached to it. To list the
#' managed policies that are attached to a group, use
#' ListAttachedGroupPolicies. For more information about policies, see
#' [Managed Policies and Inline
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
#' in the *IAM User Guide*.
#' 
#' You can paginate the results using the `MaxItems` and `Marker`
#' parameters. If there are no inline policies embedded with the specified
#' group, the operation returns an empty list.
#'
#' @usage
#' iam_list_group_policies(GroupName, Marker, MaxItems)
#'
#' @param GroupName &#91;required&#93; The name of the group to list policies for.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @section Request syntax:
#' ```
#' svc$list_group_policies(
#'   GroupName = "string",
#'   Marker = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @examples
#' # The following command lists the names of in-line policies that are
#' # embedded in the IAM group named Admins.
#' \donttest{svc$list_group_policies(
#'   GroupName = "Admins"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_list_group_policies
iam_list_group_policies <- function(GroupName, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListGroupPolicies",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$list_group_policies_input(GroupName = GroupName, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_group_policies_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_group_policies <- iam_list_group_policies

#' Lists the IAM groups that have the specified path prefix
#'
#' Lists the IAM groups that have the specified path prefix.
#' 
#' You can paginate the results using the `MaxItems` and `Marker`
#' parameters.
#'
#' @usage
#' iam_list_groups(PathPrefix, Marker, MaxItems)
#'
#' @param PathPrefix The path prefix for filtering the results. For example, the prefix
#' `/division_abc/subdivision_xyz/` gets all groups whose path starts with
#' `/division_abc/subdivision_xyz/`.
#' 
#' This parameter is optional. If it is not included, it defaults to a
#' slash (/), listing all groups. This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of either a forward slash (/) by itself or a string that must
#' begin and end with forward slashes. In addition, it can contain any
#' ASCII character from the ! (`U+0021`) through the DEL character
#' (`U+007F`), including most punctuation characters, digits, and upper and
#' lowercased letters.
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @section Request syntax:
#' ```
#' svc$list_groups(
#'   PathPrefix = "string",
#'   Marker = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @examples
#' # The following command lists the IAM groups in the current account:
#' \donttest{svc$list_groups()}
#'
#' @keywords internal
#'
#' @rdname iam_list_groups
iam_list_groups <- function(PathPrefix = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$list_groups_input(PathPrefix = PathPrefix, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_groups_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_groups <- iam_list_groups

#' Lists the IAM groups that the specified IAM user belongs to
#'
#' Lists the IAM groups that the specified IAM user belongs to.
#' 
#' You can paginate the results using the `MaxItems` and `Marker`
#' parameters.
#'
#' @usage
#' iam_list_groups_for_user(UserName, Marker, MaxItems)
#'
#' @param UserName &#91;required&#93; The name of the user to list groups for.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @section Request syntax:
#' ```
#' svc$list_groups_for_user(
#'   UserName = "string",
#'   Marker = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @examples
#' # The following command displays the groups that the IAM user named Bob
#' # belongs to.
#' \donttest{svc$list_groups_for_user(
#'   UserName = "Bob"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_list_groups_for_user
iam_list_groups_for_user <- function(UserName, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListGroupsForUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$list_groups_for_user_input(UserName = UserName, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_groups_for_user_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_groups_for_user <- iam_list_groups_for_user

#' Lists the instance profiles that have the specified path prefix
#'
#' Lists the instance profiles that have the specified path prefix. If
#' there are none, the operation returns an empty list. For more
#' information about instance profiles, go to [About Instance
#' Profiles](https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html).
#' 
#' You can paginate the results using the `MaxItems` and `Marker`
#' parameters.
#'
#' @usage
#' iam_list_instance_profiles(PathPrefix, Marker, MaxItems)
#'
#' @param PathPrefix The path prefix for filtering the results. For example, the prefix
#' `/application_abc/component_xyz/` gets all instance profiles whose path
#' starts with `/application_abc/component_xyz/`.
#' 
#' This parameter is optional. If it is not included, it defaults to a
#' slash (/), listing all instance profiles. This parameter allows (through
#' its [regex pattern](http://wikipedia.org/wiki/regex)) a string of
#' characters consisting of either a forward slash (/) by itself or a
#' string that must begin and end with forward slashes. In addition, it can
#' contain any ASCII character from the ! (`U+0021`) through the DEL
#' character (`U+007F`), including most punctuation characters, digits, and
#' upper and lowercased letters.
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @section Request syntax:
#' ```
#' svc$list_instance_profiles(
#'   PathPrefix = "string",
#'   Marker = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_list_instance_profiles
iam_list_instance_profiles <- function(PathPrefix = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListInstanceProfiles",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$list_instance_profiles_input(PathPrefix = PathPrefix, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_instance_profiles_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_instance_profiles <- iam_list_instance_profiles

#' Lists the instance profiles that have the specified associated IAM role
#'
#' Lists the instance profiles that have the specified associated IAM role.
#' If there are none, the operation returns an empty list. For more
#' information about instance profiles, go to [About Instance
#' Profiles](https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html).
#' 
#' You can paginate the results using the `MaxItems` and `Marker`
#' parameters.
#'
#' @usage
#' iam_list_instance_profiles_for_role(RoleName, Marker, MaxItems)
#'
#' @param RoleName &#91;required&#93; The name of the role to list instance profiles for.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @section Request syntax:
#' ```
#' svc$list_instance_profiles_for_role(
#'   RoleName = "string",
#'   Marker = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_list_instance_profiles_for_role
iam_list_instance_profiles_for_role <- function(RoleName, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListInstanceProfilesForRole",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$list_instance_profiles_for_role_input(RoleName = RoleName, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_instance_profiles_for_role_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_instance_profiles_for_role <- iam_list_instance_profiles_for_role

#' Lists the MFA devices for an IAM user
#'
#' Lists the MFA devices for an IAM user. If the request includes a IAM
#' user name, then this operation lists all the MFA devices associated with
#' the specified user. If you do not specify a user name, IAM determines
#' the user name implicitly based on the AWS access key ID signing the
#' request for this API.
#' 
#' You can paginate the results using the `MaxItems` and `Marker`
#' parameters.
#'
#' @usage
#' iam_list_mfa_devices(UserName, Marker, MaxItems)
#'
#' @param UserName The name of the user whose MFA devices you want to list.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @section Request syntax:
#' ```
#' svc$list_mfa_devices(
#'   UserName = "string",
#'   Marker = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_list_mfa_devices
iam_list_mfa_devices <- function(UserName = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListMFADevices",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$list_mfa_devices_input(UserName = UserName, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_mfa_devices_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_mfa_devices <- iam_list_mfa_devices

#' Lists information about the IAM OpenID Connect (OIDC) provider resource
#' objects defined in the AWS account
#'
#' Lists information about the IAM OpenID Connect (OIDC) provider resource
#' objects defined in the AWS account.
#'
#' @usage
#' iam_list_open_id_connect_providers()
#'
#' @section Request syntax:
#' ```
#' svc$list_open_id_connect_providers()
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_list_open_id_connect_providers
iam_list_open_id_connect_providers <- function() {
  op <- new_operation(
    name = "ListOpenIDConnectProviders",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$list_open_id_connect_providers_input()
  output <- .iam$list_open_id_connect_providers_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_open_id_connect_providers <- iam_list_open_id_connect_providers

#' Lists all the managed policies that are available in your AWS account,
#' including your own customer-defined managed policies and all AWS managed
#' policies
#'
#' Lists all the managed policies that are available in your AWS account,
#' including your own customer-defined managed policies and all AWS managed
#' policies.
#' 
#' You can filter the list of policies that is returned using the optional
#' `OnlyAttached`, `Scope`, and `PathPrefix` parameters. For example, to
#' list only the customer managed policies in your AWS account, set `Scope`
#' to `Local`. To list only AWS managed policies, set `Scope` to `AWS`.
#' 
#' You can paginate the results using the `MaxItems` and `Marker`
#' parameters.
#' 
#' For more information about managed policies, see [Managed Policies and
#' Inline
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_list_policies(Scope, OnlyAttached, PathPrefix, PolicyUsageFilter,
#'   Marker, MaxItems)
#'
#' @param Scope The scope to use for filtering the results.
#' 
#' To list only AWS managed policies, set `Scope` to `AWS`. To list only
#' the customer managed policies in your AWS account, set `Scope` to
#' `Local`.
#' 
#' This parameter is optional. If it is not included, or if it is set to
#' `All`, all policies are returned.
#' @param OnlyAttached A flag to filter the results to only the attached policies.
#' 
#' When `OnlyAttached` is `true`, the returned list contains only the
#' policies that are attached to an IAM user, group, or role. When
#' `OnlyAttached` is `false`, or when the parameter is not included, all
#' policies are returned.
#' @param PathPrefix The path prefix for filtering the results. This parameter is optional.
#' If it is not included, it defaults to a slash (/), listing all policies.
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of either a forward slash (/) by itself or a string that must
#' begin and end with forward slashes. In addition, it can contain any
#' ASCII character from the ! (`U+0021`) through the DEL character
#' (`U+007F`), including most punctuation characters, digits, and upper and
#' lowercased letters.
#' @param PolicyUsageFilter The policy usage method to use for filtering the results.
#' 
#' To list only permissions policies,
#' setÂ `PolicyUsageFilter`Â toÂ `PermissionsPolicy`. To list only the
#' policies used to set permissions boundaries, setÂ the value
#' toÂ `PermissionsBoundary`.
#' 
#' This parameter is optional. If it is not included, all policies are
#' returned.
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @section Request syntax:
#' ```
#' svc$list_policies(
#'   Scope = "All"|"AWS"|"Local",
#'   OnlyAttached = TRUE|FALSE,
#'   PathPrefix = "string",
#'   PolicyUsageFilter = "PermissionsPolicy"|"PermissionsBoundary",
#'   Marker = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_list_policies
iam_list_policies <- function(Scope = NULL, OnlyAttached = NULL, PathPrefix = NULL, PolicyUsageFilter = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListPolicies",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$list_policies_input(Scope = Scope, OnlyAttached = OnlyAttached, PathPrefix = PathPrefix, PolicyUsageFilter = PolicyUsageFilter, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_policies_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_policies <- iam_list_policies

#' Retrieves a list of policies that the IAM identity (user, group, or
#' role) can use to access each specified service
#'
#' Retrieves a list of policies that the IAM identity (user, group, or
#' role) can use to access each specified service.
#' 
#' This operation does not use other policy types when determining whether
#' a resource could access a service. These other policy types include
#' resource-based policies, access control lists, AWS Organizations
#' policies, IAM permissions boundaries, and AWS STS assume role policies.
#' It only applies permissions policy logic. For more about the evaluation
#' of policy types, see [Evaluating
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics)
#' in the *IAM User Guide*.
#' 
#' The list of policies returned by the operation depends on the ARN of the
#' identity that you provide.
#' 
#' -   **User** -- The list of policies includes the managed and inline
#'     policies that are attached to the user directly. The list also
#'     includes any additional managed and inline policies that are
#'     attached to the group to which the user belongs.
#' 
#' -   **Group** -- The list of policies includes only the managed and
#'     inline policies that are attached to the group directly. Policies
#'     that are attached to the group's user are not included.
#' 
#' -   **Role** -- The list of policies includes only the managed and
#'     inline policies that are attached to the role.
#' 
#' For each managed policy, this operation returns the ARN and policy name.
#' For each inline policy, it returns the policy name and the entity to
#' which it is attached. Inline policies do not have an ARN. For more
#' information about these policy types, see [Managed Policies and Inline
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html)
#' in the *IAM User Guide*.
#' 
#' Policies that are attached to users and roles as permissions boundaries
#' are not returned. To view which managed policy is currently used to set
#' the permissions boundary for a user or role, use the GetUser or GetRole
#' operations.
#'
#' @usage
#' iam_list_policies_granting_service_access(Marker, Arn,
#'   ServiceNamespaces)
#'
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param Arn &#91;required&#93; The ARN of the IAM identity (user, group, or role) whose policies you
#' want to list.
#' @param ServiceNamespaces &#91;required&#93; The service namespace for the AWS services whose policies you want to
#' list.
#' 
#' To learn the service namespace for a service, go to [Actions, Resources,
#' and Condition Keys for AWS
#' Services](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_actions-resources-contextkeys.html)
#' in the *IAM User Guide*. Choose the name of the service to view details
#' for that service. In the first paragraph, find the service prefix. For
#' example, `(service prefix: a4b)`. For more information about service
#' namespaces, see [AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
#' in theÂ *AWS General Reference*.
#'
#' @section Request syntax:
#' ```
#' svc$list_policies_granting_service_access(
#'   Marker = "string",
#'   Arn = "string",
#'   ServiceNamespaces = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # The following operation lists policies that allow ExampleUser01 to
#' # access IAM or EC2.
#' \donttest{svc$list_policies_granting_service_access(
#'   Arn = "arn:aws:iam::123456789012:user/ExampleUser01",
#'   ServiceNamespaces = list(
#'     "iam",
#'     "ec2"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_list_policies_granting_service_access
iam_list_policies_granting_service_access <- function(Marker = NULL, Arn, ServiceNamespaces) {
  op <- new_operation(
    name = "ListPoliciesGrantingServiceAccess",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$list_policies_granting_service_access_input(Marker = Marker, Arn = Arn, ServiceNamespaces = ServiceNamespaces)
  output <- .iam$list_policies_granting_service_access_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_policies_granting_service_access <- iam_list_policies_granting_service_access

#' Lists information about the versions of the specified managed policy,
#' including the version that is currently set as the policy's default
#' version
#'
#' Lists information about the versions of the specified managed policy,
#' including the version that is currently set as the policy\'s default
#' version.
#' 
#' For more information about managed policies, see [Managed Policies and
#' Inline
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_list_policy_versions(PolicyArn, Marker, MaxItems)
#'
#' @param PolicyArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM policy for which you want the
#' versions.
#' 
#' For more information about ARNs, see [Amazon Resource Names (ARNs) and
#' AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @section Request syntax:
#' ```
#' svc$list_policy_versions(
#'   PolicyArn = "string",
#'   Marker = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_list_policy_versions
iam_list_policy_versions <- function(PolicyArn, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListPolicyVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$list_policy_versions_input(PolicyArn = PolicyArn, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_policy_versions_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_policy_versions <- iam_list_policy_versions

#' Lists the names of the inline policies that are embedded in the
#' specified IAM role
#'
#' Lists the names of the inline policies that are embedded in the
#' specified IAM role.
#' 
#' An IAM role can also have managed policies attached to it. To list the
#' managed policies that are attached to a role, use
#' ListAttachedRolePolicies. For more information about policies, see
#' [Managed Policies and Inline
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
#' in the *IAM User Guide*.
#' 
#' You can paginate the results using the `MaxItems` and `Marker`
#' parameters. If there are no inline policies embedded with the specified
#' role, the operation returns an empty list.
#'
#' @usage
#' iam_list_role_policies(RoleName, Marker, MaxItems)
#'
#' @param RoleName &#91;required&#93; The name of the role to list policies for.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @section Request syntax:
#' ```
#' svc$list_role_policies(
#'   RoleName = "string",
#'   Marker = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_list_role_policies
iam_list_role_policies <- function(RoleName, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListRolePolicies",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$list_role_policies_input(RoleName = RoleName, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_role_policies_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_role_policies <- iam_list_role_policies

#' Lists the tags that are attached to the specified role
#'
#' Lists the tags that are attached to the specified role. The returned
#' list of tags is sorted by tag key. For more information about tagging,
#' see [Tagging IAM
#' Identities](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_list_role_tags(RoleName, Marker, MaxItems)
#'
#' @param RoleName &#91;required&#93; The name of the IAM role for which you want to see the list of tags.
#' 
#' This parameter accepts (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters that
#' consist of upper and lowercase alphanumeric characters with no spaces.
#' You can also include any of the following characters: \\_+=,.@-
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems (Optional) Use this only when paginating results to indicate the maximum
#' number of items that you want in the response. If additional items exist
#' beyond the maximum that you specify, the `IsTruncated` response element
#' is `true`.
#' 
#' If you do not include this parameter, it defaults to 100. Note that IAM
#' might return fewer results, even when more results are available. In
#' that case, the `IsTruncated` response element returns `true`, and
#' `Marker` contains a value to include in the subsequent call that tells
#' the service where to continue from.
#'
#' @section Request syntax:
#' ```
#' svc$list_role_tags(
#'   RoleName = "string",
#'   Marker = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @examples
#' # The following example shows how to list the tags attached to a role.
#' \donttest{svc$list_role_tags(
#'   RoleName = "taggedrole1"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_list_role_tags
iam_list_role_tags <- function(RoleName, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListRoleTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$list_role_tags_input(RoleName = RoleName, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_role_tags_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_role_tags <- iam_list_role_tags

#' Lists the IAM roles that have the specified path prefix
#'
#' Lists the IAM roles that have the specified path prefix. If there are
#' none, the operation returns an empty list. For more information about
#' roles, go to [Working with
#' Roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html).
#' 
#' You can paginate the results using the `MaxItems` and `Marker`
#' parameters.
#'
#' @usage
#' iam_list_roles(PathPrefix, Marker, MaxItems)
#'
#' @param PathPrefix The path prefix for filtering the results. For example, the prefix
#' `/application_abc/component_xyz/` gets all roles whose path starts with
#' `/application_abc/component_xyz/`.
#' 
#' This parameter is optional. If it is not included, it defaults to a
#' slash (/), listing all roles. This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of either a forward slash (/) by itself or a string that must
#' begin and end with forward slashes. In addition, it can contain any
#' ASCII character from the ! (`U+0021`) through the DEL character
#' (`U+007F`), including most punctuation characters, digits, and upper and
#' lowercased letters.
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @section Request syntax:
#' ```
#' svc$list_roles(
#'   PathPrefix = "string",
#'   Marker = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_list_roles
iam_list_roles <- function(PathPrefix = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListRoles",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$list_roles_input(PathPrefix = PathPrefix, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_roles_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_roles <- iam_list_roles

#' Lists the SAML provider resource objects defined in IAM in the account
#'
#' Lists the SAML provider resource objects defined in IAM in the account.
#' 
#' This operation requires [Signature Version
#' 4](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
#'
#' @usage
#' iam_list_saml_providers()
#'
#' @section Request syntax:
#' ```
#' svc$list_saml_providers()
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_list_saml_providers
iam_list_saml_providers <- function() {
  op <- new_operation(
    name = "ListSAMLProviders",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$list_saml_providers_input()
  output <- .iam$list_saml_providers_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_saml_providers <- iam_list_saml_providers

#' Returns information about the SSH public keys associated with the
#' specified IAM user
#'
#' Returns information about the SSH public keys associated with the
#' specified IAM user. If none exists, the operation returns an empty list.
#' 
#' The SSH public keys returned by this operation are used only for
#' authenticating the IAM user to an AWS CodeCommit repository. For more
#' information about using SSH keys to authenticate to an AWS CodeCommit
#' repository, see [Set up AWS CodeCommit for SSH
#' Connections](https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html)
#' in the *AWS CodeCommit User Guide*.
#' 
#' Although each user is limited to a small number of keys, you can still
#' paginate the results using the `MaxItems` and `Marker` parameters.
#'
#' @usage
#' iam_list_ssh_public_keys(UserName, Marker, MaxItems)
#'
#' @param UserName The name of the IAM user to list SSH public keys for. If none is
#' specified, the `UserName` field is determined implicitly based on the
#' AWS access key used to sign the request.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @section Request syntax:
#' ```
#' svc$list_ssh_public_keys(
#'   UserName = "string",
#'   Marker = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_list_ssh_public_keys
iam_list_ssh_public_keys <- function(UserName = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListSSHPublicKeys",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$list_ssh_public_keys_input(UserName = UserName, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_ssh_public_keys_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_ssh_public_keys <- iam_list_ssh_public_keys

#' Lists the server certificates stored in IAM that have the specified path
#' prefix
#'
#' Lists the server certificates stored in IAM that have the specified path
#' prefix. If none exist, the operation returns an empty list.
#' 
#' You can paginate the results using the `MaxItems` and `Marker`
#' parameters.
#' 
#' For more information about working with server certificates, see
#' [Working with Server
#' Certificates](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html)
#' in the *IAM User Guide*. This topic also includes a list of AWS services
#' that can use the server certificates that you manage with IAM.
#'
#' @usage
#' iam_list_server_certificates(PathPrefix, Marker, MaxItems)
#'
#' @param PathPrefix The path prefix for filtering the results. For example:
#' `/company/servercerts` would get all server certificates for which the
#' path starts with `/company/servercerts`.
#' 
#' This parameter is optional. If it is not included, it defaults to a
#' slash (/), listing all server certificates. This parameter allows
#' (through its [regex pattern](http://wikipedia.org/wiki/regex)) a string
#' of characters consisting of either a forward slash (/) by itself or a
#' string that must begin and end with forward slashes. In addition, it can
#' contain any ASCII character from the ! (`U+0021`) through the DEL
#' character (`U+007F`), including most punctuation characters, digits, and
#' upper and lowercased letters.
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @section Request syntax:
#' ```
#' svc$list_server_certificates(
#'   PathPrefix = "string",
#'   Marker = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_list_server_certificates
iam_list_server_certificates <- function(PathPrefix = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListServerCertificates",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$list_server_certificates_input(PathPrefix = PathPrefix, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_server_certificates_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_server_certificates <- iam_list_server_certificates

#' Returns information about the service-specific credentials associated
#' with the specified IAM user
#'
#' Returns information about the service-specific credentials associated
#' with the specified IAM user. If none exists, the operation returns an
#' empty list. The service-specific credentials returned by this operation
#' are used only for authenticating the IAM user to a specific service. For
#' more information about using service-specific credentials to
#' authenticate to an AWS service, see [Set Up service-specific
#' credentials](https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-gc.html)
#' in the AWS CodeCommit User Guide.
#'
#' @usage
#' iam_list_service_specific_credentials(UserName, ServiceName)
#'
#' @param UserName The name of the user whose service-specific credentials you want
#' information about. If this value is not specified, then the operation
#' assumes the user whose credentials are used to call the operation.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param ServiceName Filters the returned results to only those for the specified AWS
#' service. If not specified, then AWS returns service-specific credentials
#' for all services.
#'
#' @section Request syntax:
#' ```
#' svc$list_service_specific_credentials(
#'   UserName = "string",
#'   ServiceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_list_service_specific_credentials
iam_list_service_specific_credentials <- function(UserName = NULL, ServiceName = NULL) {
  op <- new_operation(
    name = "ListServiceSpecificCredentials",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$list_service_specific_credentials_input(UserName = UserName, ServiceName = ServiceName)
  output <- .iam$list_service_specific_credentials_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_service_specific_credentials <- iam_list_service_specific_credentials

#' Returns information about the signing certificates associated with the
#' specified IAM user
#'
#' Returns information about the signing certificates associated with the
#' specified IAM user. If none exists, the operation returns an empty list.
#' 
#' Although each user is limited to a small number of signing certificates,
#' you can still paginate the results using the `MaxItems` and `Marker`
#' parameters.
#' 
#' If the `UserName` field is not specified, the user name is determined
#' implicitly based on the AWS access key ID used to sign the request for
#' this API. This operation works for access keys under the AWS account.
#' Consequently, you can use this operation to manage AWS account root user
#' credentials even if the AWS account has no associated users.
#'
#' @usage
#' iam_list_signing_certificates(UserName, Marker, MaxItems)
#'
#' @param UserName The name of the IAM user whose signing certificates you want to examine.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @section Request syntax:
#' ```
#' svc$list_signing_certificates(
#'   UserName = "string",
#'   Marker = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @examples
#' # The following command lists the signing certificates for the IAM user
#' # named Bob.
#' \donttest{svc$list_signing_certificates(
#'   UserName = "Bob"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_list_signing_certificates
iam_list_signing_certificates <- function(UserName = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListSigningCertificates",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$list_signing_certificates_input(UserName = UserName, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_signing_certificates_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_signing_certificates <- iam_list_signing_certificates

#' Lists the names of the inline policies embedded in the specified IAM
#' user
#'
#' Lists the names of the inline policies embedded in the specified IAM
#' user.
#' 
#' An IAM user can also have managed policies attached to it. To list the
#' managed policies that are attached to a user, use
#' ListAttachedUserPolicies. For more information about policies, see
#' [Managed Policies and Inline
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
#' in the *IAM User Guide*.
#' 
#' You can paginate the results using the `MaxItems` and `Marker`
#' parameters. If there are no inline policies embedded with the specified
#' user, the operation returns an empty list.
#'
#' @usage
#' iam_list_user_policies(UserName, Marker, MaxItems)
#'
#' @param UserName &#91;required&#93; The name of the user to list policies for.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @section Request syntax:
#' ```
#' svc$list_user_policies(
#'   UserName = "string",
#'   Marker = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_list_user_policies
iam_list_user_policies <- function(UserName, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListUserPolicies",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$list_user_policies_input(UserName = UserName, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_user_policies_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_user_policies <- iam_list_user_policies

#' Lists the tags that are attached to the specified user
#'
#' Lists the tags that are attached to the specified user. The returned
#' list of tags is sorted by tag key. For more information about tagging,
#' see [Tagging IAM
#' Identities](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_list_user_tags(UserName, Marker, MaxItems)
#'
#' @param UserName &#91;required&#93; The name of the IAM user whose tags you want to see.
#' 
#' This parameter accepts (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters that
#' consist of upper and lowercase alphanumeric characters with no spaces.
#' You can also include any of the following characters: =,.@-
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems (Optional) Use this only when paginating results to indicate the maximum
#' number of items that you want in the response. If additional items exist
#' beyond the maximum that you specify, the `IsTruncated` response element
#' is `true`.
#' 
#' If you do not include this parameter, it defaults to 100. Note that IAM
#' might return fewer results, even when more results are available. In
#' that case, the `IsTruncated` response element returns `true`, and
#' `Marker` contains a value to include in the subsequent call that tells
#' the service where to continue from.
#'
#' @section Request syntax:
#' ```
#' svc$list_user_tags(
#'   UserName = "string",
#'   Marker = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @examples
#' # The following example shows how to list the tags attached to a user.
#' \donttest{svc$list_user_tags(
#'   UserName = "anika"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_list_user_tags
iam_list_user_tags <- function(UserName, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListUserTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$list_user_tags_input(UserName = UserName, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_user_tags_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_user_tags <- iam_list_user_tags

#' Lists the IAM users that have the specified path prefix
#'
#' Lists the IAM users that have the specified path prefix. If no path
#' prefix is specified, the operation returns all users in the AWS account.
#' If there are none, the operation returns an empty list.
#' 
#' You can paginate the results using the `MaxItems` and `Marker`
#' parameters.
#'
#' @usage
#' iam_list_users(PathPrefix, Marker, MaxItems)
#'
#' @param PathPrefix The path prefix for filtering the results. For example:
#' `/division_abc/subdivision_xyz/`, which would get all user names whose
#' path starts with `/division_abc/subdivision_xyz/`.
#' 
#' This parameter is optional. If it is not included, it defaults to a
#' slash (/), listing all user names. This parameter allows (through its
#' [regex pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of either a forward slash (/) by itself or a string that must
#' begin and end with forward slashes. In addition, it can contain any
#' ASCII character from the ! (`U+0021`) through the DEL character
#' (`U+007F`), including most punctuation characters, digits, and upper and
#' lowercased letters.
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @section Request syntax:
#' ```
#' svc$list_users(
#'   PathPrefix = "string",
#'   Marker = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @examples
#' # The following command lists the IAM users in the current account.
#' \donttest{svc$list_users()}
#'
#' @keywords internal
#'
#' @rdname iam_list_users
iam_list_users <- function(PathPrefix = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListUsers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$list_users_input(PathPrefix = PathPrefix, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_users_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_users <- iam_list_users

#' Lists the virtual MFA devices defined in the AWS account by assignment
#' status
#'
#' Lists the virtual MFA devices defined in the AWS account by assignment
#' status. If you do not specify an assignment status, the operation
#' returns a list of all virtual MFA devices. Assignment status can be
#' `Assigned`, `Unassigned`, or `Any`.
#' 
#' You can paginate the results using the `MaxItems` and `Marker`
#' parameters.
#'
#' @usage
#' iam_list_virtual_mfa_devices(AssignmentStatus, Marker, MaxItems)
#'
#' @param AssignmentStatus The status (`Unassigned` or `Assigned`) of the devices to list. If you
#' do not specify an `AssignmentStatus`, the operation defaults to `Any`,
#' which lists both assigned and unassigned virtual MFA devices.,
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @section Request syntax:
#' ```
#' svc$list_virtual_mfa_devices(
#'   AssignmentStatus = "Assigned"|"Unassigned"|"Any",
#'   Marker = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @examples
#' # The following command lists the virtual MFA devices that have been
#' # configured for the current account.
#' \donttest{svc$list_virtual_mfa_devices()}
#'
#' @keywords internal
#'
#' @rdname iam_list_virtual_mfa_devices
iam_list_virtual_mfa_devices <- function(AssignmentStatus = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListVirtualMFADevices",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$list_virtual_mfa_devices_input(AssignmentStatus = AssignmentStatus, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_virtual_mfa_devices_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_virtual_mfa_devices <- iam_list_virtual_mfa_devices

#' Adds or updates an inline policy document that is embedded in the
#' specified IAM group
#'
#' Adds or updates an inline policy document that is embedded in the
#' specified IAM group.
#' 
#' A user can also have managed policies attached to it. To attach a
#' managed policy to a group, use AttachGroupPolicy. To create a new
#' managed policy, use CreatePolicy. For information about policies, see
#' [Managed Policies and Inline
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
#' in the *IAM User Guide*.
#' 
#' For information about limits on the number of inline policies that you
#' can embed in a group, see [Limitations on IAM
#' Entities](https://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html)
#' in the *IAM User Guide*.
#' 
#' Because policy documents can be large, you should use POST rather than
#' GET when calling `PutGroupPolicy`. For general information about using
#' the Query API with IAM, go to [Making Query
#' Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_put_group_policy(GroupName, PolicyName, PolicyDocument)
#'
#' @param GroupName &#91;required&#93; The name of the group to associate the policy with.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-.
#' @param PolicyName &#91;required&#93; The name of the policy document.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param PolicyDocument &#91;required&#93; The policy document.
#' 
#' You must provide policies in JSON format in IAM. However, for AWS
#' CloudFormation templates formatted in YAML, you can provide the policy
#' in JSON or YAML format. AWS CloudFormation always converts a YAML policy
#' to JSON format before submitting it to IAM.
#' 
#' The [regex pattern](http://wikipedia.org/wiki/regex) used to validate
#' this parameter is a string of characters consisting of the following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (`U+0020`) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through `U+00FF`)
#' 
#' -   The special characters tab (`U+0009`), line feed (`U+000A`), and
#'     carriage return (`U+000D`)
#'
#' @section Request syntax:
#' ```
#' svc$put_group_policy(
#'   GroupName = "string",
#'   PolicyName = "string",
#'   PolicyDocument = "string"
#' )
#' ```
#'
#' @examples
#' # The following command adds a policy named AllPerms to the IAM group
#' # named Admins.
#' \donttest{svc$put_group_policy(
#'   GroupName = "Admins",
#'   PolicyDocument = "{\"Version\":\"2012-10-17\",\"Statement\":{\"Effect\":\"Allow\",...",
#'   PolicyName = "AllPerms"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_put_group_policy
iam_put_group_policy <- function(GroupName, PolicyName, PolicyDocument) {
  op <- new_operation(
    name = "PutGroupPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$put_group_policy_input(GroupName = GroupName, PolicyName = PolicyName, PolicyDocument = PolicyDocument)
  output <- .iam$put_group_policy_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$put_group_policy <- iam_put_group_policy

#' Adds or updates the policy that is specified as the IAM role's
#' permissions boundary
#'
#' Adds or updates the policy that is specified as the IAM role\'s
#' permissions boundary. You can use an AWS managed policy or a customer
#' managed policy to set the boundary for a role. Use the boundary to
#' control the maximum permissions that the role can have. Setting a
#' permissions boundary is an advanced feature that can affect the
#' permissions for the role.
#' 
#' You cannot set the boundary for a service-linked role.
#' 
#' Policies used as permissions boundaries do not provide permissions. You
#' must also attach a permissions policy to the role. To learn how the
#' effective permissions for a role are evaluated, see [IAM JSON Policy
#' Evaluation
#' Logic](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html)
#' in the IAM User Guide.
#'
#' @usage
#' iam_put_role_permissions_boundary(RoleName, PermissionsBoundary)
#'
#' @param RoleName &#91;required&#93; The name (friendly name, not ARN) of the IAM role for which you want to
#' set the permissions boundary.
#' @param PermissionsBoundary &#91;required&#93; The ARN of the policy that is used to set the permissions boundary for
#' the role.
#'
#' @section Request syntax:
#' ```
#' svc$put_role_permissions_boundary(
#'   RoleName = "string",
#'   PermissionsBoundary = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_put_role_permissions_boundary
iam_put_role_permissions_boundary <- function(RoleName, PermissionsBoundary) {
  op <- new_operation(
    name = "PutRolePermissionsBoundary",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$put_role_permissions_boundary_input(RoleName = RoleName, PermissionsBoundary = PermissionsBoundary)
  output <- .iam$put_role_permissions_boundary_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$put_role_permissions_boundary <- iam_put_role_permissions_boundary

#' Adds or updates an inline policy document that is embedded in the
#' specified IAM role
#'
#' Adds or updates an inline policy document that is embedded in the
#' specified IAM role.
#' 
#' When you embed an inline policy in a role, the inline policy is used as
#' part of the role\'s access (permissions) policy. The role\'s trust
#' policy is created at the same time as the role, using CreateRole. You
#' can update a role\'s trust policy using UpdateAssumeRolePolicy. For more
#' information about IAM roles, go to [Using Roles to Delegate Permissions
#' and Federate
#' Identities](https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html).
#' 
#' A role can also have a managed policy attached to it. To attach a
#' managed policy to a role, use AttachRolePolicy. To create a new managed
#' policy, use CreatePolicy. For information about policies, see [Managed
#' Policies and Inline
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
#' in the *IAM User Guide*.
#' 
#' For information about limits on the number of inline policies that you
#' can embed with a role, see [Limitations on IAM
#' Entities](https://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html)
#' in the *IAM User Guide*.
#' 
#' Because policy documents can be large, you should use POST rather than
#' GET when calling `PutRolePolicy`. For general information about using
#' the Query API with IAM, go to [Making Query
#' Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_put_role_policy(RoleName, PolicyName, PolicyDocument)
#'
#' @param RoleName &#91;required&#93; The name of the role to associate the policy with.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param PolicyName &#91;required&#93; The name of the policy document.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param PolicyDocument &#91;required&#93; The policy document.
#' 
#' You must provide policies in JSON format in IAM. However, for AWS
#' CloudFormation templates formatted in YAML, you can provide the policy
#' in JSON or YAML format. AWS CloudFormation always converts a YAML policy
#' to JSON format before submitting it to IAM.
#' 
#' The [regex pattern](http://wikipedia.org/wiki/regex) used to validate
#' this parameter is a string of characters consisting of the following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (`U+0020`) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through `U+00FF`)
#' 
#' -   The special characters tab (`U+0009`), line feed (`U+000A`), and
#'     carriage return (`U+000D`)
#'
#' @section Request syntax:
#' ```
#' svc$put_role_policy(
#'   RoleName = "string",
#'   PolicyName = "string",
#'   PolicyDocument = "string"
#' )
#' ```
#'
#' @examples
#' # The following command adds a permissions policy to the role named
#' # Test-Role.
#' \donttest{svc$put_role_policy(
#'   PolicyDocument = "{\"Version\":\"2012-10-17\",\"Statement\":{\"Effect\":\"Allow\",...",
#'   PolicyName = "S3AccessPolicy",
#'   RoleName = "S3Access"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_put_role_policy
iam_put_role_policy <- function(RoleName, PolicyName, PolicyDocument) {
  op <- new_operation(
    name = "PutRolePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$put_role_policy_input(RoleName = RoleName, PolicyName = PolicyName, PolicyDocument = PolicyDocument)
  output <- .iam$put_role_policy_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$put_role_policy <- iam_put_role_policy

#' Adds or updates the policy that is specified as the IAM user's
#' permissions boundary
#'
#' Adds or updates the policy that is specified as the IAM user\'s
#' permissions boundary. You can use an AWS managed policy or a customer
#' managed policy to set the boundary for a user. Use the boundary to
#' control the maximum permissions that the user can have. Setting a
#' permissions boundary is an advanced feature that can affect the
#' permissions for the user.
#' 
#' Policies that are used as permissions boundaries do not provide
#' permissions. You must also attach a permissions policy to the user. To
#' learn how the effective permissions for a user are evaluated, see [IAM
#' JSON Policy Evaluation
#' Logic](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html)
#' in the IAM User Guide.
#'
#' @usage
#' iam_put_user_permissions_boundary(UserName, PermissionsBoundary)
#'
#' @param UserName &#91;required&#93; The name (friendly name, not ARN) of the IAM user for which you want to
#' set the permissions boundary.
#' @param PermissionsBoundary &#91;required&#93; The ARN of the policy that is used to set the permissions boundary for
#' the user.
#'
#' @section Request syntax:
#' ```
#' svc$put_user_permissions_boundary(
#'   UserName = "string",
#'   PermissionsBoundary = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_put_user_permissions_boundary
iam_put_user_permissions_boundary <- function(UserName, PermissionsBoundary) {
  op <- new_operation(
    name = "PutUserPermissionsBoundary",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$put_user_permissions_boundary_input(UserName = UserName, PermissionsBoundary = PermissionsBoundary)
  output <- .iam$put_user_permissions_boundary_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$put_user_permissions_boundary <- iam_put_user_permissions_boundary

#' Adds or updates an inline policy document that is embedded in the
#' specified IAM user
#'
#' Adds or updates an inline policy document that is embedded in the
#' specified IAM user.
#' 
#' An IAM user can also have a managed policy attached to it. To attach a
#' managed policy to a user, use AttachUserPolicy. To create a new managed
#' policy, use CreatePolicy. For information about policies, see [Managed
#' Policies and Inline
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
#' in the *IAM User Guide*.
#' 
#' For information about limits on the number of inline policies that you
#' can embed in a user, see [Limitations on IAM
#' Entities](https://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html)
#' in the *IAM User Guide*.
#' 
#' Because policy documents can be large, you should use POST rather than
#' GET when calling `PutUserPolicy`. For general information about using
#' the Query API with IAM, go to [Making Query
#' Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_put_user_policy(UserName, PolicyName, PolicyDocument)
#'
#' @param UserName &#91;required&#93; The name of the user to associate the policy with.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param PolicyName &#91;required&#93; The name of the policy document.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param PolicyDocument &#91;required&#93; The policy document.
#' 
#' You must provide policies in JSON format in IAM. However, for AWS
#' CloudFormation templates formatted in YAML, you can provide the policy
#' in JSON or YAML format. AWS CloudFormation always converts a YAML policy
#' to JSON format before submitting it to IAM.
#' 
#' The [regex pattern](http://wikipedia.org/wiki/regex) used to validate
#' this parameter is a string of characters consisting of the following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (`U+0020`) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through `U+00FF`)
#' 
#' -   The special characters tab (`U+0009`), line feed (`U+000A`), and
#'     carriage return (`U+000D`)
#'
#' @section Request syntax:
#' ```
#' svc$put_user_policy(
#'   UserName = "string",
#'   PolicyName = "string",
#'   PolicyDocument = "string"
#' )
#' ```
#'
#' @examples
#' # The following command attaches a policy to the IAM user named Bob.
#' \donttest{svc$put_user_policy(
#'   PolicyDocument = "{\"Version\":\"2012-10-17\",\"Statement\":{\"Effect\":\"Allow\",...",
#'   PolicyName = "AllAccessPolicy",
#'   UserName = "Bob"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_put_user_policy
iam_put_user_policy <- function(UserName, PolicyName, PolicyDocument) {
  op <- new_operation(
    name = "PutUserPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$put_user_policy_input(UserName = UserName, PolicyName = PolicyName, PolicyDocument = PolicyDocument)
  output <- .iam$put_user_policy_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$put_user_policy <- iam_put_user_policy

#' Removes the specified client ID (also known as audience) from the list
#' of client IDs registered for the specified IAM OpenID Connect (OIDC)
#' provider resource object
#'
#' Removes the specified client ID (also known as audience) from the list
#' of client IDs registered for the specified IAM OpenID Connect (OIDC)
#' provider resource object.
#' 
#' This operation is idempotent; it does not fail or return an error if you
#' try to remove a client ID that does not exist.
#'
#' @usage
#' iam_remove_client_id_from_open_id_connect_provider(
#'   OpenIDConnectProviderArn, ClientID)
#'
#' @param OpenIDConnectProviderArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM OIDC provider resource to
#' remove the client ID from. You can get a list of OIDC provider ARNs by
#' using the ListOpenIDConnectProviders operation.
#' 
#' For more information about ARNs, see [Amazon Resource Names (ARNs) and
#' AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param ClientID &#91;required&#93; The client ID (also known as audience) to remove from the IAM OIDC
#' provider resource. For more information about client IDs, see
#' CreateOpenIDConnectProvider.
#'
#' @section Request syntax:
#' ```
#' svc$remove_client_id_from_open_id_connect_provider(
#'   OpenIDConnectProviderArn = "string",
#'   ClientID = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_remove_client_id_from_open_id_connect_provider
iam_remove_client_id_from_open_id_connect_provider <- function(OpenIDConnectProviderArn, ClientID) {
  op <- new_operation(
    name = "RemoveClientIDFromOpenIDConnectProvider",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$remove_client_id_from_open_id_connect_provider_input(OpenIDConnectProviderArn = OpenIDConnectProviderArn, ClientID = ClientID)
  output <- .iam$remove_client_id_from_open_id_connect_provider_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$remove_client_id_from_open_id_connect_provider <- iam_remove_client_id_from_open_id_connect_provider

#' Removes the specified IAM role from the specified EC2 instance profile
#'
#' Removes the specified IAM role from the specified EC2 instance profile.
#' 
#' Make sure that you do not have any Amazon EC2 instances running with the
#' role you are about to remove from the instance profile. Removing a role
#' from an instance profile that is associated with a running instance
#' might break any applications running on the instance.
#' 
#' For more information about IAM roles, go to [Working with
#' Roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html).
#' For more information about instance profiles, go to [About Instance
#' Profiles](https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html).
#'
#' @usage
#' iam_remove_role_from_instance_profile(InstanceProfileName, RoleName)
#'
#' @param InstanceProfileName &#91;required&#93; The name of the instance profile to update.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param RoleName &#91;required&#93; The name of the role to remove.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#'
#' @section Request syntax:
#' ```
#' svc$remove_role_from_instance_profile(
#'   InstanceProfileName = "string",
#'   RoleName = "string"
#' )
#' ```
#'
#' @examples
#' # The following command removes the role named Test-Role from the instance
#' # profile named ExampleInstanceProfile.
#' \donttest{svc$remove_role_from_instance_profile(
#'   InstanceProfileName = "ExampleInstanceProfile",
#'   RoleName = "Test-Role"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_remove_role_from_instance_profile
iam_remove_role_from_instance_profile <- function(InstanceProfileName, RoleName) {
  op <- new_operation(
    name = "RemoveRoleFromInstanceProfile",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$remove_role_from_instance_profile_input(InstanceProfileName = InstanceProfileName, RoleName = RoleName)
  output <- .iam$remove_role_from_instance_profile_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$remove_role_from_instance_profile <- iam_remove_role_from_instance_profile

#' Removes the specified user from the specified group
#'
#' Removes the specified user from the specified group.
#'
#' @usage
#' iam_remove_user_from_group(GroupName, UserName)
#'
#' @param GroupName &#91;required&#93; The name of the group to update.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param UserName &#91;required&#93; The name of the user to remove.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#'
#' @section Request syntax:
#' ```
#' svc$remove_user_from_group(
#'   GroupName = "string",
#'   UserName = "string"
#' )
#' ```
#'
#' @examples
#' # The following command removes the user named Bob from the IAM group
#' # named Admins.
#' \donttest{svc$remove_user_from_group(
#'   GroupName = "Admins",
#'   UserName = "Bob"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_remove_user_from_group
iam_remove_user_from_group <- function(GroupName, UserName) {
  op <- new_operation(
    name = "RemoveUserFromGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$remove_user_from_group_input(GroupName = GroupName, UserName = UserName)
  output <- .iam$remove_user_from_group_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$remove_user_from_group <- iam_remove_user_from_group

#' Resets the password for a service-specific credential
#'
#' Resets the password for a service-specific credential. The new password
#' is AWS generated and cryptographically strong. It cannot be configured
#' by the user. Resetting the password immediately invalidates the previous
#' password associated with this user.
#'
#' @usage
#' iam_reset_service_specific_credential(UserName,
#'   ServiceSpecificCredentialId)
#'
#' @param UserName The name of the IAM user associated with the service-specific
#' credential. If this value is not specified, then the operation assumes
#' the user whose credentials are used to call the operation.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param ServiceSpecificCredentialId &#91;required&#93; The unique identifier of the service-specific credential.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters that
#' can consist of any upper or lowercased letter or digit.
#'
#' @section Request syntax:
#' ```
#' svc$reset_service_specific_credential(
#'   UserName = "string",
#'   ServiceSpecificCredentialId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_reset_service_specific_credential
iam_reset_service_specific_credential <- function(UserName = NULL, ServiceSpecificCredentialId) {
  op <- new_operation(
    name = "ResetServiceSpecificCredential",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$reset_service_specific_credential_input(UserName = UserName, ServiceSpecificCredentialId = ServiceSpecificCredentialId)
  output <- .iam$reset_service_specific_credential_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$reset_service_specific_credential <- iam_reset_service_specific_credential

#' Synchronizes the specified MFA device with its IAM resource object on
#' the AWS servers
#'
#' Synchronizes the specified MFA device with its IAM resource object on
#' the AWS servers.
#' 
#' For more information about creating and working with virtual MFA
#' devices, go to [Using a Virtual MFA
#' Device](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_resync_mfa_device(UserName, SerialNumber, AuthenticationCode1,
#'   AuthenticationCode2)
#'
#' @param UserName &#91;required&#93; The name of the user whose MFA device you want to resynchronize.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param SerialNumber &#91;required&#93; Serial number that uniquely identifies the MFA device.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param AuthenticationCode1 &#91;required&#93; An authentication code emitted by the device.
#' 
#' The format for this parameter is a sequence of six digits.
#' @param AuthenticationCode2 &#91;required&#93; A subsequent authentication code emitted by the device.
#' 
#' The format for this parameter is a sequence of six digits.
#'
#' @section Request syntax:
#' ```
#' svc$resync_mfa_device(
#'   UserName = "string",
#'   SerialNumber = "string",
#'   AuthenticationCode1 = "string",
#'   AuthenticationCode2 = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_resync_mfa_device
iam_resync_mfa_device <- function(UserName, SerialNumber, AuthenticationCode1, AuthenticationCode2) {
  op <- new_operation(
    name = "ResyncMFADevice",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$resync_mfa_device_input(UserName = UserName, SerialNumber = SerialNumber, AuthenticationCode1 = AuthenticationCode1, AuthenticationCode2 = AuthenticationCode2)
  output <- .iam$resync_mfa_device_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$resync_mfa_device <- iam_resync_mfa_device

#' Sets the specified version of the specified policy as the policy's
#' default (operative) version
#'
#' Sets the specified version of the specified policy as the policy\'s
#' default (operative) version.
#' 
#' This operation affects all users, groups, and roles that the policy is
#' attached to. To list the users, groups, and roles that the policy is
#' attached to, use the ListEntitiesForPolicy API.
#' 
#' For information about managed policies, see [Managed Policies and Inline
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_set_default_policy_version(PolicyArn, VersionId)
#'
#' @param PolicyArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM policy whose default version
#' you want to set.
#' 
#' For more information about ARNs, see [Amazon Resource Names (ARNs) and
#' AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param VersionId &#91;required&#93; The version of the policy to set as the default (operative) version.
#' 
#' For more information about managed policy versions, see [Versioning for
#' Managed
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html)
#' in the *IAM User Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$set_default_policy_version(
#'   PolicyArn = "string",
#'   VersionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_set_default_policy_version
iam_set_default_policy_version <- function(PolicyArn, VersionId) {
  op <- new_operation(
    name = "SetDefaultPolicyVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$set_default_policy_version_input(PolicyArn = PolicyArn, VersionId = VersionId)
  output <- .iam$set_default_policy_version_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$set_default_policy_version <- iam_set_default_policy_version

#' Sets the specified version of the global endpoint token as the token
#' version used for the AWS account
#'
#' Sets the specified version of the global endpoint token as the token
#' version used for the AWS account.
#' 
#' By default, AWS Security Token Service (STS) is available as a global
#' service, and all STS requests go to a single endpoint at
#' `https://sts.amazonaws.com`. AWS recommends using Regional STS endpoints
#' to reduce latency, build in redundancy, and increase session token
#' availability. For information about Regional endpoints for STS, see [AWS
#' Regions and
#' Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html#sts_region)
#' in the *AWS General Reference*.
#' 
#' If you make an STS call to the global endpoint, the resulting session
#' tokens might be valid in some Regions but not others. It depends on the
#' version that is set in this operation. Version 1 tokens are valid only
#' in AWS Regions that are available by default. These tokens do not work
#' in manually enabled Regions, such as Asia Pacific (Hong Kong). Version 2
#' tokens are valid in all Regions. However, version 2 tokens are longer
#' and might affect systems where you temporarily store tokens. For
#' information, see [Activating and Deactivating STS in an AWS
#' Region](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html)
#' in the *IAM User Guide*.
#' 
#' To view the current session token version, see the
#' `GlobalEndpointTokenVersion` entry in the response of the
#' GetAccountSummary operation.
#'
#' @usage
#' iam_set_security_token_service_preferences(GlobalEndpointTokenVersion)
#'
#' @param GlobalEndpointTokenVersion &#91;required&#93; The version of the global endpoint token. Version 1 tokens are valid
#' only in AWS Regions that are available by default. These tokens do not
#' work in manually enabled Regions, such as Asia Pacific (Hong Kong).
#' Version 2 tokens are valid in all Regions. However, version 2 tokens are
#' longer and might affect systems where you temporarily store tokens.
#' 
#' For information, see [Activating and Deactivating STS in an AWS
#' Region](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html)
#' in the *IAM User Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$set_security_token_service_preferences(
#'   GlobalEndpointTokenVersion = "v1Token"|"v2Token"
#' )
#' ```
#'
#' @examples
#' # The following command sets the STS global endpoint token to version 2.
#' # Version 2 tokens are valid in all Regions.
#' \donttest{svc$set_security_token_service_preferences(
#'   GlobalEndpointTokenVersion = "v2Token"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_set_security_token_service_preferences
iam_set_security_token_service_preferences <- function(GlobalEndpointTokenVersion) {
  op <- new_operation(
    name = "SetSecurityTokenServicePreferences",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$set_security_token_service_preferences_input(GlobalEndpointTokenVersion = GlobalEndpointTokenVersion)
  output <- .iam$set_security_token_service_preferences_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$set_security_token_service_preferences <- iam_set_security_token_service_preferences

#' Simulate how a set of IAM policies and optionally a resource-based
#' policy works with a list of API operations and AWS resources to
#' determine the policies' effective permissions
#'
#' Simulate how a set of IAM policies and optionally a resource-based
#' policy works with a list of API operations and AWS resources to
#' determine the policies\' effective permissions. The policies are
#' provided as strings.
#' 
#' The simulation does not perform the API operations; it only checks the
#' authorization to determine if the simulated policies allow or deny the
#' operations.
#' 
#' If you want to simulate existing policies attached to an IAM user,
#' group, or role, use SimulatePrincipalPolicy instead.
#' 
#' Context keys are variables maintained by AWS and its services that
#' provide details about the context of an API query request. You can use
#' the `Condition` element of an IAM policy to evaluate context keys. To
#' get the list of context keys that the policies require for correct
#' simulation, use GetContextKeysForCustomPolicy.
#' 
#' If the output is long, you can use `MaxItems` and `Marker` parameters to
#' paginate the results.
#'
#' @usage
#' iam_simulate_custom_policy(PolicyInputList, ActionNames, ResourceArns,
#'   ResourcePolicy, ResourceOwner, CallerArn, ContextEntries,
#'   ResourceHandlingOption, MaxItems, Marker)
#'
#' @param PolicyInputList &#91;required&#93; A list of policy documents to include in the simulation. Each document
#' is specified as a string containing the complete, valid JSON text of an
#' IAM policy. Do not include any resource-based policies in this
#' parameter. Any resource-based policy must be submitted with the
#' `ResourcePolicy` parameter. The policies cannot be \"scope-down\"
#' policies, such as you could include in a call to
#' [GetFederationToken](https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetFederationToken.html)
#' or one of the
#' [AssumeRole](https://docs.aws.amazon.com/IAM/latest/APIReference/API_AssumeRole.html)
#' API operations. In other words, do not use policies designed to restrict
#' what a user can do while using the temporary credentials.
#' 
#' The [regex pattern](http://wikipedia.org/wiki/regex) used to validate
#' this parameter is a string of characters consisting of the following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (`U+0020`) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through `U+00FF`)
#' 
#' -   The special characters tab (`U+0009`), line feed (`U+000A`), and
#'     carriage return (`U+000D`)
#' @param ActionNames &#91;required&#93; A list of names of API operations to evaluate in the simulation. Each
#' operation is evaluated against each resource. Each operation must
#' include the service identifier, such as `iam:CreateUser`. This operation
#' does not support using wildcards (\*) in an action name.
#' @param ResourceArns A list of ARNs of AWS resources to include in the simulation. If this
#' parameter is not provided, then the value defaults to `*` (all
#' resources). Each API in the `ActionNames` parameter is evaluated for
#' each resource in this list. The simulation determines the access result
#' (allowed or denied) of each combination and reports it in the response.
#' 
#' The simulation does not automatically retrieve policies for the
#' specified resources. If you want to include a resource policy in the
#' simulation, then you must include the policy as a string in the
#' `ResourcePolicy` parameter.
#' 
#' If you include a `ResourcePolicy`, then it must be applicable to all of
#' the resources included in the simulation or you receive an invalid input
#' error.
#' 
#' For more information about ARNs, see [Amazon Resource Names (ARNs) and
#' AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param ResourcePolicy A resource-based policy to include in the simulation provided as a
#' string. Each resource in the simulation is treated as if it had this
#' policy attached. You can include only one resource-based policy in a
#' simulation.
#' 
#' The [regex pattern](http://wikipedia.org/wiki/regex) used to validate
#' this parameter is a string of characters consisting of the following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (`U+0020`) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through `U+00FF`)
#' 
#' -   The special characters tab (`U+0009`), line feed (`U+000A`), and
#'     carriage return (`U+000D`)
#' @param ResourceOwner An ARN representing the AWS account ID that specifies the owner of any
#' simulated resource that does not identify its owner in the resource ARN.
#' Examples of resource ARNs include an S3 bucket or object. If
#' `ResourceOwner` is specified, it is also used as the account owner of
#' any `ResourcePolicy` included in the simulation. If the `ResourceOwner`
#' parameter is not specified, then the owner of the resources and the
#' resource policy defaults to the account of the identity provided in
#' `CallerArn`. This parameter is required only if you specify a
#' resource-based policy and account that owns the resource is different
#' from the account that owns the simulated calling user `CallerArn`.
#' 
#' The ARN for an account uses the following syntax:
#' `arn:aws:iam::<i>AWS-account-ID</i>:root`. For example, to represent the
#' account with the 112233445566 ID, use the following ARN:
#' `arn:aws:iam::112233445566-ID:root`.
#' @param CallerArn The ARN of the IAM user that you want to use as the simulated caller of
#' the API operations. `CallerArn` is required if you include a
#' `ResourcePolicy` so that the policy\'s `Principal` element has a value
#' to use in evaluating the policy.
#' 
#' You can specify only the ARN of an IAM user. You cannot specify the ARN
#' of an assumed role, federated user, or a service principal.
#' @param ContextEntries A list of context keys and corresponding values for the simulation to
#' use. Whenever a context key is evaluated in one of the simulated IAM
#' permissions policies, the corresponding value is supplied.
#' @param ResourceHandlingOption Specifies the type of simulation to run. Different API operations that
#' support resource-based policies require different combinations of
#' resources. By specifying the type of simulation to run, you enable the
#' policy simulator to enforce the presence of the required resources to
#' ensure reliable simulation results. If your simulation does not match
#' one of the following scenarios, then you can omit this parameter. The
#' following list shows each of the supported scenario values and the
#' resources that you must define to run the simulation.
#' 
#' Each of the EC2 scenarios requires that you specify instance, image, and
#' security-group resources. If your scenario includes an EBS volume, then
#' you must specify that volume as a resource. If the EC2 scenario includes
#' VPC, then you must supply the network-interface resource. If it includes
#' an IP subnet, then you must specify the subnet resource. For more
#' information on the EC2 scenario options, see [Supported
#' Platforms](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html)
#' in the *Amazon EC2 User Guide*.
#' 
#' -   **EC2-Classic-InstanceStore**
#' 
#'     instance, image, security-group
#' 
#' -   **EC2-Classic-EBS**
#' 
#'     instance, image, security-group, volume
#' 
#' -   **EC2-VPC-InstanceStore**
#' 
#'     instance, image, security-group, network-interface
#' 
#' -   **EC2-VPC-InstanceStore-Subnet**
#' 
#'     instance, image, security-group, network-interface, subnet
#' 
#' -   **EC2-VPC-EBS**
#' 
#'     instance, image, security-group, network-interface, volume
#' 
#' -   **EC2-VPC-EBS-Subnet**
#' 
#'     instance, image, security-group, network-interface, subnet, volume
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#'
#' @section Request syntax:
#' ```
#' svc$simulate_custom_policy(
#'   PolicyInputList = list(
#'     "string"
#'   ),
#'   ActionNames = list(
#'     "string"
#'   ),
#'   ResourceArns = list(
#'     "string"
#'   ),
#'   ResourcePolicy = "string",
#'   ResourceOwner = "string",
#'   CallerArn = "string",
#'   ContextEntries = list(
#'     list(
#'       ContextKeyName = "string",
#'       ContextKeyValues = list(
#'         "string"
#'       ),
#'       ContextKeyType = "string"|"stringList"|"numeric"|"numericList"|"boolean"|"booleanList"|"ip"|"ipList"|"binary"|"binaryList"|"date"|"dateList"
#'     )
#'   ),
#'   ResourceHandlingOption = "string",
#'   MaxItems = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_simulate_custom_policy
iam_simulate_custom_policy <- function(PolicyInputList, ActionNames, ResourceArns = NULL, ResourcePolicy = NULL, ResourceOwner = NULL, CallerArn = NULL, ContextEntries = NULL, ResourceHandlingOption = NULL, MaxItems = NULL, Marker = NULL) {
  op <- new_operation(
    name = "SimulateCustomPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$simulate_custom_policy_input(PolicyInputList = PolicyInputList, ActionNames = ActionNames, ResourceArns = ResourceArns, ResourcePolicy = ResourcePolicy, ResourceOwner = ResourceOwner, CallerArn = CallerArn, ContextEntries = ContextEntries, ResourceHandlingOption = ResourceHandlingOption, MaxItems = MaxItems, Marker = Marker)
  output <- .iam$simulate_custom_policy_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$simulate_custom_policy <- iam_simulate_custom_policy

#' Simulate how a set of IAM policies attached to an IAM entity works with
#' a list of API operations and AWS resources to determine the policies'
#' effective permissions
#'
#' Simulate how a set of IAM policies attached to an IAM entity works with
#' a list of API operations and AWS resources to determine the policies\'
#' effective permissions. The entity can be an IAM user, group, or role. If
#' you specify a user, then the simulation also includes all of the
#' policies that are attached to groups that the user belongs to.
#' 
#' You can optionally include a list of one or more additional policies
#' specified as strings to include in the simulation. If you want to
#' simulate only policies specified as strings, use SimulateCustomPolicy
#' instead.
#' 
#' You can also optionally include one resource-based policy to be
#' evaluated with each of the resources included in the simulation.
#' 
#' The simulation does not perform the API operations; it only checks the
#' authorization to determine if the simulated policies allow or deny the
#' operations.
#' 
#' **Note:** This API discloses information about the permissions granted
#' to other users. If you do not want users to see other user\'s
#' permissions, then consider allowing them to use SimulateCustomPolicy
#' instead.
#' 
#' Context keys are variables maintained by AWS and its services that
#' provide details about the context of an API query request. You can use
#' the `Condition` element of an IAM policy to evaluate context keys. To
#' get the list of context keys that the policies require for correct
#' simulation, use GetContextKeysForPrincipalPolicy.
#' 
#' If the output is long, you can use the `MaxItems` and `Marker`
#' parameters to paginate the results.
#'
#' @usage
#' iam_simulate_principal_policy(PolicySourceArn, PolicyInputList,
#'   ActionNames, ResourceArns, ResourcePolicy, ResourceOwner, CallerArn,
#'   ContextEntries, ResourceHandlingOption, MaxItems, Marker)
#'
#' @param PolicySourceArn &#91;required&#93; The Amazon Resource Name (ARN) of a user, group, or role whose policies
#' you want to include in the simulation. If you specify a user, group, or
#' role, the simulation includes all policies that are associated with that
#' entity. If you specify a user, the simulation also includes all policies
#' that are attached to any groups the user belongs to.
#' 
#' For more information about ARNs, see [Amazon Resource Names (ARNs) and
#' AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param PolicyInputList An optional list of additional policy documents to include in the
#' simulation. Each document is specified as a string containing the
#' complete, valid JSON text of an IAM policy.
#' 
#' The [regex pattern](http://wikipedia.org/wiki/regex) used to validate
#' this parameter is a string of characters consisting of the following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (`U+0020`) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through `U+00FF`)
#' 
#' -   The special characters tab (`U+0009`), line feed (`U+000A`), and
#'     carriage return (`U+000D`)
#' @param ActionNames &#91;required&#93; A list of names of API operations to evaluate in the simulation. Each
#' operation is evaluated for each resource. Each operation must include
#' the service identifier, such as `iam:CreateUser`.
#' @param ResourceArns A list of ARNs of AWS resources to include in the simulation. If this
#' parameter is not provided, then the value defaults to `*` (all
#' resources). Each API in the `ActionNames` parameter is evaluated for
#' each resource in this list. The simulation determines the access result
#' (allowed or denied) of each combination and reports it in the response.
#' 
#' The simulation does not automatically retrieve policies for the
#' specified resources. If you want to include a resource policy in the
#' simulation, then you must include the policy as a string in the
#' `ResourcePolicy` parameter.
#' 
#' For more information about ARNs, see [Amazon Resource Names (ARNs) and
#' AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param ResourcePolicy A resource-based policy to include in the simulation provided as a
#' string. Each resource in the simulation is treated as if it had this
#' policy attached. You can include only one resource-based policy in a
#' simulation.
#' 
#' The [regex pattern](http://wikipedia.org/wiki/regex) used to validate
#' this parameter is a string of characters consisting of the following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (`U+0020`) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through `U+00FF`)
#' 
#' -   The special characters tab (`U+0009`), line feed (`U+000A`), and
#'     carriage return (`U+000D`)
#' @param ResourceOwner An AWS account ID that specifies the owner of any simulated resource
#' that does not identify its owner in the resource ARN. Examples of
#' resource ARNs include an S3 bucket or object. If `ResourceOwner` is
#' specified, it is also used as the account owner of any `ResourcePolicy`
#' included in the simulation. If the `ResourceOwner` parameter is not
#' specified, then the owner of the resources and the resource policy
#' defaults to the account of the identity provided in `CallerArn`. This
#' parameter is required only if you specify a resource-based policy and
#' account that owns the resource is different from the account that owns
#' the simulated calling user `CallerArn`.
#' @param CallerArn The ARN of the IAM user that you want to specify as the simulated caller
#' of the API operations. If you do not specify a `CallerArn`, it defaults
#' to the ARN of the user that you specify in `PolicySourceArn`, if you
#' specified a user. If you include both a `PolicySourceArn` (for example,
#' `arn:aws:iam::123456789012:user/David`) and a `CallerArn` (for example,
#' `arn:aws:iam::123456789012:user/Bob`), the result is that you simulate
#' calling the API operations as Bob, as if Bob had David\'s policies.
#' 
#' You can specify only the ARN of an IAM user. You cannot specify the ARN
#' of an assumed role, federated user, or a service principal.
#' 
#' `CallerArn` is required if you include a `ResourcePolicy` and the
#' `PolicySourceArn` is not the ARN for an IAM user. This is required so
#' that the resource-based policy\'s `Principal` element has a value to use
#' in evaluating the policy.
#' 
#' For more information about ARNs, see [Amazon Resource Names (ARNs) and
#' AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param ContextEntries A list of context keys and corresponding values for the simulation to
#' use. Whenever a context key is evaluated in one of the simulated IAM
#' permissions policies, the corresponding value is supplied.
#' @param ResourceHandlingOption Specifies the type of simulation to run. Different API operations that
#' support resource-based policies require different combinations of
#' resources. By specifying the type of simulation to run, you enable the
#' policy simulator to enforce the presence of the required resources to
#' ensure reliable simulation results. If your simulation does not match
#' one of the following scenarios, then you can omit this parameter. The
#' following list shows each of the supported scenario values and the
#' resources that you must define to run the simulation.
#' 
#' Each of the EC2 scenarios requires that you specify instance, image, and
#' security group resources. If your scenario includes an EBS volume, then
#' you must specify that volume as a resource. If the EC2 scenario includes
#' VPC, then you must supply the network interface resource. If it includes
#' an IP subnet, then you must specify the subnet resource. For more
#' information on the EC2 scenario options, see [Supported
#' Platforms](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html)
#' in the *Amazon EC2 User Guide*.
#' 
#' -   **EC2-Classic-InstanceStore**
#' 
#'     instance, image, security group
#' 
#' -   **EC2-Classic-EBS**
#' 
#'     instance, image, security group, volume
#' 
#' -   **EC2-VPC-InstanceStore**
#' 
#'     instance, image, security group, network interface
#' 
#' -   **EC2-VPC-InstanceStore-Subnet**
#' 
#'     instance, image, security group, network interface, subnet
#' 
#' -   **EC2-VPC-EBS**
#' 
#'     instance, image, security group, network interface, volume
#' 
#' -   **EC2-VPC-EBS-Subnet**
#' 
#'     instance, image, security group, network interface, subnet, volume
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#'
#' @section Request syntax:
#' ```
#' svc$simulate_principal_policy(
#'   PolicySourceArn = "string",
#'   PolicyInputList = list(
#'     "string"
#'   ),
#'   ActionNames = list(
#'     "string"
#'   ),
#'   ResourceArns = list(
#'     "string"
#'   ),
#'   ResourcePolicy = "string",
#'   ResourceOwner = "string",
#'   CallerArn = "string",
#'   ContextEntries = list(
#'     list(
#'       ContextKeyName = "string",
#'       ContextKeyValues = list(
#'         "string"
#'       ),
#'       ContextKeyType = "string"|"stringList"|"numeric"|"numericList"|"boolean"|"booleanList"|"ip"|"ipList"|"binary"|"binaryList"|"date"|"dateList"
#'     )
#'   ),
#'   ResourceHandlingOption = "string",
#'   MaxItems = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_simulate_principal_policy
iam_simulate_principal_policy <- function(PolicySourceArn, PolicyInputList = NULL, ActionNames, ResourceArns = NULL, ResourcePolicy = NULL, ResourceOwner = NULL, CallerArn = NULL, ContextEntries = NULL, ResourceHandlingOption = NULL, MaxItems = NULL, Marker = NULL) {
  op <- new_operation(
    name = "SimulatePrincipalPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$simulate_principal_policy_input(PolicySourceArn = PolicySourceArn, PolicyInputList = PolicyInputList, ActionNames = ActionNames, ResourceArns = ResourceArns, ResourcePolicy = ResourcePolicy, ResourceOwner = ResourceOwner, CallerArn = CallerArn, ContextEntries = ContextEntries, ResourceHandlingOption = ResourceHandlingOption, MaxItems = MaxItems, Marker = Marker)
  output <- .iam$simulate_principal_policy_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$simulate_principal_policy <- iam_simulate_principal_policy

#' Adds one or more tags to an IAM role
#'
#' Adds one or more tags to an IAM role. The role can be a regular role or
#' a service-linked role. If a tag with the same key name already exists,
#' then that tag is overwritten with the new value.
#' 
#' A tag consists of a key name and an associated value. By assigning tags
#' to your resources, you can do the following:
#' 
#' -   **Administrative grouping and discovery** - Attach tags to resources
#'     to aid in organization and search. For example, you could search for
#'     all resources with the key name *Project* and the value
#'     *MyImportantProject*. Or search for all resources with the key name
#'     *Cost Center* and the value *41200*.
#' 
#' -   **Access control** - Reference tags in IAM user-based and
#'     resource-based policies. You can use tags to restrict access to only
#'     an IAM user or role that has a specified tag attached. You can also
#'     restrict access to only those resources that have a certain tag
#'     attached. For examples of policies that show how to use tags to
#'     control access, see [Control Access Using IAM
#'     Tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html)
#'     in the *IAM User Guide*.
#' 
#' -   **Cost allocation** - Use tags to help track which individuals and
#'     teams are using which AWS resources.
#' 
#' <!-- -->
#' 
#' -   Make sure that you have no invalid tags and that you do not exceed
#'     the allowed number of tags per role. In either case, the entire
#'     request fails and *no* tags are added to the role.
#' 
#' -   AWS always interprets the tag `Value` as a single string. If you
#'     need to store an array, you can store comma-separated values in the
#'     string. However, you must interpret the value in your code.
#' 
#' For more information about tagging, see [Tagging IAM
#' Identities](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_tag_role(RoleName, Tags)
#'
#' @param RoleName &#91;required&#93; The name of the role that you want to add tags to.
#' 
#' This parameter accepts (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters that
#' consist of upper and lowercase alphanumeric characters with no spaces.
#' You can also include any of the following characters: \\_+=,.@-
#' @param Tags &#91;required&#93; The list of tags that you want to attach to the role. Each tag consists
#' of a key name and an associated value. You can specify this with a JSON
#' string.
#'
#' @section Request syntax:
#' ```
#' svc$tag_role(
#'   RoleName = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # The following example shows how to add tags to an existing role.
#' \donttest{svc$tag_role(
#'   RoleName = "taggedrole",
#'   Tags = list(
#'     list(
#'       Key = "Dept",
#'       Value = "Accounting"
#'     ),
#'     list(
#'       Key = "CostCenter",
#'       Value = "12345"
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_tag_role
iam_tag_role <- function(RoleName, Tags) {
  op <- new_operation(
    name = "TagRole",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$tag_role_input(RoleName = RoleName, Tags = Tags)
  output <- .iam$tag_role_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$tag_role <- iam_tag_role

#' Adds one or more tags to an IAM user
#'
#' Adds one or more tags to an IAM user. If a tag with the same key name
#' already exists, then that tag is overwritten with the new value.
#' 
#' A tag consists of a key name and an associated value. By assigning tags
#' to your resources, you can do the following:
#' 
#' -   **Administrative grouping and discovery** - Attach tags to resources
#'     to aid in organization and search. For example, you could search for
#'     all resources with the key name *Project* and the value
#'     *MyImportantProject*. Or search for all resources with the key name
#'     *Cost Center* and the value *41200*.
#' 
#' -   **Access control** - Reference tags in IAM user-based and
#'     resource-based policies. You can use tags to restrict access to only
#'     an IAM requesting user or to a role that has a specified tag
#'     attached. You can also restrict access to only those resources that
#'     have a certain tag attached. For examples of policies that show how
#'     to use tags to control access, see [Control Access Using IAM
#'     Tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html)
#'     in the *IAM User Guide*.
#' 
#' -   **Cost allocation** - Use tags to help track which individuals and
#'     teams are using which AWS resources.
#' 
#' <!-- -->
#' 
#' -   Make sure that you have no invalid tags and that you do not exceed
#'     the allowed number of tags per role. In either case, the entire
#'     request fails and *no* tags are added to the role.
#' 
#' -   AWS always interprets the tag `Value` as a single string. If you
#'     need to store an array, you can store comma-separated values in the
#'     string. However, you must interpret the value in your code.
#' 
#' For more information about tagging, see [Tagging IAM
#' Identities](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_tag_user(UserName, Tags)
#'
#' @param UserName &#91;required&#93; The name of the user that you want to add tags to.
#' 
#' This parameter accepts (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters that
#' consist of upper and lowercase alphanumeric characters with no spaces.
#' You can also include any of the following characters: =,.@-
#' @param Tags &#91;required&#93; The list of tags that you want to attach to the user. Each tag consists
#' of a key name and an associated value.
#'
#' @section Request syntax:
#' ```
#' svc$tag_user(
#'   UserName = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # The following example shows how to add tags to an existing user.
#' \donttest{svc$tag_user(
#'   Tags = list(
#'     list(
#'       Key = "Dept",
#'       Value = "Accounting"
#'     ),
#'     list(
#'       Key = "CostCenter",
#'       Value = "12345"
#'     )
#'   ),
#'   UserName = "anika"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_tag_user
iam_tag_user <- function(UserName, Tags) {
  op <- new_operation(
    name = "TagUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$tag_user_input(UserName = UserName, Tags = Tags)
  output <- .iam$tag_user_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$tag_user <- iam_tag_user

#' Removes the specified tags from the role
#'
#' Removes the specified tags from the role. For more information about
#' tagging, see [Tagging IAM
#' Identities](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_untag_role(RoleName, TagKeys)
#'
#' @param RoleName &#91;required&#93; The name of the IAM role from which you want to remove tags.
#' 
#' This parameter accepts (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters that
#' consist of upper and lowercase alphanumeric characters with no spaces.
#' You can also include any of the following characters: \\_+=,.@-
#' @param TagKeys &#91;required&#93; A list of key names as a simple array of strings. The tags with matching
#' keys are removed from the specified role.
#'
#' @section Request syntax:
#' ```
#' svc$untag_role(
#'   RoleName = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # The following example shows how to remove a tag with the key 'Dept' from
#' # a role named 'taggedrole'.
#' \donttest{svc$untag_role(
#'   RoleName = "taggedrole",
#'   TagKeys = list(
#'     "Dept"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_untag_role
iam_untag_role <- function(RoleName, TagKeys) {
  op <- new_operation(
    name = "UntagRole",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$untag_role_input(RoleName = RoleName, TagKeys = TagKeys)
  output <- .iam$untag_role_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$untag_role <- iam_untag_role

#' Removes the specified tags from the user
#'
#' Removes the specified tags from the user. For more information about
#' tagging, see [Tagging IAM
#' Identities](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_untag_user(UserName, TagKeys)
#'
#' @param UserName &#91;required&#93; The name of the IAM user from which you want to remove tags.
#' 
#' This parameter accepts (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters that
#' consist of upper and lowercase alphanumeric characters with no spaces.
#' You can also include any of the following characters: =,.@-
#' @param TagKeys &#91;required&#93; A list of key names as a simple array of strings. The tags with matching
#' keys are removed from the specified user.
#'
#' @section Request syntax:
#' ```
#' svc$untag_user(
#'   UserName = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # The following example shows how to remove tags that are attached to a
#' # user named 'anika'.
#' \donttest{svc$untag_user(
#'   TagKeys = list(
#'     "Dept"
#'   ),
#'   UserName = "anika"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_untag_user
iam_untag_user <- function(UserName, TagKeys) {
  op <- new_operation(
    name = "UntagUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$untag_user_input(UserName = UserName, TagKeys = TagKeys)
  output <- .iam$untag_user_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$untag_user <- iam_untag_user

#' Changes the status of the specified access key from Active to Inactive,
#' or vice versa
#'
#' Changes the status of the specified access key from Active to Inactive,
#' or vice versa. This operation can be used to disable a user\'s key as
#' part of a key rotation workflow.
#' 
#' If the `UserName` is not specified, the user name is determined
#' implicitly based on the AWS access key ID used to sign the request. This
#' operation works for access keys under the AWS account. Consequently, you
#' can use this operation to manage AWS account root user credentials even
#' if the AWS account has no associated users.
#' 
#' For information about rotating keys, see [Managing Keys and
#' Certificates](https://docs.aws.amazon.com/IAM/latest/UserGuide/ManagingCredentials.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_update_access_key(UserName, AccessKeyId, Status)
#'
#' @param UserName The name of the user whose key you want to update.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param AccessKeyId &#91;required&#93; The access key ID of the secret access key you want to update.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters that
#' can consist of any upper or lowercased letter or digit.
#' @param Status &#91;required&#93; The status you want to assign to the secret access key. `Active` means
#' that the key can be used for API calls to AWS, while `Inactive` means
#' that the key cannot be used.
#'
#' @section Request syntax:
#' ```
#' svc$update_access_key(
#'   UserName = "string",
#'   AccessKeyId = "string",
#'   Status = "Active"|"Inactive"
#' )
#' ```
#'
#' @examples
#' # The following command deactivates the specified access key (access key
#' # ID and secret access key) for the IAM user named Bob.
#' \donttest{svc$update_access_key(
#'   AccessKeyId = "AKIAIOSFODNN7EXAMPLE",
#'   Status = "Inactive",
#'   UserName = "Bob"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_update_access_key
iam_update_access_key <- function(UserName = NULL, AccessKeyId, Status) {
  op <- new_operation(
    name = "UpdateAccessKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$update_access_key_input(UserName = UserName, AccessKeyId = AccessKeyId, Status = Status)
  output <- .iam$update_access_key_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$update_access_key <- iam_update_access_key

#' Updates the password policy settings for the AWS account
#'
#' Updates the password policy settings for the AWS account.
#' 
#' -   This operation does not support partial updates. No parameters are
#'     required, but if you do not specify a parameter, that parameter\'s
#'     value reverts to its default value. See the **Request Parameters**
#'     section for each parameter\'s default value. Also note that some
#'     parameters do not allow the default parameter to be explicitly set.
#'     Instead, to invoke the default value, do not include that parameter
#'     when you invoke the operation.
#' 
#' For more information about using a password policy, see [Managing an IAM
#' Password
#' Policy](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingPasswordPolicies.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_update_account_password_policy(MinimumPasswordLength,
#'   RequireSymbols, RequireNumbers, RequireUppercaseCharacters,
#'   RequireLowercaseCharacters, AllowUsersToChangePassword, MaxPasswordAge,
#'   PasswordReusePrevention, HardExpiry)
#'
#' @param MinimumPasswordLength The minimum number of characters allowed in an IAM user password.
#' 
#' If you do not specify a value for this parameter, then the operation
#' uses the default value of `6`.
#' @param RequireSymbols Specifies whether IAM user passwords must contain at least one of the
#' following non-alphanumeric characters:
#' 
#' ! @ \\# \\$ \% \\^ & \* ( ) \\_ + - = \[ \] \{ \} \\| \'
#' 
#' If you do not specify a value for this parameter, then the operation
#' uses the default value of `false`. The result is that passwords do not
#' require at least one symbol character.
#' @param RequireNumbers Specifies whether IAM user passwords must contain at least one numeric
#' character (0 to 9).
#' 
#' If you do not specify a value for this parameter, then the operation
#' uses the default value of `false`. The result is that passwords do not
#' require at least one numeric character.
#' @param RequireUppercaseCharacters Specifies whether IAM user passwords must contain at least one uppercase
#' character from the ISO basic Latin alphabet (A to Z).
#' 
#' If you do not specify a value for this parameter, then the operation
#' uses the default value of `false`. The result is that passwords do not
#' require at least one uppercase character.
#' @param RequireLowercaseCharacters Specifies whether IAM user passwords must contain at least one lowercase
#' character from the ISO basic Latin alphabet (a to z).
#' 
#' If you do not specify a value for this parameter, then the operation
#' uses the default value of `false`. The result is that passwords do not
#' require at least one lowercase character.
#' @param AllowUsersToChangePassword Allows all IAM users in your account to use the AWS Management Console
#' to change their own passwords. For more information, see [Letting IAM
#' Users Change Their Own
#' Passwords](https://docs.aws.amazon.com/IAM/latest/UserGuide/HowToPwdIAMUser.html)
#' in the *IAM User Guide*.
#' 
#' If you do not specify a value for this parameter, then the operation
#' uses the default value of `false`. The result is that IAM users in the
#' account do not automatically have permissions to change their own
#' password.
#' @param MaxPasswordAge The number of days that an IAM user password is valid.
#' 
#' If you do not specify a value for this parameter, then the operation
#' uses the default value of `0`. The result is that IAM user passwords
#' never expire.
#' @param PasswordReusePrevention Specifies the number of previous passwords that IAM users are prevented
#' from reusing.
#' 
#' If you do not specify a value for this parameter, then the operation
#' uses the default value of `0`. The result is that IAM users are not
#' prevented from reusing previous passwords.
#' @param HardExpiry Prevents IAM users from setting a new password after their password has
#' expired. The IAM user cannot be accessed until an administrator resets
#' the password.
#' 
#' If you do not specify a value for this parameter, then the operation
#' uses the default value of `false`. The result is that IAM users can
#' change their passwords after they expire and continue to sign in as the
#' user.
#'
#' @section Request syntax:
#' ```
#' svc$update_account_password_policy(
#'   MinimumPasswordLength = 123,
#'   RequireSymbols = TRUE|FALSE,
#'   RequireNumbers = TRUE|FALSE,
#'   RequireUppercaseCharacters = TRUE|FALSE,
#'   RequireLowercaseCharacters = TRUE|FALSE,
#'   AllowUsersToChangePassword = TRUE|FALSE,
#'   MaxPasswordAge = 123,
#'   PasswordReusePrevention = 123,
#'   HardExpiry = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # The following command sets the password policy to require a minimum
#' # length of eight characters and to require one or more numbers in the
#' # password:
#' \donttest{svc$update_account_password_policy(
#'   MinimumPasswordLength = 8L,
#'   RequireNumbers = TRUE
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_update_account_password_policy
iam_update_account_password_policy <- function(MinimumPasswordLength = NULL, RequireSymbols = NULL, RequireNumbers = NULL, RequireUppercaseCharacters = NULL, RequireLowercaseCharacters = NULL, AllowUsersToChangePassword = NULL, MaxPasswordAge = NULL, PasswordReusePrevention = NULL, HardExpiry = NULL) {
  op <- new_operation(
    name = "UpdateAccountPasswordPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$update_account_password_policy_input(MinimumPasswordLength = MinimumPasswordLength, RequireSymbols = RequireSymbols, RequireNumbers = RequireNumbers, RequireUppercaseCharacters = RequireUppercaseCharacters, RequireLowercaseCharacters = RequireLowercaseCharacters, AllowUsersToChangePassword = AllowUsersToChangePassword, MaxPasswordAge = MaxPasswordAge, PasswordReusePrevention = PasswordReusePrevention, HardExpiry = HardExpiry)
  output <- .iam$update_account_password_policy_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$update_account_password_policy <- iam_update_account_password_policy

#' Updates the policy that grants an IAM entity permission to assume a role
#'
#' Updates the policy that grants an IAM entity permission to assume a
#' role. This is typically referred to as the \"role trust policy\". For
#' more information about roles, go to [Using Roles to Delegate Permissions
#' and Federate
#' Identities](https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html).
#'
#' @usage
#' iam_update_assume_role_policy(RoleName, PolicyDocument)
#'
#' @param RoleName &#91;required&#93; The name of the role to update with the new policy.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param PolicyDocument &#91;required&#93; The policy that grants an entity permission to assume the role.
#' 
#' You must provide policies in JSON format in IAM. However, for AWS
#' CloudFormation templates formatted in YAML, you can provide the policy
#' in JSON or YAML format. AWS CloudFormation always converts a YAML policy
#' to JSON format before submitting it to IAM.
#' 
#' The [regex pattern](http://wikipedia.org/wiki/regex) used to validate
#' this parameter is a string of characters consisting of the following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (`U+0020`) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through `U+00FF`)
#' 
#' -   The special characters tab (`U+0009`), line feed (`U+000A`), and
#'     carriage return (`U+000D`)
#'
#' @section Request syntax:
#' ```
#' svc$update_assume_role_policy(
#'   RoleName = "string",
#'   PolicyDocument = "string"
#' )
#' ```
#'
#' @examples
#' # The following command updates the role trust policy for the role named
#' # Test-Role:
#' \donttest{svc$update_assume_role_policy(
#'   PolicyDocument = "{\"Version\":\"2012-10-17\",\"Statement\":[{\"Effect\":\"Allow\",...",
#'   RoleName = "S3AccessForEC2Instances"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_update_assume_role_policy
iam_update_assume_role_policy <- function(RoleName, PolicyDocument) {
  op <- new_operation(
    name = "UpdateAssumeRolePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$update_assume_role_policy_input(RoleName = RoleName, PolicyDocument = PolicyDocument)
  output <- .iam$update_assume_role_policy_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$update_assume_role_policy <- iam_update_assume_role_policy

#' Updates the name and/or the path of the specified IAM group
#'
#' Updates the name and/or the path of the specified IAM group.
#' 
#' You should understand the implications of changing a group\'s path or
#' name. For more information, see [Renaming Users and
#' Groups](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_WorkingWithGroupsAndUsers.html)
#' in the *IAM User Guide*.
#' 
#' The person making the request (the principal), must have permission to
#' change the role group with the old name and the new name. For example,
#' to change the group named `Managers` to `MGRs`, the principal must have
#' a policy that allows them to update both groups. If the principal has
#' permission to update the `Managers` group, but not the `MGRs` group,
#' then the update fails. For more information about permissions, see
#' [Access
#' Management](https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html).
#'
#' @usage
#' iam_update_group(GroupName, NewPath, NewGroupName)
#'
#' @param GroupName &#91;required&#93; Name of the IAM group to update. If you\'re changing the name of the
#' group, this is the original name.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param NewPath New path for the IAM group. Only include this if changing the group\'s
#' path.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of either a forward slash (/) by itself or a string that must
#' begin and end with forward slashes. In addition, it can contain any
#' ASCII character from the ! (`U+0021`) through the DEL character
#' (`U+007F`), including most punctuation characters, digits, and upper and
#' lowercased letters.
#' @param NewGroupName New name for the IAM group. Only include this if changing the group\'s
#' name.
#' 
#' IAM user, group, role, and policy names must be unique within the
#' account. Names are not distinguished by case. For example, you cannot
#' create resources named both \"MyResource\" and \"myresource\".
#'
#' @section Request syntax:
#' ```
#' svc$update_group(
#'   GroupName = "string",
#'   NewPath = "string",
#'   NewGroupName = "string"
#' )
#' ```
#'
#' @examples
#' # The following command changes the name of the IAM group Test to Test-1.
#' \donttest{svc$update_group(
#'   GroupName = "Test",
#'   NewGroupName = "Test-1"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_update_group
iam_update_group <- function(GroupName, NewPath = NULL, NewGroupName = NULL) {
  op <- new_operation(
    name = "UpdateGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$update_group_input(GroupName = GroupName, NewPath = NewPath, NewGroupName = NewGroupName)
  output <- .iam$update_group_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$update_group <- iam_update_group

#' Changes the password for the specified IAM user
#'
#' Changes the password for the specified IAM user.
#' 
#' IAM users can change their own passwords by calling ChangePassword. For
#' more information about modifying passwords, see [Managing
#' Passwords](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_update_login_profile(UserName, Password, PasswordResetRequired)
#'
#' @param UserName &#91;required&#93; The name of the user whose password you want to update.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param Password The new password for the specified IAM user.
#' 
#' The [regex pattern](http://wikipedia.org/wiki/regex) used to validate
#' this parameter is a string of characters consisting of the following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (`U+0020`) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through `U+00FF`)
#' 
#' -   The special characters tab (`U+0009`), line feed (`U+000A`), and
#'     carriage return (`U+000D`)
#' 
#' However, the format can be further restricted by the account
#' administrator by setting a password policy on the AWS account. For more
#' information, see UpdateAccountPasswordPolicy.
#' @param PasswordResetRequired Allows this new password to be used only once by requiring the specified
#' IAM user to set a new password on next sign-in.
#'
#' @section Request syntax:
#' ```
#' svc$update_login_profile(
#'   UserName = "string",
#'   Password = "string",
#'   PasswordResetRequired = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # The following command creates or changes the password for the IAM user
#' # named Bob.
#' \donttest{svc$update_login_profile(
#'   Password = "SomeKindOfPassword123!@#",
#'   UserName = "Bob"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_update_login_profile
iam_update_login_profile <- function(UserName, Password = NULL, PasswordResetRequired = NULL) {
  op <- new_operation(
    name = "UpdateLoginProfile",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$update_login_profile_input(UserName = UserName, Password = Password, PasswordResetRequired = PasswordResetRequired)
  output <- .iam$update_login_profile_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$update_login_profile <- iam_update_login_profile

#' Replaces the existing list of server certificate thumbprints associated
#' with an OpenID Connect (OIDC) provider resource object with a new list
#' of thumbprints
#'
#' Replaces the existing list of server certificate thumbprints associated
#' with an OpenID Connect (OIDC) provider resource object with a new list
#' of thumbprints.
#' 
#' The list that you pass with this operation completely replaces the
#' existing list of thumbprints. (The lists are not merged.)
#' 
#' Typically, you need to update a thumbprint only when the identity
#' provider\'s certificate changes, which occurs rarely. However, if the
#' provider\'s certificate *does* change, any attempt to assume an IAM role
#' that specifies the OIDC provider as a principal fails until the
#' certificate thumbprint is updated.
#' 
#' Trust for the OIDC provider is derived from the provider\'s certificate
#' and is validated by the thumbprint. Therefore, it is best to limit
#' access to the `UpdateOpenIDConnectProviderThumbprint` operation to
#' highly privileged users.
#'
#' @usage
#' iam_update_open_id_connect_provider_thumbprint(OpenIDConnectProviderArn,
#'   ThumbprintList)
#'
#' @param OpenIDConnectProviderArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM OIDC provider resource object
#' for which you want to update the thumbprint. You can get a list of OIDC
#' provider ARNs by using the ListOpenIDConnectProviders operation.
#' 
#' For more information about ARNs, see [Amazon Resource Names (ARNs) and
#' AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#' @param ThumbprintList &#91;required&#93; A list of certificate thumbprints that are associated with the specified
#' IAM OpenID Connect provider. For more information, see
#' CreateOpenIDConnectProvider.
#'
#' @section Request syntax:
#' ```
#' svc$update_open_id_connect_provider_thumbprint(
#'   OpenIDConnectProviderArn = "string",
#'   ThumbprintList = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_update_open_id_connect_provider_thumbprint
iam_update_open_id_connect_provider_thumbprint <- function(OpenIDConnectProviderArn, ThumbprintList) {
  op <- new_operation(
    name = "UpdateOpenIDConnectProviderThumbprint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$update_open_id_connect_provider_thumbprint_input(OpenIDConnectProviderArn = OpenIDConnectProviderArn, ThumbprintList = ThumbprintList)
  output <- .iam$update_open_id_connect_provider_thumbprint_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$update_open_id_connect_provider_thumbprint <- iam_update_open_id_connect_provider_thumbprint

#' Updates the description or maximum session duration setting of a role
#'
#' Updates the description or maximum session duration setting of a role.
#'
#' @usage
#' iam_update_role(RoleName, Description, MaxSessionDuration)
#'
#' @param RoleName &#91;required&#93; The name of the role that you want to modify.
#' @param Description The new description that you want to apply to the specified role.
#' @param MaxSessionDuration The maximum session duration (in seconds) that you want to set for the
#' specified role. If you do not specify a value for this setting, the
#' default maximum of one hour is applied. This setting can have a value
#' from 1 hour to 12 hours.
#' 
#' Anyone who assumes the role from the AWS CLI or API can use the
#' `DurationSeconds` API parameter or the `duration-seconds` CLI parameter
#' to request a longer session. The `MaxSessionDuration` setting determines
#' the maximum duration that can be requested using the `DurationSeconds`
#' parameter. If users don\'t specify a value for the `DurationSeconds`
#' parameter, their security credentials are valid for one hour by default.
#' This applies when you use the `AssumeRole*` API operations or the
#' `assume-role*` CLI operations but does not apply when you use those
#' operations to create a console URL. For more information, see [Using IAM
#' Roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html)
#' in the *IAM User Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$update_role(
#'   RoleName = "string",
#'   Description = "string",
#'   MaxSessionDuration = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_update_role
iam_update_role <- function(RoleName, Description = NULL, MaxSessionDuration = NULL) {
  op <- new_operation(
    name = "UpdateRole",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$update_role_input(RoleName = RoleName, Description = Description, MaxSessionDuration = MaxSessionDuration)
  output <- .iam$update_role_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$update_role <- iam_update_role

#' Use UpdateRole instead
#'
#' Use UpdateRole instead.
#' 
#' Modifies only the description of a role. This operation performs the
#' same function as the `Description` parameter in the `UpdateRole`
#' operation.
#'
#' @usage
#' iam_update_role_description(RoleName, Description)
#'
#' @param RoleName &#91;required&#93; The name of the role that you want to modify.
#' @param Description &#91;required&#93; The new description that you want to apply to the specified role.
#'
#' @section Request syntax:
#' ```
#' svc$update_role_description(
#'   RoleName = "string",
#'   Description = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_update_role_description
iam_update_role_description <- function(RoleName, Description) {
  op <- new_operation(
    name = "UpdateRoleDescription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$update_role_description_input(RoleName = RoleName, Description = Description)
  output <- .iam$update_role_description_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$update_role_description <- iam_update_role_description

#' Updates the metadata document for an existing SAML provider resource
#' object
#'
#' Updates the metadata document for an existing SAML provider resource
#' object.
#' 
#' This operation requires [Signature Version
#' 4](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
#'
#' @usage
#' iam_update_saml_provider(SAMLMetadataDocument, SAMLProviderArn)
#'
#' @param SAMLMetadataDocument &#91;required&#93; An XML document generated by an identity provider (IdP) that supports
#' SAML 2.0. The document includes the issuer\'s name, expiration
#' information, and keys that can be used to validate the SAML
#' authentication response (assertions) that are received from the IdP. You
#' must generate the metadata document using the identity management
#' software that is used as your organization\'s IdP.
#' @param SAMLProviderArn &#91;required&#93; The Amazon Resource Name (ARN) of the SAML provider to update.
#' 
#' For more information about ARNs, see [Amazon Resource Names (ARNs) and
#' AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *AWS General Reference*.
#'
#' @section Request syntax:
#' ```
#' svc$update_saml_provider(
#'   SAMLMetadataDocument = "string",
#'   SAMLProviderArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_update_saml_provider
iam_update_saml_provider <- function(SAMLMetadataDocument, SAMLProviderArn) {
  op <- new_operation(
    name = "UpdateSAMLProvider",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$update_saml_provider_input(SAMLMetadataDocument = SAMLMetadataDocument, SAMLProviderArn = SAMLProviderArn)
  output <- .iam$update_saml_provider_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$update_saml_provider <- iam_update_saml_provider

#' Sets the status of an IAM user's SSH public key to active or inactive
#'
#' Sets the status of an IAM user\'s SSH public key to active or inactive.
#' SSH public keys that are inactive cannot be used for authentication.
#' This operation can be used to disable a user\'s SSH public key as part
#' of a key rotation work flow.
#' 
#' The SSH public key affected by this operation is used only for
#' authenticating the associated IAM user to an AWS CodeCommit repository.
#' For more information about using SSH keys to authenticate to an AWS
#' CodeCommit repository, see [Set up AWS CodeCommit for SSH
#' Connections](https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html)
#' in the *AWS CodeCommit User Guide*.
#'
#' @usage
#' iam_update_ssh_public_key(UserName, SSHPublicKeyId, Status)
#'
#' @param UserName &#91;required&#93; The name of the IAM user associated with the SSH public key.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param SSHPublicKeyId &#91;required&#93; The unique identifier for the SSH public key.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters that
#' can consist of any upper or lowercased letter or digit.
#' @param Status &#91;required&#93; The status to assign to the SSH public key. `Active` means that the key
#' can be used for authentication with an AWS CodeCommit repository.
#' `Inactive` means that the key cannot be used.
#'
#' @section Request syntax:
#' ```
#' svc$update_ssh_public_key(
#'   UserName = "string",
#'   SSHPublicKeyId = "string",
#'   Status = "Active"|"Inactive"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_update_ssh_public_key
iam_update_ssh_public_key <- function(UserName, SSHPublicKeyId, Status) {
  op <- new_operation(
    name = "UpdateSSHPublicKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$update_ssh_public_key_input(UserName = UserName, SSHPublicKeyId = SSHPublicKeyId, Status = Status)
  output <- .iam$update_ssh_public_key_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$update_ssh_public_key <- iam_update_ssh_public_key

#' Updates the name and/or the path of the specified server certificate
#' stored in IAM
#'
#' Updates the name and/or the path of the specified server certificate
#' stored in IAM.
#' 
#' For more information about working with server certificates, see
#' [Working with Server
#' Certificates](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html)
#' in the *IAM User Guide*. This topic also includes a list of AWS services
#' that can use the server certificates that you manage with IAM.
#' 
#' You should understand the implications of changing a server
#' certificate\'s path or name. For more information, see [Renaming a
#' Server
#' Certificate](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs_manage.html#RenamingServerCerts)
#' in the *IAM User Guide*.
#' 
#' The person making the request (the principal), must have permission to
#' change the server certificate with the old name and the new name. For
#' example, to change the certificate named `ProductionCert` to `ProdCert`,
#' the principal must have a policy that allows them to update both
#' certificates. If the principal has permission to update the
#' `ProductionCert` group, but not the `ProdCert` certificate, then the
#' update fails. For more information about permissions, see [Access
#' Management](https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_update_server_certificate(ServerCertificateName, NewPath,
#'   NewServerCertificateName)
#'
#' @param ServerCertificateName &#91;required&#93; The name of the server certificate that you want to update.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param NewPath The new path for the server certificate. Include this only if you are
#' updating the server certificate\'s path.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of either a forward slash (/) by itself or a string that must
#' begin and end with forward slashes. In addition, it can contain any
#' ASCII character from the ! (`U+0021`) through the DEL character
#' (`U+007F`), including most punctuation characters, digits, and upper and
#' lowercased letters.
#' @param NewServerCertificateName The new name for the server certificate. Include this only if you are
#' updating the server certificate\'s name. The name of the certificate
#' cannot contain any spaces.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#'
#' @section Request syntax:
#' ```
#' svc$update_server_certificate(
#'   ServerCertificateName = "string",
#'   NewPath = "string",
#'   NewServerCertificateName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_update_server_certificate
iam_update_server_certificate <- function(ServerCertificateName, NewPath = NULL, NewServerCertificateName = NULL) {
  op <- new_operation(
    name = "UpdateServerCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$update_server_certificate_input(ServerCertificateName = ServerCertificateName, NewPath = NewPath, NewServerCertificateName = NewServerCertificateName)
  output <- .iam$update_server_certificate_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$update_server_certificate <- iam_update_server_certificate

#' Sets the status of a service-specific credential to Active or Inactive
#'
#' Sets the status of a service-specific credential to `Active` or
#' `Inactive`. Service-specific credentials that are inactive cannot be
#' used for authentication to the service. This operation can be used to
#' disable a user\'s service-specific credential as part of a credential
#' rotation work flow.
#'
#' @usage
#' iam_update_service_specific_credential(UserName,
#'   ServiceSpecificCredentialId, Status)
#'
#' @param UserName The name of the IAM user associated with the service-specific
#' credential. If you do not specify this value, then the operation assumes
#' the user whose credentials are used to call the operation.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param ServiceSpecificCredentialId &#91;required&#93; The unique identifier of the service-specific credential.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters that
#' can consist of any upper or lowercased letter or digit.
#' @param Status &#91;required&#93; The status to be assigned to the service-specific credential.
#'
#' @section Request syntax:
#' ```
#' svc$update_service_specific_credential(
#'   UserName = "string",
#'   ServiceSpecificCredentialId = "string",
#'   Status = "Active"|"Inactive"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_update_service_specific_credential
iam_update_service_specific_credential <- function(UserName = NULL, ServiceSpecificCredentialId, Status) {
  op <- new_operation(
    name = "UpdateServiceSpecificCredential",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$update_service_specific_credential_input(UserName = UserName, ServiceSpecificCredentialId = ServiceSpecificCredentialId, Status = Status)
  output <- .iam$update_service_specific_credential_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$update_service_specific_credential <- iam_update_service_specific_credential

#' Changes the status of the specified user signing certificate from active
#' to disabled, or vice versa
#'
#' Changes the status of the specified user signing certificate from active
#' to disabled, or vice versa. This operation can be used to disable an IAM
#' user\'s signing certificate as part of a certificate rotation work flow.
#' 
#' If the `UserName` field is not specified, the user name is determined
#' implicitly based on the AWS access key ID used to sign the request. This
#' operation works for access keys under the AWS account. Consequently, you
#' can use this operation to manage AWS account root user credentials even
#' if the AWS account has no associated users.
#'
#' @usage
#' iam_update_signing_certificate(UserName, CertificateId, Status)
#'
#' @param UserName The name of the IAM user the signing certificate belongs to.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param CertificateId &#91;required&#93; The ID of the signing certificate you want to update.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters that
#' can consist of any upper or lowercased letter or digit.
#' @param Status &#91;required&#93; The status you want to assign to the certificate. `Active` means that
#' the certificate can be used for API calls to AWS `Inactive` means that
#' the certificate cannot be used.
#'
#' @section Request syntax:
#' ```
#' svc$update_signing_certificate(
#'   UserName = "string",
#'   CertificateId = "string",
#'   Status = "Active"|"Inactive"
#' )
#' ```
#'
#' @examples
#' # The following command changes the status of a signing certificate for a
#' # user named Bob to Inactive.
#' \donttest{svc$update_signing_certificate(
#'   CertificateId = "TA7SMP42TDN5Z26OBPJE7EXAMPLE",
#'   Status = "Inactive",
#'   UserName = "Bob"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_update_signing_certificate
iam_update_signing_certificate <- function(UserName = NULL, CertificateId, Status) {
  op <- new_operation(
    name = "UpdateSigningCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$update_signing_certificate_input(UserName = UserName, CertificateId = CertificateId, Status = Status)
  output <- .iam$update_signing_certificate_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$update_signing_certificate <- iam_update_signing_certificate

#' Updates the name and/or the path of the specified IAM user
#'
#' Updates the name and/or the path of the specified IAM user.
#' 
#' You should understand the implications of changing an IAM user\'s path
#' or name. For more information, see [Renaming an IAM
#' User](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users_manage.html#id_users_renaming)
#' and [Renaming an IAM
#' Group](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_groups_manage_rename.html)
#' in the *IAM User Guide*.
#' 
#' To change a user name, the requester must have appropriate permissions
#' on both the source object and the target object. For example, to change
#' Bob to Robert, the entity making the request must have permission on Bob
#' and Robert, or must have permission on all (\*). For more information
#' about permissions, see [Permissions and
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/PermissionsAndPolicies.html).
#'
#' @usage
#' iam_update_user(UserName, NewPath, NewUserName)
#'
#' @param UserName &#91;required&#93; Name of the user to update. If you\'re changing the name of the user,
#' this is the original user name.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param NewPath New path for the IAM user. Include this parameter only if you\'re
#' changing the user\'s path.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of either a forward slash (/) by itself or a string that must
#' begin and end with forward slashes. In addition, it can contain any
#' ASCII character from the ! (`U+0021`) through the DEL character
#' (`U+007F`), including most punctuation characters, digits, and upper and
#' lowercased letters.
#' @param NewUserName New name for the user. Include this parameter only if you\'re changing
#' the user\'s name.
#' 
#' IAM user, group, role, and policy names must be unique within the
#' account. Names are not distinguished by case. For example, you cannot
#' create resources named both \"MyResource\" and \"myresource\".
#'
#' @section Request syntax:
#' ```
#' svc$update_user(
#'   UserName = "string",
#'   NewPath = "string",
#'   NewUserName = "string"
#' )
#' ```
#'
#' @examples
#' # The following command changes the name of the IAM user Bob to Robert. It
#' # does not change the user's path.
#' \donttest{svc$update_user(
#'   NewUserName = "Robert",
#'   UserName = "Bob"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_update_user
iam_update_user <- function(UserName, NewPath = NULL, NewUserName = NULL) {
  op <- new_operation(
    name = "UpdateUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$update_user_input(UserName = UserName, NewPath = NewPath, NewUserName = NewUserName)
  output <- .iam$update_user_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$update_user <- iam_update_user

#' Uploads an SSH public key and associates it with the specified IAM user
#'
#' Uploads an SSH public key and associates it with the specified IAM user.
#' 
#' The SSH public key uploaded by this operation can be used only for
#' authenticating the associated IAM user to an AWS CodeCommit repository.
#' For more information about using SSH keys to authenticate to an AWS
#' CodeCommit repository, see [Set up AWS CodeCommit for SSH
#' Connections](https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html)
#' in the *AWS CodeCommit User Guide*.
#'
#' @usage
#' iam_upload_ssh_public_key(UserName, SSHPublicKeyBody)
#'
#' @param UserName &#91;required&#93; The name of the IAM user to associate the SSH public key with.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param SSHPublicKeyBody &#91;required&#93; The SSH public key. The public key must be encoded in ssh-rsa format or
#' PEM format. The minimum bit-length of the public key is 2048 bits. For
#' example, you can generate a 2048-bit key, and the resulting PEM file is
#' 1679 bytes long.
#' 
#' The [regex pattern](http://wikipedia.org/wiki/regex) used to validate
#' this parameter is a string of characters consisting of the following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (`U+0020`) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through `U+00FF`)
#' 
#' -   The special characters tab (`U+0009`), line feed (`U+000A`), and
#'     carriage return (`U+000D`)
#'
#' @section Request syntax:
#' ```
#' svc$upload_ssh_public_key(
#'   UserName = "string",
#'   SSHPublicKeyBody = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname iam_upload_ssh_public_key
iam_upload_ssh_public_key <- function(UserName, SSHPublicKeyBody) {
  op <- new_operation(
    name = "UploadSSHPublicKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$upload_ssh_public_key_input(UserName = UserName, SSHPublicKeyBody = SSHPublicKeyBody)
  output <- .iam$upload_ssh_public_key_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$upload_ssh_public_key <- iam_upload_ssh_public_key

#' Uploads a server certificate entity for the AWS account
#'
#' Uploads a server certificate entity for the AWS account. The server
#' certificate entity includes a public key certificate, a private key, and
#' an optional certificate chain, which should all be PEM-encoded.
#' 
#' We recommend that you use [AWS Certificate
#' Manager](https://docs.aws.amazon.com/acm/) to provision, manage, and
#' deploy your server certificates. With ACM you can request a certificate,
#' deploy it to AWS resources, and let ACM handle certificate renewals for
#' you. Certificates provided by ACM are free. For more information about
#' using ACM, see the [AWS Certificate Manager User
#' Guide](https://docs.aws.amazon.com/acm/latest/userguide/).
#' 
#' For more information about working with server certificates, see
#' [Working with Server
#' Certificates](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html)
#' in the *IAM User Guide*. This topic includes a list of AWS services that
#' can use the server certificates that you manage with IAM.
#' 
#' For information about the number of server certificates you can upload,
#' see [Limitations on IAM Entities and
#' Objects](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-limits.html)
#' in the *IAM User Guide*.
#' 
#' Because the body of the public key certificate, private key, and the
#' certificate chain can be large, you should use POST rather than GET when
#' calling `UploadServerCertificate`. For information about setting up
#' signatures and authorization through the API, go to [Signing AWS API
#' Requests](https://docs.aws.amazon.com/general/latest/gr/signing_aws_api_requests.html)
#' in the *AWS General Reference*. For general information about using the
#' Query API with IAM, go to [Calling the API by Making HTTP Query
#' Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/programming.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_upload_server_certificate(Path, ServerCertificateName,
#'   CertificateBody, PrivateKey, CertificateChain)
#'
#' @param Path The path for the server certificate. For more information about paths,
#' see [IAM
#' Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
#' in the *IAM User Guide*.
#' 
#' This parameter is optional. If it is not included, it defaults to a
#' slash (/). This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of either a forward slash (/) by itself or a string that must
#' begin and end with forward slashes. In addition, it can contain any
#' ASCII character from the ! (`U+0021`) through the DEL character
#' (`U+007F`), including most punctuation characters, digits, and upper and
#' lowercased letters.
#' 
#' If you are uploading a server certificate specifically for use with
#' Amazon CloudFront distributions, you must specify a path using the
#' `path` parameter. The path must begin with `/cloudfront` and must
#' include a trailing slash (for example, `/cloudfront/test/`).
#' @param ServerCertificateName &#91;required&#93; The name for the server certificate. Do not include the path in this
#' value. The name of the certificate cannot contain any spaces.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param CertificateBody &#91;required&#93; The contents of the public key certificate in PEM-encoded format.
#' 
#' The [regex pattern](http://wikipedia.org/wiki/regex) used to validate
#' this parameter is a string of characters consisting of the following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (`U+0020`) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through `U+00FF`)
#' 
#' -   The special characters tab (`U+0009`), line feed (`U+000A`), and
#'     carriage return (`U+000D`)
#' @param PrivateKey &#91;required&#93; The contents of the private key in PEM-encoded format.
#' 
#' The [regex pattern](http://wikipedia.org/wiki/regex) used to validate
#' this parameter is a string of characters consisting of the following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (`U+0020`) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through `U+00FF`)
#' 
#' -   The special characters tab (`U+0009`), line feed (`U+000A`), and
#'     carriage return (`U+000D`)
#' @param CertificateChain The contents of the certificate chain. This is typically a concatenation
#' of the PEM-encoded public key certificates of the chain.
#' 
#' The [regex pattern](http://wikipedia.org/wiki/regex) used to validate
#' this parameter is a string of characters consisting of the following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (`U+0020`) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through `U+00FF`)
#' 
#' -   The special characters tab (`U+0009`), line feed (`U+000A`), and
#'     carriage return (`U+000D`)
#'
#' @section Request syntax:
#' ```
#' svc$upload_server_certificate(
#'   Path = "string",
#'   ServerCertificateName = "string",
#'   CertificateBody = "string",
#'   PrivateKey = "string",
#'   CertificateChain = "string"
#' )
#' ```
#'
#' @examples
#' # The following upload-server-certificate command uploads a server
#' # certificate to your AWS account:
#' \donttest{svc$upload_server_certificate(
#'   CertificateBody = "-----BEGIN CERTIFICATE-----<a very long certificate text string>-----EN...",
#'   Path = "/company/servercerts/",
#'   PrivateKey = "-----BEGIN DSA PRIVATE KEY-----<a very long private key string>-----END DSA ...",
#'   ServerCertificateName = "ProdServerCert"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_upload_server_certificate
iam_upload_server_certificate <- function(Path = NULL, ServerCertificateName, CertificateBody, PrivateKey, CertificateChain = NULL) {
  op <- new_operation(
    name = "UploadServerCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$upload_server_certificate_input(Path = Path, ServerCertificateName = ServerCertificateName, CertificateBody = CertificateBody, PrivateKey = PrivateKey, CertificateChain = CertificateChain)
  output <- .iam$upload_server_certificate_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$upload_server_certificate <- iam_upload_server_certificate

#' Uploads an X
#'
#' Uploads an X.509 signing certificate and associates it with the
#' specified IAM user. Some AWS services use X.509 signing certificates to
#' validate requests that are signed with a corresponding private key. When
#' you upload the certificate, its default status is `Active`.
#' 
#' If the `UserName` is not specified, the IAM user name is determined
#' implicitly based on the AWS access key ID used to sign the request. This
#' operation works for access keys under the AWS account. Consequently, you
#' can use this operation to manage AWS account root user credentials even
#' if the AWS account has no associated users.
#' 
#' Because the body of an X.509 certificate can be large, you should use
#' POST rather than GET when calling `UploadSigningCertificate`. For
#' information about setting up signatures and authorization through the
#' API, go to [Signing AWS API
#' Requests](https://docs.aws.amazon.com/general/latest/gr/signing_aws_api_requests.html)
#' in the *AWS General Reference*. For general information about using the
#' Query API with IAM, go to [Making Query
#' Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html)
#' in the *IAM User Guide*.
#'
#' @usage
#' iam_upload_signing_certificate(UserName, CertificateBody)
#'
#' @param UserName The name of the user the signing certificate is for.
#' 
#' This parameter allows (through its [regex
#' pattern](http://wikipedia.org/wiki/regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: \\_+=,.@-
#' @param CertificateBody &#91;required&#93; The contents of the signing certificate.
#' 
#' The [regex pattern](http://wikipedia.org/wiki/regex) used to validate
#' this parameter is a string of characters consisting of the following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (`U+0020`) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through `U+00FF`)
#' 
#' -   The special characters tab (`U+0009`), line feed (`U+000A`), and
#'     carriage return (`U+000D`)
#'
#' @section Request syntax:
#' ```
#' svc$upload_signing_certificate(
#'   UserName = "string",
#'   CertificateBody = "string"
#' )
#' ```
#'
#' @examples
#' # The following command uploads a signing certificate for the IAM user
#' # named Bob.
#' \donttest{svc$upload_signing_certificate(
#'   CertificateBody = "-----BEGIN CERTIFICATE-----<certificate-body>-----END CERTIFICATE-----",
#'   UserName = "Bob"
#' )}
#'
#' @keywords internal
#'
#' @rdname iam_upload_signing_certificate
iam_upload_signing_certificate <- function(UserName = NULL, CertificateBody) {
  op <- new_operation(
    name = "UploadSigningCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .iam$upload_signing_certificate_input(UserName = UserName, CertificateBody = CertificateBody)
  output <- .iam$upload_signing_certificate_output()
  svc <- .iam$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$upload_signing_certificate <- iam_upload_signing_certificate
