% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_list_users_in_group}
\alias{cognitoidentityprovider_list_users_in_group}
\title{Lists the users in the specified group}
\usage{
cognitoidentityprovider_list_users_in_group(UserPoolId, GroupName,
  Limit, NextToken)
}
\arguments{
\item{UserPoolId}{[required] The user pool ID for the user pool.}

\item{GroupName}{[required] The name of the group.}

\item{Limit}{The limit of the request to list users.}

\item{NextToken}{An identifier that was returned from the previous call to this
operation, which can be used to return the next set of items in the
list.}
}
\value{
A list with the following syntax:\preformatted{list(
  Users = list(
    list(
      Username = "string",
      Attributes = list(
        list(
          Name = "string",
          Value = "string"
        )
      ),
      UserCreateDate = as.POSIXct(
        "2015-01-01"
      ),
      UserLastModifiedDate = as.POSIXct(
        "2015-01-01"
      ),
      Enabled = TRUE|FALSE,
      UserStatus = "UNCONFIRMED"|"CONFIRMED"|"ARCHIVED"|"COMPROMISED"|"UNKNOWN"|"RESET_REQUIRED"|"FORCE_CHANGE_PASSWORD",
      MFAOptions = list(
        list(
          DeliveryMedium = "SMS"|"EMAIL",
          AttributeName = "string"
        )
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Lists the users in the specified group.

Calling this action requires developer credentials.
}
\section{Request syntax}{
\preformatted{svc$list_users_in_group(
  UserPoolId = "string",
  GroupName = "string",
  Limit = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
