% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_admin_get_device}
\alias{cognitoidentityprovider_admin_get_device}
\title{Gets the device, as an administrator}
\usage{
cognitoidentityprovider_admin_get_device(DeviceKey, UserPoolId,
  Username)
}
\arguments{
\item{DeviceKey}{[required] The device key.}

\item{UserPoolId}{[required] The user pool ID.}

\item{Username}{[required] The user name.}
}
\value{
A list with the following syntax:\preformatted{list(
  Device = list(
    DeviceKey = "string",
    DeviceAttributes = list(
      list(
        Name = "string",
        Value = "string"
      )
    ),
    DeviceCreateDate = as.POSIXct(
      "2015-01-01"
    ),
    DeviceLastModifiedDate = as.POSIXct(
      "2015-01-01"
    ),
    DeviceLastAuthenticatedDate = as.POSIXct(
      "2015-01-01"
    )
  )
)
}
}
\description{
Gets the device, as an administrator.

Calling this action requires developer credentials.
}
\section{Request syntax}{
\preformatted{svc$admin_get_device(
  DeviceKey = "string",
  UserPoolId = "string",
  Username = "string"
)
}
}

\keyword{internal}
