% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directoryservice_operations.R
\name{directoryservice_describe_regions}
\alias{directoryservice_describe_regions}
\title{Provides information about the Regions that are configured for
multi-Region replication}
\usage{
directoryservice_describe_regions(DirectoryId, RegionName, NextToken)
}
\arguments{
\item{DirectoryId}{[required] The identifier of the directory.}

\item{RegionName}{The name of the Region. For example, \code{us-east-1}.}

\item{NextToken}{The \code{DescribeRegionsResult.NextToken} value from a previous call to
\code{\link[=directoryservice_describe_regions]{describe_regions}}. Pass null if
this is the first call.}
}
\value{
A list with the following syntax:\preformatted{list(
  RegionsDescription = list(
    list(
      DirectoryId = "string",
      RegionName = "string",
      RegionType = "Primary"|"Additional",
      Status = "Requested"|"Creating"|"Created"|"Active"|"Inoperable"|"Impaired"|"Restoring"|"RestoreFailed"|"Deleting"|"Deleted"|"Failed",
      VpcSettings = list(
        VpcId = "string",
        SubnetIds = list(
          "string"
        )
      ),
      DesiredNumberOfDomainControllers = 123,
      LaunchTime = as.POSIXct(
        "2015-01-01"
      ),
      StatusLastUpdatedDateTime = as.POSIXct(
        "2015-01-01"
      ),
      LastUpdatedDateTime = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Provides information about the Regions that are configured for
multi-Region replication.
}
\section{Request syntax}{
\preformatted{svc$describe_regions(
  DirectoryId = "string",
  RegionName = "string",
  NextToken = "string"
)
}
}

\keyword{internal}
