% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fms_operations.R
\name{fms_delete_policy}
\alias{fms_delete_policy}
\title{Permanently deletes an AWS Firewall Manager policy}
\usage{
fms_delete_policy(PolicyId, DeleteAllPolicyResources)
}
\arguments{
\item{PolicyId}{[required] The ID of the policy that you want to delete. \code{PolicyId} is returned by
\code{PutPolicy} and by \code{ListPolicies}.}

\item{DeleteAllPolicyResources}{If \code{True}, the request will also perform a clean-up process that will:
\itemize{
\item Delete rule groups created by AWS Firewall Manager
\item Remove web ACLs from in-scope resources
\item Delete web ACLs that contain no rules or rule groups
}

After the cleanup, in-scope resources will no longer be protected by web
ACLs in this policy. Protection of out-of-scope resources will remain
unchanged. Scope is determined by tags and accounts associated with the
policy. When creating the policy, if you specified that only resources
in specific accounts or with specific tags be protected by the policy,
those resources are in-scope. All others are out of scope. If you did
not specify tags or accounts, all resources are in-scope.}
}
\description{
Permanently deletes an AWS Firewall Manager policy.
}
\section{Request syntax}{
\preformatted{svc$delete_policy(
  PolicyId = "string",
  DeleteAllPolicyResources = TRUE|FALSE
)
}
}

\keyword{internal}
