% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_list_key_policies}
\alias{kms_list_key_policies}
\title{Gets the names of the key policies that are attached to a customer
master key (CMK)}
\usage{
kms_list_key_policies(KeyId, Limit, Marker)
}
\arguments{
\item{KeyId}{[required] A unique identifier for the customer master key (CMK).

Specify the key ID or the Amazon Resource Name (ARN) of the CMK.

For example:
\itemize{
\item Key ID: \code{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\code{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.}

\item{Limit}{Use this parameter to specify the maximum number of items to return.
When this value is present, AWS KMS does not return more than the
specified number of items, but it might return fewer.

This value is optional. If you include a value, it must be between 1 and
1000, inclusive. If you do not include a value, it defaults to 100.

Currently only 1 policy can be attached to a key.}

\item{Marker}{Use this parameter in a subsequent request after you receive a response
with truncated results. Set it to the value of \code{NextMarker} from the
truncated response you just received.}
}
\description{
Gets the names of the key policies that are attached to a customer
master key (CMK). This operation is designed to get policy names that
you can use in a GetKeyPolicy operation. However, the only valid policy
name is \code{default}. You cannot perform this operation on a CMK in a
different AWS account.
}
\section{Request syntax}{
\preformatted{svc$list_key_policies(
  KeyId = "string",
  Limit = 123,
  Marker = "string"
)
}
}

\examples{
# The following example lists key policies for the specified CMK.
\donttest{svc$list_key_policies(
  KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
)}

}
\keyword{internal}
